/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.redstonepaste;

import net.fybertech.redstonepaste.BlockRedstonePaste;
import net.fybertech.redstonepaste.CompatibilityRenderer;
import net.fybertech.redstonepaste.RPRenderer;
import net.fybertech.redstonepaste.RedstonePasteMod;
import net.fybertech.redstonepaste.RedstonePasteUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSlab;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RedstonePasteHighlighter {
    private long lastSystemTime = 0L;
    private long timeCounter = 0L;
    private double tickcounter;
    private MyBB[] PasteOuterBB;
    private Vec3[][] pasteSegmentLLVecs = null;

    public RedstonePasteHighlighter() {
        this.SetupPasteOuterBB();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void SetupPasteOuterBB() {
        this.PasteOuterBB = new MyBB[6];
        float x1 = 0.0f;
        float x2 = 0.0f;
        float y1 = 0.0f;
        float y2 = 0.0f;
        float z1 = 0.0f;
        float z2 = 0.0f;
        float thickness = 0.0625f;
        thickness = 0.0f;
        for (int side = 0; side < 6; ++side) {
            switch (side) {
                case 0: {
                    x1 = 0.0f;
                    x2 = 1.0f;
                    y1 = 0.0f;
                    y2 = thickness;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                case 1: {
                    x1 = 0.0f;
                    x2 = 1.0f;
                    y1 = 1.0f - thickness;
                    y2 = 1.0f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                case 2: {
                    x1 = 0.0f;
                    x2 = 1.0f;
                    y1 = 0.0f;
                    y2 = 1.0f;
                    z1 = 0.0f;
                    z2 = thickness;
                    break;
                }
                case 3: {
                    x1 = 0.0f;
                    x2 = 1.0f;
                    y1 = 0.0f;
                    y2 = 1.0f;
                    z1 = 1.0f - thickness;
                    z2 = 1.0f;
                    break;
                }
                case 4: {
                    x1 = 0.0f;
                    x2 = thickness;
                    y1 = 0.0f;
                    y2 = 1.0f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                case 5: {
                    x1 = 1.0f - thickness;
                    x2 = 1.0f;
                    y1 = 0.0f;
                    y2 = 1.0f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                }
            }
            this.PasteOuterBB[side] = new MyBB();
            this.PasteOuterBB[side].x1 = x1;
            this.PasteOuterBB[side].x2 = x2;
            this.PasteOuterBB[side].y1 = y1;
            this.PasteOuterBB[side].y2 = y2;
            this.PasteOuterBB[side].z1 = z1;
            this.PasteOuterBB[side].z2 = z2;
        }
    }

    private Vec3[] getPasteSegmentLL(int side, int segment, int x, int y, int z) {
        Vec3[] lineloop = new Vec3[4];
        switch (segment) {
            case 1: {
                segment = 0;
                break;
            }
            case 2: {
                segment = 1;
                break;
            }
            case 4: {
                segment = 2;
                break;
            }
            case 8: {
                segment = 3;
            }
        }
        if (this.pasteSegmentLLVecs == null) {
            this.pasteSegmentLLVecs = new Vec3[4][];
            block17: for (int n = 0; n < 4; ++n) {
                this.pasteSegmentLLVecs[n] = new Vec3[4];
                switch (n) {
                    case 0: {
                        this.pasteSegmentLLVecs[n][0] = new Vec3(0.0, 0.0, 0.0);
                        this.pasteSegmentLLVecs[n][1] = new Vec3(1.0, 0.0, 0.0);
                        this.pasteSegmentLLVecs[n][2] = new Vec3(0.625, 0.375, 0.0);
                        this.pasteSegmentLLVecs[n][3] = new Vec3(0.375, 0.375, 0.0);
                        continue block17;
                    }
                    case 1: {
                        this.pasteSegmentLLVecs[n][0] = new Vec3(0.0, 1.0, 0.0);
                        this.pasteSegmentLLVecs[n][1] = new Vec3(1.0, 1.0, 0.0);
                        this.pasteSegmentLLVecs[n][2] = new Vec3(0.625, 0.625, 0.0);
                        this.pasteSegmentLLVecs[n][3] = new Vec3(0.375, 0.625, 0.0);
                        continue block17;
                    }
                    case 2: {
                        this.pasteSegmentLLVecs[n][0] = new Vec3(0.0, 0.0, 0.0);
                        this.pasteSegmentLLVecs[n][1] = new Vec3(0.375, 0.375, 0.0);
                        this.pasteSegmentLLVecs[n][2] = new Vec3(0.375, 0.625, 0.0);
                        this.pasteSegmentLLVecs[n][3] = new Vec3(0.0, 1.0, 0.0);
                        continue block17;
                    }
                    case 3: {
                        this.pasteSegmentLLVecs[n][0] = new Vec3(0.625, 0.375, 0.0);
                        this.pasteSegmentLLVecs[n][1] = new Vec3(1.0, 0.0, 0.0);
                        this.pasteSegmentLLVecs[n][2] = new Vec3(1.0, 1.0, 0.0);
                        this.pasteSegmentLLVecs[n][3] = new Vec3(0.625, 0.625, 0.0);
                    }
                }
            }
        }
        double sideOffset = 0.01;
        for (int n2 = 0; n2 < 4; ++n2) {
            double xCoord = x;
            double yCoord = y;
            double zCoord = z;
            switch (side) {
                case 0: 
                case 1: {
                    yCoord = side == 0 ? (yCoord += sideOffset) : (yCoord += 1.0 - sideOffset);
                    xCoord += this.pasteSegmentLLVecs[segment][n2].field_72450_a;
                    zCoord += this.pasteSegmentLLVecs[segment][n2].field_72448_b;
                    break;
                }
                case 2: 
                case 3: {
                    zCoord = side == 2 ? (zCoord += sideOffset) : (zCoord += 1.0 - sideOffset);
                    xCoord += this.pasteSegmentLLVecs[segment][n2].field_72450_a;
                    yCoord += this.pasteSegmentLLVecs[segment][n2].field_72448_b;
                    break;
                }
                case 4: 
                case 5: {
                    xCoord = side == 4 ? (xCoord += sideOffset) : (xCoord += 1.0 - sideOffset);
                    zCoord += this.pasteSegmentLLVecs[segment][n2].field_72450_a;
                    yCoord += this.pasteSegmentLLVecs[segment][n2].field_72448_b;
                }
            }
            lineloop[n2] = new Vec3(xCoord, yCoord, zCoord);
        }
        return lineloop;
    }

    public static long getSystemTime() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void HighlightHandler(DrawBlockHighlightEvent event) {
        boolean isHoldingSlab;
        BlockRedstonePaste blockRedstonePaste = RedstonePasteMod.instance.blockRedstonePaste;
        long thisSystemTime = RedstonePasteHighlighter.getSystemTime();
        long deltaTime = thisSystemTime - this.lastSystemTime;
        this.timeCounter += deltaTime;
        while (this.timeCounter > 1000L) {
            this.timeCounter -= 1000L;
        }
        this.lastSystemTime = thisSystemTime;
        Item pasteItem = Item.func_150898_a((Block)blockRedstonePaste);
        Item repeaterItem = RedstonePasteMod.instance.itemStickyRepeater;
        Item comparatorItem = RedstonePasteMod.instance.itemStickyComparator;
        if (event.player == null) {
            return;
        }
        if (event.target == null) {
            return;
        }
        if (event.target.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        Block blocklookingat = event.player.field_70170_p.func_180495_p(event.target.func_178782_a()).func_177230_c();
        boolean isHoldingPaste = event.currentItem != null && event.currentItem.func_77973_b() == pasteItem;
        boolean isHoldingRepeater = event.currentItem != null && event.currentItem.func_77973_b() == repeaterItem;
        boolean isHoldingComparator = event.currentItem != null && event.currentItem.func_77973_b() == comparatorItem;
        boolean bl = isHoldingSlab = event.currentItem != null && event.currentItem.func_77973_b() instanceof ItemSlab;
        if (!(isHoldingPaste || isHoldingRepeater || isHoldingComparator || blocklookingat == blockRedstonePaste)) {
            return;
        }
        int pasteBlockType = BlockRedstonePaste.getPasteBlockType(event.player.field_70170_p, event.player);
        if (!(blocklookingat != blockRedstonePaste || pasteBlockType != 1 || isHoldingPaste || isHoldingRepeater || isHoldingComparator)) {
            return;
        }
        if (!(blocklookingat != blockRedstonePaste || pasteBlockType != 2 && pasteBlockType != 3 || isHoldingSlab)) {
            AxisAlignedBB bb = AxisAlignedBB.func_178781_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            int slabFace = BlockRedstonePaste.getRepeaterComparatorFace(event.player.field_70170_p, event.target.func_178782_a().func_177958_n(), event.target.func_178782_a().func_177956_o(), event.target.func_178782_a().func_177952_p());
            float thickness = 0.125f;
            switch (slabFace) {
                case 0: {
                    bb = AxisAlignedBB.func_178781_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)thickness, (double)1.0);
                    break;
                }
                case 1: {
                    bb = AxisAlignedBB.func_178781_a((double)0.0, (double)(1.0f - thickness), (double)0.0, (double)1.0, (double)1.0, (double)1.0);
                    break;
                }
                case 2: {
                    bb = AxisAlignedBB.func_178781_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)thickness);
                    break;
                }
                case 3: {
                    bb = AxisAlignedBB.func_178781_a((double)0.0, (double)0.0, (double)(1.0f - thickness), (double)1.0, (double)1.0, (double)1.0);
                    break;
                }
                case 4: {
                    bb = AxisAlignedBB.func_178781_a((double)0.0, (double)0.0, (double)0.0, (double)thickness, (double)1.0, (double)1.0);
                    break;
                }
                case 5: {
                    bb = AxisAlignedBB.func_178781_a((double)(1.0f - thickness), (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
                }
            }
            bb = bb.func_72314_b(0.001, 0.001, 0.001);
            bb.func_72317_d((double)event.target.func_178782_a().func_177958_n(), (double)event.target.func_178782_a().func_177956_o(), (double)event.target.func_178782_a().func_177952_p());
            Tessellator tessellator = Tessellator.func_178181_a();
            EntityPlayer par1EntityPlayer = event.player;
            float var8 = (float)(par1EntityPlayer.field_70142_S + (par1EntityPlayer.field_70165_t - par1EntityPlayer.field_70142_S) * (double)event.partialTicks);
            float var10 = (float)(par1EntityPlayer.field_70137_T + (par1EntityPlayer.field_70163_u - par1EntityPlayer.field_70137_T) * (double)event.partialTicks);
            float var12 = (float)(par1EntityPlayer.field_70136_U + (par1EntityPlayer.field_70161_v - par1EntityPlayer.field_70136_U) * (double)event.partialTicks);
            tessellator.func_178180_c().func_178969_c((double)(-var8), (double)(-var10), (double)(-var12));
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glLineWidth((float)2.0f);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2884);
            GL11.glPolygonMode((int)1032, (int)6913);
            this.drawOutlinedBoundingBox(bb);
            GL11.glPolygonMode((int)1032, (int)6914);
            tessellator.func_178180_c().func_178969_c(0.0, 0.0, 0.0);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2884);
            event.setCanceled(true);
            return;
        }
        if (event.subID != 0) {
            return;
        }
        this.tickcounter += (double)event.partialTicks;
        while (this.tickcounter >= 40.0) {
            this.tickcounter -= 40.0;
        }
        this.tickcounter = (float)this.timeCounter / 1000.0f * 40.0f;
        MovingObjectPosition mop = null;
        int newX = event.target.func_178782_a().func_177958_n();
        int newY = event.target.func_178782_a().func_177956_o();
        int newZ = event.target.func_178782_a().func_177952_p();
        if (blocklookingat != blockRedstonePaste || blocklookingat == blockRedstonePaste && pasteBlockType == 1) {
            newX += event.target.field_178784_b.func_82601_c();
            newY += event.target.field_178784_b.func_96559_d();
            newZ += event.target.field_178784_b.func_82599_e();
            mop = event.target;
        } else {
            double reach = Minecraft.func_71410_x().field_71442_b.func_78757_d();
            BlockRedstonePaste.rayTracing = true;
            mop = event.player.func_174822_a(reach, event.partialTicks);
            BlockRedstonePaste.rayTracing = false;
        }
        if (mop == null) {
            event.setCanceled(true);
            return;
        }
        int blockX = mop.func_178782_a().func_177958_n();
        int blockY = mop.func_178782_a().func_177956_o();
        int blockZ = mop.func_178782_a().func_177952_p();
        if (!(blockX >= newX - 1 && blockX <= newX + 1 && blockY == newY && blockZ == newZ || blockY >= newY - 1 && blockY <= newY + 1 && blockX == newX && blockZ == newZ || blockZ >= newZ - 1 && blockZ <= newZ + 1 && blockX == newX && blockY == newY)) {
            event.setCanceled(true);
            return;
        }
        blocklookingat = event.player.field_70170_p.func_180495_p(new BlockPos(newX, newY, newZ)).func_177230_c();
        if (blocklookingat != blockRedstonePaste && !event.player.field_70170_p.func_175623_d(new BlockPos(newX, newY, newZ))) {
            return;
        }
        blocklookingat = event.player.field_70170_p.func_180495_p(mop.func_178782_a()).func_177230_c();
        if (!blocklookingat.isSideSolid((IBlockAccess)event.player.field_70170_p, mop.func_178782_a(), mop.field_178784_b)) {
            return;
        }
        int segmenthit = 0;
        boolean oppositesegment = false;
        boolean allsegments = false;
        int side = mop.field_178784_b.func_176734_d().ordinal();
        double hitX = mop.field_72307_f.field_72450_a - (double)newX;
        double hitY = mop.field_72307_f.field_72448_b - (double)newY;
        double hitZ = mop.field_72307_f.field_72449_c - (double)newZ;
        segmenthit = -1;
        double segLeft = 0.35;
        double segRight = 0.65;
        double segUpper = 0.4;
        double segLower = 0.6;
        segLeft = 0.4;
        segRight = 0.6;
        if (side == 0 || side == 1) {
            segmenthit = RedstonePasteUtils.testSegmentHit(hitX, hitZ);
        } else if (side == 2 || side == 3) {
            segmenthit = RedstonePasteUtils.testSegmentHit(hitX, hitY);
        } else if (side == 4 || side == 5) {
            segmenthit = RedstonePasteUtils.testSegmentHit(hitZ, hitY);
        }
        if (segmenthit > 0 && event.player.func_70093_af()) {
            switch (segmenthit) {
                case 1: {
                    segmenthit |= 2;
                    break;
                }
                case 2: {
                    segmenthit |= 1;
                    break;
                }
                case 4: {
                    segmenthit |= 8;
                    break;
                }
                case 8: {
                    segmenthit |= 4;
                }
            }
        }
        float x1 = this.PasteOuterBB[side].x1;
        float x2 = this.PasteOuterBB[side].x2;
        float y1 = this.PasteOuterBB[side].y1;
        float y2 = this.PasteOuterBB[side].y2;
        float z1 = this.PasteOuterBB[side].z1;
        float z2 = this.PasteOuterBB[side].z2;
        x1 += (float)newX;
        x2 += (float)newX;
        y1 += (float)newY;
        y2 += (float)newY;
        z1 += (float)newZ;
        z2 += (float)newZ;
        EntityPlayer par1EntityPlayer = event.player;
        float var8 = (float)(par1EntityPlayer.field_70142_S + (par1EntityPlayer.field_70165_t - par1EntityPlayer.field_70142_S) * (double)event.partialTicks);
        float var10 = (float)(par1EntityPlayer.field_70137_T + (par1EntityPlayer.field_70163_u - par1EntityPlayer.field_70137_T) * (double)event.partialTicks);
        float var12 = (float)(par1EntityPlayer.field_70136_U + (par1EntityPlayer.field_70161_v - par1EntityPlayer.field_70136_U) * (double)event.partialTicks);
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_178969_c((double)(-var8), (double)(-var10), (double)(-var12));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glLineWidth((float)2.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        GL11.glDisable((int)3553);
        this.drawOutlinedBoundingBox(AxisAlignedBB.func_178781_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2).func_72314_b((double)0.002f, (double)0.002f, (double)0.002f));
        event.setCanceled(true);
        if (segmenthit < 1) {
            tessellator.func_178180_c().func_178969_c(0.0, 0.0, 0.0);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2884);
            GL11.glPolygonMode((int)1032, (int)6914);
            return;
        }
        GL11.glLineWidth((float)2.0f);
        GL11.glPolygonMode((int)1032, (int)6914);
        GL11.glDisable((int)2884);
        GL11.glColor4f((float)0.0f, (float)((float)this.tickcounter / 40.0f), (float)0.0f, (float)0.2f);
        int[] segmentvalues = new int[]{1, 2, 4, 8};
        float tickvalue = (float)this.tickcounter / 20.0f;
        if (tickvalue > 1.0f) {
            tickvalue = Math.abs(tickvalue - 2.0f);
        }
        int slabFace = BlockRedstonePaste.getSlabFace(event.player.field_70170_p, newX, newY, newZ);
        int repeaterFace = BlockRedstonePaste.getRepeaterComparatorFace(event.player.field_70170_p, newX, newY, newZ);
        int pasteObjects = BlockRedstonePaste.getPasteObjectCount((IBlockAccess)event.player.field_70170_p, new BlockPos(newX, newY, newZ));
        if (!(isHoldingSlab && pasteObjects < 2 && slabFace == -1 || slabFace != -1 && slabFace != EnumFacing.values()[side].func_176734_d().ordinal() || side == repeaterFace)) {
            for (int n = 0; n < 4; ++n) {
                if ((segmenthit & segmentvalues[n]) <= 0) continue;
                GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)(tickvalue / 1.0f * 0.2f));
                GL11.glPolygonMode((int)1032, (int)6914);
                this.drawLineLoop(this.getPasteSegmentLL(side, segmentvalues[n], newX, newY, newZ));
                GL11.glColor4f((float)0.0f, (float)(tickvalue / 1.0f * 0.6f + 0.4f), (float)0.0f, (float)1.0f);
                GL11.glPolygonMode((int)1032, (int)6913);
                this.drawLineLoop(this.getPasteSegmentLL(side, segmentvalues[n], newX, newY, newZ));
            }
        }
        if (isHoldingSlab && pasteObjects < 2 && slabFace == -1) {
            slabFace = EnumFacing.values()[side].func_176734_d().ordinal();
            AxisAlignedBB bb = AxisAlignedBB.func_178781_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            switch (slabFace) {
                case 0: {
                    bb = AxisAlignedBB.func_178781_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
                    break;
                }
                case 1: {
                    bb = AxisAlignedBB.func_178781_a((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
                    break;
                }
                case 2: {
                    bb = AxisAlignedBB.func_178781_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5);
                    break;
                }
                case 3: {
                    bb = AxisAlignedBB.func_178781_a((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0);
                    break;
                }
                case 4: {
                    bb = AxisAlignedBB.func_178781_a((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0);
                    break;
                }
                case 5: {
                    bb = AxisAlignedBB.func_178781_a((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
                }
            }
            bb = bb.func_72331_e(0.005, 0.005, 0.005);
            GL11.glEnable((int)2884);
            Block ghostID = Block.func_149634_a((Item)event.currentItem.func_77973_b());
            int ghostDamage = event.currentItem.func_77952_i();
            if (ghostID == Blocks.field_150333_U && ghostDamage == 0) {
                ghostID = Blocks.field_150348_b;
            }
            TextureAtlasSprite ghostIcon = RPRenderer.findSlabTexture(ghostID, ghostDamage);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GL11.glEnable((int)3553);
            GL11.glPolygonMode((int)1032, (int)6914);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(tickvalue / 1.0f * 0.4f + 0.2f));
            CompatibilityRenderer rb = new CompatibilityRenderer(tessellator.func_178180_c(), (IBlockAccess)event.player.field_70170_p);
            boolean AO = rb.enableAO;
            rb.enableAO = false;
            tessellator.func_178180_c().func_178970_b();
            rb.setRenderBounds(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
            rb.renderFaceXPos(rb, newX, newY, newZ, ghostIcon);
            rb.renderFaceXNeg(rb, newX, newY, newZ, ghostIcon);
            rb.renderFaceYPos(rb, newX, newY, newZ, ghostIcon);
            rb.renderFaceYNeg(rb, newX, newY, newZ, ghostIcon);
            rb.renderFaceZPos(rb, newX, newY, newZ, ghostIcon);
            rb.renderFaceZNeg(rb, newX, newY, newZ, ghostIcon);
            tessellator.func_78381_a();
            rb.enableAO = AO;
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2884);
            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)(tickvalue / 1.0f * 0.4f));
            GL11.glColor4f((float)0.0f, (float)0.8f, (float)0.0f, (float)0.8f);
            GL11.glPolygonMode((int)1032, (int)6913);
            bb.func_72317_d((double)newX, (double)newY, (double)newZ);
            this.drawFilledBoundingBox(bb);
        }
        tessellator.func_178180_c().func_178969_c(0.0, 0.0, 0.0);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glPolygonMode((int)1032, (int)6914);
    }

    private void drawOutlinedBoundingBox(AxisAlignedBB par1AxisAlignedBB) {
        WorldRenderer tessellator = Tessellator.func_178181_a().func_178180_c();
        tessellator.func_178964_a(3);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        Tessellator.func_178181_a().func_78381_a();
        tessellator.func_178964_a(3);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        Tessellator.func_178181_a().func_78381_a();
        tessellator.func_178964_a(1);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        Tessellator.func_178181_a().func_78381_a();
    }

    private void drawFilledBoundingBox(AxisAlignedBB par1AxisAlignedBB) {
        WorldRenderer tessellator = Tessellator.func_178181_a().func_178180_c();
        tessellator.func_178970_b();
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        Tessellator.func_178181_a().func_78381_a();
        tessellator.func_178970_b();
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        Tessellator.func_178181_a().func_78381_a();
        tessellator.func_178970_b();
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        Tessellator.func_178181_a().func_78381_a();
        tessellator.func_178970_b();
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        Tessellator.func_178181_a().func_78381_a();
        tessellator.func_178970_b();
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        Tessellator.func_178181_a().func_78381_a();
        tessellator.func_178970_b();
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_178984_b(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        Tessellator.func_178181_a().func_78381_a();
    }

    private void drawLineLoop(Vec3[] vectors) {
        WorldRenderer tessellator = Tessellator.func_178181_a().func_178180_c();
        tessellator.func_178964_a(7);
        for (int n = 0; n < vectors.length; ++n) {
            tessellator.func_178984_b(vectors[n].field_72450_a, vectors[n].field_72448_b, vectors[n].field_72449_c);
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private class MyBB {
        public float x1;
        public float x2;
        public float y1;
        public float y2;
        public float z1;
        public float z2;

        private MyBB() {
        }
    }
}

