/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.meddleapi.transformer;

import java.util.List;
import net.fybertech.dynamicmappings.DynamicMappings;
import net.fybertech.meddle.Meddle;
import net.fybertech.meddle.MeddleUtil;
import net.fybertech.meddleapi.MeddleAPI;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Transformer
implements IClassTransformer {
    String minecraftServer = "net.minecraft.server.MinecraftServer";
    String blockClass = DynamicMappings.getClassMapping((String)"net/minecraft/block/Block");
    String itemClass = DynamicMappings.getClassMapping((String)"net/minecraft/item/Item");
    String slotClass = DynamicMappings.getClassMapping((String)"net/minecraft/inventory/Slot");
    String dedicatedServerClass = null;
    String startServer_name = null;
    String containerWorkbench = DynamicMappings.getClassMapping((String)"net/minecraft/inventory/ContainerWorkbench");
    String entityPlayerMP = DynamicMappings.getClassMapping((String)"net/minecraft/entity/player/EntityPlayerMP");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (name.equals(this.minecraftServer)) {
            basicClass = this.transformMinecraftServer(basicClass);
        } else if (this.dedicatedServerClass != null && this.dedicatedServerClass.equals(name)) {
            basicClass = this.transformDedicatedServer(basicClass);
        } else if (this.containerWorkbench != null && this.containerWorkbench.equals(name)) {
            basicClass = this.transformContainerWorkbench(basicClass);
        } else if (this.entityPlayerMP != null && this.entityPlayerMP.equals(name)) {
            basicClass = this.transformEntityPlayerMP(basicClass);
        }
        return basicClass;
    }

    private byte[] failGracefully(String error, byte[] bytes) {
        Meddle.LOGGER.error("[MeddleAPI] " + error);
        return bytes;
    }

    private byte[] transformMinecraftServer(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        reader.accept((ClassVisitor)cn, 0);
        List methods = DynamicMappings.getMatchingMethods((ClassNode)cn, (String)"run", (String)"()V");
        if (methods.size() == 1) {
            MethodNode method = (MethodNode)methods.get(0);
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 182) continue;
                MethodInsnNode mn = (MethodInsnNode)insn;
                if (!mn.owner.equals("net/minecraft/server/MinecraftServer") || !mn.desc.equals("()Z")) continue;
                this.startServer_name = mn.name;
                break;
            }
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new MethodInsnNode(184, "net/fybertech/meddleapi/MeddleAPI", "onServerRunHook", "(Lnet/minecraft/server/MinecraftServer;)V", false));
            method.instructions.insertBefore(method.instructions.getFirst(), list);
        }
        if (!MeddleUtil.isClientJar()) {
            for (MethodNode method : cn.methods) {
                if (method.name.equals("main") && method.desc.equals("([Ljava/lang/String;)V")) {
                    for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                        if (insn.getOpcode() != 187) continue;
                        TypeInsnNode tn = (TypeInsnNode)insn;
                        if (!DynamicMappings.searchConstantPoolForStrings((String)tn.desc, (String[])new String[]{"Loading properties", "spawn-protection"})) continue;
                        this.dedicatedServerClass = tn.desc;
                        break;
                    }
                }
                if (this.dedicatedServerClass == null) continue;
                break;
            }
            if (this.dedicatedServerClass == null) {
                MeddleAPI.LOGGER.error("[MeddleAPI] Error locating DedicatedServer class!");
            }
        }
        ClassWriter writer = new ClassWriter(0);
        cn.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] transformDedicatedServer(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        reader.accept((ClassVisitor)cn, 0);
        List methods = DynamicMappings.getMatchingMethods((ClassNode)cn, (String)this.startServer_name, (String)"()Z");
        if (methods.size() != 1) {
            MeddleAPI.LOGGER.error("[MeddleAPI] Unable to locate DedicatedServer.startServer()!");
            return basicClass;
        }
        MethodNode startServer = (MethodNode)methods.get(0);
        boolean patchedPreInit = false;
        boolean foundNanoTime = false;
        boolean patchedInit = false;
        for (AbstractInsnNode insn = startServer.instructions.getLast(); insn != null; insn = insn.getPrevious()) {
            if (!patchedPreInit && !foundNanoTime && insn.getOpcode() == 184) {
                MethodInsnNode mn = (MethodInsnNode)insn;
                if (mn.owner.equals("java/lang/System") && mn.name.equals("nanoTime")) {
                    foundNanoTime = true;
                }
            } else if (!patchedPreInit && foundNanoTime && insn.getOpcode() == 187 && insn.getPrevious() != null && insn.getPrevious().getOpcode() == 25) {
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new MethodInsnNode(184, "net/fybertech/meddleapi/MeddleAPI", "preInit", "(Ljava/lang/Object;)V", false));
                list.add((AbstractInsnNode)new MethodInsnNode(184, "net/fybertech/meddleapi/MeddleAPI", "init", "()V", false));
                startServer.instructions.insertBefore(insn.getPrevious(), list);
                patchedPreInit = true;
            }
            if (patchedInit || insn.getOpcode() != 172 || insn.getPrevious() == null || insn.getPrevious().getOpcode() != 4) continue;
            patchedInit = true;
        }
        ClassWriter writer = new ClassWriter(0);
        cn.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] transformContainerWorkbench(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        reader.accept((ClassVisitor)cn, 0);
        MethodNode onChanged = DynamicMappings.getMethodNodeFromMapping((ClassNode)cn, (String)"net/minecraft/inventory/Container onCraftMatrixChanged (Lnet/minecraft/inventory/IInventory;)V");
        if (onChanged == null) {
            return this.failGracefully("Couldn't locate Container.onCraftMatrixChanged!", basicClass);
        }
        String detectAndSend = DynamicMappings.getMethodMapping((String)"net/minecraft/inventory/Container detectAndSendChanges ()V");
        if (detectAndSend == null) {
            return this.failGracefully("Couldn't locate Container.detectAndSendChanges!", basicClass);
        }
        AbstractInsnNode returnNode = null;
        for (AbstractInsnNode insn = onChanged.instructions.getLast(); insn != null; insn = insn.getPrevious()) {
            if (insn.getOpcode() != 177) continue;
            returnNode = insn;
            break;
        }
        String container = DynamicMappings.getClassMapping((String)"net/minecraft/inventory/Container");
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "net/fybertech/meddleapi/MeddleHooks", "containerWorkbenchHook", "(L" + container + ";)V", false));
        onChanged.instructions.insertBefore(returnNode, list);
        ClassWriter writer = new ClassWriter(0);
        cn.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] transformEntityPlayerMP(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        reader.accept((ClassVisitor)cn, 0);
        MethodNode sendSlotContents = DynamicMappings.getMethodNodeFromMapping((ClassNode)cn, (String)"net/minecraft/inventory/ICrafting sendSlotContents (Lnet/minecraft/inventory/Container;ILnet/minecraft/item/ItemStack;)V");
        if (sendSlotContents == null) {
            return this.failGracefully("Couldn't locate EntityPlayerMP.sendSlotContents!", basicClass);
        }
        AbstractInsnNode[] nodes = DynamicMappings.getOpcodeSequenceArray((AbstractInsnNode)sendSlotContents.instructions.getFirst(), (int[])new int[]{25, 21, 182, 193, 153, 177});
        if (nodes == null) {
            return this.failGracefully("Unable to locate opcode sequence in EntityPlayerMP.sendSlotContents!", basicClass);
        }
        for (AbstractInsnNode insn : nodes) {
            sendSlotContents.instructions.remove(insn);
        }
        ClassWriter writer = new ClassWriter(0);
        cn.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

