/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.meddleapi.transformer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.fybertech.dynamicmappings.DynamicMappings;
import net.fybertech.dynamicmappings.DynamicRemap;
import net.fybertech.dynamicmappings.InheritanceMap;
import net.fybertech.meddleapi.transformer.AccessTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ReobfTransformer
implements IClassTransformer {
    DynamicRemap toObfRemapper = null;
    String[] exclusions = new String[]{"com.jcraft.", "net.fybertech.meddle.", "net.fybertech.dynamicmappings.", "org.slf4j.", "org.apache.", "io.netty.", "com.google", "paulscode.", "joptsimple.", "com.mojang.", "net.minecraft.", "oshi.", "com.ibm."};

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!name.contains(".")) {
            return basicClass;
        }
        for (String ex : this.exclusions) {
            if (!name.startsWith(ex)) continue;
            return basicClass;
        }
        return this.toObfRemapper.remapClass(basicClass);
    }

    public static byte[] readStream(InputStream stream) throws IOException {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int bytesRead = 0;
        while ((bytesRead = stream.read(buffer)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        stream.close();
        baos.flush();
        baos.close();
        return baos.toByteArray();
    }

    public ReobfTransformer() {
        final AccessTransformer accessTransformer = new AccessTransformer();
        final DynamicRemap toDeobfRemapper = new DynamicRemap(DynamicMappings.reverseClassMappings, DynamicMappings.reverseFieldMappings, DynamicMappings.reverseMethodMappings){
            Map<String, ClassNode> transformedCache;
            {
                super(x0, x1, x2);
                this.transformedCache = new HashMap<String, ClassNode>();
            }

            public ClassNode remapClass(String className) {
                if (className == null) {
                    return null;
                }
                InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(className + ".class");
                byte[] data = null;
                try {
                    data = ReobfTransformer.readStream(stream);
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (data == null) {
                    return null;
                }
                ClassReader reader = new ClassReader(accessTransformer.transform(className, className, data));
                return this.remapClass(reader);
            }

            public ClassNode getClassNode(String className) {
                if (this.transformedCache.containsKey(className)) {
                    return this.transformedCache.get(className);
                }
                ClassNode cn = super.getClassNode(className);
                ClassWriter writer = new ClassWriter(0);
                cn.accept((ClassVisitor)writer);
                byte[] bytes = accessTransformer.transform(cn.name, cn.name, writer.toByteArray());
                ClassReader reader = new ClassReader(bytes);
                ClassNode outNode = new ClassNode();
                reader.accept((ClassVisitor)outNode, 0);
                this.transformedCache.put(className, outNode);
                return outNode;
            }
        };
        toDeobfRemapper.unpackagedPrefix = null;
        toDeobfRemapper.unpackagedInnerPrefix = null;
        toDeobfRemapper.inheritanceMapper = new InheritanceMap(){

            public ClassNode locateClass(String classname) throws IOException {
                return toDeobfRemapper.getClassNode(classname);
            }
        };
        this.toObfRemapper = new DynamicRemap(DynamicMappings.classMappings, DynamicMappings.fieldMappings, DynamicMappings.methodMappings){

            public ClassNode getClassNode(String className) {
                if (className == null) {
                    return null;
                }
                if (DynamicMappings.classMappings.containsKey(className = className.replace(".", "/"))) {
                    return toDeobfRemapper.remapClass((String)DynamicMappings.classMappings.get(className));
                }
                return toDeobfRemapper.getClassNode(className);
            }
        };
        this.toObfRemapper.unpackagedPrefix = null;
        this.toObfRemapper.unpackagedInnerPrefix = null;
        this.toObfRemapper.inheritanceMapper = new InheritanceMap(){

            public ClassNode locateClass(String classname) throws IOException {
                return ReobfTransformer.this.toObfRemapper.getClassNode(classname);
            }
        };
    }
}

