/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.meddleapi.transformer;

import net.fybertech.dynamicmappings.DynamicMappings;
import net.fybertech.meddle.MeddleUtil;
import net.fybertech.meddleapi.MeddleAPI;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClientTransformer
implements IClassTransformer {
    String minecraftClass = DynamicMappings.getClassMapping((String)"net/minecraft/client/Minecraft");
    String guiMainMenu = DynamicMappings.getClassMapping((String)"net/minecraft/client/gui/GuiMainMenu");
    String entityPlayerSP = DynamicMappings.getClassMapping((String)"net/minecraft/client/entity/EntityPlayerSP");
    String netClientHandler = DynamicMappings.getClassMapping((String)"net/minecraft/client/network/NetHandlerPlayClient");
    String keyBinding = DynamicMappings.getClassMapping((String)"net/minecraft/client/settings/KeyBinding");
    String blockRendererDispatcher = DynamicMappings.getClassMapping((String)"net/minecraft/client/renderer/BlockRendererDispatcher");
    String iBlockState = DynamicMappings.getClassMapping((String)"net/minecraft/block/state/IBlockState");
    String blockPos = DynamicMappings.getClassMapping((String)"net/minecraft/util/BlockPos");
    String iBlockAccess = DynamicMappings.getClassMapping((String)"net/minecraft/world/IBlockAccess");
    String worldRenderer = DynamicMappings.getClassMapping((String)"net/minecraft/client/renderer/WorldRenderer");

    public ClientTransformer() {
        if (!MeddleUtil.notNull((Object[])new Object[]{this.minecraftClass, this.guiMainMenu})) {
            MeddleAPI.LOGGER.error("[MeddleAPI] Error obtaining dynamic mappings for client transformer");
        }
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (name.equals(this.minecraftClass)) {
            return this.transformMinecraft(basicClass);
        }
        if (name.equals(this.guiMainMenu)) {
            return this.transformGuiMainMenu(basicClass);
        }
        if (name.equals(this.entityPlayerSP)) {
            return this.transformEntityPlayerSP(basicClass);
        }
        if (name.equals(this.netClientHandler)) {
            return this.transformNetClientHandler(basicClass);
        }
        if (name.equals(this.keyBinding)) {
            return this.transformKeyBinding(basicClass);
        }
        if (name.equals(this.blockRendererDispatcher)) {
            return this.transformBlockRendererDispatcher(basicClass);
        }
        return basicClass;
    }

    private byte[] transformBlockRendererDispatcher(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        reader.accept((ClassVisitor)cn, 8);
        MethodNode renderBlock = DynamicMappings.getMethodNodeFromMapping((ClassNode)cn, (String)"net/minecraft/client/renderer/BlockRendererDispatcher renderBlock (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/BlockPos;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/WorldRenderer;)Z");
        if (renderBlock == null) {
            return basicClass;
        }
        if (!MeddleUtil.notNull((Object[])new Object[]{this.iBlockState, this.blockPos, this.iBlockAccess, this.worldRenderer})) {
            return basicClass;
        }
        String hookDesc = "(L" + this.iBlockState + ";L" + this.blockPos + ";L" + this.iBlockAccess + ";L" + this.worldRenderer + ";)Z";
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new VarInsnNode(25, 2));
        list.add((AbstractInsnNode)new VarInsnNode(25, 3));
        list.add((AbstractInsnNode)new VarInsnNode(25, 4));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "net/fybertech/meddleapi/MeddleClientHooks", "renderBlockHook", hookDesc, false));
        LabelNode l1 = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(153, l1));
        list.add((AbstractInsnNode)new InsnNode(4));
        list.add((AbstractInsnNode)new InsnNode(172));
        list.add((AbstractInsnNode)l1);
        renderBlock.instructions.insert(list);
        ClassWriter writer = new ClassWriter(3);
        cn.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] transformKeyBinding(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        reader.accept((ClassVisitor)cn, 8);
        MethodNode onTick = DynamicMappings.getMethodNodeFromMapping((ClassNode)cn, (String)"net/minecraft/client/settings/KeyBinding onTick (I)V");
        MethodNode setKeyBindState = DynamicMappings.getMethodNodeFromMapping((ClassNode)cn, (String)"net/minecraft/client/settings/KeyBinding setKeyBindState (IZ)V");
        if (setKeyBindState != null) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(21, 0));
            list.add((AbstractInsnNode)new VarInsnNode(21, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new MethodInsnNode(184, "net/fybertech/meddleapi/MeddleClientHooks", "setKeyBindStateHook", "(IZL" + this.keyBinding + ";)V", false));
            AbstractInsnNode returnNode = null;
            for (AbstractInsnNode insn = setKeyBindState.instructions.getLast(); insn != null; insn = insn.getPrevious()) {
                if (insn.getOpcode() != 177) continue;
                returnNode = insn;
                break;
            }
            if (returnNode != null) {
                setKeyBindState.instructions.insertBefore(returnNode, list);
            }
        }
        ClassWriter writer = new ClassWriter(3);
        cn.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] transformNetClientHandler(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        reader.accept((ClassVisitor)cn, 8);
        MethodNode handleOpenWindow = DynamicMappings.getMethodNodeFromMapping((ClassNode)cn, (String)"net/minecraft/client/network/NetHandlerPlayClient handleOpenWindow (Lnet/minecraft/network/play/server/S2DPacketOpenWindow;)V");
        String packet = DynamicMappings.getClassMapping((String)"net/minecraft/network/play/server/S2DPacketOpenWindow");
        if (handleOpenWindow == null || packet == null || this.entityPlayerSP == null) {
            return basicClass;
        }
        LabelNode endlabel = new LabelNode();
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 2));
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "net/fybertech/meddleapi/MeddleClientHooks", "handleOpenWindowHook", "(L" + this.entityPlayerSP + ";L" + packet + ";)Z", false));
        list.add((AbstractInsnNode)new JumpInsnNode(153, endlabel));
        list.add((AbstractInsnNode)new InsnNode(177));
        list.add((AbstractInsnNode)endlabel);
        AbstractInsnNode destNode = null;
        for (destNode = handleOpenWindow.instructions.getFirst(); destNode != null && destNode.getOpcode() != 58; destNode = destNode.getNext()) {
        }
        if (destNode != null) {
            handleOpenWindow.instructions.insert(destNode, list);
        }
        ClassWriter writer = new ClassWriter(3);
        cn.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] transformEntityPlayerSP(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        reader.accept((ClassVisitor)cn, 0);
        String iInteractionObject = DynamicMappings.getClassMapping((String)"net/minecraft/world/IInteractionObject");
        if (iInteractionObject == null) {
            return basicClass;
        }
        MethodNode displayGui = DynamicMappings.getMethodNodeFromMapping((ClassNode)cn, (String)"net/minecraft/entity/player/EntityPlayer displayGui (Lnet/minecraft/world/IInteractionObject;)V");
        if (displayGui == null) {
            return basicClass;
        }
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "net/fybertech/meddleapi/MeddleClientHooks", "displayGuiHook", "(L" + cn.name + ";L" + iInteractionObject + ";)V", false));
        AbstractInsnNode returnNode = null;
        for (AbstractInsnNode insn = displayGui.instructions.getLast(); insn != null; insn = insn.getPrevious()) {
            if (insn.getOpcode() != 177) continue;
            returnNode = insn;
            break;
        }
        if (returnNode != null) {
            displayGui.instructions.insertBefore(returnNode, list);
        }
        ClassWriter writer = new ClassWriter(0);
        cn.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] transformGuiMainMenu(byte[] basicClass) {
        MethodNode initGui;
        ClassReader reader = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        reader.accept((ClassVisitor)cn, 0);
        String guiScreen = DynamicMappings.getClassMapping((String)"net/minecraft/client/gui/GuiScreen");
        String drawScreenMapping = DynamicMappings.getMethodMapping((String)"net/minecraft/client/gui/GuiScreen drawScreen (IIF)V");
        MethodNode drawScreen = DynamicMappings.getMethodNode((ClassNode)cn, (String)drawScreenMapping);
        boolean brandingHook = false;
        if (drawScreen != null) {
            for (AbstractInsnNode insn = drawScreen.instructions.getLast(); insn != null; insn = insn.getPrevious()) {
                AbstractInsnNode[] nodes = DynamicMappings.getOpcodeSequenceArray((AbstractInsnNode)insn, (int[])new int[]{25, 21, 21, 23, 183});
                if (nodes == null || ((VarInsnNode)nodes[0]).var != 0) continue;
                MethodInsnNode mn = (MethodInsnNode)nodes[4];
                if (!drawScreenMapping.equals(mn.owner + " " + mn.name + " " + mn.desc)) continue;
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new MethodInsnNode(184, "net/fybertech/meddleapi/MeddleClientHooks", "drawMainMenuBranding", "(L" + guiScreen + ";)V", false));
                drawScreen.instructions.insertBefore(nodes[0], list);
                brandingHook = true;
                break;
            }
        }
        if (!brandingHook) {
            MeddleAPI.LOGGER.error("[MeddleAPI] Unable to add drawMainMenuBranding hook!");
        }
        if ((initGui = DynamicMappings.getMethodNodeFromMapping((ClassNode)cn, (String)"net/minecraft/client/gui/GuiScreen initGui ()V")) != null) {
            AbstractInsnNode returnOp = null;
            for (AbstractInsnNode insn = initGui.instructions.getLast(); insn != null; insn = insn.getPrevious()) {
                if (insn.getOpcode() != 177) continue;
                returnOp = insn;
                break;
            }
            if (returnOp != null) {
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new MethodInsnNode(184, "net/fybertech/meddleapi/MeddleClientHooks", "initMainMenuHook", "(L" + cn.name + ";)V", false));
                initGui.instructions.insertBefore(returnOp, list);
            }
        }
        String guiButton = DynamicMappings.getClassMapping((String)"net/minecraft/client/gui/GuiButton");
        MethodNode actionPerformed = DynamicMappings.getMethodNodeFromMapping((ClassNode)cn, (String)"net/minecraft/client/gui/GuiScreen actionPerformed (Lnet/minecraft/client/gui/GuiButton;)V");
        if (actionPerformed != null && guiButton != null) {
            LabelNode label = new LabelNode();
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new MethodInsnNode(184, "net/fybertech/meddleapi/MeddleClientHooks", "actionPerformedMainMenuHook", "(L" + cn.name + ";L" + guiButton + ";)Z", false));
            list.add((AbstractInsnNode)new JumpInsnNode(153, label));
            list.add((AbstractInsnNode)new InsnNode(177));
            list.add((AbstractInsnNode)label);
            actionPerformed.instructions.insert(list);
        }
        ClassWriter writer = new ClassWriter(0);
        cn.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] transformMinecraft(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        reader.accept((ClassVisitor)cn, 0);
        boolean finished = false;
        for (MethodNode method : cn.methods) {
            Type t = Type.getMethodType((String)method.desc);
            if (t.getReturnType().getSort() != 0 || t.getArgumentTypes().length != 0) continue;
            boolean foundFirst = false;
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                InsnList list;
                if (!foundFirst && DynamicMappings.isLdcWithString((AbstractInsnNode)insn, (String)"Startup")) {
                    foundFirst = true;
                    if (!(insn.getNext() instanceof MethodInsnNode)) continue;
                    insn = insn.getNext();
                    insn = insn.getNext();
                    list = new InsnList();
                    list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    list.add((AbstractInsnNode)new MethodInsnNode(184, "net/fybertech/meddleapi/MeddleAPI", "preInit", "(Ljava/lang/Object;)V", false));
                    method.instructions.insert(insn, list);
                    continue;
                }
                if (!foundFirst || !DynamicMappings.isLdcWithString((AbstractInsnNode)insn, (String)"Post startup")) continue;
                if (!(insn.getNext() instanceof MethodInsnNode)) break;
                insn = insn.getNext();
                list = new InsnList();
                list.add((AbstractInsnNode)new MethodInsnNode(184, "net/fybertech/meddleapi/MeddleAPI", "init", "()V", false));
                method.instructions.insert(insn, list);
                finished = true;
                break;
            }
            if (!finished) continue;
            break;
        }
        ClassWriter writer = new ClassWriter(0);
        cn.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

