/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.meddleapi.transformer;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.fybertech.dynamicmappings.AccessUtil;
import net.fybertech.dynamicmappings.DynamicMappings;
import net.fybertech.dynamicmappings.InheritanceMap;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class AccessTransformer
implements IClassTransformer {
    static boolean processedTransformers = false;
    static Map<String, Integer> expandedFieldTransformers = new HashMap<String, Integer>();
    static Map<String, Integer> expandedMethodTransformers = new HashMap<String, Integer>();
    static Set<String> classesToTransform = new HashSet<String>();

    String getClassMapping(String deobf) {
        String result = DynamicMappings.getClassMapping((String)deobf);
        return result != null ? result : deobf;
    }

    String getReverseClassMapping(String obf) {
        String result = DynamicMappings.getReverseClassMapping((String)obf);
        return result != null ? result : obf;
    }

    String remapFieldDescriptor(String desc) {
        Type t = Type.getType((String)desc);
        String out = "";
        out = t.getSort() != 10 ? out + t.getDescriptor() : out + "L" + this.getReverseClassMapping(t.getClassName()) + ";";
        out = out.replace(".", "/");
        return out;
    }

    String remapMethodDescriptor(String desc) {
        Type t = Type.getMethodType((String)desc);
        Type[] args = t.getArgumentTypes();
        Type returnType = t.getReturnType();
        String out = "(";
        for (Type arg : args) {
            out = arg.getSort() != 10 ? out + arg.getDescriptor() : out + "L" + this.getReverseClassMapping(arg.getClassName()) + ";";
        }
        out = out + ")";
        out = returnType.getSort() != 10 ? out + returnType.getDescriptor() : out + "L" + this.getReverseClassMapping(returnType.getClassName()) + ";";
        out = out.replace(".", "/");
        return out;
    }

    public AccessTransformer() {
        String[] keysplit;
        boolean found;
        ClassNode classNode;
        InheritanceMap classMap;
        String mappedClass;
        int access;
        String className;
        String[] split;
        if (processedTransformers) {
            return;
        }
        AccessUtil accessUtil = new AccessUtil();
        accessUtil.readAllTransformerConfigs();
        InheritanceMap inheritanceMap = new InheritanceMap();
        for (String transformer : accessUtil.accessTransformerFields) {
            split = transformer.split(" ");
            if (split.length != 4) continue;
            className = split[0];
            String fieldName = split[1];
            String fieldDesc = split[2];
            access = 0;
            try {
                access = Integer.parseInt(split[3]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (access < 1) continue;
            mappedClass = this.getClassMapping(className);
            classMap = null;
            try {
                classMap = inheritanceMap.buildMap(mappedClass);
            }
            catch (IOException e) {
                continue;
            }
            classNode = DynamicMappings.getClassNode((String)mappedClass);
            if (classNode == null) continue;
            HashMap<String, String> fieldsMap = new HashMap<String, String>();
            for (String key : classMap.fields.keySet()) {
                found = false;
                for (FieldNode field : classNode.fields) {
                    if (!key.equals(field.name + " " + field.desc)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                Set inheritedFields = (Set)classMap.fields.get(key);
                String fieldMapping = null;
                Iterator iterator = inheritedFields.iterator();
                while (iterator.hasNext()) {
                    InheritanceMap.FieldHolder holder = (InheritanceMap.FieldHolder)iterator.next();
                    fieldMapping = DynamicMappings.getReverseFieldMapping((String)(holder.cn.name + " " + holder.fn.name + " " + holder.fn.desc));
                    if (fieldMapping == null) continue;
                    break;
                }
                if (fieldMapping == null) {
                    keysplit = key.split(" ");
                    fieldMapping = keysplit[0] + " " + this.remapFieldDescriptor(keysplit[1]);
                } else {
                    fieldMapping = fieldMapping.substring(fieldMapping.indexOf(32) + 1);
                }
                fieldsMap.put(fieldMapping, key);
            }
            for (String key : fieldsMap.keySet()) {
                split = key.split(" ");
                if (!fieldName.equals(split[0]) && !fieldName.equals("*") || !fieldDesc.equals(split[1]) && !fieldDesc.equals("*")) continue;
                expandedFieldTransformers.put(mappedClass + " " + (String)fieldsMap.get(key), access);
                classesToTransform.add(mappedClass);
            }
        }
        for (String transformer : accessUtil.accessTransformerMethods) {
            split = transformer.split(" ");
            if (split.length != 4) continue;
            className = split[0];
            String methodName = split[1];
            String methodDesc = split[2];
            access = 0;
            try {
                access = Integer.parseInt(split[3]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (access < 1) continue;
            mappedClass = this.getClassMapping(className);
            classMap = null;
            try {
                classMap = inheritanceMap.buildMap(mappedClass);
            }
            catch (IOException e) {
                continue;
            }
            classNode = DynamicMappings.getClassNode((String)mappedClass);
            if (classNode == null) continue;
            HashMap<String, String> methodsMap = new HashMap<String, String>();
            for (String key : classMap.methods.keySet()) {
                found = false;
                for (MethodNode method : classNode.methods) {
                    if (!key.equals(method.name + " " + method.desc)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                Set inheritedMethods = (Set)classMap.methods.get(key);
                String methodMapping = null;
                for (InheritanceMap.FieldHolder holder : inheritedMethods) {
                    methodMapping = DynamicMappings.getReverseMethodMapping((String)(holder.cn.name + " " + holder.mn.name + " " + holder.mn.desc));
                    if (methodMapping == null) continue;
                    break;
                }
                if (methodMapping == null) {
                    keysplit = key.split(" ");
                    methodMapping = keysplit[0] + " " + this.remapMethodDescriptor(keysplit[1]);
                } else {
                    methodMapping = methodMapping.substring(methodMapping.indexOf(32) + 1);
                }
                methodsMap.put(methodMapping, key);
            }
            for (String key : methodsMap.keySet()) {
                split = key.split(" ");
                if (!methodName.equals(split[0]) && !methodName.equals("*") || !methodDesc.equals(split[1]) && !methodDesc.equals("*")) continue;
                expandedMethodTransformers.put(mappedClass + " " + (String)methodsMap.get(key), access);
                classesToTransform.add(mappedClass);
            }
        }
        processedTransformers = true;
    }

    private byte[] transformClass(byte[] basicClass) {
        int access;
        String key;
        ClassReader reader = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        reader.accept((ClassVisitor)cn, 0);
        int allAccess = 7;
        for (FieldNode field : cn.fields) {
            key = cn.name + " " + field.name + " " + field.desc;
            if (!expandedFieldTransformers.containsKey(key) || (access = expandedFieldTransformers.get(key).intValue()) < 1) continue;
            field.access = field.access & ~allAccess | access;
        }
        for (MethodNode method : cn.methods) {
            key = cn.name + " " + method.name + " " + method.desc;
            if (!expandedMethodTransformers.containsKey(key) || (access = expandedMethodTransformers.get(key).intValue()) < 1) continue;
            method.access = method.access & ~allAccess | access;
        }
        ClassWriter writer = new ClassWriter(0);
        cn.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (classesToTransform.contains(name)) {
            basicClass = this.transformClass(basicClass);
        }
        return basicClass;
    }
}

