/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.meddleapi;

import net.fybertech.meddle.Meddle;
import net.fybertech.meddleapi.GuiMods;
import net.fybertech.meddleapi.MeddleAPI;
import net.fybertech.meddleapi.MeddleClient;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.network.play.server.S2DPacketOpenWindow;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IInteractionObject;

public class MeddleClientHooks {
    static boolean debug = false;
    static String mappingsVersion = null;

    public static void drawMainMenuBranding(GuiScreen gui) {
        FontRenderer fontRenderer = gui.fontRendererObj;
        if (mappingsVersion == null) {
            Meddle.ModContainer mc = (Meddle.ModContainer)Meddle.loadedModsList.get("dynamicmappings");
            mappingsVersion = mc != null ? mc.meta.version() : "n/a";
        }
        gui.drawString(fontRenderer, "Meddle " + Meddle.getVersion(), 2, gui.height - 60, 0xFFFFFF);
        int modCount = Meddle.loadedModsList.size();
        String modOrMods = modCount == 1 ? " mod" : " mods";
        gui.drawString(fontRenderer, "  " + modCount + modOrMods + " loaded", 2, gui.height - 50, 0xAAAAAA);
        gui.drawString(fontRenderer, "MeddleAPI " + MeddleAPI.getVersion(), 2, gui.height - 40, 0xFFFFFF);
        modCount = MeddleAPI.apiMods.size();
        modOrMods = modCount == 1 ? " mod" : " mods";
        gui.drawString(fontRenderer, "  " + modCount + modOrMods + " loaded", 2, gui.height - 30, 0xAAAAAA);
        gui.drawString(fontRenderer, "DynamicMappings " + mappingsVersion, 2, gui.height - 20, 0xFFFFFF);
    }

    public static void initMainMenuHook(GuiMainMenu gui) {
        int x = gui.width / 2 + 104;
        int y = gui.height / 4 + 48;
        gui.buttonList.add(new GuiButton(25, x, y + 72 + 12, 20, 20, "M"));
    }

    public static boolean actionPerformedMainMenuHook(GuiMainMenu gui, GuiButton button) {
        if (button.id == 25) {
            Minecraft.getMinecraft().displayGuiScreen((GuiScreen)new GuiMods((GuiScreen)gui));
            return true;
        }
        return false;
    }

    public static void displayGuiHook(EntityPlayerSP player, IInteractionObject iiobject) {
        MeddleClient.IDisplayGui handler;
        if (debug) {
            System.out.println("displayGui: " + iiobject.getGuiID());
        }
        if ((handler = MeddleClient.guiHandlers.get(iiobject.getGuiID())) != null) {
            handler.onOpenGui(player, iiobject.getGuiID(), iiobject.getDisplayName(), 0);
        }
    }

    public static boolean handleOpenWindowHook(EntityPlayerSP player, S2DPacketOpenWindow packet) {
        MeddleClient.IDisplayGui handler;
        if (debug) {
            System.out.println("openWindowHook: " + packet.getGuiId() + " " + packet.getSlotCount());
        }
        if ((handler = MeddleClient.guiHandlers.get(packet.getGuiId())) != null) {
            handler.onOpenGui(player, packet.getGuiId(), packet.getWindowTitle(), packet.getSlotCount());
            player.openContainer.windowId = packet.getWindowId();
            return true;
        }
        return false;
    }

    public static void setKeyBindStateHook(int keyCode, boolean pressed, KeyBinding keyBinding) {
        for (MeddleClient.IKeyBindingState handler : MeddleClient.keyBindStateHandlers) {
            handler.onsetKeyBindState(keyCode, pressed, keyBinding);
        }
    }

    public static boolean renderBlockHook(IBlockState state, BlockPos pos, IBlockAccess blockAccess, WorldRenderer renderer) {
        if (state == null || state.getBlock() == null) {
            return false;
        }
        MeddleClient.ICustomBlockRenderer customRenderer = MeddleClient.customBlockRenderers.get(state.getBlock());
        if (customRenderer == null) {
            return false;
        }
        return customRenderer.renderBlock(state, pos, blockAccess, renderer);
    }
}

