/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.meddleapi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;

public class MeddleClient {
    public static Map<String, IDisplayGui> guiHandlers = new HashMap<String, IDisplayGui>();
    public static Set<IKeyBindingState> keyBindStateHandlers = new HashSet<IKeyBindingState>();
    public static Map<Block, ICustomBlockRenderer> customBlockRenderers = new HashMap<Block, ICustomBlockRenderer>();

    public static void registerGuiHandler(IDisplayGui displayGui) {
        for (String handler : displayGui.getHandledGuiIDs()) {
            guiHandlers.put(handler, displayGui);
        }
    }

    public static void registerKeyBindStateHandler(IKeyBindingState handler) {
        keyBindStateHandlers.add(handler);
    }

    public static void registerCustomBlockRenderer(Block block, ICustomBlockRenderer renderer) {
        customBlockRenderers.put(block, renderer);
    }

    public static interface IKeyBindingState {
        public void onsetKeyBindState(int var1, boolean var2, KeyBinding var3);
    }

    public static interface IDisplayGui {
        public List<String> getHandledGuiIDs();

        public void onOpenGui(EntityPlayerSP var1, String var2, IChatComponent var3, int var4);
    }

    public static interface ICustomBlockRenderer {
        public boolean renderBlock(IBlockState var1, BlockPos var2, IBlockAccess var3, WorldRenderer var4);
    }
}

