/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.meddleapi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import net.fybertech.dynamicmappings.DynamicMappings;
import net.fybertech.meddle.Meddle;
import net.fybertech.meddle.MeddleUtil;
import net.fybertech.meddleapi.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MeddleAPI {
    public static final Logger LOGGER = LogManager.getLogger((String)"MeddleAPI");
    public static List<Object> apiMods = new ArrayList<Object>();
    public static List<ICommand> delayedICommands = new ArrayList<ICommand>();
    public static CommonProxy proxy = (CommonProxy)MeddleAPI.createProxyInstance("net.fybertech.meddleapi.CommonProxy", "net.fybertech.meddleapi.ClientProxy");
    public static Object mainObject = null;
    private static String meddleAPIVersion = null;
    private static Method registerItemMethod = null;

    public static String getVersion() {
        if (meddleAPIVersion == null) {
            Meddle.ModContainer mc = (Meddle.ModContainer)Meddle.loadedModsList.get("meddleapi");
            meddleAPIVersion = mc != null ? mc.meta.version() : "n/a";
        }
        return meddleAPIVersion;
    }

    private static List<String> findMissingMappings(InputStream stream) throws IOException {
        ArrayList<String> missingMappings = new ArrayList<String>();
        boolean isClient = MeddleUtil.isClientJar();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] split;
            if (line.startsWith("#") || line.length() < 1 || (split = line.split(" ", 3)).length != 3) continue;
            int side = 0;
            try {
                side = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (side < 1 || side > 3 || isClient && side == 2 || !isClient && side == 1) continue;
            boolean hasMapping = false;
            String mapping = split[2];
            char type = split[0].toUpperCase().charAt(0);
            switch (type) {
                case 'C': {
                    if (!DynamicMappings.classMappings.containsKey(mapping)) break;
                    hasMapping = true;
                    break;
                }
                case 'F': {
                    if (!DynamicMappings.fieldMappings.containsKey(mapping)) break;
                    hasMapping = true;
                    break;
                }
                case 'M': {
                    if (!DynamicMappings.methodMappings.containsKey(mapping)) break;
                    hasMapping = true;
                }
            }
            if (hasMapping) continue;
            missingMappings.add(mapping);
        }
        reader.close();
        return missingMappings;
    }

    private static boolean hasRequiredMappings(JarFile jarFile) {
        List<String> missingMappings;
        ZipEntry entry = jarFile.getEntry("requiredmappings.cfg");
        if (entry == null) {
            return true;
        }
        String jarName = jarFile.getName().replace("\\", "/");
        if (jarName.contains("/")) {
            jarName = jarName.substring(jarName.lastIndexOf(47) + 1);
        }
        try {
            missingMappings = MeddleAPI.findMissingMappings(jarFile.getInputStream(entry));
        }
        catch (IOException e) {
            LOGGER.error("[MeddleAPI] Error reading requiredmappings.cfg from " + jarName);
            return false;
        }
        if (missingMappings.size() > 0) {
            LOGGER.error("[MeddleAPI] " + jarName + " has missing mappings, aborting mod initialization");
            return false;
        }
        LOGGER.info("[MeddleAPI] All mappings present for " + jarName);
        return true;
    }

    public static void preInit(Object obj) {
        LOGGER.info("[MeddleAPI] PreInit Phase");
        mainObject = obj;
        for (Meddle.ModContainer meddleMod : Meddle.discoveredModsList) {
            String[] mods;
            String apiModsAttr;
            Attributes attr;
            Manifest manifest = null;
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(meddleMod.jar);
            }
            catch (IOException e) {
                continue;
            }
            try {
                manifest = jarFile.getManifest();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (manifest == null || (attr = manifest.getMainAttributes()) == null || (apiModsAttr = attr.getValue("MeddleAPI-Mods")) == null || apiModsAttr.length() < 1 || !MeddleAPI.hasRequiredMappings(jarFile)) continue;
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            for (String className : mods = apiModsAttr.split(" ")) {
                try {
                    LOGGER.info("[MeddleAPI] Initializing mod class " + className);
                    Object c = Class.forName(className, true, MeddleAPI.class.getClassLoader()).newInstance();
                    apiMods.add(c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void init() {
        LOGGER.info("[MeddleAPI] Init Phase");
        for (Object modClass : apiMods) {
            try {
                LOGGER.info("[MeddleAPI] Init() - " + modClass.getClass().getName());
                Method init = modClass.getClass().getMethod("init", new Class[0]);
                init.invoke(modClass, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        proxy.refreshResources();
    }

    public static void registerItem(int itemID, String itemName, Item item) {
        if (registerItemMethod == null) {
            Method[] methods;
            String itemClassName = DynamicMappings.getClassMapping((String)"net.minecraft.item.Item");
            Class<?> itemClass = null;
            try {
                itemClass = Class.forName(itemClassName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            for (Method method : methods = itemClass.getDeclaredMethods()) {
                Class<?>[] types = method.getParameterTypes();
                if (types.length != 3 || types[0] != Integer.TYPE || types[1] != String.class || types[2] != itemClass) continue;
                method.setAccessible(true);
                registerItemMethod = method;
            }
        }
        try {
            registerItemMethod.invoke(null, itemID, itemName, item);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerBlock(int blockID, String blockName, Block block) {
        Block.registerBlock((int)blockID, (String)blockName, (Block)block);
        for (IBlockState ibs : block.getBlockState().getValidStates()) {
            int var23 = Block.blockRegistry.getIDForObject((Object)block) << 4 | block.getMetaFromState(ibs);
            Block.BLOCK_STATE_IDS.put((Object)ibs, var23);
        }
        Item.registerItemBlock((Block)block);
    }

    public static Object createProxyInstance(String serverClass, String clientClass) {
        Class<?> c = null;
        if (MeddleUtil.isClientJar()) {
            try {
                c = Class.forName(clientClass);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("[MeddleAPI] Unable to find client proxy class " + clientClass);
                return null;
            }
        }
        try {
            c = Class.forName(serverClass);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("[MeddleAPI] Unable to find server proxy class " + serverClass);
            return null;
        }
        try {
            Object o = c.getConstructor(new Class[0]).newInstance(new Object[0]);
            return o;
        }
        catch (Exception e) {
            LOGGER.error("[MeddleAPI] An error occured while initializing proxy class " + c.getName());
            e.printStackTrace();
            return null;
        }
    }

    public static ICommandManager getICommandManager() {
        return MeddleAPI.getServer().getCommandManager();
    }

    public static MinecraftServer getServer() {
        return proxy.getServer(mainObject);
    }

    public static void registerCommandHandler(ICommand cmd) {
        if (MeddleUtil.isClientJar()) {
            delayedICommands.add(cmd);
        } else {
            ((CommandHandler)MeddleAPI.getServer().getCommandManager()).registerCommand(cmd);
        }
    }

    public static void onServerRunHook(MinecraftServer server) {
        if (MeddleUtil.isClientJar()) {
            CommandHandler cmdHandler = (CommandHandler)server.getCommandManager();
            for (ICommand cmd : delayedICommands) {
                cmdHandler.registerCommand(cmd);
            }
        }
    }
}

