/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.meddleapi;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class ConfigFile {
    private File configFile = null;
    boolean changed = false;
    public Map<String, Map<String, String>> categoryMaps = new HashMap<String, Map<String, String>>();
    public Set<ConfigKey> configData = new HashSet<ConfigKey>();

    private List<String> readTextFile(File file) {
        ArrayList<String> output = new ArrayList<String>();
        Scanner reader = null;
        try {
            reader = new Scanner(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (reader == null) {
            return null;
        }
        while (reader.hasNextLine()) {
            output.add(reader.nextLine());
        }
        reader.close();
        return output;
    }

    public ConfigFile() {
    }

    public ConfigFile(File f) {
        this.configFile = f;
    }

    public void load() {
        if (this.configFile == null || !this.configFile.exists()) {
            return;
        }
        List<String> lines = this.readTextFile(this.configFile);
        if (lines == null) {
            return;
        }
        this.categoryMaps.clear();
        Map<Object, Object> currentCategory = null;
        for (String line : lines) {
            if ((line = line.trim()).startsWith("#") || line.length() < 1) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                String categoryName = line.substring(1, line.length() - 1);
                if (this.categoryMaps.containsKey(categoryName)) {
                    currentCategory = this.categoryMaps.get(categoryName);
                    continue;
                }
                currentCategory = new HashMap();
                this.categoryMaps.put(categoryName, currentCategory);
                continue;
            }
            if (!line.contains("=")) continue;
            if (currentCategory == null) {
                currentCategory = new HashMap();
                this.categoryMaps.put("general", currentCategory);
            }
            String key = line.substring(0, line.indexOf(61) - 1).trim().toLowerCase();
            String rest = line.substring(line.indexOf(61) + 1).trim();
            currentCategory.put(key, rest);
        }
    }

    public void save() {
        try {
            PrintWriter pw = new PrintWriter(this.configFile);
            for (String catName : this.categoryMaps.keySet()) {
                pw.println("[" + catName + "]");
                for (ConfigKey key : this.configData) {
                    if (!key.categoryName.equals(catName)) continue;
                    if (key.description != null) {
                        pw.println("  # " + key.description.replace("\n", "\n  # "));
                        if (key.defaultValue != null) {
                            pw.println("  #\n  # Default: " + key.defaultValue.toString());
                        }
                    }
                    pw.println("  " + key.keyName + " = " + key.value.toString());
                    if (key.description == null) continue;
                    pw.println();
                }
            }
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean hasChanged() {
        return this.changed;
    }

    protected Map<String, String> getCategory(String categoryName) {
        if (categoryName == null) {
            categoryName = "general";
        }
        if (this.categoryMaps.containsKey(categoryName)) {
            return this.categoryMaps.get(categoryName);
        }
        this.changed = true;
        HashMap<String, String> category = new HashMap<String, String>();
        this.categoryMaps.put(categoryName, category);
        return category;
    }

    public int stringToInt(String s) {
        int output = 0;
        try {
            output = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return output;
    }

    public float stringToFloat(String s) {
        float output = 0.0f;
        try {
            output = Float.parseFloat(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return output;
    }

    public double stringToDouble(String s) {
        double output = 0.0;
        try {
            output = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return output;
    }

    public <T> T get(ConfigKey<T> key) {
        Object output;
        if (this.configData.contains(key)) {
            return key.value;
        }
        Map<String, String> category = this.getCategory(key.categoryName);
        if (category.containsKey(key.keyName.toLowerCase())) {
            String s = category.get(key.keyName.toLowerCase());
            if (key.defaultValue instanceof Integer) {
                key.setValue(this.stringToInt(s));
            } else if (key.defaultValue instanceof Float) {
                key.setValue((Integer)((Object)Float.valueOf(this.stringToFloat(s))));
            } else if (key.defaultValue instanceof Double) {
                key.setValue((Integer)this.stringToDouble(s));
            } else if (key.defaultValue instanceof Boolean) {
                key.setValue((Integer)((Object)Boolean.valueOf(Boolean.parseBoolean(s))));
            } else {
                key.setValue((Integer)((Object)s));
            }
            this.configData.add(key);
            output = key.value;
        } else {
            this.changed = true;
            this.configData.add(key);
            output = key.value;
        }
        return output;
    }

    public static ConfigKey<String> key(String keyName) {
        return new ConfigKey<String>("general", keyName, "", null);
    }

    public static <T> ConfigKey<T> key(String keyName, T defaultValue) {
        return new ConfigKey<T>("general", keyName, defaultValue, null);
    }

    public static <T> ConfigKey<T> key(String categoryName, String keyName, T defaultValue) {
        return new ConfigKey<T>(categoryName, keyName, defaultValue, null);
    }

    public static <T> ConfigKey<T> key(String categoryName, String keyName, T defaultValue, String description) {
        return new ConfigKey<T>(categoryName, keyName, defaultValue, description);
    }

    public static class ConfigKey<T> {
        public final String categoryName;
        public final String keyName;
        public final T defaultValue;
        public final String description;
        public T value;

        public ConfigKey(String categoryName, String keyName, T defaultValue, String description) {
            this.categoryName = categoryName != null ? categoryName : "general";
            this.keyName = keyName;
            this.defaultValue = defaultValue;
            this.description = description;
            this.value = defaultValue;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + (this.categoryName != null ? this.categoryName.hashCode() : 0);
            hash = hash * 31 + (this.keyName != null ? this.keyName.hashCode() : 0);
            return hash;
        }
    }
}

