/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.dynamicmappings.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fybertech.dynamicmappings.DynamicMappings;
import net.fybertech.dynamicmappings.Mapping;
import net.fybertech.dynamicmappings.MethodCallIterator;
import net.fybertech.dynamicmappings.MethodCallVisitor;
import net.fybertech.dynamicmappings.mappers.MappingsBase;
import net.fybertech.meddle.MeddleUtil;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SharedMappings
extends MappingsBase {
    @Mapping(provides={"net/minecraft/server/MinecraftServer"})
    public boolean getMinecraftServerClass() {
        ClassNode cn = this.getClassNode("net/minecraft/server/MinecraftServer");
        if (cn == null) {
            return false;
        }
        this.addClassMapping("net/minecraft/server/MinecraftServer", cn);
        return true;
    }

    @Mapping(provides={"net/minecraft/world/World"}, depends={"net/minecraft/server/MinecraftServer"})
    public boolean getWorldClass() {
        ClassNode server = this.getClassNode(this.getClassMapping("net/minecraft/server/MinecraftServer"));
        if (server == null) {
            return false;
        }
        ArrayList<String> potentialClasses = new ArrayList<String>();
        for (String interfaceClass : server.interfaces) {
            ClassNode node;
            if (interfaceClass.contains("/") || (node = this.getClassNode(interfaceClass)) == null) continue;
            for (MethodNode method : node.methods) {
                Type returnType = Type.getReturnType((String)method.desc);
                if (returnType.getSort() != 10 || returnType.getClassName().contains(".")) continue;
                potentialClasses.add(returnType.getClassName());
            }
        }
        String[] matchStrings = new String[]{"Getting biome", "chunkCheck", "Level name", "Chunk stats"};
        for (String className : potentialClasses) {
            if (!this.searchConstantPoolForStrings(className, matchStrings)) continue;
            ClassNode worldClass = this.getClassNode(className);
            this.addClassMapping("net/minecraft/world/World", worldClass);
            return true;
        }
        return false;
    }

    @Mapping(provides={"net/minecraft/world/WorldType", "net/minecraft/world/WorldServer"}, providesMethods={"net/minecraft/server/MinecraftServer loadAllWorlds (Ljava/lang/String;Ljava/lang/String;JLnet/minecraft/world/WorldType;Ljava/lang/String;)V"}, depends={"net/minecraft/server/MinecraftServer"})
    public boolean getWorldServerClass() {
        ClassNode server = this.getClassNode("net/minecraft/server/MinecraftServer");
        if (server == null) {
            return false;
        }
        ArrayList<MethodNode> methods = new ArrayList<MethodNode>();
        for (MethodNode method : server.methods) {
            Type t;
            if (!method.desc.startsWith("(Ljava/lang/String;Ljava/lang/String;JL") || !method.desc.endsWith(";Ljava/lang/String;)V") || (t = Type.getMethodType((String)method.desc)).getArgumentTypes().length != 5) continue;
            methods.add(method);
        }
        if (methods.size() == 1) {
            Type t = Type.getMethodType((String)((MethodNode)methods.get((int)0)).desc);
            Type[] args = t.getArgumentTypes();
            String worldType = args[3].getClassName();
            if (!this.searchConstantPoolForStrings(worldType, "default", "flat", "amplified")) {
                return false;
            }
            this.addClassMapping("net/minecraft/world/WorldType", worldType);
            this.addMethodMapping("net/minecraft/server/MinecraftServer loadAllWorlds (Ljava/lang/String;Ljava/lang/String;JLnet/minecraft/world/WorldType;Ljava/lang/String;)V", server.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
            ArrayList<String> worldServerNames = new ArrayList<String>();
            List<TypeInsnNode> list = this.getAllInsnNodesOfType(((MethodNode)methods.get((int)0)).instructions.getFirst(), TypeInsnNode.class);
            for (TypeInsnNode mn : list) {
                if (mn.getOpcode() != 187 || !this.searchConstantPoolForStrings(mn.desc, "doDaylightCycle", "playerCheckLight", "Saving level") || worldServerNames.contains(mn.desc)) continue;
                worldServerNames.add(mn.desc);
            }
            if (worldServerNames.size() == 1) {
                this.addClassMapping("net/minecraft/world/WorldServer", (String)worldServerNames.get(0));
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/util/IThreadListener"}, depends={"net/minecraft/world/WorldServer"})
    public boolean processWorldServerClass() {
        ClassNode worldServer = this.getClassNodeFromMapping("net/minecraft/world/WorldServer");
        if (worldServer == null) {
            return false;
        }
        ArrayList<String> ifaces = new ArrayList<String>();
        for (String iface : worldServer.interfaces) {
            ClassNode cn = this.getClassNode(iface);
            for (MethodNode method : cn.methods) {
                if (!method.desc.equals("(Ljava/lang/Runnable;)Lcom/google/common/util/concurrent/ListenableFuture;") || ifaces.contains(iface)) continue;
                ifaces.add(iface);
            }
        }
        if (ifaces.size() == 1) {
            this.addClassMapping("net/minecraft/util/IThreadListener", (String)ifaces.get(0));
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/util/IThreadListener addScheduledTask (Ljava/lang/Runnable;)Lcom/google/common/util/concurrent/ListenableFuture;", "net/minecraft/util/IThreadListener isCallingFromMinecraftThread ()Z"}, depends={"net/minecraft/util/IThreadListener"})
    public boolean processIThreadListenerClass() {
        ClassNode threadListener = this.getClassNodeFromMapping("net/minecraft/util/IThreadListener");
        if (threadListener == null) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(threadListener, null, "(Ljava/lang/Runnable;)Lcom/google/common/util/concurrent/ListenableFuture;");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/util/IThreadListener addScheduledTask (Ljava/lang/Runnable;)Lcom/google/common/util/concurrent/ListenableFuture;", threadListener.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(threadListener, null, "()Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/util/IThreadListener isCallingFromMinecraftThread ()Z", threadListener.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/init/Blocks"}, depends={"net/minecraft/world/World"})
    public boolean getBlocksClass() {
        ClassNode worldClass = this.getClassNodeFromMapping("net/minecraft/world/World");
        if (worldClass == null) {
            return false;
        }
        HashSet<String> potentialClasses = new HashSet<String>();
        for (MethodNode method : worldClass.methods) {
            for (AbstractInsnNode node = method.instructions.getFirst(); node != null; node = node.getNext()) {
                String descClass;
                if (node.getOpcode() != 178) continue;
                FieldInsnNode fieldNode = (FieldInsnNode)node;
                if (!fieldNode.desc.startsWith("L") || fieldNode.desc.contains("/") || fieldNode.owner.equals(descClass = Type.getType((String)fieldNode.desc).getClassName())) continue;
                potentialClasses.add(fieldNode.owner);
            }
        }
        String[] matchStrings = new String[]{"Accessed Blocks before Bootstrap!", "air", "stone"};
        for (String className : potentialClasses) {
            if (!this.searchConstantPoolForStrings(className, matchStrings)) continue;
            ClassNode blocksClass = this.getClassNode(className);
            this.addClassMapping("net/minecraft/init/Blocks", blocksClass);
            return true;
        }
        return false;
    }

    @Mapping(provides={"net/minecraft/block/Block"}, depends={"net/minecraft/init/Blocks"})
    public boolean getBlockClass() {
        ClassNode blocksClass = this.getClassNode(this.getClassMapping("net/minecraft/init/Blocks"));
        if (blocksClass == null) {
            return false;
        }
        HashMap<Object, Integer> classes = new HashMap<Object, Integer>();
        for (FieldNode field : blocksClass.fields) {
            String descClass = Type.getType((String)field.desc).getClassName();
            int val = classes.containsKey(descClass) ? (Integer)classes.get(descClass) : 0;
            classes.put(descClass, ++val);
        }
        String mostClass = null;
        int mostCount = 0;
        for (String key : classes.keySet()) {
            if ((Integer)classes.get(key) <= mostCount) continue;
            mostClass = key;
            mostCount = (Integer)classes.get(key);
        }
        if (mostCount > 100) {
            ClassNode blockClass = this.getClassNode(mostClass);
            this.addClassMapping("net/minecraft/block/Block", blockClass);
            return true;
        }
        return false;
    }

    @Mapping(provides={"net/minecraft/block/state/BlockState"}, depends={"net/minecraft/block/Block"})
    public boolean getBlockStateClass() {
        ClassNode block = this.getClassNode(this.getClassMapping("net/minecraft/block/Block"));
        if (block == null) {
            return false;
        }
        for (FieldNode fn : block.fields) {
            Type t = Type.getType((String)fn.desc);
            if (t.getSort() != 10) continue;
            if (!this.searchConstantPoolForStrings(t.getClassName(), "block", "properties", "Block: ", " has invalidly named property: ")) continue;
            this.addClassMapping("net/minecraft/block/state/BlockState", t.getClassName());
            return true;
        }
        return false;
    }

    @Mapping(provides={"net/minecraft/block/state/IBlockState"}, depends={"net/minecraft/block/Block"})
    public boolean getIBlockStateClass() {
        ClassNode block = this.getClassNode(this.getClassMapping("net/minecraft/block/Block"));
        if (block == null) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(block, null, null);
        methods = this.removeMethodsWithoutFlags(methods, 8);
        Iterator<MethodNode> it = methods.iterator();
        while (it.hasNext()) {
            MethodNode method = it.next();
            if (!method.desc.equals("(I)L" + block.name + ";") && method.desc.startsWith("(I)L")) continue;
            it.remove();
        }
        if (methods.size() == 1) {
            MethodNode method = methods.get(0);
            Type t = Type.getMethodType((String)method.desc).getReturnType();
            ClassNode cn = this.getClassNode(t.getClassName());
            if ((cn.access & 0x200) == 0) {
                return false;
            }
            boolean check = false;
            for (MethodNode m : cn.methods) {
                if (!m.desc.equals("()L" + block.name + ";")) continue;
                check = true;
            }
            if (check) {
                this.addClassMapping("net/minecraft/block/state/IBlockState", cn.name);
            } else {
                return false;
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/block/state/IBlockWrapper"}, providesMethods={"net/minecraft/block/state/IBlockState getPropertyNames ()Ljava/util/Collection;", "net/minecraft/block/state/IBlockState getValue (Lnet/minecraft/block/properties/IProperty;)Ljava/lang/Comparable;", "net/minecraft/block/state/IBlockState withProperty (Lnet/minecraft/block/properties/IProperty;Ljava/lang/Comparable;)Lnet/minecraft/block/state/IBlockState;", "net/minecraft/block/state/IBlockState cycleProperty (Lnet/minecraft/block/properties/IProperty;)Lnet/minecraft/block/state/IBlockState;", "net/minecraft/block/state/IBlockState getProperties ()Lcom/google/common/collect/ImmutableMap;", "net/minecraft/block/state/IBlockState getBlock ()Lnet/minecraft/block/Block;"}, depends={"net/minecraft/block/Block", "net/minecraft/block/state/IBlockState", "net/minecraft/block/properties/IProperty"})
    public boolean processIBlockStateClass() {
        List<MethodNode> methods;
        ClassNode block = this.getClassNode(this.getClassMapping("net/minecraft/block/Block"));
        ClassNode iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState");
        ClassNode iProperty = this.getClassNodeFromMapping("net/minecraft/block/properties/IProperty");
        if (block == null || iBlockState == null || iProperty == null) {
            return false;
        }
        if (iBlockState.interfaces.size() == 1) {
            this.addClassMapping("net/minecraft/block/state/IBlockWrapper", (String)iBlockState.interfaces.get(0));
        }
        if ((methods = this.getMatchingMethods(iBlockState, null, "()Ljava/util/Collection;")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/state/IBlockState getPropertyNames ()Ljava/util/Collection;", iBlockState.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iBlockState, null, "(L" + iProperty.name + ";)Ljava/lang/Comparable;")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/state/IBlockState getValue (Lnet/minecraft/block/properties/IProperty;)Ljava/lang/Comparable;", iBlockState.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iBlockState, null, "(L" + iProperty.name + ";Ljava/lang/Comparable;)L" + iBlockState.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/state/IBlockState withProperty (Lnet/minecraft/block/properties/IProperty;Ljava/lang/Comparable;)Lnet/minecraft/block/state/IBlockState;", iBlockState.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iBlockState, null, "(L" + iProperty.name + ";)L" + iBlockState.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/state/IBlockState cycleProperty (Lnet/minecraft/block/properties/IProperty;)Lnet/minecraft/block/state/IBlockState;", iBlockState.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iBlockState, null, "()Lcom/google/common/collect/ImmutableMap;")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/state/IBlockState getProperties ()Lcom/google/common/collect/ImmutableMap;", iBlockState.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iBlockState, null, "()L" + block.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/state/IBlockState getBlock ()Lnet/minecraft/block/Block;", iBlockState.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/world/IBlockAccess"}, depends={"net/minecraft/world/World"})
    public boolean getIBlockAccessClass() {
        ClassNode world = this.getClassNode(this.getClassMapping("net/minecraft/world/World"));
        if (world == null) {
            return false;
        }
        if (world.interfaces.size() != 1) {
            return false;
        }
        ClassNode classBlockAccess = this.getClassNode((String)world.interfaces.get(0));
        this.addClassMapping("net/minecraft/world/IBlockAccess", classBlockAccess);
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/world/IBlockAccess getTileEntity (Lnet/minecraft/util/BlockPos;)Lnet/minecraft/tileentity/TileEntity;", "net/minecraft/world/IBlockAccess getBlockState (Lnet/minecraft/util/BlockPos;)Lnet/minecraft/block/state/IBlockState;", "net/minecraft/world/IBlockAccess isAirBlock (Lnet/minecraft/util/BlockPos;)Z", "net/minecraft/world/IBlockAccess getStrongPower (Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/EnumFacing;)I"}, depends={"net/minecraft/world/IBlockAccess", "net/minecraft/block/state/IBlockState", "net/minecraft/tileentity/TileEntity", "net/minecraft/util/BlockPos", "net/minecraft/util/EnumFacing"})
    public boolean processIBlockAccessClass() {
        ClassNode iBlockAccess = this.getClassNodeFromMapping("net/minecraft/world/IBlockAccess");
        ClassNode iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState");
        ClassNode tileEntity = this.getClassNodeFromMapping("net/minecraft/tileentity/TileEntity");
        ClassNode blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos");
        ClassNode enumFacing = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing");
        if (!MeddleUtil.notNull((Object[])new Object[]{iBlockAccess, iBlockState, tileEntity, blockPos, enumFacing})) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(iBlockAccess, null, this.assembleDescriptor("(", blockPos, ")", tileEntity));
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/world/IBlockAccess getTileEntity (Lnet/minecraft/util/BlockPos;)Lnet/minecraft/tileentity/TileEntity;", iBlockAccess.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iBlockAccess, null, this.assembleDescriptor("(", blockPos, ")", iBlockState))).size() == 1) {
            this.addMethodMapping("net/minecraft/world/IBlockAccess getBlockState (Lnet/minecraft/util/BlockPos;)Lnet/minecraft/block/state/IBlockState;", iBlockAccess.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iBlockAccess, null, this.assembleDescriptor("(", blockPos, ")Z"))).size() == 1) {
            this.addMethodMapping("net/minecraft/world/IBlockAccess isAirBlock (Lnet/minecraft/util/BlockPos;)Z", iBlockAccess.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iBlockAccess, null, this.assembleDescriptor("(", blockPos, enumFacing, ")I"))).size() == 1) {
            this.addMethodMapping("net/minecraft/world/IBlockAccess getStrongPower (Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/EnumFacing;)I", iBlockAccess.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/util/BlockPos"}, depends={"net/minecraft/block/Block"})
    public boolean getBlockPosClass() {
        ClassNode block = this.getClassNode(this.getClassMapping("net/minecraft/block/Block"));
        if (block == null) {
            return false;
        }
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (MethodNode method : block.methods) {
            Type t = Type.getMethodType((String)method.desc);
            Type[] args = t.getArgumentTypes();
            if (args.length < 2) continue;
            String name = args[1].getClassName();
            int count = counts.containsKey(name) ? (Integer)counts.get(name) : 0;
            counts.put(name, ++count);
        }
        int max = 0;
        String maxClass = null;
        for (String key : counts.keySet()) {
            int count = (Integer)counts.get(key);
            if (count <= max) continue;
            max = count;
            maxClass = key;
        }
        if (max < 10) {
            return false;
        }
        ClassNode blockPos = this.getClassNode(maxClass);
        this.addClassMapping("net/minecraft/util/BlockPos", blockPos);
        return true;
    }

    @Mapping(provides={"net/minecraft/util/Vec3i"}, providesMethods={"net/minecraft/util/BlockPos down (I)Lnet/minecraft/util/BlockPos;", "net/minecraft/util/BlockPos up (I)Lnet/minecraft/util/BlockPos;", "net/minecraft/util/BlockPos north (I)Lnet/minecraft/util/BlockPos;", "net/minecraft/util/BlockPos south (I)Lnet/minecraft/util/BlockPos;", "net/minecraft/util/BlockPos west (I)Lnet/minecraft/util/BlockPos;", "net/minecraft/util/BlockPos east (I)Lnet/minecraft/util/BlockPos;", "net/minecraft/util/BlockPos down ()Lnet/minecraft/util/BlockPos;", "net/minecraft/util/BlockPos up ()Lnet/minecraft/util/BlockPos;", "net/minecraft/util/BlockPos north ()Lnet/minecraft/util/BlockPos;", "net/minecraft/util/BlockPos south ()Lnet/minecraft/util/BlockPos;", "net/minecraft/util/BlockPos west ()Lnet/minecraft/util/BlockPos;", "net/minecraft/util/BlockPos east ()Lnet/minecraft/util/BlockPos;", "net/minecraft/util/BlockPos offset (Lnet/minecraft/util/EnumFacing;)Lnet/minecraft/util/BlockPos;"}, dependsFields={"net/minecraft/util/EnumFacing DOWN Lnet/minecraft/util/EnumFacing;", "net/minecraft/util/EnumFacing UP Lnet/minecraft/util/EnumFacing;", "net/minecraft/util/EnumFacing NORTH Lnet/minecraft/util/EnumFacing;", "net/minecraft/util/EnumFacing SOUTH Lnet/minecraft/util/EnumFacing;", "net/minecraft/util/EnumFacing WEST Lnet/minecraft/util/EnumFacing;", "net/minecraft/util/EnumFacing EAST Lnet/minecraft/util/EnumFacing;"}, depends={"net/minecraft/util/BlockPos", "net/minecraft/util/EnumFacing"})
    public boolean processBlockPosClass() {
        ClassNode blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos");
        ClassNode enumFacing = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing");
        if (blockPos == null || enumFacing == null) {
            return false;
        }
        if (this.searchConstantPoolForStrings(blockPos.superName, "x", "y", "z")) {
            this.addClassMapping("net/minecraft/util/Vec3i", blockPos.superName);
        }
        FieldNode[] facings = new FieldNode[]{this.getFieldNodeFromMapping(enumFacing, "net/minecraft/util/EnumFacing DOWN Lnet/minecraft/util/EnumFacing;"), this.getFieldNodeFromMapping(enumFacing, "net/minecraft/util/EnumFacing UP Lnet/minecraft/util/EnumFacing;"), this.getFieldNodeFromMapping(enumFacing, "net/minecraft/util/EnumFacing NORTH Lnet/minecraft/util/EnumFacing;"), this.getFieldNodeFromMapping(enumFacing, "net/minecraft/util/EnumFacing SOUTH Lnet/minecraft/util/EnumFacing;"), this.getFieldNodeFromMapping(enumFacing, "net/minecraft/util/EnumFacing WEST Lnet/minecraft/util/EnumFacing;"), this.getFieldNodeFromMapping(enumFacing, "net/minecraft/util/EnumFacing EAST Lnet/minecraft/util/EnumFacing;")};
        for (int n = 0; n < 6; ++n) {
            if (facings[n] != null) continue;
            return false;
        }
        String[] dirs = new String[]{"down", "up", "north", "south", "west", "east"};
        MethodNode[] offsetMethods = new MethodNode[6];
        List<MethodNode> methods = this.getMatchingMethods(blockPos, null, "(I)L" + blockPos.name + ";");
        if (methods.size() == 6) {
            for (int methodNum = 0; methodNum < 6; ++methodNum) {
                AbstractInsnNode insn = this.findNextOpcodeNum(methods.get((int)methodNum).instructions.getFirst(), 178);
                if (insn == null) continue;
                FieldInsnNode fn = (FieldInsnNode)insn;
                if (!fn.owner.equals(enumFacing.name) || !fn.desc.equals("L" + enumFacing.name + ";")) continue;
                for (int dirNum = 0; dirNum < 6; ++dirNum) {
                    if (!facings[dirNum].name.equals(fn.name)) continue;
                    this.addMethodMapping("net/minecraft/util/BlockPos " + dirs[dirNum] + " (I)Lnet/minecraft/util/BlockPos;", blockPos.name + " " + methods.get((int)methodNum).name + " " + methods.get((int)methodNum).desc);
                    offsetMethods[dirNum] = methods.get(methodNum);
                }
            }
        }
        if ((methods = this.getMatchingMethods(blockPos, null, "()L" + blockPos.name + ";")).size() >= 6) {
            for (MethodNode method : methods) {
                AbstractInsnNode insn = this.findNextOpcodeNum(method.instructions.getFirst(), 182);
                if (insn == null) continue;
                MethodInsnNode mn = (MethodInsnNode)insn;
                if (!mn.owner.equals(blockPos.name) || !mn.desc.equals("(I)L" + blockPos.name + ";")) continue;
                for (int dirNum = 0; dirNum < 6; ++dirNum) {
                    if (!offsetMethods[dirNum].name.equals(mn.name)) continue;
                    this.addMethodMapping("net/minecraft/util/BlockPos " + dirs[dirNum] + " ()Lnet/minecraft/util/BlockPos;", blockPos.name + " " + method.name + " " + method.desc);
                }
            }
        }
        if ((methods = this.getMatchingMethods(blockPos, null, "(L" + enumFacing.name + ";)L" + blockPos.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/util/BlockPos offset (Lnet/minecraft/util/EnumFacing;)Lnet/minecraft/util/BlockPos;", blockPos.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/util/Vec3i x I", "net/minecraft/util/Vec3i y I", "net/minecraft/util/Vec3i z I"}, providesMethods={"net/minecraft/util/Vec3i getX ()I", "net/minecraft/util/Vec3i getY ()I", "net/minecraft/util/Vec3i getZ ()I"}, depends={"net/minecraft/util/Vec3i"})
    public boolean processVec3iClass() {
        ClassNode vec3i = this.getClassNodeFromMapping("net/minecraft/util/Vec3i");
        if (vec3i == null) {
            return false;
        }
        String x = null;
        String y = null;
        String z = null;
        List<FieldNode> fields = this.getMatchingFields(vec3i, null, "I");
        if (fields.size() == 3) {
            x = fields.get((int)0).name;
            y = fields.get((int)1).name;
            z = fields.get((int)2).name;
            this.addFieldMapping("net/minecraft/util/Vec3i x I", vec3i.name + " " + x + " I");
            this.addFieldMapping("net/minecraft/util/Vec3i y I", vec3i.name + " " + y + " I");
            this.addFieldMapping("net/minecraft/util/Vec3i z I", vec3i.name + " " + z + " I");
        }
        List<MethodNode> methods = this.getMatchingMethods(vec3i, null, "()I");
        for (MethodNode method : methods) {
            if (!this.matchOpcodeSequence(method.instructions.getFirst(), 25, 180, 172)) continue;
            FieldInsnNode fn = (FieldInsnNode)this.findNextOpcodeNum(method.instructions.getFirst(), 180);
            if (!fn.owner.equals(vec3i.name) || !fn.desc.equals("I")) continue;
            if (fn.name.equals(x)) {
                this.addMethodMapping("net/minecraft/util/Vec3i getX ()I", vec3i.name + " " + method.name + " ()I");
                continue;
            }
            if (fn.name.equals(y)) {
                this.addMethodMapping("net/minecraft/util/Vec3i getY ()I", vec3i.name + " " + method.name + " ()I");
                continue;
            }
            if (!fn.name.equals(z)) continue;
            this.addMethodMapping("net/minecraft/util/Vec3i getZ ()I", vec3i.name + " " + method.name + " ()I");
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/util/Vec3 xCoord D", "net/minecraft/util/Vec3 yCoord D", "net/minecraft/util/Vec3 zCoord D"}, providesMethods={}, depends={"net/minecraft/util/Vec3"})
    public boolean processVec3Class() {
        ClassNode vec3 = this.getClassNodeFromMapping("net/minecraft/util/Vec3");
        if (!MeddleUtil.notNull((Object[])new Object[]{vec3})) {
            return false;
        }
        List<FieldNode> fields = this.getMatchingFields(vec3, null, "D");
        if (fields.size() == 3) {
            this.addFieldMapping("net/minecraft/util/Vec3 xCoord D", vec3.name + " " + fields.get((int)0).name + " D");
            this.addFieldMapping("net/minecraft/util/Vec3 yCoord D", vec3.name + " " + fields.get((int)1).name + " D");
            this.addFieldMapping("net/minecraft/util/Vec3 zCoord D", vec3.name + " " + fields.get((int)2).name + " D");
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/entity/item/EntityItem", "net/minecraft/item/ItemStack"}, providesMethods={"net/minecraft/block/Block spawnAsEntity (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/item/ItemStack;)V"}, depends={"net/minecraft/world/World", "net/minecraft/util/BlockPos", "net/minecraft/block/Block"})
    public boolean getEntityItemClass() {
        ClassNode blockClass;
        ClassNode blockPosClass;
        ClassNode worldClass = this.getClassNode(this.getClassMapping("net/minecraft/world/World"));
        if (!MeddleUtil.notNull((Object[])new Object[]{worldClass, blockPosClass = this.getClassNode(this.getClassMapping("net/minecraft/util/BlockPos")), blockClass = this.getClassNode(this.getClassMapping("net/minecraft/block/Block"))})) {
            return false;
        }
        for (MethodNode method : blockClass.methods) {
            Type methodType;
            Type[] arguments;
            if ((method.access & 8) != 8 || (arguments = (methodType = Type.getMethodType((String)method.desc)).getArgumentTypes()).length != 3 || arguments[0].getSort() != 10 || arguments[1].getSort() != 10 || arguments[2].getSort() != 10 || !arguments[0].getClassName().equals(worldClass.name) || !arguments[1].getClassName().equals(blockPosClass.name)) continue;
            boolean foundString = false;
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (!foundString && this.isLdcWithString(insn, "doTileDrops")) {
                    foundString = true;
                    continue;
                }
                if (!foundString || insn.getOpcode() != 187) continue;
                TypeInsnNode newNode = (TypeInsnNode)insn;
                this.addClassMapping("net/minecraft/entity/item/EntityItem", this.getClassNode(newNode.desc));
                this.addClassMapping("net/minecraft/item/ItemStack", this.getClassNode(arguments[2].getClassName()));
                this.addMethodMapping("net/minecraft/block/Block spawnAsEntity (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/item/ItemStack;)V", blockClass.name + " " + method.name + " " + method.desc);
                return true;
            }
        }
        return false;
    }

    @Mapping(provides={"net/minecraft/block/BlockFire", "net/minecraft/block/BlockLeaves", "net/minecraft/block/BlockChest", "net/minecraft/block/BlockSlab", "net/minecraft/block/BlockHopper", "net/minecraft/block/BlockGrass"}, providesFields={"net/minecraft/init/Blocks air Lnet/minecraft/block/Block;", "net/minecraft/init/Blocks stone Lnet/minecraft/block/Block;", "net/minecraft/init/Blocks grass Lnet/minecraft/block/BlockGrass;", "net/minecraft/init/Blocks dirt Lnet/minecraft/block/Block;", "net/minecraft/init/Blocks cobblestone Lnet/minecraft/block/Block;", "net/minecraft/init/Blocks planks Lnet/minecraft/block/Block;", "net/minecraft/init/Blocks sapling Lnet/minecraft/block/Block;", "net/minecraft/init/Blocks bedrock Lnet/minecraft/block/Block;", "net/minecraft/init/Blocks iron_block Lnet/minecraft/block/Block;", "net/minecraft/init/Blocks chest Lnet/minecraft/block/BlockChest;", "net/minecraft/init/Blocks obsidian Lnet/minecraft/block/Block;", "net/minecraft/init/Blocks hopper Lnet/minecraft/block/BlockHopper;", "net/minecraft/init/Blocks glass_pane Lnet/minecraft/block/Block;"}, depends={"net/minecraft/init/Blocks", "net/minecraft/block/Block"})
    public boolean processBlocksClass() {
        FieldInsnNode field;
        HashMap<String, String> blocksClassFields = new HashMap<String, String>();
        HashMap<String, FieldInsnNode> blocksFields = new HashMap<String, FieldInsnNode>();
        ClassNode blockClass = this.getClassNode(this.getClassMapping("net/minecraft/block/Block"));
        ClassNode blocksClass = this.getClassNode(this.getClassMapping("net/minecraft/init/Blocks"));
        if (blockClass == null || blocksClass == null) {
            return false;
        }
        for (MethodNode method : blocksClass.methods) {
            if (!method.name.equals("<clinit>")) continue;
            String lastString = null;
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                String s = this.getLdcString(insn);
                if (s != null) {
                    lastString = s;
                }
                if (lastString == null || lastString.contains(" ") || insn.getOpcode() != 179) continue;
                FieldInsnNode fieldNode = (FieldInsnNode)insn;
                if (!fieldNode.desc.startsWith("L") || fieldNode.desc.contains("/")) continue;
                blocksFields.put(lastString, fieldNode);
                if (fieldNode.desc.equals("L" + blockClass.name + ";")) continue;
                blocksClassFields.put(lastString, fieldNode.desc.substring(1, fieldNode.desc.length() - 1));
            }
        }
        String className = (String)blocksClassFields.get("fire");
        if (className != null && this.searchConstantPoolForStrings(className, "doFireTick")) {
            this.addClassMapping("net/minecraft/block/BlockFire", this.getClassNode(className));
        }
        if ((className = (String)blocksClassFields.get("leaves")) != null && this.searchConstantPoolForStrings(className, "decayable")) {
            this.addClassMapping("net/minecraft/block/BlockLeaves", this.getClassNode(className));
        }
        if ((className = (String)blocksClassFields.get("chest")) != null && this.searchConstantPoolForStrings(className, "container.chestDouble")) {
            this.addClassMapping("net/minecraft/block/BlockChest", this.getClassNode(className));
        }
        if ((className = (String)blocksClassFields.get("stone_slab")) != null && this.searchConstantPoolForStrings(className, "half")) {
            this.addClassMapping("net/minecraft/block/BlockSlab", className);
        }
        if ((className = (String)blocksClassFields.get("hopper")) != null && this.searchConstantPoolForStrings(className, "facing", "enabled")) {
            this.addClassMapping("net/minecraft/block/BlockHopper", className);
        }
        if ((className = (String)blocksClassFields.get("grass")) != null && this.searchConstantPoolForStrings(className, "snowy")) {
            this.addClassMapping("net/minecraft/block/BlockGrass", className);
        }
        if ((field = (FieldInsnNode)blocksFields.get("air")) != null) {
            this.addFieldMapping("net/minecraft/init/Blocks air Lnet/minecraft/block/Block;", field);
        }
        if ((field = (FieldInsnNode)blocksFields.get("stone")) != null) {
            this.addFieldMapping("net/minecraft/init/Blocks stone Lnet/minecraft/block/Block;", field);
        }
        if ((field = (FieldInsnNode)blocksFields.get("grass")) != null) {
            this.addFieldMapping("net/minecraft/init/Blocks grass Lnet/minecraft/block/BlockGrass;", field);
        }
        if ((field = (FieldInsnNode)blocksFields.get("dirt")) != null) {
            this.addFieldMapping("net/minecraft/init/Blocks dirt Lnet/minecraft/block/Block;", field);
        }
        if ((field = (FieldInsnNode)blocksFields.get("cobblestone")) != null) {
            this.addFieldMapping("net/minecraft/init/Blocks cobblestone Lnet/minecraft/block/Block;", field);
        }
        if ((field = (FieldInsnNode)blocksFields.get("planks")) != null) {
            this.addFieldMapping("net/minecraft/init/Blocks planks Lnet/minecraft/block/Block;", field);
        }
        if ((field = (FieldInsnNode)blocksFields.get("sapling")) != null) {
            this.addFieldMapping("net/minecraft/init/Blocks sapling Lnet/minecraft/block/Block;", field);
        }
        if ((field = (FieldInsnNode)blocksFields.get("bedrock")) != null) {
            this.addFieldMapping("net/minecraft/init/Blocks bedrock Lnet/minecraft/block/Block;", field);
        }
        if ((field = (FieldInsnNode)blocksFields.get("chest")) != null) {
            this.addFieldMapping("net/minecraft/init/Blocks chest Lnet/minecraft/block/BlockChest;", field);
        }
        if ((field = (FieldInsnNode)blocksFields.get("glass_pane")) != null) {
            this.addFieldMapping("net/minecraft/init/Blocks glass_pane Lnet/minecraft/block/Block;", field);
        }
        if ((field = (FieldInsnNode)blocksFields.get("iron_block")) != null) {
            this.addFieldMapping("net/minecraft/init/Blocks iron_block Lnet/minecraft/block/Block;", field);
        }
        if ((field = (FieldInsnNode)blocksFields.get("obsidian")) != null) {
            this.addFieldMapping("net/minecraft/init/Blocks obsidian Lnet/minecraft/block/Block;", field);
        }
        if ((field = (FieldInsnNode)blocksFields.get("hopper")) != null) {
            this.addFieldMapping("net/minecraft/init/Blocks hopper Lnet/minecraft/block/BlockHopper;", field);
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/init/Sounds entity_creeper_primed Lnet/minecraft/util/Sound;", "net/minecraft/init/Sounds entity_hostile_hurt Lnet/minecraft/util/Sound;", "net/minecraft/init/Sounds entity_hostile_swim Lnet/minecraft/util/Sound;", "net/minecraft/init/Sounds block_water_ambient Lnet/minecraft/util/Sound;", "net/minecraft/init/Sounds block_lava_pop Lnet/minecraft/util/Sound;", "net/minecraft/init/Sounds entity_generic_explode Lnet/minecraft/util/Sound;", "net/minecraft/init/Sounds ui_button_click Lnet/minecraft/util/Sound;", "net/minecraft/init/Sounds block_portal_trigger Lnet/minecraft/util/Sound;"}, depends={"net/minecraft/util/Sound", "net/minecraft/init/Sounds"})
    public boolean processSoundsClass() {
        ClassNode sound = this.getClassNodeFromMapping("net/minecraft/util/Sound");
        ClassNode sounds = this.getClassNodeFromMapping("net/minecraft/init/Sounds");
        if (sound == null || sounds == null) {
            return false;
        }
        HashMap<String, FieldInsnNode> soundFields = new HashMap<String, FieldInsnNode>();
        for (MethodNode method : sounds.methods) {
            if (!method.name.equals("<clinit>")) continue;
            String lastString = null;
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                String s = this.getLdcString(insn);
                if (s != null) {
                    lastString = s;
                }
                if (lastString == null || lastString.contains(" ") || insn.getOpcode() != 179) continue;
                FieldInsnNode fieldNode = (FieldInsnNode)insn;
                if (!fieldNode.desc.equals("L" + sound.name + ";")) continue;
                soundFields.put(lastString, fieldNode);
                String newName = lastString.replace(".", "_");
                this.addFieldMapping("net/minecraft/init/Sounds " + newName + " Lnet/minecraft/util/Sound;", fieldNode);
            }
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/block/BlockHopper FACING Lnet/minecraft/block/properties/PropertyDirection;", "net/minecraft/block/BlockHopper ENABLED Lnet/minecraft/block/properties/PropertyBool;", "net/minecraft/block/material/Material iron Lnet/minecraft/block/material/Material;"}, providesMethods={"net/minecraft/block/properties/PropertyDirection create (Ljava/lang/String;Lcom/google/common/base/Predicate;)Lnet/minecraft/block/properties/PropertyDirection;", "net/minecraft/item/ItemStack hasDisplayName ()Z", "net/minecraft/util/EnumFacing getOpposite ()Lnet/minecraft/util/EnumFacing;"}, dependsMethods={"net/minecraft/block/Block onBlockPlacedBy (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;)V", "net/minecraft/block/Block isFullCube (Lnet/minecraft/block/state/IBlockState;)Z", "net/minecraft/block/Block isOpaqueCube (Lnet/minecraft/block/state/IBlockState;)Z", "net/minecraft/block/Block onBlockPlaced (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/EnumFacing;FFFILnet/minecraft/entity/EntityLivingBase;)Lnet/minecraft/block/state/IBlockState;"}, depends={"net/minecraft/block/Block", "net/minecraft/block/BlockHopper", "net/minecraft/block/properties/PropertyDirection", "net/minecraft/block/properties/PropertyBool", "net/minecraft/block/material/Material", "net/minecraft/item/ItemStack", "net/minecraft/block/state/IBlockState", "net/minecraft/util/EnumFacing"})
    public boolean processBlockHopperClass() {
        List<MethodInsnNode> nodes;
        List<MethodInsnNode> getOpposite;
        MethodNode hasDisplayName;
        List<MethodInsnNode> nodes2;
        List<MethodInsnNode> hasDisplayNameList;
        MethodNode onBlockPlacedBy;
        List<FieldInsnNode> materials;
        List<MethodInsnNode> nodes3;
        List<MethodNode> methods;
        ClassNode enumFacing;
        ClassNode iBlockState;
        ClassNode itemStack;
        ClassNode material;
        ClassNode propertyBool;
        ClassNode propertyDirection;
        ClassNode blockHopper;
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        if (!MeddleUtil.notNull((Object[])new Object[]{block, blockHopper = this.getClassNodeFromMapping("net/minecraft/block/BlockHopper"), propertyDirection = this.getClassNodeFromMapping("net/minecraft/block/properties/PropertyDirection"), propertyBool = this.getClassNodeFromMapping("net/minecraft/block/properties/PropertyBool"), material = this.getClassNodeFromMapping("net/minecraft/block/material/Material"), itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack"), iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState"), enumFacing = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing")})) {
            return false;
        }
        List<FieldNode> fields = this.getMatchingFields(blockHopper, null, "L" + propertyDirection.name + ";");
        if (fields.size() == 1) {
            this.addFieldMapping("net/minecraft/block/BlockHopper FACING Lnet/minecraft/block/properties/PropertyDirection;", blockHopper.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        if ((fields = this.getMatchingFields(blockHopper, null, "L" + propertyBool.name + ";")).size() == 1) {
            this.addFieldMapping("net/minecraft/block/BlockHopper ENABLED Lnet/minecraft/block/properties/PropertyBool;", blockHopper.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(blockHopper, "<clinit>", "()V")).size() == 1) {
            nodes3 = this.getAllInsnNodesOfType(methods.get(0), MethodInsnNode.class);
            if ((nodes3 = this.filterMethodInsnNodes(nodes3, propertyDirection.name, "(Ljava/lang/String;Lcom/google/common/base/Predicate;)L" + propertyDirection.name + ";")).size() == 1) {
                this.addMethodMapping("net/minecraft/block/properties/PropertyDirection create (Ljava/lang/String;Lcom/google/common/base/Predicate;)Lnet/minecraft/block/properties/PropertyDirection;", propertyDirection.name + " " + nodes3.get((int)0).name + " " + nodes3.get((int)0).desc);
            }
        }
        if ((methods = this.getMatchingMethods(blockHopper, "<init>", "()V")).size() == 1 && (materials = this.filterFieldInsnNodes(nodes3 = this.getAllInsnNodesOfType(methods.get(0), FieldInsnNode.class), material.name, "L" + material.name + ";")).size() == 1) {
            this.addFieldMapping("net/minecraft/block/material/Material iron Lnet/minecraft/block/material/Material;", material.name + " " + materials.get((int)0).name + " " + materials.get((int)0).desc);
        }
        if ((onBlockPlacedBy = this.getMethodNodeFromMapping(blockHopper, "net/minecraft/block/Block onBlockPlacedBy (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;)V")) != null && (hasDisplayNameList = this.filterMethodInsnNodes(nodes2 = this.getAllInsnNodesOfType(onBlockPlacedBy, MethodInsnNode.class), itemStack.name, "()Z")).size() == 1 && (hasDisplayName = this.getMethodNode(itemStack, "--- " + hasDisplayNameList.get((int)0).name + " " + hasDisplayNameList.get((int)0).desc)) != null) {
            for (AbstractInsnNode insn = hasDisplayName.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (!this.isLdcWithString(insn, "Name")) continue;
                this.addMethodMapping("net/minecraft/item/ItemStack hasDisplayName ()Z", itemStack.name + " " + hasDisplayName.name + " " + hasDisplayName.desc);
                break;
            }
        }
        MethodNode isFullCube = this.getMethodNodeFromMapping(blockHopper, "net/minecraft/block/Block isFullCube (Lnet/minecraft/block/state/IBlockState;)Z");
        MethodNode isOpaqueCube = this.getMethodNodeFromMapping(blockHopper, "net/minecraft/block/Block isOpaqueCube (Lnet/minecraft/block/state/IBlockState;)Z");
        MethodNode onBlockPlaced = this.getMethodNodeFromMapping(blockHopper, "net/minecraft/block/Block onBlockPlaced (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/EnumFacing;FFFILnet/minecraft/entity/EntityLivingBase;)Lnet/minecraft/block/state/IBlockState;");
        if (onBlockPlaced != null && (getOpposite = this.filterMethodInsnNodes(nodes = this.getAllInsnNodesOfType(onBlockPlaced, MethodInsnNode.class), enumFacing.name, "()L" + enumFacing.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/util/EnumFacing getOpposite ()Lnet/minecraft/util/EnumFacing;", enumFacing.name + " " + getOpposite.get((int)0).name + " " + getOpposite.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/block/BlockLeavesBase"}, providesMethods={"net/minecraft/block/Block setTickRandomly (Z)Lnet/minecraft/block/Block;", "net/minecraft/block/Block isVisuallyOpaque ()Z", "net/minecraft/block/Block isOpaqueCube (Lnet/minecraft/block/state/IBlockState;)Z"}, depends={"net/minecraft/block/Block", "net/minecraft/block/BlockLeaves", "net/minecraft/block/state/IBlockState"})
    public boolean processBlockLeavesClass() {
        List<MethodNode> methods;
        MethodNode init;
        ClassNode iBlockState;
        ClassNode blockLeaves = this.getClassNode(this.getClassMapping("net/minecraft/block/BlockLeaves"));
        ClassNode block = this.getClassNode(this.getClassMapping("net/minecraft/block/Block"));
        if (!MeddleUtil.notNull((Object[])new Object[]{block, blockLeaves, iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState")})) {
            return false;
        }
        ClassNode blockLeavesBase = this.getClassNode(blockLeaves.superName);
        if (blockLeavesBase != null && blockLeavesBase.superName != null && block.name.equals(blockLeavesBase.superName)) {
            this.addClassMapping("net/minecraft/block/BlockLeavesBase", blockLeavesBase);
        }
        if ((init = this.getMethodNode(blockLeaves, "--- <init> ()V")) != null) {
            List<MethodInsnNode> nodes = this.getAllInsnNodesOfType(init, MethodInsnNode.class);
            Iterator<MethodInsnNode> it = nodes.iterator();
            while (it.hasNext()) {
                MethodInsnNode mn = it.next();
                if (mn.owner.equals(blockLeaves.name) && mn.desc.equals("(Z)L" + block.name + ";")) continue;
                it.remove();
            }
            if (nodes.size() == 1) {
                this.addMethodMapping("net/minecraft/block/Block setTickRandomly (Z)Lnet/minecraft/block/Block;", block.name + " " + nodes.get((int)0).name + " " + nodes.get((int)0).desc);
            }
        }
        if ((methods = this.getMatchingMethods(blockLeaves, null, "()Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block isVisuallyOpaque ()Z", block.name + " " + methods.get((int)0).name + " ()Z");
        }
        if ((methods = this.getMatchingMethods(blockLeaves, null, this.assembleDescriptor("(", iBlockState, ")Z"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block isOpaqueCube (Lnet/minecraft/block/state/IBlockState;)Z", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/block/Block fullBlock Z"}, providesMethods={"net/minecraft/block/Block canSilkHarvest ()Z", "net/minecraft/block/Block getBlockBoundsBasedOnState (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;)Lnet/minecraft/util/AxisAlignedBB;", "net/minecraft/block/Block isFullCube (Lnet/minecraft/block/state/IBlockState;)Z"}, dependsMethods={"net/minecraft/block/Block isOpaqueCube (Lnet/minecraft/block/state/IBlockState;)Z"}, depends={"net/minecraft/block/Block", "net/minecraft/block/BlockSlab", "net/minecraft/block/material/Material", "net/minecraft/block/state/IBlockState", "net/minecraft/world/IBlockAccess", "net/minecraft/util/BlockPos", "net/minecraft/util/AxisAlignedBB"})
    public boolean processBlockSlabClass() {
        MethodNode canSilkHarvest;
        List<FieldInsnNode> nodes;
        ClassNode aabb;
        ClassNode blockPos;
        ClassNode iBlockAccess;
        ClassNode iBlockState;
        ClassNode material;
        ClassNode blockSlab;
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        if (!MeddleUtil.notNull((Object[])new Object[]{block, blockSlab = this.getClassNodeFromMapping("net/minecraft/block/BlockSlab"), material = this.getClassNodeFromMapping("net/minecraft/block/material/Material"), iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState"), iBlockAccess = this.getClassNodeFromMapping("net/minecraft/world/IBlockAccess"), blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos"), aabb = this.getClassNodeFromMapping("net/minecraft/util/AxisAlignedBB")})) {
            return false;
        }
        MethodNode init = this.getMethodNode(blockSlab, "--- <init> (L" + material.name + ";)V");
        if (init != null && (nodes = this.getAllInsnNodesOfType(init, FieldInsnNode.class)).size() == 1 && nodes.get((int)0).owner.equals(blockSlab.name) && nodes.get((int)0).desc.equals("Z")) {
            this.addFieldMapping("net/minecraft/block/Block fullBlock Z", block.name + " " + nodes.get((int)0).name + " Z");
        }
        List<MethodNode> methods = this.getMatchingMethods(blockSlab, null, "()Z");
        if ((methods = this.removeMethodsWithFlags(methods, 1024)).size() == 1 && (canSilkHarvest = this.getMethodNode(block, "--- " + methods.get((int)0).name + " " + methods.get((int)0).desc)) != null) {
            this.addMethodMapping("net/minecraft/block/Block canSilkHarvest ()Z", block.name + " " + canSilkHarvest.name + " ()Z");
        }
        if ((methods = this.getMatchingMethods(blockSlab, null, this.assembleDescriptor("(", iBlockState, iBlockAccess, blockPos, ")", aabb))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getBlockBoundsBasedOnState (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;)Lnet/minecraft/util/AxisAlignedBB;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        MethodNode isOpaqueCube = this.getMethodNodeFromMapping(block, "net/minecraft/block/Block isOpaqueCube (Lnet/minecraft/block/state/IBlockState;)Z");
        methods = this.getMatchingMethods(blockSlab, null, "(L" + iBlockState.name + ";)Z");
        if ((methods = this.removeMethodsWithFlags(methods, 8)).size() == 3 && isOpaqueCube != null) {
            Iterator<MethodNode> it = methods.iterator();
            while (it.hasNext()) {
                MethodNode method = it.next();
                if (method.name.equals(isOpaqueCube.name) && method.desc.equals(isOpaqueCube.desc)) {
                    it.remove();
                }
                if (this.matchOpcodeSequence(method.instructions.getFirst(), 25, 182, 172)) continue;
                it.remove();
            }
            if (methods.size() == 1) {
                this.addMethodMapping("net/minecraft/block/Block isFullCube (Lnet/minecraft/block/state/IBlockState;)Z", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/item/Item"}, depends={"net/minecraft/block/Block", "net/minecraft/item/ItemStack"})
    public boolean getItemClass() {
        String className;
        ClassNode blockClass = this.getClassNode(this.getClassMapping("net/minecraft/block/Block"));
        ClassNode itemStackClass = this.getClassNode(this.getClassMapping("net/minecraft/item/ItemStack"));
        if (blockClass == null || itemStackClass == null) {
            return false;
        }
        ArrayList<String> possibleClasses = new ArrayList<String>();
        for (MethodNode method : itemStackClass.methods) {
            String className2;
            Type t;
            Type[] args;
            if (!method.name.equals("<init>") || (args = (t = Type.getMethodType((String)method.desc)).getArgumentTypes()).length != 1 || args[0].getSort() != 10 || (className2 = args[0].getClassName()).equals(blockClass.name)) continue;
            possibleClasses.add(className2);
        }
        if (possibleClasses.size() == 1 && this.searchConstantPoolForStrings(className = (String)possibleClasses.get(0), "item.", "arrow")) {
            this.addClassMapping("net/minecraft/item/Item", this.getClassNode((String)possibleClasses.get(0)));
            return true;
        }
        return false;
    }

    @Mapping(provides={"net/minecraft/block/BlockContainer", "net/minecraft/block/ITileEntityProvider"}, depends={"net/minecraft/block/Block", "net/minecraft/block/BlockChest"})
    public boolean getBlockContainerClass() {
        ClassNode blockClass = this.getClassNode(this.getClassMapping("net/minecraft/block/Block"));
        ClassNode blockChestClass = this.getClassNode(this.getClassMapping("net/minecraft/block/BlockChest"));
        if (blockClass == null || blockChestClass == null || blockChestClass.superName == null) {
            return false;
        }
        ClassNode containerClass = this.getClassNode(blockChestClass.superName);
        if (!containerClass.superName.equals(blockClass.name)) {
            return false;
        }
        if (containerClass.interfaces.size() != 1) {
            return false;
        }
        this.addClassMapping("net/minecraft/block/BlockContainer", containerClass);
        this.addClassMapping("net/minecraft/block/ITileEntityProvider", this.getClassNode((String)containerClass.interfaces.get(0)));
        return true;
    }

    @Mapping(provides={"net/minecraft/tileentity/TileEntity"}, providesMethods={"net/minecraft/block/ITileEntityProvider createNewTileEntity (Lnet/minecraft/world/World;I)Lnet/minecraft/tileentity/TileEntity;"}, depends={"net/minecraft/block/ITileEntityProvider", "net/minecraft/world/World"})
    public boolean getTileEntityClass() {
        ClassNode teProviderClass = this.getClassNode(this.getClassMapping("net/minecraft/block/ITileEntityProvider"));
        ClassNode world = this.getClassNodeFromMapping("net/minecraft/world/World");
        if (teProviderClass == null || world == null) {
            return false;
        }
        String tileEntity_name = null;
        for (MethodNode method : teProviderClass.methods) {
            Type t = Type.getMethodType((String)method.desc);
            Type returnType = t.getReturnType();
            if (returnType.getSort() != 10) {
                return false;
            }
            String className = returnType.getClassName();
            if (tileEntity_name == null && this.searchConstantPoolForStrings(className, "Furnace", "MobSpawner")) {
                this.addClassMapping("net/minecraft/tileentity/TileEntity", this.getClassNode(className));
                tileEntity_name = className;
            }
            if (tileEntity_name == null || !method.desc.equals("(L" + world.name + ";I)L" + tileEntity_name + ";")) continue;
            this.addMethodMapping("net/minecraft/block/ITileEntityProvider createNewTileEntity (Lnet/minecraft/world/World;I)Lnet/minecraft/tileentity/TileEntity;", teProviderClass.name + " " + method.name + " " + method.desc);
            return true;
        }
        return false;
    }

    @Mapping(provides={"net/minecraft/tileentity/TileEntityChest", "net/minecraft/network/PacketBuffer", "net/minecraft/network/Packet", "net/minecraft/crash/CrashReportCategory"}, providesFields={"net/minecraft/tileentity/TileEntity worldObj Lnet/minecraft/world/World;", "net/minecraft/tileentity/TileEntity pos Lnet/minecraft/util/BlockPos;", "net/minecraft/tileentity/TileEntity tileEntityInvalid Z", "net/minecraft/tileentity/TileEntity blockMetadata I", "net/minecraft/tileentity/TileEntity blockType Lnet/minecraft/block/Block;"}, providesMethods={"net/minecraft/tileentity/TileEntity addMapping (Ljava/lang/Class;Ljava/lang/String;)V", "net/minecraft/tileentity/TileEntity getWorld ()Lnet/minecraft/world/World;", "net/minecraft/tileentity/TileEntity setWorldObj (Lnet/minecraft/world/World;)V", "net/minecraft/tileentity/TileEntity createAndLoadEntity (Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/tileentity/TileEntity;", "net/minecraft/tileentity/TileEntity getBlockMetadata ()I", "net/minecraft/tileentity/TileEntity getPos ()Lnet/minecraft/util/BlockPos;", "net/minecraft/tileentity/TileEntity setPos (Lnet/minecraft/util/BlockPos;)V", "net/minecraft/tileentity/TileEntity getBlockType ()Lnet/minecraft/block/Block;", "net/minecraft/tileentity/TileEntity receiveClientEvent (II)Z", "net/minecraft/tileentity/TileEntity getDescriptionPacket ()Lnet/minecraft/network/Packet;", "net/minecraft/tileentity/TileEntity addInfoToCrashReport (Lnet/minecraft/crash/CrashReportCategory;)V", "net/minecraft/tileentity/TileEntity validate ()V", "net/minecraft/tileentity/TileEntity invalidate ()V", "net/minecraft/tileentity/TileEntity updateContainingBlockInfo ()V", "net/minecraft/tileentity/TileEntity markDirty ()V", "net/minecraft/tileentity/TileEntity readFromNBT (Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/nbt/NBTTagCompound;)V", "net/minecraft/tileentity/TileEntity writeToNBT (Lnet/minecraft/nbt/NBTTagCompound;)V"}, depends={"net/minecraft/tileentity/TileEntity", "net/minecraft/world/World", "net/minecraft/nbt/NBTTagCompound", "net/minecraft/util/BlockPos", "net/minecraft/block/Block", "net/minecraft/init/Blocks"})
    public boolean processTileEntityClass() {
        List<FieldNode> fields;
        ClassNode blocks;
        ClassNode block;
        ClassNode blockPos;
        ClassNode tagCompound;
        ClassNode world;
        ClassNode minecraftServer = this.getClassNode("net/minecraft/server/MinecraftServer");
        ClassNode tileEntity = this.getClassNodeFromMapping("net/minecraft/tileentity/TileEntity");
        if (!MeddleUtil.notNull((Object[])new Object[]{tileEntity, world = this.getClassNodeFromMapping("net/minecraft/world/World"), tagCompound = this.getClassNodeFromMapping("net/minecraft/nbt/NBTTagCompound"), blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos"), block = this.getClassNodeFromMapping("net/minecraft/block/Block"), blocks = this.getClassNodeFromMapping("net/minecraft/init/Blocks")})) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(tileEntity, "<clinit>", "()V");
        if (methods.size() != 1) {
            return false;
        }
        HashMap<String, String> teMap = new HashMap<String, String>();
        String lastClass = null;
        for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
            String c = this.getLdcClass(insn);
            if (c != null) {
                lastClass = c;
                continue;
            }
            String name = this.getLdcString(insn);
            if (name == null || lastClass == null) continue;
            teMap.put(name, lastClass);
        }
        String className = (String)teMap.get("Chest");
        if (className != null) {
            this.addClassMapping("net/minecraft/tileentity/TileEntityChest", className);
        }
        if ((fields = this.getMatchingFields(tileEntity, null, "L" + world.name + ";")).size() == 1) {
            this.addFieldMapping("net/minecraft/tileentity/TileEntity worldObj Lnet/minecraft/world/World;", tileEntity.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        if ((fields = this.getMatchingFields(tileEntity, null, "L" + blockPos.name + ";")).size() == 1) {
            this.addFieldMapping("net/minecraft/tileentity/TileEntity pos Lnet/minecraft/util/BlockPos;", tileEntity.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        if ((fields = this.getMatchingFields(tileEntity, null, "Z")).size() == 1) {
            this.addFieldMapping("net/minecraft/tileentity/TileEntity tileEntityInvalid Z", tileEntity.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        if ((fields = this.getMatchingFields(tileEntity, null, "I")).size() == 1) {
            this.addFieldMapping("net/minecraft/tileentity/TileEntity blockMetadata I", tileEntity.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        if ((fields = this.getMatchingFields(tileEntity, null, "L" + block.name + ";")).size() == 1) {
            this.addFieldMapping("net/minecraft/tileentity/TileEntity blockType Lnet/minecraft/block/Block;", tileEntity.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tileEntity, null, "(Ljava/lang/Class;Ljava/lang/String;)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/tileentity/TileEntity addMapping (Ljava/lang/Class;Ljava/lang/String;)V", tileEntity.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tileEntity, null, "()L" + world.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/tileentity/TileEntity getWorld ()Lnet/minecraft/world/World;", tileEntity.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tileEntity, null, "(L" + world.name + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/tileentity/TileEntity setWorldObj (Lnet/minecraft/world/World;)V", tileEntity.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tileEntity, null, this.assembleDescriptor("(", minecraftServer, tagCompound, ")", tileEntity))).size() == 1) {
            this.addMethodMapping("net/minecraft/tileentity/TileEntity createAndLoadEntity (Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/tileentity/TileEntity;", tileEntity.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tileEntity, null, "()I")).size() == 1) {
            this.addMethodMapping("net/minecraft/tileentity/TileEntity getBlockMetadata ()I", tileEntity.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tileEntity, null, "()L" + blockPos.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/tileentity/TileEntity getPos ()Lnet/minecraft/util/BlockPos;", tileEntity.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tileEntity, null, "(L" + blockPos.name + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/tileentity/TileEntity setPos (Lnet/minecraft/util/BlockPos;)V", tileEntity.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tileEntity, null, "()L" + block.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/tileentity/TileEntity getBlockType ()Lnet/minecraft/block/Block;", tileEntity.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tileEntity, null, "(II)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/tileentity/TileEntity receiveClientEvent (II)Z", tileEntity.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        for (Object method : tileEntity.methods) {
            ClassNode packet;
            String packetClass;
            if (!((MethodNode)method).desc.startsWith("()L") || (packetClass = Type.getMethodType((String)((MethodNode)method).desc).getReturnType().getClassName()).contains(".") || (packet = this.getClassNode(packetClass)) == null || (packet.access & 0x200) == 0) continue;
            boolean isPacket = false;
            for (MethodNode m : packet.methods) {
                Type t = Type.getMethodType((String)m.desc);
                Type[] args = t.getArgumentTypes();
                if (args.length != 1) continue;
                String packetBuffer_name = args[0].getClassName();
                if (!this.searchConstantPoolForStrings(packetBuffer_name, "VarInt too big", "String too big (was")) continue;
                this.addClassMapping("net/minecraft/network/PacketBuffer", packetBuffer_name);
                isPacket = true;
                break;
            }
            if (!isPacket) continue;
            this.addClassMapping("net/minecraft/network/Packet", packet);
            this.addMethodMapping("net/minecraft/tileentity/TileEntity getDescriptionPacket ()Lnet/minecraft/network/Packet;", tileEntity.name + " " + ((MethodNode)method).name + " " + ((MethodNode)method).desc);
            break;
        }
        methods.clear();
        for (Object method : tileEntity.methods) {
            Type t = Type.getMethodType((String)((MethodNode)method).desc);
            Type[] args = t.getArgumentTypes();
            if (t.getReturnType().getSort() != 0 || args.length != 1) continue;
            className = args[0].getClassName();
            if (!this.searchConstantPoolForStrings(className, "(Error finding world loc)", "Details:")) continue;
            this.addClassMapping("net/minecraft/crash/CrashReportCategory", className);
            methods.add((MethodNode)method);
        }
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/tileentity/TileEntity addInfoToCrashReport (Lnet/minecraft/crash/CrashReportCategory;)V", tileEntity.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        methods = this.getMatchingMethods(tileEntity, null, "()V");
        Iterator<MethodNode> it = methods.iterator();
        while (it.hasNext()) {
            if (!it.next().name.contains("<")) continue;
            it.remove();
        }
        if (methods.size() == 4) {
            ArrayList<MethodNode> matchedMethods = new ArrayList<MethodNode>();
            for (MethodNode method : methods) {
                if (!this.matchOpcodeSequence(method.instructions.getFirst(), 25, 3, 181, 177)) continue;
                matchedMethods.add(method);
            }
            if (matchedMethods.size() == 1) {
                this.addMethodMapping("net/minecraft/tileentity/TileEntity validate ()V", tileEntity.name + " " + ((MethodNode)matchedMethods.get((int)0)).name + " ()V");
                methods.remove(matchedMethods.get(0));
            }
            matchedMethods.clear();
            for (MethodNode method : methods) {
                if (!this.matchOpcodeSequence(method.instructions.getFirst(), 25, 4, 181, 177)) continue;
                matchedMethods.add(method);
            }
            if (matchedMethods.size() == 1) {
                this.addMethodMapping("net/minecraft/tileentity/TileEntity invalidate ()V", tileEntity.name + " " + ((MethodNode)matchedMethods.get((int)0)).name + " ()V");
                methods.remove(matchedMethods.get(0));
            }
            matchedMethods.clear();
            for (MethodNode method : methods) {
                if (!this.matchOpcodeSequence(method.instructions.getFirst(), 25, 1, 181, 25, 2, 181, 177)) continue;
                matchedMethods.add(method);
            }
            if (matchedMethods.size() == 1) {
                this.addMethodMapping("net/minecraft/tileentity/TileEntity updateContainingBlockInfo ()V", tileEntity.name + " " + ((MethodNode)matchedMethods.get((int)0)).name + " ()V");
                methods.remove(matchedMethods.get(0));
            }
            if (methods.size() == 1) {
                for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
                    if (insn.getOpcode() != 178 || !((FieldInsnNode)insn).owner.equals(blocks.name)) continue;
                    this.addMethodMapping("net/minecraft/tileentity/TileEntity markDirty ()V", tileEntity.name + " " + methods.get((int)0).name + " ()V");
                    break;
                }
            }
        }
        if ((methods = this.getMatchingMethods(tileEntity, null, this.assembleDescriptor("(", minecraftServer, tagCompound, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/tileentity/TileEntity readFromNBT (Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/nbt/NBTTagCompound;)V", tileEntity.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tileEntity, null, this.assembleDescriptor("(", tagCompound, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/tileentity/TileEntity writeToNBT (Lnet/minecraft/nbt/NBTTagCompound;)V", tileEntity.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/inventory/ContainerChest", "net/minecraft/tileentity/TileEntityLockable", "net/minecraft/server/gui/IUpdatePlayerListBox"}, providesMethods={}, depends={"net/minecraft/tileentity/TileEntity", "net/minecraft/tileentity/TileEntityChest", "net/minecraft/entity/player/InventoryPlayer", "net/minecraft/entity/player/EntityPlayer", "net/minecraft/inventory/Container", "net/minecraft/inventory/IInventory"})
    public boolean processTileEntityChestClass() {
        List<MethodNode> methods;
        ClassNode tileEntity = this.getClassNodeFromMapping("net/minecraft/tileentity/TileEntity");
        ClassNode tileEntityChest = this.getClassNodeFromMapping("net/minecraft/tileentity/TileEntityChest");
        ClassNode inventoryPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/InventoryPlayer");
        ClassNode entityPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayer");
        ClassNode container = this.getClassNodeFromMapping("net/minecraft/inventory/Container");
        ClassNode iInventory = this.getClassNodeFromMapping("net/minecraft/inventory/IInventory");
        if (!MeddleUtil.notNull((Object[])new Object[]{tileEntity, tileEntityChest, inventoryPlayer, entityPlayer, container, iInventory})) {
            return false;
        }
        if (tileEntityChest.interfaces.size() == 2) {
            String iUpdatePlayerListBox_name = null;
            int count = 0;
            for (String iface : tileEntityChest.interfaces) {
                if (iface.equals(iInventory.name)) continue;
                ++count;
                iUpdatePlayerListBox_name = iface;
            }
            if (count == 1) {
                ClassNode iUpdatePlayerListBox = this.getClassNode(iUpdatePlayerListBox_name);
                if (iUpdatePlayerListBox.methods.size() == 1) {
                    this.addClassMapping("net/minecraft/server/gui/IUpdatePlayerListBox", iUpdatePlayerListBox_name);
                }
            }
        }
        if (this.searchConstantPoolForStrings(tileEntityChest.superName, "LootTable")) {
            ClassNode lootTableClass = this.getClassNode(tileEntityChest.superName);
            ClassNode tileEntityLockable = this.getClassNode(lootTableClass.superName);
            if (tileEntityLockable.superName.equals(tileEntity.name)) {
                this.addClassMapping("net/minecraft/tileentity/TileEntityLockable", tileEntityLockable.name);
            }
        }
        if ((methods = this.getMatchingMethods(tileEntityChest, null, this.assembleDescriptor("(", inventoryPlayer, entityPlayer, ")", container))).size() == 1) {
            for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 187) continue;
                TypeInsnNode tn = (TypeInsnNode)insn;
                ClassNode containerChest = this.getClassNode(tn.desc);
                if (!containerChest.superName.equals(container.name)) continue;
                this.addClassMapping("net/minecraft/inventory/ContainerChest", containerChest);
            }
        }
        return true;
    }

    @Mapping(provides={}, providesMethods={"net/minecraft/inventory/IInventory openInventory (Lnet/minecraft/entity/player/EntityPlayer;)V", "net/minecraft/inventory/IInventory closeInventory (Lnet/minecraft/entity/player/EntityPlayer;)V"}, depends={"net/minecraft/inventory/ContainerChest", "net/minecraft/inventory/IInventory", "net/minecraft/entity/player/EntityPlayer"})
    public boolean processContainerChest() {
        ClassNode entityPlayer;
        ClassNode iInventory;
        ClassNode containerChest = this.getClassNodeFromMapping("net/minecraft/inventory/ContainerChest");
        if (!MeddleUtil.notNull((Object[])new Object[]{containerChest, iInventory = this.getClassNodeFromMapping("net/minecraft/inventory/IInventory"), entityPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayer")})) {
            return false;
        }
        String openInventory = null;
        List<MethodNode> methods = this.getMatchingMethods(containerChest, "<init>", this.assembleDescriptor("(", iInventory, iInventory, entityPlayer, ")V"));
        if (methods.size() == 1) {
            for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 185) continue;
                MethodInsnNode mn = (MethodInsnNode)insn;
                if (!mn.owner.equals(iInventory.name) || !mn.desc.equals("(L" + entityPlayer.name + ";)V")) continue;
                openInventory = mn.name;
            }
        }
        methods = this.getMatchingMethods(iInventory, null, "(L" + entityPlayer.name + ";)V");
        if (openInventory != null && methods.size() == 2) {
            for (MethodNode method : methods) {
                if (method.name.equals(openInventory)) {
                    this.addMethodMapping("net/minecraft/inventory/IInventory openInventory (Lnet/minecraft/entity/player/EntityPlayer;)V", iInventory.name + " " + method.name + " " + method.desc);
                    continue;
                }
                this.addMethodMapping("net/minecraft/inventory/IInventory closeInventory (Lnet/minecraft/entity/player/EntityPlayer;)V", iInventory.name + " " + method.name + " " + method.desc);
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/entity/player/EntityPlayer"}, depends={"net/minecraft/server/MinecraftServer", "net/minecraft/world/World", "net/minecraft/util/BlockPos"})
    public boolean getEntityPlayerClass() {
        ClassNode serverClass = this.getClassNode(this.getClassMapping("net/minecraft/server/MinecraftServer"));
        ClassNode worldClass = this.getClassNode(this.getClassMapping("net/minecraft/world/World"));
        ClassNode blockPosClass = this.getClassNode(this.getClassMapping("net/minecraft/util/BlockPos"));
        if (serverClass == null || worldClass == null || blockPosClass == null) {
            return false;
        }
        ArrayList<String> potentialClasses = new ArrayList<String>();
        for (MethodNode method : serverClass.methods) {
            Type[] args;
            Type t = Type.getMethodType((String)method.desc);
            if (t.getReturnType().getSort() != 1 || !this.checkMethodParameters(method, 10, 10, 10) || !(args = t.getArgumentTypes())[0].getClassName().equals(worldClass.name) || !args[1].getClassName().equals(blockPosClass.name)) continue;
            potentialClasses.add(args[2].getClassName());
        }
        if (potentialClasses.size() != 1) {
            return false;
        }
        String className = (String)potentialClasses.get(0);
        if (!this.searchConstantPoolForStrings(className, "Inventory", "Notch")) {
            return false;
        }
        this.addClassMapping("net/minecraft/entity/player/EntityPlayer", this.getClassNode(className));
        return true;
    }

    @Mapping(provides={"net/minecraft/entity/EntityLivingBase"}, depends={"net/minecraft/entity/player/EntityPlayer"})
    public boolean getEntityLivingBaseClass() {
        ClassNode entityPlayerClass = this.getClassNode(this.getClassMapping("net/minecraft/entity/player/EntityPlayer"));
        if (entityPlayerClass == null || entityPlayerClass.superName == null) {
            return false;
        }
        if (!this.searchConstantPoolForStrings(entityPlayerClass.superName, "Health", "doMobLoot", "ai")) {
            return false;
        }
        this.addClassMapping("net/minecraft/entity/EntityLivingBase", this.getClassNode(entityPlayerClass.superName));
        return true;
    }

    @Mapping(provides={"net/minecraft/entity/Entity"}, depends={"net/minecraft/entity/EntityLivingBase"})
    public boolean getEntityClass() {
        ClassNode entityLivingBase = this.getClassNode(this.getClassMapping("net/minecraft/entity/EntityLivingBase"));
        if (entityLivingBase == null || entityLivingBase.superName == null) {
            return false;
        }
        ClassNode entity = this.getClassNode(entityLivingBase.superName);
        if (!entity.superName.equals("java/lang/Object")) {
            return false;
        }
        this.addClassMapping("net/minecraft/entity/Entity", entity);
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/entity/Entity getFlag (I)Z", "net/minecraft/entity/Entity isSneaking ()Z"}, depends={"net/minecraft/entity/Entity"})
    public boolean processEntityClass() {
        ClassNode entity = this.getClassNodeFromMapping("net/minecraft/entity/Entity");
        if (entity == null) {
            return false;
        }
        MethodNode getFlag = null;
        List<MethodNode> methods = this.getMatchingMethods(entity, null, "(I)Z");
        if (methods.size() == 1) {
            getFlag = methods.get(0);
            this.addMethodMapping("net/minecraft/entity/Entity getFlag (I)Z", entity.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        methods = this.getMatchingMethods(entity, null, "()Z");
        Iterator<MethodNode> it = methods.iterator();
        while (it.hasNext()) {
            MethodNode method = it.next();
            AbstractInsnNode[] nodes = this.getOpcodeSequenceArray(method.instructions.getFirst(), 25, 4, 182, 172);
            if (nodes == null) {
                it.remove();
                continue;
            }
            MethodInsnNode mn = (MethodInsnNode)nodes[2];
            if (mn.owner.equals(entity.name) && mn.name.equals(getFlag.name) && mn.desc.equals(getFlag.desc)) continue;
            it.remove();
        }
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/entity/Entity isSneaking ()Z", entity.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/entity/EntityList"}, depends={"net/minecraft/entity/Entity"})
    public boolean getEntityListClass() {
        ClassNode entity = this.getClassNode(this.getClassMapping("net/minecraft/entity/Entity"));
        if (entity == null) {
            return false;
        }
        String className = null;
        for (MethodNode method : entity.methods) {
            if (!method.desc.startsWith("(I")) continue;
            boolean foundFirst = false;
            boolean foundSecond = false;
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (!foundFirst && !this.isLdcWithString(insn, "changeDimension")) continue;
                foundFirst = true;
                if (!foundSecond && !this.isLdcWithString(insn, "reloading")) continue;
                foundSecond = true;
                if (insn.getOpcode() == 184) {
                    MethodInsnNode mn = (MethodInsnNode)insn;
                    if (className == null) {
                        className = mn.owner;
                        continue;
                    }
                    if (!className.equals(mn.owner)) {
                        return false;
                    }
                }
                if (className != null) break;
            }
            if (className == null) continue;
            break;
        }
        if (!this.searchConstantPoolForStrings(className, "ThrownPotion", "EnderDragon")) {
            return false;
        }
        this.addClassMapping("net/minecraft/entity/EntityList", this.getClassNode(className));
        return true;
    }

    @Mapping(provides={"net/minecraft/entity/monster/EntityZombie", "net/minecraft/entity/passive/EntityVillager", "net/minecraft/entity/passive/EntitySheep", "net/minecraft/entity/monster/EntityEnderman", "net/minecraft/entity/item/EntityEnderPearl", "net/minecraft/entity/monster/EntityCreeper", "net/minecraft/entity/passive/EntityOcelot"}, depends={"net/minecraft/entity/EntityList"})
    public boolean parseEntityList() {
        String ocelotClass;
        String creeperClass;
        String enderpearlClass;
        String endermanClass;
        String sheepClass;
        String villagerClass;
        String zombieClass;
        HashMap<String, String> entityListClasses = new HashMap<String, String>();
        ClassNode entityList = this.getClassNode(this.getClassMapping("net/minecraft/entity/EntityList"));
        if (entityList == null) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(entityList, "<clinit>", "()V");
        if (methods.size() != 1) {
            return false;
        }
        String entityClass = null;
        String entityName = null;
        for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
            entityClass = this.getLdcClass(insn);
            if (entityClass == null) continue;
            if ((insn = insn.getNext()) == null) break;
            entityName = this.getLdcString(insn);
            if (entityName == null) continue;
            entityListClasses.put(entityName, entityClass);
        }
        if ((zombieClass = (String)entityListClasses.get("Zombie")) != null && this.searchConstantPoolForStrings(zombieClass, "zombie.spawnReinforcements", "IsBaby")) {
            this.addClassMapping("net/minecraft/entity/monster/EntityZombie", zombieClass);
        }
        if ((villagerClass = (String)entityListClasses.get("Villager")) != null && this.searchConstantPoolForStrings(villagerClass, "Profession", "entity.Villager.")) {
            this.addClassMapping("net/minecraft/entity/passive/EntityVillager", villagerClass);
        }
        if ((sheepClass = (String)entityListClasses.get("Sheep")) != null && this.searchConstantPoolForStrings(sheepClass, "Sheared")) {
            this.addClassMapping("net/minecraft/entity/passive/EntitySheep", sheepClass);
        }
        if ((endermanClass = (String)entityListClasses.get("Enderman")) != null && this.searchConstantPoolForStrings(endermanClass, "carried", "carriedData")) {
            this.addClassMapping("net/minecraft/entity/monster/EntityEnderman", endermanClass);
        }
        if ((enderpearlClass = (String)entityListClasses.get("ThrownEnderpearl")) != null && this.searchConstantPoolForStrings(enderpearlClass, "doMobSpawning")) {
            this.addClassMapping("net/minecraft/entity/item/EntityEnderPearl", enderpearlClass);
        }
        if ((creeperClass = (String)entityListClasses.get("Creeper")) != null && this.searchConstantPoolForStrings(creeperClass, "mobGriefing", "Fuse", "ExplosionRadius")) {
            this.addClassMapping("net/minecraft/entity/monster/EntityCreeper", creeperClass);
        }
        if ((ocelotClass = (String)entityListClasses.get("Ozelot")) != null && this.searchConstantPoolForStrings(ocelotClass, "CatType", "entity.Cat.name")) {
            this.addClassMapping("net/minecraft/entity/passive/EntityOcelot", ocelotClass);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/entity/monster/EntityMob", "net/minecraft/world/GameRules", "net/minecraft/world/Explosion"}, providesMethods={"net/minecraft/entity/Entity onUpdate ()V", "net/minecraft/entity/Entity playSound (Lnet/minecraft/util/Sound;FF)V", "net/minecraft/entity/monster/EntityCreeper explode ()V", "net/minecraft/world/World getGameRules ()Lnet/minecraft/world/GameRules;", "net/minecraft/world/World createExplosion (Lnet/minecraft/entity/Entity;DDDFZ)Lnet/minecraft/world/Explosion;"}, dependsFields={"net/minecraft/init/Sounds entity_creeper_primed Lnet/minecraft/util/Sound;", "net/minecraft/init/Sounds entity_hostile_hurt Lnet/minecraft/util/Sound;", "net/minecraft/init/Sounds entity_hostile_swim Lnet/minecraft/util/Sound;", "net/minecraft/init/Sounds entity_generic_explode Lnet/minecraft/util/Sound;"}, depends={"net/minecraft/entity/monster/EntityCreeper", "net/minecraft/entity/Entity", "net/minecraft/world/World", "net/minecraft/init/Sounds", "net/minecraft/util/Sound"})
    public boolean processEntityCreeperClass() {
        MethodNode explode;
        String swimSound;
        ClassNode creeper = this.getClassNodeFromMapping("net/minecraft/entity/monster/EntityCreeper");
        ClassNode entity = this.getClassNodeFromMapping("net/minecraft/entity/Entity");
        ClassNode world = this.getClassNodeFromMapping("net/minecraft/world/World");
        ClassNode sounds = this.getClassNodeFromMapping("net/minecraft/init/Sounds");
        ClassNode sound = this.getClassNodeFromMapping("net/minecraft/util/Sound");
        if (!MeddleUtil.notNull((Object[])new Object[]{creeper, entity, world, sound, sounds})) {
            return false;
        }
        String hurtSound = this.getSoundFieldFull("entity.hostile.hurt");
        if (this.searchConstantPoolForFields(creeper.superName, hurtSound, swimSound = this.getSoundFieldFull("entity.hostile.swim"))) {
            this.addClassMapping("net/minecraft/entity/monster/EntityMob", creeper.superName);
        }
        String fieldPrimed = this.getSoundField("entity.creeper.primed");
        List<MethodNode> methods = this.getMatchingMethods(creeper, null, "()V");
        Iterator<MethodNode> it = methods.iterator();
        while (it.hasNext()) {
            MethodNode method = it.next();
            boolean hasIt = false;
            List<FieldInsnNode> fields = this.getAllInsnNodesOfType(method.instructions.getFirst(), FieldInsnNode.class);
            for (FieldInsnNode fn : fields) {
                if (!fn.owner.equals(sounds.name) || !fn.name.equals(fieldPrimed)) continue;
                hasIt = true;
            }
            if (hasIt) continue;
            it.remove();
        }
        String explodeName = null;
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/entity/Entity onUpdate ()V", entity.name + " " + methods.get((int)0).name + " ()V");
            MethodInsnNode playSound = null;
            int playSoundCount = 0;
            explode = null;
            int explodeCount = 0;
            List<MethodInsnNode> nodes = this.getAllInsnNodesOfType(methods.get((int)0).instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : nodes) {
                if (mn.owner.equals(creeper.name) && mn.desc.equals("(L" + sound.name + ";FF)V")) {
                    playSound = mn;
                    ++playSoundCount;
                }
                if (mn.owner.equals(creeper.name) && mn.desc.equals("()V")) {
                    explode = mn;
                    ++explodeCount;
                }
                if (playSoundCount == 1) {
                    this.addMethodMapping("net/minecraft/entity/Entity playSound (Lnet/minecraft/util/Sound;FF)V", entity.name + " " + playSound.name + " " + playSound.desc);
                }
                if (explodeCount != true) continue;
                this.addMethodMapping("net/minecraft/entity/monster/EntityCreeper explode ()V", creeper.name + " " + explode.name + " ()V");
                explodeName = explode.name;
            }
        }
        String gameRules = null;
        String soundExplosion = this.getSoundFieldFull("entity.generic.explode");
        explode = this.getMethodNodeFromMapping(creeper, "net/minecraft/entity/monster/EntityCreeper explode ()V");
        if (explode != null) {
            List<MethodInsnNode> miNodes = this.getAllInsnNodesOfType(explode.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : miNodes) {
                String returnClass;
                if (!mn.owner.equals(world.name)) continue;
                if (mn.desc.startsWith("()L")) {
                    returnClass = Type.getMethodType((String)mn.desc).getReturnType().getClassName();
                    if (!this.searchConstantPoolForStrings(returnClass, "doFireTick", "doDaylightCycle", "reducedDebugInfo")) continue;
                    gameRules = returnClass;
                    this.addClassMapping("net/minecraft/world/GameRules", returnClass);
                    this.addMethodMapping("net/minecraft/world/World getGameRules ()Lnet/minecraft/world/GameRules;", world.name + " " + mn.name + " " + mn.desc);
                    continue;
                }
                if (!mn.desc.startsWith("(L" + entity.name + ";DDDFZ)L") || !this.searchConstantPoolForFields(returnClass = Type.getMethodType((String)mn.desc).getReturnType().getClassName(), soundExplosion)) continue;
                this.addClassMapping("net/minecraft/world/Explosion", returnClass);
                this.addMethodMapping("net/minecraft/world/World createExplosion (Lnet/minecraft/entity/Entity;DDDFZ)Lnet/minecraft/world/Explosion;", world.name + " " + mn.name + " " + mn.desc);
            }
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/world/Explosion doExplosionA ()V", "net/minecraft/world/Explosion doExplosionB (Z)V"}, depends={"net/minecraft/world/Explosion"})
    public boolean processExplosionClass() {
        ClassNode explosion = this.getClassNodeFromMapping("net/minecraft/world/Explosion");
        if (explosion == null) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(explosion, null, "()V");
        Iterator<MethodNode> it = methods.iterator();
        while (it.hasNext()) {
            MethodNode mn = it.next();
            if (mn.name.startsWith("<")) {
                it.remove();
                continue;
            }
            if (!this.matchOpcodeSequence(mn.instructions.getFirst(), 25, 180, 185, 177)) continue;
            it.remove();
        }
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/world/Explosion doExplosionA ()V", explosion.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(explosion, null, "(Z)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/world/Explosion doExplosionB (Z)V", explosion.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={}, providesFields={"net/minecraft/entity/monster/EntityEnderman carriableBlocks Ljava/util/Set;"}, providesMethods={}, depends={"net/minecraft/entity/monster/EntityEnderman", "net/minecraft/entity/EntityLivingBase", "net/minecraft/entity/Entity"})
    public boolean processEntityEndermanClass() {
        ClassNode entityEnderman = this.getClassNodeFromMapping("net/minecraft/entity/monster/EntityEnderman");
        ClassNode entityLivingBase = this.getClassNodeFromMapping("net/minecraft/entity/EntityLivingBase");
        ClassNode entity = this.getClassNodeFromMapping("net/minecraft/entity/Entity");
        if (!MeddleUtil.notNull((Object[])new Object[]{entityEnderman, entityLivingBase, entity})) {
            return false;
        }
        List<FieldNode> fields = this.getMatchingFields(entityEnderman, null, "Ljava/util/Set;");
        if (fields.size() == 1) {
            this.addFieldMapping("net/minecraft/entity/monster/EntityEnderman carriableBlocks Ljava/util/Set;", entityEnderman.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/entity/Entity fallDistance F"}, depends={"net/minecraft/entity/item/EntityEnderPearl", "net/minecraft/entity/Entity", "net/minecraft/entity/EntityLivingBase", "net/minecraft/util/MovingObjectPosition"})
    public boolean processEntityEnderPearlClass() {
        ClassNode pearl = this.getClassNodeFromMapping("net/minecraft/entity/item/EntityEnderPearl");
        ClassNode entity = this.getClassNodeFromMapping("net/minecraft/entity/Entity");
        ClassNode entityLivingBase = this.getClassNodeFromMapping("net/minecraft/entity/EntityLivingBase");
        ClassNode movingObjectPos = this.getClassNodeFromMapping("net/minecraft/util/MovingObjectPosition");
        if (pearl == null || entity == null || movingObjectPos == null) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(pearl, null, "(L" + movingObjectPos.name + ";)V");
        if (methods.size() == 1) {
            HashSet<String> fieldNames = new HashSet<String>();
            for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
                AbstractInsnNode node;
                if (insn.getOpcode() != 11 || (node = this.getNextRealOpcode(insn.getNext())) == null || node.getOpcode() != 181) continue;
                FieldInsnNode fn = (FieldInsnNode)node;
                if (!fn.owner.equals(entityLivingBase.name) || !fn.desc.equals("F")) continue;
                fieldNames.add(fn.name);
            }
            if (fieldNames.size() == 1) {
                String name = (String)fieldNames.iterator().next();
                this.addFieldMapping("net/minecraft/entity/Entity fallDistance F", entity.name + " " + name + " F");
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/block/BlockAir", "net/minecraft/block/BlockStone", "net/minecraft/block/BlockGrass", "net/minecraft/block/BlockDirt", "net/minecraft/block/BlockPlanks", "net/minecraft/block/BlockSapling", "net/minecraft/block/BlockDynamicLiquid", "net/minecraft/block/BlockStaticLiquid", "net/minecraft/block/BlockSand", "net/minecraft/block/BlockGravel", "net/minecraft/block/BlockOre", "net/minecraft/block/BlockOldLog", "net/minecraft/block/BlockOldLeaf", "net/minecraft/block/BlockSponge", "net/minecraft/block/BlockGlass", "net/minecraft/block/BlockDispenser", "net/minecraft/block/BlockSandStone", "net/minecraft/block/BlockNote", "net/minecraft/block/BlockBed", "net/minecraft/block/BlockRailPowered", "net/minecraft/block/BlockRailDetector", "net/minecraft/block/BlockPistonBase", "net/minecraft/block/BlockWeb", "net/minecraft/block/BlockTallGrass", "net/minecraft/block/BlockDeadBush", "net/minecraft/block/BlockPistonExtension", "net/minecraft/block/BlockColored", "net/minecraft/block/BlockPistonMoving", "net/minecraft/block/BlockYellowFlower", "net/minecraft/block/BlockRedFlower", "net/minecraft/block/BlockMushroom", "net/minecraft/block/BlockDoubleStoneSlab", "net/minecraft/block/BlockHalfStoneSlab", "net/minecraft/block/BlockTNT", "net/minecraft/block/BlockBookshelf", "net/minecraft/block/BlockObsidian", "net/minecraft/block/BlockTorch", "net/minecraft/block/BlockFire", "net/minecraft/block/BlockMobSpawner", "net/minecraft/block/BlockStairs", "net/minecraft/block/BlockChest", "net/minecraft/block/BlockRedstoneWire", "net/minecraft/block/BlockWorkbench", "net/minecraft/block/BlockWorkbench$InterfaceCraftingTable", "net/minecraft/block/BlockCrops", "net/minecraft/block/BlockFarmland", "net/minecraft/block/BlockFurnace", "net/minecraft/block/BlockStandingSign", "net/minecraft/block/BlockDoor", "net/minecraft/block/BlockLadder", "net/minecraft/block/BlockRail", "net/minecraft/block/BlockWallSign", "net/minecraft/block/BlockLever", "net/minecraft/block/BlockPressurePlate", "net/minecraft/block/BlockRedstoneOre", "net/minecraft/block/BlockRedstoneTorch", "net/minecraft/block/BlockButtonStone", "net/minecraft/block/BlockSnow", "net/minecraft/block/BlockIce", "net/minecraft/block/BlockSnowBlock", "net/minecraft/block/BlockCactus", "net/minecraft/block/BlockClay", "net/minecraft/block/BlockReed", "net/minecraft/block/BlockJukebox", "net/minecraft/block/BlockFence", "net/minecraft/block/BlockPumpkin", "net/minecraft/block/BlockNetherrack", "net/minecraft/block/BlockSoulSand", "net/minecraft/block/BlockGlowstone", "net/minecraft/block/BlockPortal", "net/minecraft/block/BlockCake", "net/minecraft/block/BlockRedstoneRepeater", "net/minecraft/block/BlockStainedGlass", "net/minecraft/block/BlockTrapDoor", "net/minecraft/block/BlockSilverfish", "net/minecraft/block/BlockStoneBrick", "net/minecraft/block/BlockHugeMushroom", "net/minecraft/block/BlockPane", "net/minecraft/block/BlockMelon", "net/minecraft/block/BlockStem", "net/minecraft/block/BlockVine", "net/minecraft/block/BlockFenceGate", "net/minecraft/block/BlockMycelium", "net/minecraft/block/BlockLilyPad", "net/minecraft/block/BlockNetherBrick", "net/minecraft/block/BlockNetherWart", "net/minecraft/block/BlockEnchantmentTable", "net/minecraft/block/BlockBrewingStand", "net/minecraft/block/BlockCauldron", "net/minecraft/block/BlockEndPortal", "net/minecraft/block/BlockEndPortalFrame", "net/minecraft/block/BlockDragonEgg", "net/minecraft/block/BlockRedstoneLight", "net/minecraft/block/BlockDoubleWoodSlab", "net/minecraft/block/BlockHalfWoodSlab", "net/minecraft/block/BlockCocoa", "net/minecraft/block/BlockEnderChest", "net/minecraft/block/BlockTripWireHook", "net/minecraft/block/BlockTripWire", "net/minecraft/block/BlockCommandBlock", "net/minecraft/block/BlockBeacon", "net/minecraft/block/BlockWall", "net/minecraft/block/BlockFlowerPot", "net/minecraft/block/BlockCarrot", "net/minecraft/block/BlockPotato", "net/minecraft/block/BlockButtonWood", "net/minecraft/block/BlockSkull", "net/minecraft/block/BlockAnvil", "net/minecraft/block/BlockPressurePlateWeighted", "net/minecraft/block/BlockRedstoneComparator", "net/minecraft/block/BlockDaylightDetector", "net/minecraft/block/BlockCompressedPowered", "net/minecraft/block/BlockHopper", "net/minecraft/block/BlockQuartz", "net/minecraft/block/BlockDropper", "net/minecraft/block/BlockStainedGlassPane", "net/minecraft/block/BlockNewLeaf", "net/minecraft/block/BlockNewLog", "net/minecraft/block/BlockSlime", "net/minecraft/block/BlockBarrier", "net/minecraft/block/BlockPrismarine", "net/minecraft/block/BlockSeaLantern", "net/minecraft/block/BlockHay", "net/minecraft/block/BlockCarpet", "net/minecraft/block/BlockHardenedClay", "net/minecraft/block/BlockPackedIce", "net/minecraft/block/BlockDoublePlant", "net/minecraft/block/BlockBanner$BlockBannerStanding", "net/minecraft/block/BlockBanner$BlockBannerHanging", "net/minecraft/block/BlockRedSandstone", "net/minecraft/block/BlockDoubleStoneSlabNew", "net/minecraft/block/BlockHalfStoneSlabNew"}, dependsMethods={"net/minecraft/block/Block registerBlocks ()V"}, depends={"net/minecraft/block/Block", "net/minecraft/util/ResourceLocation"})
    public boolean discoverBlocks() {
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        MethodNode registerBlocks = this.getMethodNodeFromMapping(block, "net/minecraft/block/Block registerBlocks ()V");
        MethodNode registerBlock1 = this.getMethodNodeFromMapping(block, "net/minecraft/block/Block registerBlock (ILjava/lang/String;Lnet/minecraft/block/Block;)V");
        MethodNode registerBlock2 = this.getMethodNodeFromMapping(block, "net/minecraft/block/Block registerBlock (ILnet/minecraft/util/ResourceLocation;Lnet/minecraft/block/Block;)V");
        if (registerBlocks == null || registerBlock1 == null || registerBlock2 == null) {
            return false;
        }
        HashMap<Integer, String> blockClassMap = new HashMap<Integer, String>();
        blockClassMap.put(0, "net/minecraft/block/BlockAir");
        blockClassMap.put(1, "net/minecraft/block/BlockStone");
        blockClassMap.put(2, "net/minecraft/block/BlockGrass");
        blockClassMap.put(3, "net/minecraft/block/BlockDirt");
        blockClassMap.put(5, "net/minecraft/block/BlockPlanks");
        blockClassMap.put(6, "net/minecraft/block/BlockSapling");
        blockClassMap.put(8, "net/minecraft/block/BlockDynamicLiquid");
        blockClassMap.put(9, "net/minecraft/block/BlockStaticLiquid");
        blockClassMap.put(12, "net/minecraft/block/BlockSand");
        blockClassMap.put(13, "net/minecraft/block/BlockGravel");
        blockClassMap.put(14, "net/minecraft/block/BlockOre");
        blockClassMap.put(17, "net/minecraft/block/BlockOldLog");
        blockClassMap.put(18, "net/minecraft/block/BlockOldLeaf");
        blockClassMap.put(19, "net/minecraft/block/BlockSponge");
        blockClassMap.put(20, "net/minecraft/block/BlockGlass");
        blockClassMap.put(23, "net/minecraft/block/BlockDispenser");
        blockClassMap.put(24, "net/minecraft/block/BlockSandStone");
        blockClassMap.put(25, "net/minecraft/block/BlockNote");
        blockClassMap.put(26, "net/minecraft/block/BlockBed");
        blockClassMap.put(27, "net/minecraft/block/BlockRailPowered");
        blockClassMap.put(28, "net/minecraft/block/BlockRailDetector");
        blockClassMap.put(29, "net/minecraft/block/BlockPistonBase");
        blockClassMap.put(30, "net/minecraft/block/BlockWeb");
        blockClassMap.put(31, "net/minecraft/block/BlockTallGrass");
        blockClassMap.put(32, "net/minecraft/block/BlockDeadBush");
        blockClassMap.put(34, "net/minecraft/block/BlockPistonExtension");
        blockClassMap.put(35, "net/minecraft/block/BlockColored");
        blockClassMap.put(36, "net/minecraft/block/BlockPistonMoving");
        blockClassMap.put(37, "net/minecraft/block/BlockYellowFlower");
        blockClassMap.put(38, "net/minecraft/block/BlockRedFlower");
        blockClassMap.put(39, "net/minecraft/block/BlockMushroom");
        blockClassMap.put(43, "net/minecraft/block/BlockDoubleStoneSlab");
        blockClassMap.put(44, "net/minecraft/block/BlockHalfStoneSlab");
        blockClassMap.put(46, "net/minecraft/block/BlockTNT");
        blockClassMap.put(47, "net/minecraft/block/BlockBookshelf");
        blockClassMap.put(49, "net/minecraft/block/BlockObsidian");
        blockClassMap.put(50, "net/minecraft/block/BlockTorch");
        blockClassMap.put(51, "net/minecraft/block/BlockFire");
        blockClassMap.put(52, "net/minecraft/block/BlockMobSpawner");
        blockClassMap.put(53, "net/minecraft/block/BlockStairs");
        blockClassMap.put(54, "net/minecraft/block/BlockChest");
        blockClassMap.put(55, "net/minecraft/block/BlockRedstoneWire");
        blockClassMap.put(58, "net/minecraft/block/BlockWorkbench");
        blockClassMap.put(59, "net/minecraft/block/BlockCrops");
        blockClassMap.put(60, "net/minecraft/block/BlockFarmland");
        blockClassMap.put(61, "net/minecraft/block/BlockFurnace");
        blockClassMap.put(63, "net/minecraft/block/BlockStandingSign");
        blockClassMap.put(64, "net/minecraft/block/BlockDoor");
        blockClassMap.put(65, "net/minecraft/block/BlockLadder");
        blockClassMap.put(66, "net/minecraft/block/BlockRail");
        blockClassMap.put(68, "net/minecraft/block/BlockWallSign");
        blockClassMap.put(69, "net/minecraft/block/BlockLever");
        blockClassMap.put(70, "net/minecraft/block/BlockPressurePlate");
        blockClassMap.put(73, "net/minecraft/block/BlockRedstoneOre");
        blockClassMap.put(75, "net/minecraft/block/BlockRedstoneTorch");
        blockClassMap.put(77, "net/minecraft/block/BlockButtonStone");
        blockClassMap.put(78, "net/minecraft/block/BlockSnow");
        blockClassMap.put(79, "net/minecraft/block/BlockIce");
        blockClassMap.put(80, "net/minecraft/block/BlockSnowBlock");
        blockClassMap.put(81, "net/minecraft/block/BlockCactus");
        blockClassMap.put(82, "net/minecraft/block/BlockClay");
        blockClassMap.put(83, "net/minecraft/block/BlockReed");
        blockClassMap.put(84, "net/minecraft/block/BlockJukebox");
        blockClassMap.put(85, "net/minecraft/block/BlockFence");
        blockClassMap.put(86, "net/minecraft/block/BlockPumpkin");
        blockClassMap.put(87, "net/minecraft/block/BlockNetherrack");
        blockClassMap.put(88, "net/minecraft/block/BlockSoulSand");
        blockClassMap.put(89, "net/minecraft/block/BlockGlowstone");
        blockClassMap.put(90, "net/minecraft/block/BlockPortal");
        blockClassMap.put(92, "net/minecraft/block/BlockCake");
        blockClassMap.put(93, "net/minecraft/block/BlockRedstoneRepeater");
        blockClassMap.put(95, "net/minecraft/block/BlockStainedGlass");
        blockClassMap.put(96, "net/minecraft/block/BlockTrapDoor");
        blockClassMap.put(97, "net/minecraft/block/BlockSilverfish");
        blockClassMap.put(98, "net/minecraft/block/BlockStoneBrick");
        blockClassMap.put(99, "net/minecraft/block/BlockHugeMushroom");
        blockClassMap.put(101, "net/minecraft/block/BlockPane");
        blockClassMap.put(103, "net/minecraft/block/BlockMelon");
        blockClassMap.put(104, "net/minecraft/block/BlockStem");
        blockClassMap.put(106, "net/minecraft/block/BlockVine");
        blockClassMap.put(107, "net/minecraft/block/BlockFenceGate");
        blockClassMap.put(110, "net/minecraft/block/BlockMycelium");
        blockClassMap.put(111, "net/minecraft/block/BlockLilyPad");
        blockClassMap.put(112, "net/minecraft/block/BlockNetherBrick");
        blockClassMap.put(115, "net/minecraft/block/BlockNetherWart");
        blockClassMap.put(116, "net/minecraft/block/BlockEnchantmentTable");
        blockClassMap.put(117, "net/minecraft/block/BlockBrewingStand");
        blockClassMap.put(118, "net/minecraft/block/BlockCauldron");
        blockClassMap.put(119, "net/minecraft/block/BlockEndPortal");
        blockClassMap.put(120, "net/minecraft/block/BlockEndPortalFrame");
        blockClassMap.put(122, "net/minecraft/block/BlockDragonEgg");
        blockClassMap.put(123, "net/minecraft/block/BlockRedstoneLight");
        blockClassMap.put(125, "net/minecraft/block/BlockDoubleWoodSlab");
        blockClassMap.put(126, "net/minecraft/block/BlockHalfWoodSlab");
        blockClassMap.put(127, "net/minecraft/block/BlockCocoa");
        blockClassMap.put(130, "net/minecraft/block/BlockEnderChest");
        blockClassMap.put(131, "net/minecraft/block/BlockTripWireHook");
        blockClassMap.put(132, "net/minecraft/block/BlockTripWire");
        blockClassMap.put(137, "net/minecraft/block/BlockCommandBlock");
        blockClassMap.put(138, "net/minecraft/block/BlockBeacon");
        blockClassMap.put(139, "net/minecraft/block/BlockWall");
        blockClassMap.put(140, "net/minecraft/block/BlockFlowerPot");
        blockClassMap.put(141, "net/minecraft/block/BlockCarrot");
        blockClassMap.put(142, "net/minecraft/block/BlockPotato");
        blockClassMap.put(143, "net/minecraft/block/BlockButtonWood");
        blockClassMap.put(144, "net/minecraft/block/BlockSkull");
        blockClassMap.put(145, "net/minecraft/block/BlockAnvil");
        blockClassMap.put(147, "net/minecraft/block/BlockPressurePlateWeighted");
        blockClassMap.put(149, "net/minecraft/block/BlockRedstoneComparator");
        blockClassMap.put(151, "net/minecraft/block/BlockDaylightDetector");
        blockClassMap.put(152, "net/minecraft/block/BlockCompressedPowered");
        blockClassMap.put(154, "net/minecraft/block/BlockHopper");
        blockClassMap.put(155, "net/minecraft/block/BlockQuartz");
        blockClassMap.put(158, "net/minecraft/block/BlockDropper");
        blockClassMap.put(160, "net/minecraft/block/BlockStainedGlassPane");
        blockClassMap.put(161, "net/minecraft/block/BlockNewLeaf");
        blockClassMap.put(162, "net/minecraft/block/BlockNewLog");
        blockClassMap.put(165, "net/minecraft/block/BlockSlime");
        blockClassMap.put(166, "net/minecraft/block/BlockBarrier");
        blockClassMap.put(168, "net/minecraft/block/BlockPrismarine");
        blockClassMap.put(169, "net/minecraft/block/BlockSeaLantern");
        blockClassMap.put(170, "net/minecraft/block/BlockHay");
        blockClassMap.put(171, "net/minecraft/block/BlockCarpet");
        blockClassMap.put(172, "net/minecraft/block/BlockHardenedClay");
        blockClassMap.put(174, "net/minecraft/block/BlockPackedIce");
        blockClassMap.put(175, "net/minecraft/block/BlockDoublePlant");
        blockClassMap.put(176, "net/minecraft/block/BlockBanner$BlockBannerStanding");
        blockClassMap.put(177, "net/minecraft/block/BlockBanner$BlockBannerHanging");
        blockClassMap.put(179, "net/minecraft/block/BlockRedSandstone");
        blockClassMap.put(181, "net/minecraft/block/BlockDoubleStoneSlabNew");
        blockClassMap.put(182, "net/minecraft/block/BlockHalfStoneSlabNew");
        MethodCallVisitor registerBlocksMethodVisitor = new MethodCallVisitor(registerBlocks, false);
        block0: for (MethodCallIterator.MethodCall call : registerBlocksMethodVisitor) {
            ClassNode workbench;
            MethodInsnNode mi = call.methodNode;
            if ((!mi.name.equals(registerBlock1.name) || !mi.desc.equals(registerBlock1.desc)) && (!mi.name.equals(registerBlock2.name) || !mi.desc.equals(registerBlock2.desc))) continue;
            int blockId = (Integer)call.args[0];
            String blockClass = (String)call.args[2];
            if (!blockClassMap.containsKey(blockId)) continue;
            this.addClassMapping((String)blockClassMap.get(blockId), blockClass);
            if (!((String)blockClassMap.get(blockId)).equals("net/minecraft/block/BlockWorkbench") || (workbench = this.getClassNode(blockClass)) == null) continue;
            List<TypeInsnNode> typeNodes = this.getAllInsnNodesOfType(workbench, TypeInsnNode.class);
            for (TypeInsnNode tn : typeNodes) {
                if (!tn.desc.startsWith(blockClass + "$") || !this.searchConstantPoolForStrings(tn.desc, "minecraft:crafting_table")) continue;
                this.addClassMapping("net/minecraft/block/BlockWorkbench$InterfaceCraftingTable", tn.desc);
                continue block0;
            }
        }
        return true;
    }

    public static int argCount(String methodDesc) {
        int count = 0;
        boolean complexType = false;
        for (int i = 1; i < methodDesc.length() && methodDesc.charAt(i) != ')'; ++i) {
            if (complexType) {
                if (methodDesc.charAt(i) != ';') continue;
                complexType = false;
                ++count;
                continue;
            }
            if (methodDesc.charAt(i) == '[' || methodDesc.charAt(i) == 'L') {
                complexType = true;
                continue;
            }
            ++count;
        }
        return count;
    }

    @Mapping(providesFields={"net/minecraft/block/BlockTNT EXPLODE Lnet/minecraft/block/properties/PropertyBool;"}, providesMethods={"net/minecraft/block/Block onBlockAdded (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;)V", "net/minecraft/block/Block onBlockDestroyedByPlayer (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;)V", "net/minecraft/block/properties/PropertyBool create (Ljava/lang/String;)Lnet/minecraft/block/properties/PropertyBool;", "net/minecraft/block/Block onEntityCollidedWithBlock (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;)V", "net/minecraft/world/World setBlockToAir (Lnet/minecraft/util/BlockPos;)Z", "net/minecraft/block/BlockTNT explode (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/EntityLivingBase;)V", "net/minecraft/world/World spawnEntityInWorld (Lnet/minecraft/entity/Entity;)Z"}, depends={"net/minecraft/block/Block", "net/minecraft/block/BlockTNT", "net/minecraft/world/World", "net/minecraft/util/BlockPos", "net/minecraft/block/state/IBlockState", "net/minecraft/block/properties/PropertyBool", "net/minecraft/entity/Entity", "net/minecraft/entity/EntityLivingBase", "net/minecraft/util/Sound"})
    public boolean processBlockTNTClass() {
        List<MethodInsnNode> nodes;
        Iterator<MethodNode> it;
        List<MethodNode> methods;
        List<FieldNode> fields;
        ClassNode sound;
        ClassNode entityLivingBase;
        ClassNode entity;
        ClassNode propertyBool;
        ClassNode iBlockState;
        ClassNode blockPos;
        ClassNode world;
        ClassNode tnt;
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        if (!MeddleUtil.notNull((Object[])new Object[]{block, tnt = this.getClassNodeFromMapping("net/minecraft/block/BlockTNT"), world = this.getClassNodeFromMapping("net/minecraft/world/World"), blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos"), iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState"), propertyBool = this.getClassNodeFromMapping("net/minecraft/block/properties/PropertyBool"), entity = this.getClassNodeFromMapping("net/minecraft/entity/Entity"), entityLivingBase = this.getClassNodeFromMapping("net/minecraft/entity/EntityLivingBase"), sound = this.getClassNodeFromMapping("net/minecraft/util/Sound")})) {
            return false;
        }
        MethodNode clinit = this.getMethodNode(tnt, "--- <clinit> ()V");
        if (clinit != null) {
            List<MethodInsnNode> nodes2 = this.getAllInsnNodesOfType(clinit, MethodInsnNode.class);
            Iterator<MethodInsnNode> it2 = nodes2.iterator();
            while (it2.hasNext()) {
                MethodInsnNode mn = it2.next();
                if (mn.owner.equals(propertyBool.name) && mn.desc.equals("(Ljava/lang/String;)L" + propertyBool.name + ";")) continue;
                it2.remove();
            }
            if (nodes2.size() == 1) {
                this.addMethodMapping("net/minecraft/block/properties/PropertyBool create (Ljava/lang/String;)Lnet/minecraft/block/properties/PropertyBool;", propertyBool.name + " " + nodes2.get((int)0).name + " " + nodes2.get((int)0).desc);
            }
        }
        if ((fields = this.getMatchingFields(tnt, null, "L" + propertyBool.name + ";")).size() == 1) {
            this.addFieldMapping("net/minecraft/block/BlockTNT EXPLODE Lnet/minecraft/block/properties/PropertyBool;", tnt.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tnt, null, this.assembleDescriptor("(", world, blockPos, iBlockState, ")V"))).size() == 2) {
            ArrayList<MethodNode> onDestroyed = new ArrayList<MethodNode>();
            it = methods.iterator();
            while (it.hasNext()) {
                MethodNode method = it.next();
                if (!this.matchOpcodeSequence(method.instructions.getFirst(), 25, 25, 25, 25, 1, 182, 177)) continue;
                onDestroyed.add(method);
                it.remove();
            }
            if (methods.size() == 1) {
                this.addMethodMapping("net/minecraft/block/Block onBlockAdded (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            }
            if (onDestroyed.size() == 1) {
                this.addMethodMapping("net/minecraft/block/Block onBlockDestroyedByPlayer (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;)V", block.name + " " + ((MethodNode)onDestroyed.get((int)0)).name + " " + ((MethodNode)onDestroyed.get((int)0)).desc);
            }
        }
        if ((methods = this.getMatchingMethods(tnt, null, this.assembleDescriptor("(", world, blockPos, iBlockState, entity, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block onEntityCollidedWithBlock (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            nodes = this.getAllInsnNodesOfType(methods.get(0), MethodInsnNode.class);
            it = nodes.iterator();
            while (it.hasNext()) {
                MethodInsnNode mn = (MethodInsnNode)it.next();
                if (mn.owner.equals(world.name) && mn.desc.equals("(L" + blockPos.name + ";)Z")) continue;
                it.remove();
            }
            if (nodes.size() == 1) {
                this.addMethodMapping("net/minecraft/world/World setBlockToAir (Lnet/minecraft/util/BlockPos;)Z", world.name + " " + nodes.get((int)0).name + " " + nodes.get((int)0).desc);
            }
        }
        if ((methods = this.getMatchingMethods(tnt, null, this.assembleDescriptor("(", world, blockPos, iBlockState, entityLivingBase, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/BlockTNT explode (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/EntityLivingBase;)V", tnt.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            nodes = this.getAllInsnNodesOfType(methods.get(0), MethodInsnNode.class);
            ArrayList<MethodInsnNode> spawnEntityInWorld = new ArrayList<MethodInsnNode>();
            for (MethodInsnNode mn : nodes) {
                if (!mn.owner.equals(world.name) || !mn.desc.equals("(L" + entity.name + ";)Z")) continue;
                spawnEntityInWorld.add(mn);
            }
            if (spawnEntityInWorld.size() == 1) {
                this.addMethodMapping("net/minecraft/world/World spawnEntityInWorld (Lnet/minecraft/entity/Entity;)Z", world.name + " " + ((MethodInsnNode)spawnEntityInWorld.get((int)0)).name + " " + ((MethodInsnNode)spawnEntityInWorld.get((int)0)).desc);
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/block/IGrowable"}, providesMethods={}, depends={"net/minecraft/block/Block", "net/minecraft/block/BlockGrass", "net/minecraft/block/state/IBlockState", "net/minecraft/util/BlockPos"})
    public boolean processBlockGrassClass() {
        ClassNode blockPos;
        ClassNode iBlockState;
        ClassNode grass;
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        if (!MeddleUtil.notNull((Object[])new Object[]{block, grass = this.getClassNodeFromMapping("net/minecraft/block/BlockGrass"), iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState"), blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos")})) {
            return false;
        }
        ClassNode iGrowable = null;
        if (grass.interfaces.size() == 1) {
            iGrowable = this.getClassNode((String)grass.interfaces.get(0));
            if (iGrowable != null && iGrowable.methods.size() == 3) {
                this.addClassMapping("net/minecraft/block/IGrowable", iGrowable.name);
            } else {
                iGrowable = null;
            }
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/block/IGrowable canGrow (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Z)Z", "net/minecraft/block/IGrowable canUseBonemeal (Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z", "net/minecraft/block/IGrowable grow (Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;)V"}, depends={"net/minecraft/block/IGrowable", "net/minecraft/block/Block", "net/minecraft/block/BlockGrass", "net/minecraft/block/state/IBlockState", "net/minecraft/util/BlockPos", "net/minecraft/world/World"})
    public boolean processIGrowableClass() {
        ClassNode iGrowable = this.getClassNodeFromMapping("net/minecraft/block/IGrowable");
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        ClassNode grass = this.getClassNodeFromMapping("net/minecraft/block/BlockGrass");
        ClassNode iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState");
        ClassNode blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos");
        ClassNode world = this.getClassNodeFromMapping("net/minecraft/world/World");
        if (!MeddleUtil.notNull((Object[])new Object[]{iGrowable, block, grass, iBlockState, blockPos, world})) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(iGrowable, null, this.assembleDescriptor("(", world, blockPos, iBlockState, "Z)Z"));
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/block/IGrowable canGrow (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Z)Z", iGrowable.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iGrowable, null, this.assembleDescriptor("(", world, "Ljava/util/Random;", blockPos, iBlockState, ")Z"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/IGrowable canUseBonemeal (Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z", iGrowable.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iGrowable, null, this.assembleDescriptor("(", world, "Ljava/util/Random;", blockPos, iBlockState, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/IGrowable grow (Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;)V", iGrowable.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/block/EnumRenderType"}, providesFields={"net/minecraft/block/material/Material air Lnet/minecraft/block/material/Material;"}, providesMethods={"net/minecraft/block/Block getCollisionBoundingBox (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)Lnet/minecraft/util/AxisAlignedBB;", "net/minecraft/block/Block canCollideCheck (Lnet/minecraft/block/state/IBlockState;Z)Z", "net/minecraft/block/Block isReplaceable (Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;)Z", "net/minecraft/block/Block getRenderType ()Lnet/minecraft/block/EnumRenderType;"}, depends={"net/minecraft/block/Block", "net/minecraft/block/BlockAir", "net/minecraft/world/World", "net/minecraft/util/BlockPos", "net/minecraft/block/state/IBlockState", "net/minecraft/block/material/Material", "net/minecraft/util/AxisAlignedBB", "net/minecraft/world/IBlockAccess"})
    public boolean processBlockAirClass() {
        List<MethodNode> methods;
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        ClassNode blockAir = this.getClassNodeFromMapping("net/minecraft/block/BlockAir");
        ClassNode world = this.getClassNodeFromMapping("net/minecraft/world/World");
        ClassNode blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos");
        ClassNode iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState");
        ClassNode material = this.getClassNodeFromMapping("net/minecraft/block/material/Material");
        ClassNode aabb = this.getClassNodeFromMapping("net/minecraft/util/AxisAlignedBB");
        ClassNode iBlockAccess = this.getClassNodeFromMapping("net/minecraft/world/IBlockAccess");
        if (!MeddleUtil.notNull((Object[])new Object[]{block, blockAir, world, blockPos, iBlockState, material, aabb, iBlockAccess})) {
            return false;
        }
        List<FieldInsnNode> fieldNodes = this.getAllInsnNodesOfType(blockAir, FieldInsnNode.class);
        Iterator<FieldInsnNode> it = fieldNodes.iterator();
        while (it.hasNext()) {
            if (it.next().desc.equals("L" + material.name + ";")) continue;
            it.remove();
        }
        if (fieldNodes.size() == 1) {
            this.addFieldMapping("net/minecraft/block/material/Material air Lnet/minecraft/block/material/Material;", material.name + " " + fieldNodes.get((int)0).name + " " + fieldNodes.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(blockAir, null, this.assembleDescriptor("(", iBlockState, world, blockPos, ")", aabb))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getCollisionBoundingBox (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)Lnet/minecraft/util/AxisAlignedBB;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(blockAir, null, this.assembleDescriptor("(", iBlockState, "Z)Z"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block canCollideCheck (Lnet/minecraft/block/state/IBlockState;Z)Z", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(blockAir, null, this.assembleDescriptor("(", iBlockAccess, blockPos, ")Z"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block isReplaceable (Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;)Z", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        methods.clear();
        for (MethodNode method : blockAir.methods) {
            if (!method.desc.startsWith("(L" + iBlockState.name + ";)L")) continue;
            methods.add(method);
        }
        if (methods.size() == 1) {
            String renderType = Type.getMethodType((String)methods.get((int)0).desc).getReturnType().getClassName();
            if (this.searchConstantPoolForStrings(renderType, "INVISIBLE", "LIQUID")) {
                this.addClassMapping("net/minecraft/block/EnumRenderType", renderType);
                this.addMethodMapping("net/minecraft/block/Block getRenderType ()Lnet/minecraft/block/EnumRenderType;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            }
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/block/EnumRenderType INVISIBLE Lnet/minecraft/block/EnumRenderType;", "net/minecraft/block/EnumRenderType LIQUID Lnet/minecraft/block/EnumRenderType;", "net/minecraft/block/EnumRenderType ENTITYBLOCK_ANIMATED Lnet/minecraft/block/EnumRenderType;", "net/minecraft/block/EnumRenderType MODEL Lnet/minecraft/block/EnumRenderType;"}, depends={"net/minecraft/block/EnumRenderType"})
    public boolean processEnumRenderTypeClass() {
        ClassNode renderType = this.getClassNodeFromMapping("net/minecraft/block/EnumRenderType");
        if (renderType == null) {
            return false;
        }
        HashMap map = new HashMap();
        MethodNode clinit = this.getMethodNode(renderType, "--- <clinit> ()V");
        if (clinit == null) {
            return false;
        }
        String lastString = null;
        for (AbstractInsnNode insn = clinit.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            String string = this.getLdcString(insn);
            if (string != null) {
                lastString = string;
                continue;
            }
            if (insn.getOpcode() != 179 || lastString == null) continue;
            FieldInsnNode fn = (FieldInsnNode)insn;
            if (!fn.owner.equals(renderType.name) || !fn.desc.equals("L" + renderType.name + ";")) continue;
            if (lastString.equals("INVISIBLE")) {
                this.addFieldMapping("net/minecraft/block/EnumRenderType INVISIBLE Lnet/minecraft/block/EnumRenderType;", renderType.name + " " + fn.name + " " + fn.desc);
            } else if (lastString.equals("LIQUID")) {
                this.addFieldMapping("net/minecraft/block/EnumRenderType LIQUID Lnet/minecraft/block/EnumRenderType;", renderType.name + " " + fn.name + " " + fn.desc);
            } else if (lastString.equals("ENTITYBLOCK_ANIMATED")) {
                this.addFieldMapping("net/minecraft/block/EnumRenderType ENTITYBLOCK_ANIMATED Lnet/minecraft/block/EnumRenderType;", renderType.name + " " + fn.name + " " + fn.desc);
            } else if (lastString.equals("MODEL")) {
                this.addFieldMapping("net/minecraft/block/EnumRenderType MODEL Lnet/minecraft/block/EnumRenderType;", renderType.name + " " + fn.name + " " + fn.desc);
            }
            lastString = null;
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/stats/StatList", "net/minecraft/util/ChatComponentTranslation", "net/minecraft/inventory/ContainerWorkbench"}, depends={"net/minecraft/block/BlockWorkbench", "net/minecraft/block/BlockWorkbench$InterfaceCraftingTable", "net/minecraft/inventory/Container"})
    public boolean processBlockWorkbenchClass() {
        ClassNode container;
        ClassNode workbenchIface;
        ClassNode workbench = this.getClassNodeFromMapping("net/minecraft/block/BlockWorkbench");
        if (!MeddleUtil.notNull((Object[])new Object[]{workbench, workbenchIface = this.getClassNodeFromMapping("net/minecraft/block/BlockWorkbench$InterfaceCraftingTable"), container = this.getClassNodeFromMapping("net/minecraft/inventory/Container")})) {
            return false;
        }
        List<FieldInsnNode> fieldNodes = this.getAllInsnNodesOfType(workbench, FieldInsnNode.class);
        for (FieldInsnNode fn : fieldNodes) {
            if (fn.getOpcode() != 178 || !this.searchConstantPoolForStrings(fn.owner, "stat.leaveGame", "stat.playerKills")) continue;
            this.addClassMapping("net/minecraft/stats/StatList", fn.owner);
        }
        boolean foundTranslate = false;
        List<TypeInsnNode> typeNodes = this.getAllInsnNodesOfType(workbenchIface, TypeInsnNode.class);
        ArrayList<TypeInsnNode> containers = new ArrayList<TypeInsnNode>();
        for (TypeInsnNode tn : typeNodes) {
            if (!foundTranslate && this.searchConstantPoolForStrings(tn.desc, "TranslatableComponent{key='")) {
                foundTranslate = true;
                this.addClassMapping("net/minecraft/util/ChatComponentTranslation", tn.desc);
                continue;
            }
            ClassNode cn = this.getClassNode(tn.desc);
            if (cn == null || cn.superName == null || !cn.superName.equals(container.name)) continue;
            containers.add(tn);
        }
        if (containers.size() == 1) {
            this.addClassMapping("net/minecraft/inventory/ContainerWorkbench", ((TypeInsnNode)containers.get((int)0)).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/block/BlockLog", "net/minecraft/block/BlockRotatedPillar"}, depends={"net/minecraft/block/BlockOldLog", "net/minecraft/block/Block"})
    public boolean processBlockOldLog() {
        ClassNode rotatedPillar;
        ClassNode blockLog;
        ClassNode oldLog = this.getClassNodeFromMapping("net/minecraft/block/BlockOldLog");
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        if (oldLog == null || block == null) {
            return false;
        }
        if (this.searchConstantPoolForStrings(oldLog.superName, "axis") && (blockLog = this.getClassNode(oldLog.superName)) != null && this.searchConstantPoolForStrings(blockLog.superName, "axis") && (rotatedPillar = this.getClassNode(blockLog.superName)) != null && rotatedPillar.superName.equals(block.name)) {
            this.addClassMapping("net/minecraft/block/BlockLog", blockLog.name);
            this.addClassMapping("net/minecraft/block/BlockRotatedPillar", rotatedPillar.name);
            return true;
        }
        return false;
    }

    private boolean verifyBlockSoundTypeClass(String className) {
        ClassNode soundType = this.getClassNode(className);
        ClassNode sound = this.getClassNodeFromMapping("net/minecraft/util/Sound");
        if (soundType == null || sound == null) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(soundType, "<init>", this.assembleDescriptor("(FF", sound, sound, sound, sound, sound, ")V"));
        return methods.size() == 1;
    }

    @Mapping(provides={"net/minecraft/block/BlockSoundType"}, providesFields={"net/minecraft/block/material/Material wood Lnet/minecraft/block/material/Material;", "net/minecraft/block/Block soundTypeWood Lnet/minecraft/block/Block$SoundType;", "net/minecraft/block/material/Material leaves Lnet/minecraft/block/material/Material;"}, providesMethods={"net/minecraft/block/Block setHardness (F)Lnet/minecraft/block/Block;", "net/minecraft/block/Block setStepSound (Lnet/minecraft/block/Block$SoundType;)Lnet/minecraft/block/Block;", "net/minecraft/block/Block breakBlock (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;)V", "net/minecraft/world/World isAreaLoaded (Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/BlockPos;)Z", "net/minecraft/util/BlockPos add (III)Lnet/minecraft/util/BlockPos;", "net/minecraft/util/BlockPos getAllInBox (Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/BlockPos;)Ljava/lang/Iterable;"}, depends={"net/minecraft/block/BlockLog", "net/minecraft/block/Block", "net/minecraft/block/material/Material", "net/minecraft/creativetab/CreativeTabs", "net/minecraft/world/World", "net/minecraft/util/BlockPos", "net/minecraft/block/state/IBlockState", "net/minecraft/util/Sound"})
    public boolean processBlockLog() {
        ClassNode iBlockState;
        ClassNode blockPos;
        ClassNode world;
        ClassNode creativeTabs;
        ClassNode material;
        ClassNode block;
        ClassNode blockLog = this.getClassNodeFromMapping("net/minecraft/block/BlockLog");
        if (!MeddleUtil.notNull((Object[])new Object[]{blockLog, block = this.getClassNodeFromMapping("net/minecraft/block/Block"), material = this.getClassNodeFromMapping("net/minecraft/block/material/Material"), creativeTabs = this.getClassNodeFromMapping("net/minecraft/creativetab/CreativeTabs"), world = this.getClassNodeFromMapping("net/minecraft/world/World"), blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos"), iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState")})) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(blockLog, "<init>", "()V");
        if (methods.size() == 1) {
            List<FieldInsnNode> fieldNodes = this.getAllInsnNodesOfType(methods.get((int)0).instructions.getFirst(), FieldInsnNode.class);
            List<MethodInsnNode> methodNodes = this.getAllInsnNodesOfType(methods.get((int)0).instructions.getFirst(), MethodInsnNode.class);
            String wood_name = null;
            int materialCount = 0;
            String soundType_name = null;
            String sound_name = null;
            int soundCount = 0;
            for (FieldInsnNode fn : fieldNodes) {
                String className;
                if (!fn.desc.startsWith("L") || (className = Type.getType((String)fn.desc).getClassName()).equals(creativeTabs.name)) continue;
                if (className.equals(material.name)) {
                    wood_name = fn.name;
                    ++materialCount;
                    continue;
                }
                if (!this.verifyBlockSoundTypeClass(className)) continue;
                if (soundType_name == null) {
                    soundType_name = className;
                    this.addClassMapping("net/minecraft/block/BlockSoundType", className);
                }
                sound_name = fn.name;
                ++soundCount;
            }
            if (materialCount == 1) {
                this.addFieldMapping("net/minecraft/block/material/Material wood Lnet/minecraft/block/material/Material;", material.name + " " + wood_name + " L" + material.name + ";");
            }
            if (soundCount == 1) {
                this.addFieldMapping("net/minecraft/block/Block soundTypeWood Lnet/minecraft/block/Block$SoundType;", block.name + " " + sound_name + " L" + soundType_name + ";");
            }
            String setHardness_name = null;
            int setHardness_count = 0;
            String setStepSound_name = null;
            int setStepSound_count = 0;
            for (MethodInsnNode mn : methodNodes) {
                if (!mn.owner.equals(blockLog.name)) continue;
                if (mn.desc.equals("(F)L" + block.name + ";")) {
                    setHardness_name = mn.name;
                    ++setHardness_count;
                    continue;
                }
                if (soundType_name == null || !mn.desc.equals("(L" + soundType_name + ";)L" + block.name + ";")) continue;
                setStepSound_name = mn.name;
                ++setStepSound_count;
            }
            if (setHardness_count == 1) {
                this.addMethodMapping("net/minecraft/block/Block setHardness (F)Lnet/minecraft/block/Block;", block.name + " " + setHardness_name + " (F)L" + block.name + ";");
            }
            if (setStepSound_count == 1) {
                this.addMethodMapping("net/minecraft/block/Block setStepSound (Lnet/minecraft/block/Block$SoundType;)Lnet/minecraft/block/Block;", block.name + " " + setStepSound_name + " (L" + soundType_name + ";)L" + block.name + ";");
            }
        }
        if ((methods = this.getMatchingMethods(blockLog, null, this.assembleDescriptor("(", world, blockPos, iBlockState, ")V"))).size() == 1) {
            MethodInsnNode mn;
            this.addMethodMapping("net/minecraft/block/Block breakBlock (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            List<MethodInsnNode> methodNodes = this.getAllInsnNodesOfType(methods.get((int)0).instructions.getFirst(), MethodInsnNode.class);
            Iterator<MethodInsnNode> it = methodNodes.iterator();
            while (it.hasNext()) {
                mn = it.next();
                if (mn.owner.equals(world.name) && mn.desc.equals("(L" + blockPos.name + ";L" + blockPos.name + ";)Z")) continue;
                it.remove();
            }
            if (methodNodes.size() == 1) {
                this.addMethodMapping("net/minecraft/world/World isAreaLoaded (Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/BlockPos;)Z", world.name + " " + methodNodes.get((int)0).name + " " + methodNodes.get((int)0).desc);
            }
            methodNodes = this.getAllInsnNodesOfType(methods.get((int)0).instructions.getFirst(), MethodInsnNode.class);
            it = methodNodes.iterator();
            while (it.hasNext()) {
                mn = it.next();
                if (mn.owner.equals(blockPos.name) && mn.desc.equals("(III)L" + blockPos.name + ";")) continue;
                it.remove();
            }
            if (methodNodes.size() > 0) {
                String add_name = methodNodes.get((int)0).name;
                int add_matches = 0;
                for (MethodInsnNode mn2 : methodNodes) {
                    if (!mn2.name.equals(add_name)) continue;
                    ++add_matches;
                }
                if (methodNodes.size() == add_matches) {
                    this.addMethodMapping("net/minecraft/util/BlockPos add (III)Lnet/minecraft/util/BlockPos;", blockPos.name + " " + methodNodes.get((int)0).name + " " + methodNodes.get((int)0).desc);
                }
            }
            methodNodes = this.getAllInsnNodesOfType(methods.get((int)0).instructions.getFirst(), MethodInsnNode.class);
            it = methodNodes.iterator();
            while (it.hasNext()) {
                mn = it.next();
                if (mn.owner.equals(blockPos.name) && mn.desc.equals(this.assembleDescriptor("(", blockPos, blockPos, ")Ljava/lang/Iterable;"))) continue;
                it.remove();
            }
            if (methodNodes.size() == 1) {
                this.addMethodMapping("net/minecraft/util/BlockPos getAllInBox (Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/BlockPos;)Ljava/lang/Iterable;", blockPos.name + " " + methodNodes.get((int)0).name + " " + methodNodes.get((int)0).desc);
            }
            List<FieldInsnNode> fieldNodes = this.getAllInsnNodesOfType(methods.get((int)0).instructions.getFirst(), FieldInsnNode.class);
            Iterator<FieldInsnNode> it2 = fieldNodes.iterator();
            while (it2.hasNext()) {
                FieldInsnNode fn = it2.next();
                if (fn.owner.equals(material.name)) continue;
                it2.remove();
            }
            if (fieldNodes.size() == 1) {
                this.addFieldMapping("net/minecraft/block/material/Material leaves Lnet/minecraft/block/material/Material;", material.name + " " + fieldNodes.get((int)0).name + " " + fieldNodes.get((int)0).desc);
            }
        }
        return true;
    }

    @Mapping(provides={}, providesFields={"net/minecraft/block/BlockPane NORTH Lnet/minecraft/block/properties/PropertyBool;", "net/minecraft/block/BlockPane SOUTH Lnet/minecraft/block/properties/PropertyBool;", "net/minecraft/block/BlockPane WEST Lnet/minecraft/block/properties/PropertyBool;", "net/minecraft/block/BlockPane EAST Lnet/minecraft/block/properties/PropertyBool;"}, providesMethods={}, depends={"net/minecraft/block/BlockPane", "net/minecraft/block/properties/PropertyBool"})
    public boolean processBlockPaneClass() {
        ClassNode propBool;
        ClassNode pane = this.getClassNodeFromMapping("net/minecraft/block/BlockPane");
        if (!MeddleUtil.notNull((Object[])new Object[]{pane, propBool = this.getClassNodeFromMapping("net/minecraft/block/properties/PropertyBool")})) {
            return false;
        }
        MethodNode clinit = this.getMethodNode(pane, "- <clinit> ()V");
        if (clinit == null) {
            return false;
        }
        String lastString = null;
        String north = null;
        String south = null;
        String east = null;
        String west = null;
        for (AbstractInsnNode insn = clinit.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            FieldInsnNode fn;
            String s = this.getLdcString(insn);
            if (s != null) {
                lastString = s;
                continue;
            }
            if (lastString == null || (fn = this.getNextInsnNodeOfType(insn, FieldInsnNode.class)) == null || fn.getOpcode() != 179 || lastString == null || !fn.owner.equals(pane.name) || !fn.desc.equals("L" + propBool.name + ";")) continue;
            if (lastString.equals("north") && north == null) {
                north = fn.name;
            } else if (lastString.equals("south") && south == null) {
                south = fn.name;
            } else if (lastString.equals("east") && east == null) {
                east = fn.name;
            } else if (lastString.equals("west") && west == null) {
                west = fn.name;
            }
            lastString = null;
            insn = fn;
        }
        if (MeddleUtil.notNull((Object[])new Object[]{north, south, east, west})) {
            this.addFieldMapping("net/minecraft/block/BlockPane NORTH Lnet/minecraft/block/properties/PropertyBool;", pane.name + " " + north + " L" + propBool.name + ";");
            this.addFieldMapping("net/minecraft/block/BlockPane SOUTH Lnet/minecraft/block/properties/PropertyBool;", pane.name + " " + south + " L" + propBool.name + ";");
            this.addFieldMapping("net/minecraft/block/BlockPane WEST Lnet/minecraft/block/properties/PropertyBool;", pane.name + " " + west + " L" + propBool.name + ";");
            this.addFieldMapping("net/minecraft/block/BlockPane EAST Lnet/minecraft/block/properties/PropertyBool;", pane.name + " " + east + " L" + propBool.name + ";");
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/block/BlockLiquid"}, providesMethods={}, depends={"net/minecraft/block/BlockDynamicLiquid"})
    public boolean processBlockDynamicLiquidClass() {
        ClassNode dynamicLiquid = this.getClassNodeFromMapping("net/minecraft/block/BlockDynamicLiquid");
        if (!MeddleUtil.notNull((Object[])new Object[]{dynamicLiquid})) {
            return false;
        }
        String blockLiquid_name = dynamicLiquid.superName;
        if (this.searchConstantPoolForStrings(blockLiquid_name, "level")) {
            this.addClassMapping("net/minecraft/block/BlockLiquid", blockLiquid_name);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/block/properties/PropertyBool", "net/minecraft/block/BlockDoor$EnumHingePosition", "net/minecraft/block/BlockDoor$EnumDoorHalf"}, providesFields={"net/minecraft/block/BlockDoor FACING Lnet/minecraft/block/properties/PropertyDirection;", "net/minecraft/block/BlockDoor HINGE Lnet/minecraft/block/properties/PropertyEnum;", "net/minecraft/block/BlockDoor HALF Lnet/minecraft/block/properties/PropertyEnum;", "net/minecraft/block/BlockDoor OPEN Lnet/minecraft/block/properties/PropertyBool;", "net/minecraft/block/BlockDoor POWERED Lnet/minecraft/block/properties/PropertyBool;"}, providesMethods={}, depends={"net/minecraft/block/BlockDoor", "net/minecraft/block/properties/PropertyDirection", "net/minecraft/block/properties/PropertyHelper", "net/minecraft/block/properties/PropertyEnum"})
    public boolean processBlockDoorClass() {
        List<MethodNode> methods;
        ClassNode propertyEnum;
        ClassNode propertyHelper;
        ClassNode propertyDirection;
        ClassNode blockDoor = this.getClassNodeFromMapping("net/minecraft/block/BlockDoor");
        if (!MeddleUtil.notNull((Object[])new Object[]{blockDoor, propertyDirection = this.getClassNodeFromMapping("net/minecraft/block/properties/PropertyDirection"), propertyHelper = this.getClassNodeFromMapping("net/minecraft/block/properties/PropertyHelper"), propertyEnum = this.getClassNodeFromMapping("net/minecraft/block/properties/PropertyEnum")})) {
            return false;
        }
        HashSet<String> classNames = new HashSet<String>();
        ArrayList<Object> directionFields = new ArrayList<Object>();
        ArrayList<Object> enumFields = new ArrayList<Object>();
        ArrayList<Object> unknownFields = new ArrayList<Object>();
        for (Object field : blockDoor.fields) {
            Type t = Type.getType((String)((FieldNode)field).desc);
            if (t.getSort() != 10) continue;
            if (t.getClassName().equals(propertyDirection.name)) {
                directionFields.add(field);
                continue;
            }
            if (t.getClassName().equals(propertyEnum.name)) {
                enumFields.add(field);
                continue;
            }
            unknownFields.add(field);
            classNames.add(t.getClassName());
        }
        if (directionFields.size() == 1) {
            this.addFieldMapping("net/minecraft/block/BlockDoor FACING Lnet/minecraft/block/properties/PropertyDirection;", blockDoor.name + " " + ((FieldNode)directionFields.get((int)0)).name + " " + ((FieldNode)directionFields.get((int)0)).desc);
        }
        ClassNode propertyBool = null;
        for (String className : classNames) {
            AbstractInsnNode insn;
            List<MethodNode> methods2;
            ClassNode cn = this.getClassNode(className);
            if (!cn.superName.equals(propertyHelper.name) || (methods2 = this.getMatchingMethods(cn, "<init>", "(Ljava/lang/String;)V")).size() != 1 || (insn = this.findNextOpcodeNum(methods2.get((int)0).instructions.getFirst(), 18)) == null) continue;
            LdcInsnNode ldc = (LdcInsnNode)insn;
            if (!(ldc.cst instanceof Type) || !((Type)ldc.cst).getClassName().equals("java.lang.Boolean")) continue;
            this.addClassMapping("net/minecraft/block/properties/PropertyBool", className);
            propertyBool = cn;
            break;
        }
        if ((methods = this.getMatchingMethods(blockDoor, "<clinit>", "()V")).size() == 1) {
            for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
                AbstractInsnNode[] nodes = this.getOpcodeSequenceArray(insn, 18, 18, 184, 179);
                if (nodes != null) {
                    String enumDoorHalf;
                    LdcInsnNode ldc1 = (LdcInsnNode)nodes[0];
                    LdcInsnNode ldc2 = (LdcInsnNode)nodes[1];
                    MethodInsnNode mn = (MethodInsnNode)nodes[2];
                    FieldInsnNode fn = (FieldInsnNode)nodes[3];
                    if (!(ldc1.cst instanceof String) || !(ldc2.cst instanceof Type) || !mn.owner.equals(propertyEnum.name) || !fn.owner.equals(blockDoor.name) || !fn.desc.equals("L" + propertyEnum.name + ";")) continue;
                    if (((String)ldc1.cst).equals("hinge")) {
                        String enumHingePosition = ((Type)ldc2.cst).getClassName();
                        if (this.searchConstantPoolForStrings(enumHingePosition, "LEFT", "RIGHT")) {
                            this.addClassMapping("net/minecraft/block/BlockDoor$EnumHingePosition", enumHingePosition);
                            this.addFieldMapping("net/minecraft/block/BlockDoor HINGE Lnet/minecraft/block/properties/PropertyEnum;", blockDoor.name + " " + fn.name + " " + fn.desc);
                        }
                    } else if (((String)ldc1.cst).equals("half") && this.searchConstantPoolForStrings(enumDoorHalf = ((Type)ldc2.cst).getClassName(), "UPPER", "LOWER")) {
                        this.addClassMapping("net/minecraft/block/BlockDoor$EnumDoorHalf", enumDoorHalf);
                        this.addFieldMapping("net/minecraft/block/BlockDoor HALF Lnet/minecraft/block/properties/PropertyEnum;", blockDoor.name + " " + fn.name + " " + fn.desc);
                    }
                    insn = nodes[3];
                    continue;
                }
                nodes = this.getOpcodeSequenceArray(insn, 18, 184, 179);
                if (nodes == null) continue;
                LdcInsnNode ldc = (LdcInsnNode)nodes[0];
                MethodInsnNode mn = (MethodInsnNode)nodes[1];
                FieldInsnNode fn = (FieldInsnNode)nodes[2];
                if (!(ldc.cst instanceof String) || !mn.owner.equals(propertyBool.name) || !fn.owner.equals(blockDoor.name) || !fn.desc.equals("L" + propertyBool.name + ";")) continue;
                if (((String)ldc.cst).equals("open")) {
                    this.addFieldMapping("net/minecraft/block/BlockDoor OPEN Lnet/minecraft/block/properties/PropertyBool;", blockDoor.name + " " + fn.name + " " + fn.desc);
                } else if (((String)ldc.cst).equals("powered")) {
                    this.addFieldMapping("net/minecraft/block/BlockDoor POWERED Lnet/minecraft/block/properties/PropertyBool;", blockDoor.name + " " + fn.name + " " + fn.desc);
                }
                insn = nodes[2];
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/util/IStringSerializable"}, providesMethods={"net/minecraft/util/IStringSerializable getName ()Ljava/lang/String;"}, providesFields={"net/minecraft/block/BlockDoor$EnumHingePosition LEFT Lnet/minecraft/block/BlockDoor$EnumHingePosition;", "net/minecraft/block/BlockDoor$EnumHingePosition RIGHT Lnet/minecraft/block/BlockDoor$EnumHingePosition;", "net/minecraft/block/BlockDoor$EnumDoorHalf UPPER Lnet/minecraft/block/BlockDoor$EnumDoorHalf;", "net/minecraft/block/BlockDoor$EnumDoorHalf LOWER Lnet/minecraft/block/BlockDoor$EnumDoorHalf;"}, depends={"net/minecraft/block/BlockDoor$EnumHingePosition", "net/minecraft/block/BlockDoor$EnumDoorHalf"})
    public boolean processBlockDoorProperties() {
        ClassNode hingePosition = this.getClassNodeFromMapping("net/minecraft/block/BlockDoor$EnumHingePosition");
        ClassNode doorHalf = this.getClassNodeFromMapping("net/minecraft/block/BlockDoor$EnumDoorHalf");
        if (hingePosition == null || doorHalf == null) {
            return false;
        }
        List<FieldNode> fields = this.getMatchingFields(hingePosition, null, "L" + hingePosition.name + ";");
        if (fields.size() == 2) {
            this.addFieldMapping("net/minecraft/block/BlockDoor$EnumHingePosition LEFT Lnet/minecraft/block/BlockDoor$EnumHingePosition;", hingePosition.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
            this.addFieldMapping("net/minecraft/block/BlockDoor$EnumHingePosition RIGHT Lnet/minecraft/block/BlockDoor$EnumHingePosition;", hingePosition.name + " " + fields.get((int)1).name + " " + fields.get((int)1).desc);
        }
        if ((fields = this.getMatchingFields(doorHalf, null, "L" + doorHalf.name + ";")).size() == 2) {
            this.addFieldMapping("net/minecraft/block/BlockDoor$EnumDoorHalf UPPER Lnet/minecraft/block/BlockDoor$EnumDoorHalf;", doorHalf.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
            this.addFieldMapping("net/minecraft/block/BlockDoor$EnumDoorHalf LOWER Lnet/minecraft/block/BlockDoor$EnumDoorHalf;", doorHalf.name + " " + fields.get((int)1).name + " " + fields.get((int)1).desc);
        }
        if (hingePosition.interfaces.size() == 1 && doorHalf.interfaces.size() == 1 && ((String)hingePosition.interfaces.get(0)).equals(doorHalf.interfaces.get(0))) {
            String iStringSerializable_name = (String)hingePosition.interfaces.get(0);
            ClassNode iStringSerializable = this.getClassNode(iStringSerializable_name);
            if (iStringSerializable == null) {
                return false;
            }
            List<MethodNode> methods = this.getMatchingMethods(iStringSerializable, null, "()Ljava/lang/String;");
            if (methods.size() == 1) {
                this.addClassMapping("net/minecraft/util/IStringSerializable", iStringSerializable_name);
                this.addMethodMapping("net/minecraft/util/IStringSerializable getName ()Ljava/lang/String;", iStringSerializable_name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/block/BlockDirectional", "net/minecraft/block/properties/PropertyDirection"}, providesFields={"net/minecraft/block/BlockDirectional FACING Lnet/minecraft/block/properties/PropertyDirection;"}, depends={"net/minecraft/block/BlockBed", "net/minecraft/block/BlockFenceGate", "net/minecraft/block/Block", "net/minecraft/util/EnumFacing"})
    public boolean getBlockDirectionalClass() {
        ClassNode blockBed = this.getClassNodeFromMapping("net/minecraft/block/BlockBed");
        ClassNode blockFenceGate = this.getClassNodeFromMapping("net/minecraft/block/BlockFenceGate");
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        ClassNode enumFacing = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing");
        if (!MeddleUtil.notNull((Object[])new Object[]{blockBed, blockFenceGate, block, enumFacing})) {
            return false;
        }
        if (!blockBed.superName.equals(blockFenceGate.superName)) {
            return false;
        }
        if (!this.searchConstantPoolForStrings(blockBed.superName, "facing")) {
            return false;
        }
        this.addClassMapping("net/minecraft/block/BlockDirectional", blockBed.superName);
        ClassNode blockDirectional = this.getClassNode(blockBed.superName);
        if (blockDirectional.fields.size() != 1) {
            return false;
        }
        if (!((FieldNode)blockDirectional.fields.get((int)0)).desc.startsWith("L")) {
            return false;
        }
        String propertyDirection_name = Type.getType((String)((FieldNode)blockDirectional.fields.get((int)0)).desc).getClassName();
        if (!this.searchConstantPoolForClasses(propertyDirection_name, enumFacing.name)) {
            return false;
        }
        this.addClassMapping("net/minecraft/block/properties/PropertyDirection", propertyDirection_name);
        this.addFieldMapping("net/minecraft/block/BlockDirectional FACING Lnet/minecraft/block/properties/PropertyDirection;", blockDirectional.name + " " + ((FieldNode)blockDirectional.fields.get((int)0)).name + " " + ((FieldNode)blockDirectional.fields.get((int)0)).desc);
        return true;
    }

    @Mapping(provides={"net/minecraft/block/properties/PropertyEnum", "net/minecraft/block/properties/PropertyHelper"}, providesMethods={"net/minecraft/block/properties/PropertyDirection create (Ljava/lang/String;)Lnet/minecraft/block/properties/PropertyDirection;", "net/minecraft/block/properties/PropertyEnum create (Ljava/lang/String;Ljava/lang/Class;)Lnet/minecraft/block/properties/PropertyEnum;"}, depends={"net/minecraft/block/properties/PropertyDirection", "net/minecraft/block/properties/IProperty"})
    public boolean processPropertyDirectionClass() {
        ClassNode propertyDirection = this.getClassNodeFromMapping("net/minecraft/block/properties/PropertyDirection");
        ClassNode iProperty = this.getClassNodeFromMapping("net/minecraft/block/properties/IProperty");
        if (!MeddleUtil.notNull((Object[])new Object[]{propertyDirection, iProperty})) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(propertyDirection, null, "(Ljava/lang/String;)L" + propertyDirection.name + ";");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/block/properties/PropertyDirection create (Ljava/lang/String;)Lnet/minecraft/block/properties/PropertyDirection;", propertyDirection.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        String propertyEnum_name = null;
        if (!this.searchConstantPoolForStrings(propertyDirection.superName, "Multiple values have the same name '")) {
            return false;
        }
        propertyEnum_name = propertyDirection.superName;
        this.addClassMapping("net/minecraft/block/properties/PropertyEnum", propertyEnum_name);
        ClassNode propertyEnum = this.getClassNode(propertyEnum_name);
        if (propertyEnum == null) {
            return false;
        }
        String propertyHelper_name = null;
        if (this.searchConstantPoolForStrings(propertyEnum.superName, "name", "clazz", "values")) {
            propertyHelper_name = propertyEnum.superName;
            this.addClassMapping("net/minecraft/block/properties/PropertyHelper", propertyHelper_name);
        }
        if ((methods = this.getMatchingMethods(propertyEnum, null, "(Ljava/lang/String;Ljava/lang/Class;)L" + propertyEnum.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/properties/PropertyEnum create (Ljava/lang/String;Ljava/lang/Class;)Lnet/minecraft/block/properties/PropertyEnum;", propertyEnum.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/world/IInteractionObject", "net/minecraft/block/BlockAnvil$Anvil", "net/minecraft/entity/player/InventoryPlayer", "net/minecraft/inventory/Container"}, providesMethods={"net/minecraft/world/IInteractionObject getGuiID ()Ljava/lang/String;", "net/minecraft/world/IInteractionObject createContainer (Lnet/minecraft/entity/player/InventoryPlayer;Lnet/minecraft/entity/player/EntityPlayer;)Lnet/minecraft/inventory/Container;", "net/minecraft/entity/player/EntityPlayer displayGui (Lnet/minecraft/world/IInteractionObject;)V"}, dependsMethods={"net/minecraft/block/Block onBlockActivated (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/MainOrOffHand;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/EnumFacing;FFF)Z"}, depends={"net/minecraft/block/BlockAnvil", "net/minecraft/entity/player/EntityPlayer"})
    public boolean getIInteractionObjectClass() {
        ClassNode blockAnvil = this.getClassNodeFromMapping("net/minecraft/block/BlockAnvil");
        ClassNode entityPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayer");
        if (blockAnvil == null || entityPlayer == null) {
            return false;
        }
        MethodNode onBlockActivated = this.getMethodNodeFromMapping(blockAnvil, "net/minecraft/block/Block onBlockActivated (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/MainOrOffHand;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/EnumFacing;FFF)Z");
        if (onBlockActivated == null) {
            return false;
        }
        String iInteractionObject = null;
        String anvilInteractionObject = null;
        for (AbstractInsnNode insn = onBlockActivated.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn.getOpcode() != 187) continue;
            TypeInsnNode tn = (TypeInsnNode)insn;
            if (!this.searchConstantPoolForStrings(tn.desc, "anvil")) continue;
            anvilInteractionObject = tn.desc;
            this.addClassMapping("net/minecraft/block/BlockAnvil$Anvil", tn.desc);
            break;
        }
        if (anvilInteractionObject != null) {
            ClassNode anvil = this.getClassNode(anvilInteractionObject);
            if (anvil.interfaces.size() == 1) {
                iInteractionObject = (String)anvil.interfaces.get(0);
                this.addClassMapping("net/minecraft/world/IInteractionObject", iInteractionObject);
            }
        }
        if (iInteractionObject != null) {
            ClassNode iiobject = this.getClassNode(iInteractionObject);
            List<MethodNode> methods = this.getMatchingMethods(iiobject, null, "()Ljava/lang/String;");
            if (methods.size() == 1) {
                this.addMethodMapping("net/minecraft/world/IInteractionObject getGuiID ()Ljava/lang/String;", iInteractionObject + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            }
            methods.clear();
            for (MethodNode method : iiobject.methods) {
                Type[] args;
                Type t;
                if (!this.checkMethodParameters(method, 10, 10) || (t = Type.getMethodType((String)method.desc)).getReturnType().getSort() != 10 || !(args = t.getArgumentTypes())[1].getClassName().equals(entityPlayer.name)) continue;
                methods.add(method);
            }
            if (methods.size() == 1) {
                MethodNode m = methods.get(0);
                Type t = Type.getMethodType((String)m.desc);
                String inventoryPlayer = t.getArgumentTypes()[0].getClassName();
                String container = t.getReturnType().getClassName();
                boolean match1 = false;
                if (this.searchConstantPoolForStrings(inventoryPlayer, "Adding item to inventory", "container.inventory")) {
                    match1 = true;
                    this.addClassMapping("net/minecraft/entity/player/InventoryPlayer", inventoryPlayer);
                }
                boolean match2 = false;
                if (this.searchConstantPoolForStrings(container, "Listener already listening")) {
                    match2 = true;
                    this.addClassMapping("net/minecraft/inventory/Container", container);
                }
                if (match1 && match2) {
                    this.addMethodMapping("net/minecraft/world/IInteractionObject createContainer (Lnet/minecraft/entity/player/InventoryPlayer;Lnet/minecraft/entity/player/EntityPlayer;)Lnet/minecraft/inventory/Container;", iInteractionObject + " " + m.name + " " + m.desc);
                }
            }
            for (AbstractInsnNode insn = onBlockActivated.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 182) continue;
                MethodInsnNode mn = (MethodInsnNode)insn;
                if (!mn.desc.equals("(L" + iInteractionObject + ";)V")) continue;
                this.addMethodMapping("net/minecraft/entity/player/EntityPlayer displayGui (Lnet/minecraft/world/IInteractionObject;)V", entityPlayer.name + " " + mn.name + " " + mn.desc);
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/inventory/Slot", "net/minecraft/inventory/EnumContainerAction"}, providesFields={"net/minecraft/inventory/Container inventorySlots Ljava/util/List;", "net/minecraft/inventory/Container crafters Ljava/util/List;"}, providesMethods={"net/minecraft/inventory/Container addSlotToContainer (Lnet/minecraft/inventory/Slot;)Lnet/minecraft/inventory/Slot;", "net/minecraft/inventory/Container canInteractWith (Lnet/minecraft/entity/player/EntityPlayer;)Z", "net/minecraft/inventory/Container transferStackInSlot (Lnet/minecraft/entity/player/EntityPlayer;I)Lnet/minecraft/item/ItemStack;", "net/minecraft/inventory/Container onContainerClosed (Lnet/minecraft/entity/player/EntityPlayer;)V", "net/minecraft/inventory/Container getSlot (I)Lnet/minecraft/inventory/Slot;", "net/minecraft/inventory/Container mergeItemStack (Lnet/minecraft/item/ItemStack;IIZ)Z", "net/minecraft/inventory/Container slotClick (IILnet/minecraft/inventory/EnumContainerAction;Lnet/minecraft/entity/player/EntityPlayer;)Lnet/minecraft/item/ItemStack;", "net/minecraft/inventory/Container putStackInSlot (ILnet/minecraft/item/ItemStack;)V", "net/minecraft/inventory/Container onCraftMatrixChanged (Lnet/minecraft/inventory/IInventory;)V", "net/minecraft/inventory/Container detectAndSendChanges ()V", "net/minecraft/inventory/Container canAddItemToSlot (Lnet/minecraft/inventory/Slot;Lnet/minecraft/item/ItemStack;Z)Z"}, depends={"net/minecraft/inventory/Container", "net/minecraft/entity/player/EntityPlayer", "net/minecraft/item/ItemStack", "net/minecraft/inventory/IInventory", "net/minecraft/inventory/ICrafting"})
    public boolean processContainerClass() {
        String containerAction;
        ClassNode iCrafting;
        ClassNode iInventory;
        ClassNode itemStack;
        ClassNode entityPlayer;
        ClassNode container = this.getClassNodeFromMapping("net/minecraft/inventory/Container");
        if (!MeddleUtil.notNull((Object[])new Object[]{container, entityPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayer"), itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack"), iInventory = this.getClassNodeFromMapping("net/minecraft/inventory/IInventory"), iCrafting = this.getClassNodeFromMapping("net/minecraft/inventory/ICrafting")})) {
            return false;
        }
        List<Object> methods = new ArrayList<MethodNode>();
        String slotClass = null;
        for (MethodNode method : container.methods) {
            Type type = Type.getMethodType((String)method.desc);
            Type[] args = type.getArgumentTypes();
            Type returnType = type.getReturnType();
            if (args.length != 1 || args[0].getSort() != 10 || returnType.getSort() != 10 || !args[0].getClassName().equals(returnType.getClassName())) continue;
            methods.add(method);
        }
        if (methods.size() == 1) {
            slotClass = Type.getMethodType((String)((MethodNode)methods.get((int)0)).desc).getReturnType().getClassName();
            this.addClassMapping("net/minecraft/inventory/Slot", slotClass);
            this.addMethodMapping("net/minecraft/inventory/Container addSlotToContainer (Lnet/minecraft/inventory/Slot;)Lnet/minecraft/inventory/Slot;", container.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        methods.clear();
        for (MethodNode method : container.methods) {
            if ((method.access & 0x400) == 0 || !method.desc.equals("(L" + entityPlayer.name + ";)Z")) continue;
            methods.add(method);
        }
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Container canInteractWith (Lnet/minecraft/entity/player/EntityPlayer;)Z", container.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        if ((methods = this.getMatchingMethods(container, null, this.assembleDescriptor("(", entityPlayer, "I)", itemStack))).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Container transferStackInSlot (Lnet/minecraft/entity/player/EntityPlayer;I)Lnet/minecraft/item/ItemStack;", container.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        if ((methods = this.getMatchingMethods(container, null, this.assembleDescriptor("(", entityPlayer, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Container onContainerClosed (Lnet/minecraft/entity/player/EntityPlayer;)V", container.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        if ((methods = this.getMatchingMethods(container, null, "(I)L" + slotClass + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Container getSlot (I)Lnet/minecraft/inventory/Slot;", container.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
            for (AbstractInsnNode insn = ((MethodNode)methods.get((int)0)).instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 180) continue;
                FieldInsnNode fn = (FieldInsnNode)insn;
                if (!fn.desc.equals("Ljava/util/List;")) continue;
                this.addFieldMapping("net/minecraft/inventory/Container inventorySlots Ljava/util/List;", container.name + " " + fn.name + " " + fn.desc);
            }
        }
        if ((methods = this.getMatchingMethods(container, null, "(L" + itemStack.name + ";IIZ)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Container mergeItemStack (Lnet/minecraft/item/ItemStack;IIZ)Z", container.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        methods.clear();
        for (MethodNode method : container.methods) {
            Type[] typeArray;
            if (!method.desc.startsWith("(IIL") || !method.desc.endsWith(";L" + entityPlayer.name + ";)L" + itemStack.name + ";") || (typeArray = Type.getMethodType((String)method.desc).getArgumentTypes()).length != 4) continue;
            methods.add(method);
        }
        if (methods.size() == 1 && this.searchConstantPoolForStrings(containerAction = Type.getMethodType((String)((MethodNode)methods.get((int)0)).desc).getArgumentTypes()[2].getClassName(), "PICKUP", "QUICK_CRAFT")) {
            this.addClassMapping("net/minecraft/inventory/EnumContainerAction", containerAction);
            this.addMethodMapping("net/minecraft/inventory/Container slotClick (IILnet/minecraft/inventory/EnumContainerAction;Lnet/minecraft/entity/player/EntityPlayer;)Lnet/minecraft/item/ItemStack;", container.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        if ((methods = this.getMatchingMethods(container, null, "(IL" + itemStack.name + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Container putStackInSlot (ILnet/minecraft/item/ItemStack;)V", container.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        if ((methods = this.getMatchingMethods(container, null, "(L" + iInventory.name + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Container onCraftMatrixChanged (Lnet/minecraft/inventory/IInventory;)V", container.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
            List<MethodInsnNode> list = this.getAllInsnNodesOfType(((MethodNode)methods.get((int)0)).instructions.getFirst(), MethodInsnNode.class);
            if (list.size() == 1) {
                MethodInsnNode mn = list.get(0);
                if (mn.owner.equals(container.name) && mn.desc.equals("()V")) {
                    this.addMethodMapping("net/minecraft/inventory/Container detectAndSendChanges ()V", container.name + " " + mn.name + " ()V");
                }
            }
        }
        if ((methods = this.getMatchingMethods(container, null, "(L" + slotClass + ";L" + itemStack.name + ";Z)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Container canAddItemToSlot (Lnet/minecraft/inventory/Slot;Lnet/minecraft/item/ItemStack;Z)Z", container.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        if ((methods = this.getMatchingMethods(container, null, "(L" + iCrafting.name + ";)V")).size() > 0) {
            HashSet<String> fieldNames = new HashSet<String>();
            for (MethodNode methodNode : methods) {
                List<FieldInsnNode> list = this.getAllInsnNodesOfType(methodNode.instructions.getFirst(), FieldInsnNode.class);
                for (FieldInsnNode fn : list) {
                    if (!fn.owner.equals(container.name) || !fn.desc.equals("Ljava/util/List;")) continue;
                    fieldNames.add(fn.name);
                }
            }
            if (fieldNames.size() == 1) {
                String fieldName = fieldNames.toArray(new String[1])[0];
                this.addFieldMapping("net/minecraft/inventory/Container crafters Ljava/util/List;", container.name + " " + fieldName + " Ljava/util/List;");
            }
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/inventory/ICrafting updateCraftingInventory (Lnet/minecraft/inventory/Container;Ljava/util/List;)V", "net/minecraft/inventory/ICrafting sendSlotContents (Lnet/minecraft/inventory/Container;ILnet/minecraft/item/ItemStack;)V", "net/minecraft/inventory/ICrafting sendProgressBarUpdate (Lnet/minecraft/inventory/Container;II)V", "net/minecraft/inventory/ICrafting func_175173_a (Lnet/minecraft/inventory/Container;Lnet/minecraft/inventory/IInventory;)V"}, depends={"net/minecraft/inventory/ICrafting", "net/minecraft/inventory/Container", "net/minecraft/item/ItemStack", "net/minecraft/inventory/IInventory"})
    public boolean processICraftingClass() {
        ClassNode iCrafting = this.getClassNodeFromMapping("net/minecraft/inventory/ICrafting");
        ClassNode container = this.getClassNodeFromMapping("net/minecraft/inventory/Container");
        ClassNode itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack");
        ClassNode iInventory = this.getClassNodeFromMapping("net/minecraft/inventory/IInventory");
        if (!MeddleUtil.notNull((Object[])new Object[]{iCrafting, container, itemStack, iInventory})) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(iCrafting, null, "(L" + container.name + ";Ljava/util/List;)V");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/ICrafting updateCraftingInventory (Lnet/minecraft/inventory/Container;Ljava/util/List;)V", iCrafting.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iCrafting, null, "(L" + container.name + ";IL" + itemStack.name + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/ICrafting sendSlotContents (Lnet/minecraft/inventory/Container;ILnet/minecraft/item/ItemStack;)V", iCrafting.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iCrafting, null, "(L" + container.name + ";II)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/ICrafting sendProgressBarUpdate (Lnet/minecraft/inventory/Container;II)V", iCrafting.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iCrafting, null, "(L" + container.name + ";L" + iInventory.name + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/ICrafting func_175173_a (Lnet/minecraft/inventory/Container;Lnet/minecraft/inventory/IInventory;)V", iCrafting.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/inventory/Slot inventory Lnet/minecraft/inventory/IInventory;", "net/minecraft/inventory/Slot slotIndex I", "net/minecraft/inventory/Slot xDisplayPosition I", "net/minecraft/inventory/Slot yDisplayPosition I", "net/minecraft/inventory/Slot slotNumber I"}, providesMethods={"net/minecraft/inventory/Slot onSlotChange (Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)V", "net/minecraft/inventory/Slot onCrafting (Lnet/minecraft/item/ItemStack;I)V", "net/minecraft/inventory/Slot onCrafting (Lnet/minecraft/item/ItemStack;)V", "net/minecraft/inventory/Slot putStack (Lnet/minecraft/item/ItemStack;)V", "net/minecraft/inventory/Slot onPickupFromSlot (Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/item/ItemStack;)V", "net/minecraft/inventory/Slot isItemValid (Lnet/minecraft/item/ItemStack;)Z", "net/minecraft/inventory/Slot getStack ()Lnet/minecraft/item/ItemStack;", "net/minecraft/inventory/Slot getHasStack ()Z", "net/minecraft/inventory/Slot onSlotChanged ()V", "net/minecraft/inventory/Slot getSlotStackLimit ()I", "net/minecraft/inventory/Slot getItemStackLimit (Lnet/minecraft/item/ItemStack;)I", "net/minecraft/inventory/Slot decrStackSize (I)Lnet/minecraft/item/ItemStack;", "net/minecraft/inventory/Slot isHere (Lnet/minecraft/inventory/IInventory;I)Z", "net/minecraft/inventory/Slot canTakeStack (Lnet/minecraft/entity/player/EntityPlayer;)Z"}, depends={"net/minecraft/inventory/Slot", "net/minecraft/item/ItemStack", "net/minecraft/entity/player/EntityPlayer", "net/minecraft/inventory/IInventory"})
    public boolean processSlotClass() {
        List<FieldNode> fields;
        ClassNode iInventory;
        ClassNode entityPlayer;
        ClassNode itemStack;
        ClassNode slot = this.getClassNodeFromMapping("net/minecraft/inventory/Slot");
        if (!MeddleUtil.notNull((Object[])new Object[]{slot, itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack"), entityPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayer"), iInventory = this.getClassNodeFromMapping("net/minecraft/inventory/IInventory")})) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(slot, "<init>", this.assembleDescriptor("(", iInventory, "III)V"));
        String slotIndex = null;
        String xDisplayPosition = null;
        String yDisplayPosition = null;
        if (methods.size() == 1) {
            for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 181) continue;
                FieldInsnNode fn = (FieldInsnNode)insn;
                if (!fn.owner.equals(slot.name)) continue;
                if (fn.desc.equals("L" + iInventory.name + ";")) {
                    this.addFieldMapping("net/minecraft/inventory/Slot inventory Lnet/minecraft/inventory/IInventory;", slot.name + " " + fn.name + " " + fn.desc);
                    continue;
                }
                if (!fn.desc.equals("I")) continue;
                if (slotIndex == null) {
                    slotIndex = fn.name;
                    continue;
                }
                if (xDisplayPosition == null) {
                    xDisplayPosition = fn.name;
                    continue;
                }
                if (yDisplayPosition != null) continue;
                yDisplayPosition = fn.name;
            }
        }
        if (MeddleUtil.notNull((Object[])new Object[]{slotIndex, xDisplayPosition, yDisplayPosition}) && (fields = this.getMatchingFields(slot, null, "I")).size() == 4) {
            for (FieldNode field : fields) {
                if (field.name.equals(slotIndex)) {
                    this.addFieldMapping("net/minecraft/inventory/Slot slotIndex I", slot.name + " " + field.name + " I");
                    continue;
                }
                if (field.name.equals(xDisplayPosition)) {
                    this.addFieldMapping("net/minecraft/inventory/Slot xDisplayPosition I", slot.name + " " + field.name + " I");
                    continue;
                }
                if (field.name.equals(yDisplayPosition)) {
                    this.addFieldMapping("net/minecraft/inventory/Slot yDisplayPosition I", slot.name + " " + field.name + " I");
                    continue;
                }
                this.addFieldMapping("net/minecraft/inventory/Slot slotNumber I", slot.name + " " + field.name + " I");
            }
        }
        if ((methods = this.getMatchingMethods(slot, null, this.assembleDescriptor("(", itemStack, itemStack, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Slot onSlotChange (Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)V", slot.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(slot, null, this.assembleDescriptor("(", itemStack, "I)V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Slot onCrafting (Lnet/minecraft/item/ItemStack;I)V", slot.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(slot, null, this.assembleDescriptor("(", itemStack, ")V"))).size() == 2) {
            boolean isReturn2;
            MethodNode onCrafting = null;
            MethodNode putStack = null;
            boolean isReturn1 = this.getNextRealOpcode(methods.get((int)0).instructions.getFirst()).getOpcode() == 177;
            boolean bl = isReturn2 = this.getNextRealOpcode(methods.get((int)1).instructions.getFirst()).getOpcode() == 177;
            if (isReturn1 && !isReturn2) {
                onCrafting = methods.get(0);
                putStack = methods.get(1);
            } else if (!isReturn1 && isReturn2) {
                onCrafting = methods.get(1);
                putStack = methods.get(0);
            }
            if (onCrafting != null && putStack != null) {
                this.addMethodMapping("net/minecraft/inventory/Slot onCrafting (Lnet/minecraft/item/ItemStack;)V", slot.name + " " + onCrafting.name + " " + onCrafting.desc);
                this.addMethodMapping("net/minecraft/inventory/Slot putStack (Lnet/minecraft/item/ItemStack;)V", slot.name + " " + putStack.name + " " + putStack.desc);
            }
        }
        if ((methods = this.getMatchingMethods(slot, null, this.assembleDescriptor("(", entityPlayer, itemStack, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Slot onPickupFromSlot (Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/item/ItemStack;)V", slot.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(slot, null, this.assembleDescriptor("(", itemStack, ")Z"))).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Slot isItemValid (Lnet/minecraft/item/ItemStack;)Z", slot.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        String getStack = null;
        methods = this.getMatchingMethods(slot, null, this.assembleDescriptor("()", itemStack));
        if (methods.size() == 1) {
            getStack = slot.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc;
            this.addMethodMapping("net/minecraft/inventory/Slot getStack ()Lnet/minecraft/item/ItemStack;", getStack);
        }
        methods = this.getMatchingMethods(slot, null, "()Z");
        if (getStack != null && (methods.size() == 1 || methods.size() == 2)) {
            block2: for (MethodNode method : methods) {
                for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                    if (insn.getOpcode() != 182) continue;
                    MethodInsnNode mn = (MethodInsnNode)insn;
                    if (!getStack.equals(mn.owner + " " + mn.name + " " + mn.desc)) continue;
                    this.addMethodMapping("net/minecraft/inventory/Slot getHasStack ()Z", slot.name + " " + method.name + " " + method.desc);
                    break block2;
                }
            }
        }
        if ((methods = this.getMatchingMethods(slot, null, "()V")).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Slot onSlotChanged ()V", slot.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(slot, null, "()I")).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Slot getSlotStackLimit ()I", slot.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(slot, null, this.assembleDescriptor("(", itemStack, ")I"))).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Slot getItemStackLimit (Lnet/minecraft/item/ItemStack;)I", slot.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(slot, null, this.assembleDescriptor("(I)", itemStack))).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Slot decrStackSize (I)Lnet/minecraft/item/ItemStack;", slot.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(slot, null, this.assembleDescriptor("(", iInventory, "I)Z"))).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Slot isHere (Lnet/minecraft/inventory/IInventory;I)Z", slot.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(slot, null, this.assembleDescriptor("(", entityPlayer, ")Z"))).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/Slot canTakeStack (Lnet/minecraft/entity/player/EntityPlayer;)Z", slot.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/item/ItemSword", "net/minecraft/item/ItemSoup", "net/minecraft/item/ItemBanner", "net/minecraft/item/ItemDye", "net/minecraft/item/ItemBow", "net/minecraft/item/ItemRecord", "net/minecraft/item/ItemAxe", "net/minecraft/item/ItemTool", "net/minecraft/item/ItemPickaxe"}, providesMethods={"net/minecraft/item/Item registerItems ()V"}, depends={"net/minecraft/item/Item"})
    public boolean discoverItems() {
        ClassNode pickaxe;
        ClassNode tool;
        ClassNode axe;
        ClassNode itemClass = this.getClassNodeFromMapping("net/minecraft/item/Item");
        if (itemClass == null) {
            return false;
        }
        List<MethodNode> methods = this.removeMethodsWithoutFlags(this.getMatchingMethods(itemClass, null, "()V"), 8);
        Iterator<MethodNode> it = methods.iterator();
        while (it.hasNext()) {
            if (!it.next().name.contains("<")) continue;
            it.remove();
        }
        if (methods.size() != 1) {
            return false;
        }
        MethodNode registerItemsMethod = methods.get(0);
        this.addMethodMapping("net/minecraft/item/Item registerItems ()V", itemClass.name + " " + registerItemsMethod.name + " " + registerItemsMethod.desc);
        HashMap<String, String> itemClassMap = new HashMap<String, String>();
        for (AbstractInsnNode insn = registerItemsMethod.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            String name = this.getLdcString(insn);
            if (name == null || insn.getNext().getOpcode() != 187) continue;
            insn = insn.getNext();
            TypeInsnNode newNode = (TypeInsnNode)insn;
            if (newNode.desc.equals(itemClass.name)) continue;
            itemClassMap.put(name, newNode.desc);
        }
        String className = (String)itemClassMap.get("iron_sword");
        if (className != null && this.searchConstantPoolForStrings(className, "Weapon modifier")) {
            this.addClassMapping("net/minecraft/item/ItemSword", className);
        }
        if ((className = (String)itemClassMap.get("mushroom_stew")) != null && className.equals(itemClassMap.get("rabbit_stew"))) {
            this.addClassMapping("net/minecraft/item/ItemSoup", className);
        }
        if ((className = (String)itemClassMap.get("banner")) != null && this.searchConstantPoolForStrings(className, "item.banner.")) {
            this.addClassMapping("net/minecraft/item/ItemBanner", className);
        }
        if ((className = (String)itemClassMap.get("dye")) != null && this.searchConstantPoolForStrings(className, ".")) {
            this.addClassMapping("net/minecraft/item/ItemDye", className);
        }
        if ((className = (String)itemClassMap.get("bow")) != null && this.searchConstantPoolForStrings(className, "pull", "pulling")) {
            this.addClassMapping("net/minecraft/item/ItemBow", className);
        }
        if ((className = (String)itemClassMap.get("record_13")) != null && this.searchConstantPoolForStrings(className, "item.record.")) {
            this.addClassMapping("net/minecraft/item/ItemRecord", className);
        }
        String itemTool = null;
        className = (String)itemClassMap.get("iron_axe");
        if (className != null && (axe = this.getClassNode(className)) != null && (tool = this.getClassNode(axe.superName)) != null && tool.superName.equals(itemClass.name) && this.searchConstantPoolForStrings(tool.name, "Tool modifier")) {
            this.addClassMapping("net/minecraft/item/ItemAxe", axe.name);
            this.addClassMapping("net/minecraft/item/ItemTool", tool.name);
            itemTool = tool.name;
        }
        if ((className = (String)itemClassMap.get("iron_pickaxe")) != null && itemTool != null && (pickaxe = this.getClassNode(className)) != null && pickaxe.superName != null && pickaxe.superName.equals(itemTool)) {
            this.addClassMapping("net/minecraft/item/ItemPickaxe", pickaxe.name);
        }
        if ((className = (String)itemClassMap.get("iron_pickaxe")) != null && (axe = this.getClassNode(className)) != null && (tool = this.getClassNode(axe.superName)) != null && tool.superName.equals(itemClass.name) && this.searchConstantPoolForStrings(tool.name, "Tool modifier")) {
            this.addClassMapping("net/minecraft/item/ItemPickaxe", axe.name);
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/item/ItemPickaxe EFFECTIVE_ON Ljava/util/Set;", "net/minecraft/item/ItemTool efficiencyOnProperMaterial F"}, providesMethods={"net/minecraft/item/Item canHarvestBlock (Lnet/minecraft/block/state/IBlockState;)Z", "net/minecraft/item/ItemTool getStrVsBlock (Lnet/minecraft/item/ItemStack;Lnet/minecraft/block/state/IBlockState;)F"}, depends={"net/minecraft/item/ItemPickaxe", "net/minecraft/item/Item", "net/minecraft/item/ItemStack", "net/minecraft/block/Block", "net/minecraft/item/ItemTool", "net/minecraft/block/state/IBlockState"})
    public boolean processItemPickaxeClass() {
        List<MethodNode> methods;
        ClassNode iBlockState;
        ClassNode itemTool;
        ClassNode block;
        ClassNode itemStack;
        ClassNode item;
        ClassNode itemPickaxe = this.getClassNodeFromMapping("net/minecraft/item/ItemPickaxe");
        if (!MeddleUtil.notNull((Object[])new Object[]{itemPickaxe, item = this.getClassNodeFromMapping("net/minecraft/item/Item"), itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack"), block = this.getClassNodeFromMapping("net/minecraft/block/Block"), itemTool = this.getClassNodeFromMapping("net/minecraft/item/ItemTool"), iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState")})) {
            return false;
        }
        List<FieldNode> fields = this.getMatchingFields(itemPickaxe, null, "Ljava/util/Set;");
        if (fields.size() == 1) {
            this.addFieldMapping("net/minecraft/item/ItemPickaxe EFFECTIVE_ON Ljava/util/Set;", itemPickaxe.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(itemPickaxe, null, "(L" + iBlockState.name + ";)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/item/Item canHarvestBlock (Lnet/minecraft/block/state/IBlockState;)Z", item.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(itemPickaxe, null, "(L" + itemStack.name + ";L" + iBlockState.name + ";)F")).size() == 1) {
            this.addMethodMapping("net/minecraft/item/ItemTool getStrVsBlock (Lnet/minecraft/item/ItemStack;Lnet/minecraft/block/state/IBlockState;)F", itemTool.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            List<FieldInsnNode> nodes = this.getAllInsnNodesOfType(methods.get(0), FieldInsnNode.class);
            Iterator<FieldInsnNode> it = nodes.iterator();
            while (it.hasNext()) {
                FieldInsnNode fn = it.next();
                if (fn.owner.equals(itemPickaxe.name) && fn.desc.equals("F")) continue;
                it.remove();
            }
            if (nodes.size() == 1 && this.getFieldNode(itemTool, "--- " + nodes.get((int)0).name + " F") != null) {
                this.addFieldMapping("net/minecraft/item/ItemTool efficiencyOnProperMaterial F", itemTool.name + " " + nodes.get((int)0).name + " F");
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/util/Sound"}, depends={"net/minecraft/item/ItemRecord"})
    public boolean processItemRecordClass() {
        String soundClass;
        ClassNode itemRecord = this.getClassNodeFromMapping("net/minecraft/item/ItemRecord");
        if (itemRecord == null) {
            return false;
        }
        ArrayList<MethodNode> methods = new ArrayList<MethodNode>();
        for (MethodNode method : itemRecord.methods) {
            if (!method.name.equals("<init>") || !method.desc.startsWith("(Ljava/lang/String;L")) continue;
            methods.add(method);
        }
        if (methods.size() == 1 && this.searchConstantPoolForStrings(soundClass = Type.getMethodType((String)((MethodNode)methods.get((int)0)).desc).getArgumentTypes()[1].getClassName(), "ambient.cave", "weather.rain")) {
            this.addClassMapping("net/minecraft/util/Sound", soundClass);
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/item/Item onPlayerStoppedUsing (Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/EntityLivingBase;I)V", "net/minecraft/item/Item getMaxItemUseDuration (Lnet/minecraft/item/ItemStack;)I", "net/minecraft/item/Item getItemEnchantability ()I", "net/minecraft/item/Item getItemUseAction (Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/EnumAction;", "net/minecraft/entity/EntityLivingBase setItemInUse (Lnet/minecraft/util/MainOrOffHand;)V"}, provides={"net/minecraft/item/EnumAction", "net/minecraft/init/Sounds"}, dependsMethods={"net/minecraft/item/Item onItemRightClick (Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/MainOrOffHand;)Lnet/minecraft/util/ObjectActionHolder;"}, depends={"net/minecraft/item/Item", "net/minecraft/item/ItemBow", "net/minecraft/item/ItemStack", "net/minecraft/world/World", "net/minecraft/entity/player/EntityPlayer", "net/minecraft/entity/EntityLivingBase", "net/minecraft/util/MainOrOffHand", "net/minecraft/util/Sound"})
    public boolean processItemBowClass() {
        MethodNode method;
        ClassNode sound;
        ClassNode hand;
        ClassNode entityLivingBase;
        ClassNode entityPlayer;
        ClassNode world;
        ClassNode itemStack;
        ClassNode itemBow;
        ClassNode item = this.getClassNodeFromMapping("net/minecraft/item/Item");
        if (!MeddleUtil.notNull((Object[])new Object[]{item, itemBow = this.getClassNodeFromMapping("net/minecraft/item/ItemBow"), itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack"), world = this.getClassNodeFromMapping("net/minecraft/world/World"), entityPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayer"), entityLivingBase = this.getClassNodeFromMapping("net/minecraft/entity/EntityLivingBase"), hand = this.getClassNodeFromMapping("net/minecraft/util/MainOrOffHand"), sound = this.getClassNodeFromMapping("net/minecraft/util/Sound")})) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(itemBow, null, this.assembleDescriptor("(", itemStack, world, entityLivingBase, "I)V"));
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/item/Item onPlayerStoppedUsing (Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/EntityLivingBase;I)V", item.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            List<FieldInsnNode> nodes = this.getAllInsnNodesOfType(methods.get((int)0).instructions.getFirst(), FieldInsnNode.class);
            Iterator iterator = nodes.iterator();
            while (iterator.hasNext()) {
                FieldInsnNode fn = (FieldInsnNode)iterator.next();
                if (!fn.desc.equals("L" + sound.name + ";") || !this.searchConstantPoolForStrings(fn.owner, "Accessed Sounds before Bootstrap!")) continue;
                this.addClassMapping("net/minecraft/init/Sounds", fn.owner);
            }
        }
        if ((methods = this.getMatchingMethods(itemBow, null, this.assembleDescriptor("(", itemStack, ")I"))).size() == 1) {
            this.addMethodMapping("net/minecraft/item/Item getMaxItemUseDuration (Lnet/minecraft/item/ItemStack;)I", item.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        methods.clear();
        for (MethodNode method2 : itemBow.methods) {
            if (!method2.desc.startsWith("(L" + itemStack.name + ";)L")) continue;
            methods.add(method2);
        }
        if (methods.size() == 1) {
            method = methods.get(0);
            Type t = Type.getMethodType((String)method.desc).getReturnType();
            if (this.searchConstantPoolForStrings(t.getClassName(), "EAT", "DRINK", "BLOCK")) {
                this.addClassMapping("net/minecraft/item/EnumAction", t.getClassName());
                this.addMethodMapping("net/minecraft/item/Item getItemUseAction (Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/EnumAction;", item.name + " " + method.name + " " + method.desc);
            }
        }
        if ((methods = this.getMatchingMethods(itemBow, null, "()I")).size() == 1) {
            this.addMethodMapping("net/minecraft/item/Item getItemEnchantability ()I", item.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((method = this.getMethodNodeFromMapping(itemBow, "net/minecraft/item/Item onItemRightClick (Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/MainOrOffHand;)Lnet/minecraft/util/ObjectActionHolder;")) != null) {
            ArrayList<MethodInsnNode> methodNodes = new ArrayList<MethodInsnNode>();
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 182) continue;
                MethodInsnNode mn = (MethodInsnNode)insn;
                if (!mn.owner.equals(entityPlayer.name) || !mn.desc.equals("(L" + hand.name + ";)V")) continue;
                methodNodes.add(mn);
            }
            if (methodNodes.size() == 1) {
                this.addMethodMapping("net/minecraft/entity/EntityLivingBase setItemInUse (Lnet/minecraft/util/MainOrOffHand;)V", entityLivingBase.name + " " + ((MethodInsnNode)methodNodes.get((int)0)).name + " " + ((MethodInsnNode)methodNodes.get((int)0)).desc);
            }
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/item/EnumAction NONE Lnet/minecraft/item/EnumAction;", "net/minecraft/item/EnumAction EAT Lnet/minecraft/item/EnumAction;", "net/minecraft/item/EnumAction DRINK Lnet/minecraft/item/EnumAction;", "net/minecraft/item/EnumAction BLOCK Lnet/minecraft/item/EnumAction;", "net/minecraft/item/EnumAction BOW Lnet/minecraft/item/EnumAction;"}, depends={"net/minecraft/item/EnumAction"})
    public boolean processEnumActionClass() {
        ClassNode enumAction = this.getClassNodeFromMapping("net/minecraft/item/EnumAction");
        if (enumAction == null) {
            return false;
        }
        ArrayList<String> strings = new ArrayList<String>();
        ArrayList<String> fields = new ArrayList<String>();
        MethodNode init = this.getMethodNode(enumAction, "--- <clinit> ()V");
        if (init == null) {
            return false;
        }
        for (AbstractInsnNode insn = init.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            String s = this.getLdcString(insn);
            if (s != null) {
                strings.add(s);
                continue;
            }
            if (insn.getOpcode() != 179) continue;
            FieldInsnNode fn = (FieldInsnNode)insn;
            if (!fn.owner.equals(enumAction.name) || !fn.desc.equals("L" + enumAction.name + ";")) continue;
            fields.add(fn.name);
        }
        if (strings.size() == 5 && fields.size() == 5) {
            for (int n = 0; n < 5; ++n) {
                this.addFieldMapping("net/minecraft/item/EnumAction " + (String)strings.get(n) + " Lnet/minecraft/item/EnumAction;", enumAction.name + " " + (String)fields.get(n) + " L" + enumAction.name + ";");
            }
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/item/Item setHasSubtypes (Z)Lnet/minecraft/item/Item;", "net/minecraft/item/ItemStack getMetadata ()I"}, providesFields={}, dependsMethods={"net/minecraft/item/Item getUnlocalizedName (Lnet/minecraft/item/ItemStack;)Ljava/lang/String;"}, depends={"net/minecraft/item/Item", "net/minecraft/item/ItemDye", "net/minecraft/item/ItemStack"})
    public boolean processItemDyeClass() {
        MethodNode method;
        ClassNode itemStack;
        ClassNode itemDye;
        ClassNode item = this.getClassNodeFromMapping("net/minecraft/item/Item");
        if (!MeddleUtil.notNull((Object[])new Object[]{item, itemDye = this.getClassNodeFromMapping("net/minecraft/item/ItemDye"), itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack")})) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(itemDye, "<init>", "()V");
        if (methods.size() == 1) {
            List<MethodInsnNode> mnodes = this.getAllInsnNodesOfType(methods.get((int)0).instructions.getFirst(), MethodInsnNode.class);
            ArrayList<MethodInsnNode> foundnodes = new ArrayList<MethodInsnNode>();
            for (MethodInsnNode mn : mnodes) {
                if (!mn.owner.equals(itemDye.name) || !mn.desc.equals("(Z)L" + item.name + ";")) continue;
                foundnodes.add(mn);
            }
            if (foundnodes.size() == 1) {
                this.addMethodMapping("net/minecraft/item/Item setHasSubtypes (Z)Lnet/minecraft/item/Item;", item.name + " " + ((MethodInsnNode)foundnodes.get((int)0)).name + " " + ((MethodInsnNode)foundnodes.get((int)0)).desc);
            }
        }
        if ((method = this.getMethodNodeFromMapping(itemDye, "net/minecraft/item/Item getUnlocalizedName (Lnet/minecraft/item/ItemStack;)Ljava/lang/String;")) != null) {
            List<MethodInsnNode> mnodes = this.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            Iterator<MethodInsnNode> iterator = mnodes.iterator();
            while (iterator.hasNext()) {
                MethodInsnNode mn;
                mn = iterator.next();
                if (mn.owner.equals(itemStack.name) && mn.desc.equals("()I")) continue;
                iterator.remove();
            }
            if (mnodes.size() == 1) {
                this.addMethodMapping("net/minecraft/item/ItemStack getMetadata ()I", itemStack.name + " " + mnodes.get((int)0).name + " ()I");
            }
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/item/Item setMaxDamage (I)Lnet/minecraft/item/Item;", "net/minecraft/item/Item getMaxDamage ()I"}, providesFields={"net/minecraft/item/Item maxDamage I"}, depends={"net/minecraft/item/Item", "net/minecraft/item/ItemBanner"})
    public boolean getMaxDamageStuff() {
        ClassNode item = this.getClassNodeFromMapping("net/minecraft/item/Item");
        ClassNode banner = this.getClassNodeFromMapping("net/minecraft/item/ItemBanner");
        if (item == null || banner == null) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(banner, "<init>", "()V");
        if (methods.size() != 1) {
            return false;
        }
        int count = 0;
        String setMaxDamageName = null;
        String setMaxDamageDesc = "(I)L" + item.name + ";";
        for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn.getOpcode() != 182) continue;
            MethodInsnNode mn = (MethodInsnNode)insn;
            if (!mn.desc.equals(setMaxDamageDesc)) continue;
            setMaxDamageName = mn.name;
            ++count;
        }
        if (count != 1) {
            return false;
        }
        this.addMethodMapping("net/minecraft/item/Item setMaxDamage (I)Lnet/minecraft/item/Item;", item.name + " " + setMaxDamageName + " " + setMaxDamageDesc);
        String maxDamageField = null;
        methods = this.getMatchingMethods(item, setMaxDamageName, setMaxDamageDesc);
        if (methods.size() != 1) {
            return false;
        }
        for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn.getOpcode() < 0) continue;
            if (insn.getOpcode() != 25) {
                return false;
            }
            if ((insn = insn.getNext()).getOpcode() != 21) {
                return false;
            }
            if ((insn = insn.getNext()).getOpcode() != 181) {
                return false;
            }
            FieldInsnNode fn = (FieldInsnNode)insn;
            if (!fn.desc.equals("I")) {
                return false;
            }
            maxDamageField = fn.name;
            break;
        }
        if (maxDamageField == null) {
            return false;
        }
        this.addFieldMapping("net/minecraft/item/Item maxDamage I", item.name + " " + maxDamageField + " I");
        methods = this.getMatchingMethods(item, null, "()I");
        block2: for (MethodNode method : methods) {
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() < 0) continue;
                if (insn.getOpcode() != 25) {
                    return false;
                }
                if ((insn = insn.getNext()).getOpcode() != 180) {
                    return false;
                }
                FieldInsnNode fn = (FieldInsnNode)insn;
                if (!fn.name.equals(maxDamageField)) continue block2;
                this.addMethodMapping("net/minecraft/item/Item getMaxDamage ()I", item.name + " " + method.name + " " + method.desc);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Mapping(provides={"net/minecraft/util/Vec3", "net/minecraft/block/material/Material", "net/minecraft/block/material/MapColor", "net/minecraft/block/state/BlockState", "net/minecraft/util/RegistryNamespacedDefaultedByKey", "net/minecraft/util/ObjectIntIdentityMap"}, providesFields={"net/minecraft/block/Block unlocalizedName Ljava/lang/String;", "net/minecraft/block/Block blockRegistry Lnet/minecraft/util/RegistryNamespacedDefaultedByKey;", "net/minecraft/block/Block BLOCK_STATE_IDS Lnet/minecraft/util/ObjectIntIdentityMap;", "net/minecraft/block/Block defaultBlockState Lnet/minecraft/block/state/IBlockState;", "net/minecraft/block/Block translucent Z", "net/minecraft/block/Block useNeighborBrightness Z"}, providesMethods={"net/minecraft/block/Block getIdFromBlock (Lnet/minecraft/block/Block;)I", "net/minecraft/block/Block onBlockActivated (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/MainOrOffHand;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/EnumFacing;FFF)Z", "net/minecraft/block/Block collisionRayTrace (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/Vec3;Lnet/minecraft/util/Vec3;)Lnet/minecraft/util/MovingObjectPosition;", "net/minecraft/block/Block registerBlock (ILnet/minecraft/util/ResourceLocation;Lnet/minecraft/block/Block;)V", "net/minecraft/block/Block registerBlock (ILjava/lang/String;Lnet/minecraft/block/Block;)V", "net/minecraft/block/Block getStateFromMeta (I)Lnet/minecraft/block/state/IBlockState;", "net/minecraft/block/Block getStateById (I)Lnet/minecraft/block/state/IBlockState;", "net/minecraft/block/Block getMetaFromState (Lnet/minecraft/block/state/IBlockState;)I", "net/minecraft/block/Block setDefaultState (Lnet/minecraft/block/state/IBlockState;)V", "net/minecraft/block/Block getDefaultState ()Lnet/minecraft/block/state/IBlockState;", "net/minecraft/block/Block getActualState (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;)Lnet/minecraft/block/state/IBlockState;", "net/minecraft/block/Block setUnlocalizedName (Ljava/lang/String;)Lnet/minecraft/block/Block;", "net/minecraft/block/Block getLocalizedName ()Ljava/lang/String;", "net/minecraft/block/Block getUnlocalizedName ()Ljava/lang/String;", "net/minecraft/block/Block onEntityCollidedWithBlock (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/entity/Entity;)V", "net/minecraft/block/Block onBlockPlaced (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/EnumFacing;FFFILnet/minecraft/entity/EntityLivingBase;)Lnet/minecraft/block/state/IBlockState;", "net/minecraft/block/Block onBlockClicked (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/entity/player/EntityPlayer;)V", "net/minecraft/block/material/Material getMaterialMapColor ()Lnet/minecraft/block/material/MapColor;", "net/minecraft/block/Block createBlockState ()Lnet/minecraft/block/state/BlockState;", "net/minecraft/block/Block getBlockState ()Lnet/minecraft/block/state/BlockState;", "net/minecraft/block/Block registerBlocks ()V", "net/minecraft/util/ObjectIntIdentityMap put (Ljava/lang/Object;I)V"}, depends={"net/minecraft/block/Block", "net/minecraft/item/Item", "net/minecraft/item/ItemStack", "net/minecraft/world/World", "net/minecraft/util/BlockPos", "net/minecraft/block/state/IBlockState", "net/minecraft/entity/player/EntityPlayer", "net/minecraft/util/MainOrOffHand", "net/minecraft/util/EnumFacing", "net/minecraft/util/MovingObjectPosition", "net/minecraft/util/ResourceLocation", "net/minecraft/world/IBlockAccess", "net/minecraft/entity/Entity", "net/minecraft/entity/EntityLivingBase"})
    public boolean processBlockClass() {
        List<FieldNode> fields;
        Object method;
        String descriptor;
        ClassNode entity;
        ClassNode entityLivingBase;
        ClassNode iBlockAccess;
        ClassNode resourceLocation;
        ClassNode movingObjectPosition;
        ClassNode enumFacing;
        ClassNode mainOrOffHand;
        ClassNode entityPlayer;
        ClassNode iBlockState;
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        ClassNode item = this.getClassNodeFromMapping("net/minecraft/item/Item");
        ClassNode itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack");
        ClassNode world = this.getClassNodeFromMapping("net/minecraft/world/World");
        ClassNode blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos");
        if (!MeddleUtil.notNull((Object[])new Object[]{block, item, itemStack, blockPos, world, iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState"), entityPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayer"), mainOrOffHand = this.getClassNodeFromMapping("net/minecraft/util/MainOrOffHand"), enumFacing = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing"), movingObjectPosition = this.getClassNodeFromMapping("net/minecraft/util/MovingObjectPosition"), resourceLocation = this.getClassNodeFromMapping("net/minecraft/util/ResourceLocation"), iBlockAccess = this.getClassNodeFromMapping("net/minecraft/world/IBlockAccess"), entityLivingBase = this.getClassNodeFromMapping("net/minecraft/entity/EntityLivingBase"), entity = this.getClassNodeFromMapping("net/minecraft/entity/Entity")})) {
            return false;
        }
        List<Object> methods = new ArrayList();
        methods = this.getMatchingMethods(block, null, "(L" + block.name + ";)I");
        if ((methods = this.removeMethodsWithoutFlags(methods, 8)).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getIdFromBlock (Lnet/minecraft/block/Block;)I", block.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
            for (AbstractInsnNode insn2 = ((MethodNode)methods.get((int)0)).instructions.getFirst(); insn2 != null; insn2 = insn2.getNext()) {
                if (insn2.getOpcode() != 178) continue;
                FieldInsnNode fn = (FieldInsnNode)insn2;
                String registryNamespacedDefaultedByKey = Type.getType((String)fn.desc).getClassName();
                this.addClassMapping("net/minecraft/util/RegistryNamespacedDefaultedByKey", registryNamespacedDefaultedByKey);
                this.addFieldMapping("net/minecraft/block/Block blockRegistry Lnet/minecraft/util/RegistryNamespacedDefaultedByKey;", block.name + " " + fn.name + " " + fn.desc);
            }
        }
        if ((methods = this.getMatchingMethods(block, null, "(IL" + resourceLocation.name + ";L" + block.name + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block registerBlock (ILnet/minecraft/util/ResourceLocation;Lnet/minecraft/block/Block;)V", block.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, "(ILjava/lang/String;L" + block.name + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block registerBlock (ILjava/lang/String;Lnet/minecraft/block/Block;)V", block.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        methods.clear();
        String materialClass = null;
        String mapColorClass = null;
        for (MethodNode method2 : block.methods) {
            Type t;
            Type[] args;
            if (!method2.name.equals("<init>") || (args = (t = Type.getMethodType((String)method2.desc)).getArgumentTypes()).length != 1 || args[0].getSort() != 10) continue;
            methods.add(method2);
        }
        if (methods.size() == 1) {
            materialClass = Type.getMethodType((String)((MethodNode)methods.get((int)0)).desc).getArgumentTypes()[0].getClassName();
            this.addClassMapping("net/minecraft/block/material/Material", materialClass);
            for (AbstractInsnNode insn3 = ((MethodNode)methods.get((int)0)).instructions.getFirst(); insn3 != null; insn3 = insn3.getNext()) {
                if (insn3.getOpcode() != 182) continue;
                MethodInsnNode mn = (MethodInsnNode)insn3;
                if (!mn.owner.equals(materialClass)) continue;
                mapColorClass = Type.getMethodType((String)mn.desc).getReturnType().getClassName();
                if (this.searchConstantPoolForStrings(mapColorClass, "Map colour ID must be between 0 and 63 (inclusive)")) {
                    this.addClassMapping("net/minecraft/block/material/MapColor", mapColorClass);
                    this.addMethodMapping("net/minecraft/block/material/Material getMaterialMapColor ()Lnet/minecraft/block/material/MapColor;", materialClass + " " + mn.name + " " + mn.desc);
                    break;
                }
                mapColorClass = null;
            }
        }
        String blockStateClass = null;
        methods.clear();
        if (materialClass != null && mapColorClass != null) {
            methods = this.getMatchingMethods(block, "<init>", "(L" + materialClass + ";L" + mapColorClass + ";)V");
        }
        if (methods.size() == 1) {
            for (AbstractInsnNode insn4 = ((MethodNode)methods.get((int)0)).instructions.getFirst(); insn4 != null; insn4 = insn4.getNext()) {
                if (insn4.getOpcode() != 182) continue;
                MethodInsnNode mn = (MethodInsnNode)insn4;
                Type returnType = Type.getMethodType((String)mn.desc).getReturnType();
                if (returnType.getSort() != 10 || !returnType.getClassName().equals(iBlockState.name) || !this.searchConstantPoolForStrings(mn.owner, "block", "properties")) continue;
                blockStateClass = mn.owner;
                this.addClassMapping("net/minecraft/block/state/BlockState", mn.owner);
                break;
            }
        }
        if ((methods = this.getMatchingMethods(block, null, descriptor = this.assembleDescriptor("(", world, blockPos, iBlockState, entityPlayer, mainOrOffHand, itemStack, enumFacing, "FFF)Z"))).size() == 1) {
            method = (MethodNode)methods.get(0);
            this.addMethodMapping("net/minecraft/block/Block onBlockActivated (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/MainOrOffHand;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/EnumFacing;FFF)Z", block.name + " " + ((MethodNode)method).name + " " + ((MethodNode)method).desc);
        }
        methods.clear();
        for (MethodNode method3 : block.methods) {
            Type type;
            Type[] args;
            if (!method3.desc.startsWith("(L" + iBlockState.name + ";L" + world.name + ";L" + blockPos.name + ";L") || !method3.desc.endsWith(";)L" + movingObjectPosition.name + ";") || (args = (type = Type.getMethodType((String)method3.desc)).getArgumentTypes()).length != 5 || args[3].getSort() != 10 || !args[3].getClassName().equals(args[4].getClassName())) continue;
            methods.add(method3);
        }
        if (methods.size() == 1) {
            method = (MethodNode)methods.get(0);
            String vec3_name = Type.getMethodType((String)((MethodNode)method).desc).getArgumentTypes()[3].getClassName();
            this.addClassMapping("net/minecraft/util/Vec3", vec3_name);
            this.addMethodMapping("net/minecraft/block/Block collisionRayTrace (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/Vec3;Lnet/minecraft/util/Vec3;)Lnet/minecraft/util/MovingObjectPosition;", block.name + " " + ((MethodNode)method).name + " " + ((MethodNode)method).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, "(I)L" + iBlockState.name + ";")).size() == 2) {
            for (Object method2 : methods) {
                if ((((MethodNode)method2).access & 8) == 0) {
                    this.addMethodMapping("net/minecraft/block/Block getStateFromMeta (I)Lnet/minecraft/block/state/IBlockState;", block.name + " " + ((MethodNode)method2).name + " " + ((MethodNode)method2).desc);
                    continue;
                }
                this.addMethodMapping("net/minecraft/block/Block getStateById (I)Lnet/minecraft/block/state/IBlockState;", block.name + " " + ((MethodNode)method2).name + " " + ((MethodNode)method2).desc);
            }
        }
        methods = this.getMatchingMethods(block, null, "(L" + iBlockState.name + ";)I");
        block6: for (Object method2 : methods) {
            void var22_25;
            AbstractInsnNode abstractInsnNode = ((MethodNode)method2).instructions.getFirst();
            while (var22_25 != null) {
                if (this.isLdcWithString((AbstractInsnNode)var22_25, "Don't know how to convert ")) {
                    this.addMethodMapping("net/minecraft/block/Block getMetaFromState (Lnet/minecraft/block/state/IBlockState;)I", block.name + " " + ((MethodNode)method2).name + " " + ((MethodNode)method2).desc);
                    break block6;
                }
                AbstractInsnNode abstractInsnNode2 = var22_25.getNext();
            }
        }
        if ((methods = this.getMatchingMethods(block, null, "(L" + iBlockState.name + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block setDefaultState (Lnet/minecraft/block/state/IBlockState;)V", block.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, "()L" + iBlockState.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getDefaultState ()Lnet/minecraft/block/state/IBlockState;", block.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
            List<FieldInsnNode> nodes = this.getAllInsnNodesOfType((MethodNode)methods.get(0), FieldInsnNode.class);
            if (nodes.size() == 1 && nodes.get((int)0).owner.equals(block.name) && nodes.get((int)0).desc.equals("L" + iBlockState.name + ";")) {
                this.addFieldMapping("net/minecraft/block/Block defaultBlockState Lnet/minecraft/block/state/IBlockState;", block.name + " " + nodes.get((int)0).name + " " + nodes.get((int)0).desc);
            }
        }
        if ((methods = this.getMatchingMethods(block, null, "(L" + iBlockState.name + ";L" + iBlockAccess.name + ";L" + blockPos.name + ";)L" + iBlockState.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getActualState (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;)Lnet/minecraft/block/state/IBlockState;", block.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        methods = this.getMatchingMethods(block, null, "(Ljava/lang/String;)L" + block.name + ";");
        if ((methods = this.removeMethodsWithFlags(methods, 8)).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block setUnlocalizedName (Ljava/lang/String;)Lnet/minecraft/block/Block;", block.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
            for (AbstractInsnNode insn5 = ((MethodNode)methods.get((int)0)).instructions.getFirst(); insn5 != null; insn5 = insn5.getNext()) {
                if (insn5.getOpcode() != 181) continue;
                FieldInsnNode fn = (FieldInsnNode)insn5;
                if (!fn.desc.equals("Ljava/lang/String;")) continue;
                this.addFieldMapping("net/minecraft/block/Block unlocalizedName Ljava/lang/String;", block.name + " " + fn.name + " " + fn.desc);
            }
        }
        methods = this.getMatchingMethods(block, null, "()Ljava/lang/String;");
        Iterator<Object> iterator = methods.iterator();
        while (iterator.hasNext()) {
            Object method2;
            method2 = (MethodNode)iterator.next();
            if (!((MethodNode)method2).name.equals("toString")) continue;
            iterator.remove();
        }
        if (methods.size() == 2) {
            for (Object method2 : methods) {
                void var22_29;
                AbstractInsnNode abstractInsnNode = ((MethodNode)method2).instructions.getFirst();
                while (var22_29 != null) {
                    if (this.isLdcWithString((AbstractInsnNode)var22_29, ".name")) {
                        this.addMethodMapping("net/minecraft/block/Block getLocalizedName ()Ljava/lang/String;", block.name + " " + ((MethodNode)method2).name + " " + ((MethodNode)method2).desc);
                    } else if (this.isLdcWithString((AbstractInsnNode)var22_29, "tile.")) {
                        this.addMethodMapping("net/minecraft/block/Block getUnlocalizedName ()Ljava/lang/String;", block.name + " " + ((MethodNode)method2).name + " " + ((MethodNode)method2).desc);
                    }
                    AbstractInsnNode abstractInsnNode3 = var22_29.getNext();
                }
            }
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, blockPos, entity, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block onEntityCollidedWithBlock (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/entity/Entity;)V", block.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, blockPos, enumFacing, "FFFI", entityLivingBase, ")", iBlockState))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block onBlockPlaced (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/EnumFacing;FFFILnet/minecraft/entity/EntityLivingBase;)Lnet/minecraft/block/state/IBlockState;", block.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, blockPos, entityPlayer, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block onBlockClicked (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/entity/player/EntityPlayer;)V", block.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        methods.clear();
        if (blockStateClass != null) {
            methods = this.getMatchingMethods(block, null, "()L" + blockStateClass + ";");
        }
        if (methods.size() == 2) {
            MethodNode createBlockState = null;
            block12: for (MethodNode methodNode : methods) {
                for (AbstractInsnNode insn6 = methodNode.instructions.getFirst(); insn6 != null; insn6 = insn6.getNext()) {
                    if (insn6.getOpcode() != 187) continue;
                    TypeInsnNode tn = (TypeInsnNode)insn6;
                    if (!tn.desc.equals(blockStateClass)) continue;
                    if (createBlockState != null) {
                        createBlockState = null;
                        break block12;
                    }
                    createBlockState = methodNode;
                    continue block12;
                }
            }
            if (createBlockState != null) {
                this.addMethodMapping("net/minecraft/block/Block createBlockState ()Lnet/minecraft/block/state/BlockState;", block.name + " " + createBlockState.name + " " + createBlockState.desc);
                methods.remove(createBlockState);
                this.addMethodMapping("net/minecraft/block/Block getBlockState ()Lnet/minecraft/block/state/BlockState;", block.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
            }
        }
        methods = this.getMatchingMethods(block, null, "()V");
        methods = this.removeMethodsWithoutFlags(methods, 8);
        Iterator<Object> it = methods.iterator();
        while (it.hasNext()) {
            if (!((MethodNode)it.next()).name.contains("<")) continue;
            it.remove();
        }
        String objectIntIdentityMap = null;
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block registerBlocks ()V", block.name + " " + ((MethodNode)methods.get((int)0)).name + " ()V");
            for (AbstractInsnNode insn7 = ((MethodNode)methods.get((int)0)).instructions.getFirst(); insn7 != null; insn7 = insn7.getNext()) {
                if (insn7.getOpcode() != 182) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)insn7;
                if (!methodInsnNode.desc.equals("(Ljava/lang/Object;I)V")) continue;
                objectIntIdentityMap = methodInsnNode.owner;
                this.addClassMapping("net/minecraft/util/ObjectIntIdentityMap", methodInsnNode.owner);
                this.addMethodMapping("net/minecraft/util/ObjectIntIdentityMap put (Ljava/lang/Object;I)V", methodInsnNode.owner + " " + methodInsnNode.name + " " + methodInsnNode.desc);
            }
            List<FieldInsnNode> fieldNodes = this.getAllInsnNodesOfType((MethodNode)methods.get(0), FieldInsnNode.class);
            ArrayList<FieldInsnNode> arrayList = new ArrayList<FieldInsnNode>();
            ArrayList<FieldInsnNode> fieldPuts = new ArrayList<FieldInsnNode>();
            Iterator<FieldInsnNode> it2 = fieldNodes.iterator();
            while (it2.hasNext()) {
                FieldInsnNode fn = it2.next();
                if (fn.owner.equals(block.name) && fn.desc.equals("Z")) {
                    if (fn.getOpcode() == 180) {
                        arrayList.add(fn);
                        continue;
                    }
                    if (fn.getOpcode() != 181) continue;
                    fieldPuts.add(fn);
                    continue;
                }
                it2.remove();
            }
            if (arrayList.size() == 1 && fieldPuts.size() == 2 && ((FieldInsnNode)fieldPuts.get((int)0)).name.equals(((FieldInsnNode)fieldPuts.get((int)1)).name)) {
                this.addFieldMapping("net/minecraft/block/Block translucent Z", block.name + " " + ((FieldInsnNode)arrayList.get((int)0)).name + " Z");
                this.addFieldMapping("net/minecraft/block/Block useNeighborBrightness Z", block.name + " " + ((FieldInsnNode)fieldPuts.get((int)0)).name + " Z");
            }
        }
        if ((fields = this.getMatchingFields(block, null, "L" + objectIntIdentityMap + ";")).size() == 1) {
            this.addFieldMapping("net/minecraft/block/Block BLOCK_STATE_IDS Lnet/minecraft/util/ObjectIntIdentityMap;", block.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/item/ItemBlock", "net/minecraft/util/AxisAlignedBB"}, providesFields={"net/minecraft/block/Block blockState Lnet/minecraft/block/state/BlockState;", "net/minecraft/block/Block displayOnCreativeTab Lnet/minecraft/creativetab/CreativeTabs;", "net/minecraft/entity/Entity motionY D"}, providesMethods={"net/minecraft/block/Block getStateId (Lnet/minecraft/block/state/IBlockState;)I", "net/minecraft/block/Block getBlockById (I)Lnet/minecraft/block/Block;", "net/minecraft/block/Block getBlockFromItem (Lnet/minecraft/item/Item;)Lnet/minecraft/block/Block;", "net/minecraft/block/Block getBlockFromName (Ljava/lang/String;)Lnet/minecraft/block/Block;", "net/minecraft/block/Block onNeighborBlockChange (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/Block;)V", "net/minecraft/block/Block setCreativeTab (Lnet/minecraft/creativetab/CreativeTabs;)Lnet/minecraft/block/Block;", "net/minecraft/block/Block dropBlockAsItemWithChance (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;FI)V", "net/minecraft/block/Block dropBlockAsItem (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;I)V", "net/minecraft/block/Block harvestBlock (Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/tileentity/TileEntity;Lnet/minecraft/item/ItemStack;)V", "net/minecraft/block/Block onFallenUpon (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/entity/Entity;F)V", "net/minecraft/entity/Entity fall (FF)V", "net/minecraft/block/Block onLanded (Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;)V", "net/minecraft/block/Block damageDropped (Lnet/minecraft/block/state/IBlockState;)I", "net/minecraft/block/Block isBlockSolid (Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/EnumFacing;)Z"}, depends={"net/minecraft/block/Block", "net/minecraft/item/Item", "net/minecraft/block/state/IBlockState", "net/minecraft/block/state/BlockState", "net/minecraft/util/BlockPos", "net/minecraft/world/World", "net/minecraft/world/IBlockAccess", "net/minecraft/creativetab/CreativeTabs", "net/minecraft/entity/player/EntityPlayer", "net/minecraft/tileentity/TileEntity", "net/minecraft/item/ItemStack", "net/minecraft/entity/Entity", "net/minecraft/util/EnumFacing"})
    public boolean processBlockClass2() {
        List<FieldInsnNode> nodes;
        FieldNode fn;
        ClassNode enumFacing;
        ClassNode entity;
        ClassNode itemStack;
        ClassNode tileEntity;
        ClassNode entityPlayer;
        ClassNode creativeTabs;
        ClassNode iBlockAccess;
        ClassNode world;
        ClassNode blockPos;
        ClassNode blockState;
        ClassNode iBlockState;
        ClassNode item;
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        if (!MeddleUtil.notNull((Object[])new Object[]{block, item = this.getClassNodeFromMapping("net/minecraft/item/Item"), iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState"), blockState = this.getClassNodeFromMapping("net/minecraft/block/state/BlockState"), blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos"), world = this.getClassNodeFromMapping("net/minecraft/world/World"), iBlockAccess = this.getClassNodeFromMapping("net/minecraft/world/IBlockAccess"), creativeTabs = this.getClassNodeFromMapping("net/minecraft/creativetab/CreativeTabs"), entityPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayer"), tileEntity = this.getClassNodeFromMapping("net/minecraft/tileentity/TileEntity"), itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack"), entity = this.getClassNodeFromMapping("net/minecraft/entity/Entity"), enumFacing = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing")})) {
            return false;
        }
        String axisAlignedBB_name = null;
        List<FieldNode> fields = this.getMatchingFields(block, null, null);
        Iterator<FieldNode> it = fields.iterator();
        while (it.hasNext()) {
            fn = it.next();
            if (!fn.desc.startsWith("L")) {
                it.remove();
                continue;
            }
            Type t = Type.getType((String)fn.desc);
            if (axisAlignedBB_name == null && this.searchConstantPoolForStrings(t.getClassName(), "box[")) {
                ClassNode cn = this.getClassNode(t.getClassName());
                int doubles = 0;
                for (FieldNode cnfn : cn.fields) {
                    if (!cnfn.desc.equals("D")) continue;
                    ++doubles;
                }
                if (cn.fields.size() == 6 && doubles == 6) {
                    axisAlignedBB_name = t.getClassName();
                    this.addClassMapping("net/minecraft/util/AxisAlignedBB", axisAlignedBB_name);
                }
            }
            if (axisAlignedBB_name != null && t.getClassName().equals(axisAlignedBB_name)) continue;
            it.remove();
        }
        if (fields.size() == 1) {
            this.addFieldMapping("net/minecraft/block/Block blockBounds Lnet/minecraft/util/AxisAlignedBB;", block.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        if ((fields = this.getMatchingFields(block, null, "L" + blockState.name + ";")).size() == 1) {
            this.addFieldMapping("net/minecraft/block/Block blockState Lnet/minecraft/block/state/BlockState;", block.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        List<MethodNode> methods = this.getMatchingMethods(block, null, "(L" + iBlockState.name + ";)I");
        if ((methods = this.removeMethodsWithoutFlags(methods, 8)).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getStateId (Lnet/minecraft/block/state/IBlockState;)I", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        methods = this.getMatchingMethods(block, null, "(I)L" + block.name + ";");
        if ((methods = this.removeMethodsWithoutFlags(methods, 8)).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getBlockById (I)Lnet/minecraft/block/Block;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        methods = this.getMatchingMethods(block, null, "(L" + item.name + ";)L" + block.name + ";");
        if ((methods = this.removeMethodsWithoutFlags(methods, 8)).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getBlockFromItem (Lnet/minecraft/item/Item;)Lnet/minecraft/block/Block;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 193) continue;
                TypeInsnNode tn = (TypeInsnNode)insn;
                if (!this.searchConstantPoolForStrings(tn.desc, "BlockEntityTag")) continue;
                this.addClassMapping("net/minecraft/item/ItemBlock", tn.desc);
                break;
            }
        }
        methods = this.getMatchingMethods(block, null, "(Ljava/lang/String;)L" + block.name + ";");
        if ((methods = this.removeMethodsWithoutFlags(methods, 8)).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getBlockFromName (Ljava/lang/String;)Lnet/minecraft/block/Block;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, "(L" + axisAlignedBB_name + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block setBlockBounds (Lnet/minecraft/util/AxisAlignedBB;)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, "(L" + iBlockState.name + ";)L" + axisAlignedBB_name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getBlockBounds (Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/util/AxisAlignedBB;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, blockPos, iBlockState, block, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block onNeighborBlockChange (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/Block;)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", iBlockAccess, blockPos, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block setBlockBoundsBasedOnState (Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", creativeTabs, ")", block))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block setCreativeTab (Lnet/minecraft/creativetab/CreativeTabs;)Lnet/minecraft/block/Block;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            nodes = this.getAllInsnNodesOfType(methods.get(0), FieldInsnNode.class);
            if (nodes.size() == 1 && nodes.get((int)0).owner.equals(block.name) && nodes.get((int)0).desc.equals("L" + creativeTabs.name + ";")) {
                this.addFieldMapping("net/minecraft/block/Block displayOnCreativeTab Lnet/minecraft/creativetab/CreativeTabs;", block.name + " " + nodes.get((int)0).name + " " + nodes.get((int)0).desc);
            }
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, blockPos, iBlockState, "I)V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block dropBlockAsItem (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;I)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, blockPos, iBlockState, "FI)V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block dropBlockAsItemWithChance (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;FI)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            nodes = this.getAllInsnNodesOfType(methods.get(0), MethodInsnNode.class);
            Iterator<FieldInsnNode> it2 = nodes.iterator();
            while (it2.hasNext()) {
                MethodInsnNode mn = (MethodInsnNode)it2.next();
                if (mn.owner.equals(block.name) && mn.desc.equals("(L" + iBlockState.name + ";)I")) continue;
                it2.remove();
            }
            if (nodes.size() == 1) {
                this.addMethodMapping("net/minecraft/block/Block damageDropped (Lnet/minecraft/block/state/IBlockState;)I", block.name + " " + ((MethodInsnNode)nodes.get((int)0)).name + " " + ((MethodInsnNode)nodes.get((int)0)).desc);
            }
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, entityPlayer, blockPos, iBlockState, tileEntity, itemStack, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block harvestBlock (Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/tileentity/TileEntity;Lnet/minecraft/item/ItemStack;)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, blockPos, entity, "F)V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block onFallenUpon (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/entity/Entity;F)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            nodes = this.getAllInsnNodesOfType(methods.get(0), MethodInsnNode.class);
            if (nodes.size() == 1) {
                MethodInsnNode mn = (MethodInsnNode)nodes.get(0);
                if (mn.owner.equals(entity.name) && mn.desc.equals("(FF)V")) {
                    this.addMethodMapping("net/minecraft/entity/Entity fall (FF)V", entity.name + " " + mn.name + " " + mn.desc);
                }
            }
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, entity, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block onLanded (Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            nodes = this.getAllInsnNodesOfType(methods.get(0), FieldInsnNode.class);
            if (nodes.size() == 1) {
                fn = nodes.get(0);
                if (fn.owner.equals(entity.name) && fn.desc.equals("D")) {
                    this.addFieldMapping("net/minecraft/entity/Entity motionY D", entity.name + " " + fn.name + " " + fn.desc);
                }
            }
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", iBlockAccess, blockPos, enumFacing, ")Z"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block isBlockSolid (Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/EnumFacing;)Z", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/block/EnumBlockRotation", "net/minecraft/block/EnumBlockMirroring"}, providesFields={"net/minecraft/block/Block blockMaterial Lnet/minecraft/block/material/Material;", "net/minecraft/block/Block mapColor Lnet/minecraft/block/material/MapColor;", "net/minecraft/block/Block lightOpacity I", "net/minecraft/block/Block lightValue I", "net/minecraft/block/Block blockResistance F", "net/minecraft/block/Block stepSound Lnet/minecraft/block/BlockSoundType;"}, providesMethods={"net/minecraft/block/Block getMaterial (Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/block/material/Material;", "net/minecraft/block/Block getMapColor (Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/block/material/MapColor;", "net/minecraft/block/Block getStateFromRotation (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/EnumBlockRotation;)Lnet/minecraft/block/state/IBlockState;", "net/minecraft/block/Block getStateFromMirroring (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/EnumBlockMirroring;)Lnet/minecraft/block/state/IBlockState;", "net/minecraft/block/Block setLightOpacity (I)Lnet/minecraft/block/Block;", "net/minecraft/block/Block setLightLevel (F)Lnet/minecraft/block/Block;", "net/minecraft/block/Block setResistance (F)Lnet/minecraft/block/Block;", "net/minecraft/block/Block getStepSound ()Lnet/minecraft/block/BlockSoundType;", "net/minecraft/block/Block getComparatorInputOverride (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)I", "net/minecraft/block/Block isEqualTo (Lnet/minecraft/block/Block;Lnet/minecraft/block/Block;)Z", "net/minecraft/block/Block isAssociatedBlock (Lnet/minecraft/block/Block;)Z", "net/minecraft/block/Block canDropFromExplosion (Lnet/minecraft/world/Explosion;)Z", "net/minecraft/block/Block fillWithRain (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)V", "net/minecraft/block/Block onBlockHarvested (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/player/EntityPlayer;)V", "net/minecraft/block/Block onBlockPlacedBy (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;)V", "net/minecraft/block/Block quantityDroppedWithBonus (ILjava/util/Random;)I", "net/minecraft/block/Block quantityDropped (Ljava/util/Random;)I", "net/minecraft/block/Block createStackedBlock (Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/item/ItemStack;", "net/minecraft/item/Item getHasSubtypes ()Z", "net/minecraft/block/Block modifyAcceleration (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/Vec3;)Lnet/minecraft/util/Vec3;", "net/minecraft/block/Block canReplace (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/EnumFacing;Lnet/minecraft/item/ItemStack;)Z", "net/minecraft/block/Block canPlaceBlockOnSide (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/EnumFacing;)Z", "net/minecraft/block/Block canPlaceBlockAt (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)Z", "net/minecraft/block/Block onBlockDestroyedByExplosion (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/world/Explosion;)V", "net/minecraft/block/Block getExplosionResistance (Lnet/minecraft/entity/Entity;)F", "net/minecraft/block/Block dropXpOnBlockBreak (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;I)V", "net/minecraft/block/Block getPlayerRelativeBlockHardness (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)F", "net/minecraft/entity/player/EntityPlayer canHarvestBlock (Lnet/minecraft/block/state/IBlockState;)Z", "net/minecraft/entity/player/EntityPlayer getToolDigEfficiency (Lnet/minecraft/block/state/IBlockState;)F", "net/minecraft/block/Block getItemDropped (Lnet/minecraft/block/state/IBlockState;Ljava/util/Random;I)Lnet/minecraft/item/Item;", "net/minecraft/block/Block randomTick (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Ljava/util/Random;)V", "net/minecraft/block/Block updateTick (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Ljava/util/Random;)V", "net/minecraft/block/Block addCollisionBoxesToList (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/AxisAlignedBB;Ljava/util/List;Lnet/minecraft/entity/Entity;)V", "net/minecraft/block/state/IBlockWrapper getCollisionBoundingBox (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)Lnet/minecraft/util/AxisAlignedBB;", "net/minecraft/block/Block addCollisionBoxToList (Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/AxisAlignedBB;Ljava/util/List;Lnet/minecraft/util/AxisAlignedBB;)V"}, depends={"net/minecraft/block/Block", "net/minecraft/item/Item", "net/minecraft/block/state/IBlockState", "net/minecraft/block/state/BlockState", "net/minecraft/util/BlockPos", "net/minecraft/world/World", "net/minecraft/world/IBlockAccess", "net/minecraft/creativetab/CreativeTabs", "net/minecraft/entity/player/EntityPlayer", "net/minecraft/tileentity/TileEntity", "net/minecraft/item/ItemStack", "net/minecraft/block/material/Material", "net/minecraft/block/material/MapColor", "net/minecraft/block/BlockSoundType", "net/minecraft/entity/EntityLivingBase", "net/minecraft/util/EnumFacing", "net/minecraft/entity/Entity", "net/minecraft/util/Vec3", "net/minecraft/util/AxisAlignedBB", "net/minecraft/block/state/IBlockWrapper"})
    public boolean processBlockClass3() {
        List<FieldInsnNode> nodes;
        ClassNode iBlockWrapper;
        ClassNode aabb;
        ClassNode vec3;
        ClassNode entity;
        ClassNode enumFacing;
        ClassNode entityLivingBase;
        ClassNode explosion;
        ClassNode blockSoundType;
        ClassNode mapColor;
        ClassNode material;
        ClassNode itemStack;
        ClassNode tileEntity;
        ClassNode entityPlayer;
        ClassNode creativeTabs;
        ClassNode iBlockAccess;
        ClassNode world;
        ClassNode blockPos;
        ClassNode blockState;
        ClassNode iBlockState;
        ClassNode item;
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        if (!MeddleUtil.notNull((Object[])new Object[]{block, item = this.getClassNodeFromMapping("net/minecraft/item/Item"), iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState"), blockState = this.getClassNodeFromMapping("net/minecraft/block/state/BlockState"), blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos"), world = this.getClassNodeFromMapping("net/minecraft/world/World"), iBlockAccess = this.getClassNodeFromMapping("net/minecraft/world/IBlockAccess"), creativeTabs = this.getClassNodeFromMapping("net/minecraft/creativetab/CreativeTabs"), entityPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayer"), tileEntity = this.getClassNodeFromMapping("net/minecraft/tileentity/TileEntity"), itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack"), material = this.getClassNodeFromMapping("net/minecraft/block/material/Material"), mapColor = this.getClassNodeFromMapping("net/minecraft/block/material/MapColor"), blockSoundType = this.getClassNodeFromMapping("net/minecraft/block/BlockSoundType"), explosion = this.getClassNodeFromMapping("net/minecraft/world/Explosion"), entityLivingBase = this.getClassNodeFromMapping("net/minecraft/entity/EntityLivingBase"), enumFacing = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing"), entity = this.getClassNodeFromMapping("net/minecraft/entity/Entity"), vec3 = this.getClassNodeFromMapping("net/minecraft/util/Vec3"), aabb = this.getClassNodeFromMapping("net/minecraft/util/AxisAlignedBB"), iBlockWrapper = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockWrapper")})) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", iBlockState, ")", material));
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getMaterial (Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/block/material/Material;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            nodes = this.getAllInsnNodesOfType(methods.get(0), FieldInsnNode.class);
            if (nodes.size() == 1 && ((FieldInsnNode)nodes.get((int)0)).owner.equals(block.name) && ((FieldInsnNode)nodes.get((int)0)).desc.equals("L" + material.name + ";")) {
                this.addFieldMapping("net/minecraft/block/Block blockMaterial Lnet/minecraft/block/material/Material;", block.name + " " + ((FieldInsnNode)nodes.get((int)0)).name + " " + ((FieldInsnNode)nodes.get((int)0)).desc);
            }
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", iBlockState, ")", mapColor))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getMapColor (Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/block/material/MapColor;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            nodes = this.getAllInsnNodesOfType(methods.get(0), FieldInsnNode.class);
            if (nodes.size() == 1 && ((FieldInsnNode)nodes.get((int)0)).owner.equals(block.name) && ((FieldInsnNode)nodes.get((int)0)).desc.equals("L" + mapColor.name + ";")) {
                this.addFieldMapping("net/minecraft/block/Block mapColor Lnet/minecraft/block/material/MapColor;", block.name + " " + nodes.get((int)0).name + " " + nodes.get((int)0).desc);
            }
        }
        methods.clear();
        for (MethodNode method : block.methods) {
            if (!method.desc.startsWith("(L" + iBlockState.name + ";L") || !method.desc.endsWith(";)L" + iBlockState.name + ";") || Type.getMethodType((String)method.desc).getArgumentTypes().length != 2) continue;
            methods.add(method);
        }
        if (methods.size() == 2 && !methods.get((int)0).desc.equals(methods.get((int)1).desc)) {
            for (MethodNode method : methods) {
                String className = Type.getMethodType((String)method.desc).getArgumentTypes()[1].getClassName();
                if (this.searchConstantPoolForStrings(className, "rotate_0", "rotate_90")) {
                    this.addClassMapping("net/minecraft/block/EnumBlockRotation", className);
                    this.addMethodMapping("net/minecraft/block/Block getStateFromRotation (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/EnumBlockRotation;)Lnet/minecraft/block/state/IBlockState;", block.name + " " + method.name + " " + method.desc);
                    continue;
                }
                if (!this.searchConstantPoolForStrings(className, "no_mirror", "mirror_left_right")) continue;
                this.addClassMapping("net/minecraft/block/EnumBlockMirroring", className);
                this.addMethodMapping("net/minecraft/block/Block getStateFromMirroring (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/EnumBlockMirroring;)Lnet/minecraft/block/state/IBlockState;", block.name + " " + method.name + " " + method.desc);
            }
        }
        methods = this.getMatchingMethods(block, null, "(I)L" + block.name + ";");
        if ((methods = this.removeMethodsWithFlags(methods, 8)).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block setLightOpacity (I)Lnet/minecraft/block/Block;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            nodes = this.getAllInsnNodesOfType(methods.get(0), FieldInsnNode.class);
            if (nodes.size() == 1 && nodes.get((int)0).owner.equals(block.name) && nodes.get((int)0).desc.equals("I")) {
                this.addFieldMapping("net/minecraft/block/Block lightOpacity I", block.name + " " + nodes.get((int)0).name + " " + nodes.get((int)0).desc);
            }
        }
        methods = this.getMatchingMethods(block, null, "(F)L" + block.name + ";");
        int setLightLevel_num = -1;
        int setResistance_num = -1;
        for (int n = 0; n < methods.size(); ++n) {
            MethodNode method = methods.get(n);
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (this.isLdcWithFloat(insn, 15.0f)) {
                    if (setLightLevel_num == -1) {
                        setLightLevel_num = n;
                        continue;
                    }
                    setLightLevel_num = -2;
                    continue;
                }
                if (!this.isLdcWithFloat(insn, 3.0f)) continue;
                setResistance_num = setResistance_num == -1 ? n : -2;
            }
        }
        if (setLightLevel_num >= 0) {
            this.addMethodMapping("net/minecraft/block/Block setLightLevel (F)Lnet/minecraft/block/Block;", block.name + " " + methods.get((int)setLightLevel_num).name + " " + methods.get((int)setLightLevel_num).desc);
            List<FieldInsnNode> nodes2 = this.getAllInsnNodesOfType(methods.get(setLightLevel_num), FieldInsnNode.class);
            if (nodes2.size() == 1 && nodes2.get((int)0).owner.equals(block.name) && nodes2.get((int)0).desc.equals("I")) {
                this.addFieldMapping("net/minecraft/block/Block lightValue I", block.name + " " + nodes2.get((int)0).name + " " + nodes2.get((int)0).desc);
            }
        }
        if (setResistance_num >= 0) {
            this.addMethodMapping("net/minecraft/block/Block setResistance (F)Lnet/minecraft/block/Block;", block.name + " " + methods.get((int)setResistance_num).name + " " + methods.get((int)setResistance_num).desc);
            List<FieldInsnNode> nodes3 = this.getAllInsnNodesOfType(methods.get(setResistance_num), FieldInsnNode.class);
            if (nodes3.size() == 1 && nodes3.get((int)0).owner.equals(block.name) && nodes3.get((int)0).desc.equals("F")) {
                this.addFieldMapping("net/minecraft/block/Block blockResistance F", block.name + " " + nodes3.get((int)0).name + " " + nodes3.get((int)0).desc);
            }
        }
        if ((methods = this.getMatchingMethods(block, null, "()L" + blockSoundType.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getStepSound ()Lnet/minecraft/block/BlockSoundType;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            List<FieldInsnNode> nodes4 = this.getAllInsnNodesOfType(methods.get(0), FieldInsnNode.class);
            if (nodes4.size() == 1 && nodes4.get((int)0).owner.equals(block.name) && nodes4.get((int)0).desc.equals("L" + blockSoundType.name + ";")) {
                this.addFieldMapping("net/minecraft/block/Block stepSound Lnet/minecraft/block/BlockSoundType;", block.name + " " + nodes4.get((int)0).name + " " + nodes4.get((int)0).desc);
            }
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", iBlockState, world, blockPos, ")I"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getComparatorInputOverride (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)I", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", block, block, ")Z"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block isEqualTo (Lnet/minecraft/block/Block;Lnet/minecraft/block/Block;)Z", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", block, ")Z"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block isAssociatedBlock (Lnet/minecraft/block/Block;)Z", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", explosion, ")Z"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block canDropFromExplosion (Lnet/minecraft/world/Explosion;)Z", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, blockPos, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block fillWithRain (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, blockPos, iBlockState, entityPlayer, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block onBlockHarvested (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/player/EntityPlayer;)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, blockPos, iBlockState, entityLivingBase, itemStack, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block onBlockPlacedBy (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, "(ILjava/util/Random;)I")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block quantityDroppedWithBonus (ILjava/util/Random;)I", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            List<MethodInsnNode> nodes5 = this.getAllInsnNodesOfType(methods.get(0), MethodInsnNode.class);
            if (nodes5.size() == 1 && nodes5.get((int)0).owner.equals(block.name) && nodes5.get((int)0).desc.equals("(Ljava/util/Random;)I")) {
                this.addMethodMapping("net/minecraft/block/Block quantityDropped (Ljava/util/Random;)I", block.name + " " + nodes5.get((int)0).name + " " + nodes5.get((int)0).desc);
            }
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", iBlockState, ")", itemStack))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block createStackedBlock (Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/item/ItemStack;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            List<MethodInsnNode> nodes6 = this.getAllInsnNodesOfType(methods.get(0), MethodInsnNode.class);
            Iterator<MethodInsnNode> it = nodes6.iterator();
            while (it.hasNext()) {
                MethodInsnNode mn = it.next();
                if (mn.owner.equals(item.name) && mn.desc.equals("()Z")) continue;
                it.remove();
            }
            if (nodes6.size() == 1) {
                this.addMethodMapping("net/minecraft/item/Item getHasSubtypes ()Z", item.name + " " + nodes6.get((int)0).name + " ()Z");
            }
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, blockPos, entity, vec3, ")", vec3))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block modifyAcceleration (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/Vec3;)Lnet/minecraft/util/Vec3;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, blockPos, enumFacing, itemStack, ")Z"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block canReplace (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/EnumFacing;Lnet/minecraft/item/ItemStack;)Z", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, blockPos, enumFacing, ")Z"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block canPlaceBlockOnSide (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/EnumFacing;)Z", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            List<MethodInsnNode> nodes7 = this.getAllInsnNodesOfType(methods.get(0), MethodInsnNode.class);
            if (nodes7.size() == 1 && nodes7.get((int)0).owner.equals(block.name) && nodes7.get((int)0).desc.equals(this.assembleDescriptor("(", world, blockPos, ")Z"))) {
                this.addMethodMapping("net/minecraft/block/Block canPlaceBlockAt (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)Z", block.name + " " + nodes7.get((int)0).name + " " + nodes7.get((int)0).desc);
            }
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, blockPos, explosion, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block onBlockDestroyedByExplosion (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/world/Explosion;)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", entity, ")F"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getExplosionResistance (Lnet/minecraft/entity/Entity;)F", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, blockPos, "I)V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block dropXpOnBlockBreak (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;I)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", iBlockState, entityPlayer, world, blockPos, ")F"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getPlayerRelativeBlockHardness (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)F", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            List<MethodInsnNode> nodes8 = this.getAllInsnNodesOfType(methods.get(0), MethodInsnNode.class);
            ArrayList getBlockHardness = new ArrayList();
            ArrayList<MethodInsnNode> canHarvestBlock = new ArrayList<MethodInsnNode>();
            ArrayList<MethodInsnNode> getToolDigEfficiency = new ArrayList<MethodInsnNode>();
            for (MethodInsnNode mn : nodes8) {
                if (!mn.owner.equals(entityPlayer.name)) continue;
                if (mn.desc.equals(this.assembleDescriptor("(", iBlockState, ")Z"))) {
                    canHarvestBlock.add(mn);
                    continue;
                }
                if (!mn.desc.equals(this.assembleDescriptor("(", iBlockState, ")F"))) continue;
                getToolDigEfficiency.add(mn);
            }
            if (canHarvestBlock.size() == 1) {
                this.addMethodMapping("net/minecraft/entity/player/EntityPlayer canHarvestBlock (Lnet/minecraft/block/state/IBlockState;)Z", entityPlayer.name + " " + ((MethodInsnNode)canHarvestBlock.get((int)0)).name + " " + ((MethodInsnNode)canHarvestBlock.get((int)0)).desc);
            }
            if (getToolDigEfficiency.size() == 2 && ((MethodInsnNode)getToolDigEfficiency.get((int)0)).name.equals(((MethodInsnNode)getToolDigEfficiency.get((int)1)).name)) {
                this.addMethodMapping("net/minecraft/entity/player/EntityPlayer getToolDigEfficiency (Lnet/minecraft/block/state/IBlockState;)F", entityPlayer.name + " " + ((MethodInsnNode)getToolDigEfficiency.get((int)0)).name + " " + ((MethodInsnNode)getToolDigEfficiency.get((int)0)).desc);
            }
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", iBlockState, "Ljava/util/Random;I)", item))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getItemDropped (Lnet/minecraft/block/state/IBlockState;Ljava/util/Random;I)Lnet/minecraft/item/Item;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", world, blockPos, iBlockState, "Ljava/util/Random;)V"))).size() == 2) {
            List<MethodInsnNode> nodes9;
            Iterator<MethodNode> it = methods.iterator();
            while (it.hasNext()) {
                if (this.getNextRealOpcode(it.next().instructions.getFirst()).getOpcode() != 177) continue;
                it.remove();
            }
            if (methods.size() == 1 && (nodes9 = this.getAllInsnNodesOfType(methods.get(0), MethodInsnNode.class)).size() == 1 && nodes9.get((int)0).owner.equals(block.name) && !nodes9.get((int)0).name.equals(methods.get((int)0).name) && nodes9.get((int)0).desc.equals(methods.get((int)0).desc)) {
                this.addMethodMapping("net/minecraft/block/Block randomTick (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Ljava/util/Random;)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
                this.addMethodMapping("net/minecraft/block/Block updateTick (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Ljava/util/Random;)V", block.name + " " + nodes9.get((int)0).name + " " + nodes9.get((int)0).desc);
            }
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", iBlockState, world, blockPos, aabb, "Ljava/util/List;", entity, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block addCollisionBoxesToList (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/AxisAlignedBB;Ljava/util/List;Lnet/minecraft/entity/Entity;)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            List<MethodInsnNode> nodes10 = this.getAllInsnNodesOfType(methods.get(0), MethodInsnNode.class);
            ArrayList<MethodInsnNode> getCollisionBoundingBox = new ArrayList<MethodInsnNode>();
            ArrayList<MethodInsnNode> addCollisionBoxToList = new ArrayList<MethodInsnNode>();
            for (MethodInsnNode mn : nodes10) {
                if (mn.owner.equals(block.name)) {
                    if (!mn.desc.equals(this.assembleDescriptor("(", blockPos, aabb, "Ljava/util/List;", aabb, ")V"))) continue;
                    addCollisionBoxToList.add(mn);
                    continue;
                }
                if (!mn.owner.equals(iBlockState.name) || !mn.desc.equals(this.assembleDescriptor("(", world, blockPos, ")", aabb))) continue;
                getCollisionBoundingBox.add(mn);
            }
            if (getCollisionBoundingBox.size() == 1) {
                this.addMethodMapping("net/minecraft/block/state/IBlockWrapper getCollisionBoundingBox (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)Lnet/minecraft/util/AxisAlignedBB;", iBlockWrapper.name + " " + ((MethodInsnNode)getCollisionBoundingBox.get((int)0)).name + " " + ((MethodInsnNode)getCollisionBoundingBox.get((int)0)).desc);
            }
            if (addCollisionBoxToList.size() == 1) {
                this.addMethodMapping("net/minecraft/block/Block addCollisionBoxToList (Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/AxisAlignedBB;Ljava/util/List;Lnet/minecraft/util/AxisAlignedBB;)V", block.name + " " + ((MethodInsnNode)addCollisionBoxToList.get((int)0)).name + " " + ((MethodInsnNode)addCollisionBoxToList.get((int)0)).desc);
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/block/properties/IProperty"}, providesMethods={"net/minecraft/block/state/BlockState getPropertyValue (Lnet/minecraft/block/Block;Lnet/minecraft/block/properties/IProperty;)Ljava/lang/String;", "net/minecraft/block/state/BlockState getValidStates ()Lcom/google/common/collect/ImmutableList;", "net/minecraft/block/state/BlockState getAllowedValues ()Ljava/util/List;", "net/minecraft/block/state/BlockState getBaseState ()Lnet/minecraft/block/state/IBlockState;", "net/minecraft/block/state/BlockState getBlock ()Lnet/minecraft/block/Block;", "net/minecraft/block/state/BlockState getProperties ()Ljava/util/Collection;"}, depends={"net/minecraft/block/state/BlockState", "net/minecraft/block/Block", "net/minecraft/block/state/IBlockState"})
    public boolean processBlockStateClass() {
        ClassNode block;
        ClassNode iBlockState;
        ClassNode blockState = this.getClassNodeFromMapping("net/minecraft/block/state/BlockState");
        if (!MeddleUtil.notNull((Object[])new Object[]{blockState, iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState"), block = this.getClassNodeFromMapping("net/minecraft/block/Block")})) {
            return false;
        }
        List<Object> methods = new ArrayList();
        String iProperty = null;
        for (MethodNode method : blockState.methods) {
            Type t;
            if (!method.name.equals("<init>") || !method.desc.startsWith("(L" + block.name + ";[L") || (t = Type.getMethodType((String)method.desc)).getArgumentTypes().length != 2 || t.getArgumentTypes()[1].getSort() != 9) continue;
            iProperty = t.getArgumentTypes()[1].getElementType().getClassName();
        }
        if (iProperty != null) {
            this.addClassMapping("net/minecraft/block/properties/IProperty", iProperty);
        }
        if ((methods = this.getMatchingMethods(blockState, null, "(L" + block.name + ";L" + iProperty + ";)Ljava/lang/String;")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/state/BlockState getPropertyValue (Lnet/minecraft/block/Block;Lnet/minecraft/block/properties/IProperty;)Ljava/lang/String;", blockState.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        if ((methods = this.getMatchingMethods(blockState, null, "()Lcom/google/common/collect/ImmutableList;")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/state/BlockState getValidStates ()Lcom/google/common/collect/ImmutableList;", blockState.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        if ((methods = this.getMatchingMethods(blockState, null, "()Ljava/util/List;")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/state/BlockState getAllowedValues ()Ljava/util/List;", blockState.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        if ((methods = this.getMatchingMethods(blockState, null, "()L" + iBlockState.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/state/BlockState getBaseState ()Lnet/minecraft/block/state/IBlockState;", blockState.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        if ((methods = this.getMatchingMethods(blockState, null, "()L" + block.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/state/BlockState getBlock ()Lnet/minecraft/block/Block;", blockState.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        if ((methods = this.getMatchingMethods(blockState, null, "()Ljava/util/Collection;")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/state/BlockState getProperties ()Ljava/util/Collection;", blockState.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/creativetab/CreativeTabs tabBlock Lnet/minecraft/creativetab/CreativeTabs;", "net/minecraft/creativetab/CreativeTabs tabDecorations Lnet/minecraft/creativetab/CreativeTabs;", "net/minecraft/creativetab/CreativeTabs tabRedstone Lnet/minecraft/creativetab/CreativeTabs;", "net/minecraft/creativetab/CreativeTabs tabTransport Lnet/minecraft/creativetab/CreativeTabs;", "net/minecraft/creativetab/CreativeTabs tabMisc Lnet/minecraft/creativetab/CreativeTabs;", "net/minecraft/creativetab/CreativeTabs tabAllSearch Lnet/minecraft/creativetab/CreativeTabs;", "net/minecraft/creativetab/CreativeTabs tabFood Lnet/minecraft/creativetab/CreativeTabs;", "net/minecraft/creativetab/CreativeTabs tabTools Lnet/minecraft/creativetab/CreativeTabs;", "net/minecraft/creativetab/CreativeTabs tabCombat Lnet/minecraft/creativetab/CreativeTabs;", "net/minecraft/creativetab/CreativeTabs tabBrewing Lnet/minecraft/creativetab/CreativeTabs;", "net/minecraft/creativetab/CreativeTabs tabMaterials Lnet/minecraft/creativetab/CreativeTabs;", "net/minecraft/creativetab/CreativeTabs tabInventory Lnet/minecraft/creativetab/CreativeTabs;"}, depends={"net/minecraft/creativetab/CreativeTabs"})
    public boolean getCreativeTabs() {
        ClassNode creativeTabs = this.getClassNodeFromMapping("net/minecraft/creativetab/CreativeTabs");
        if (creativeTabs == null) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(creativeTabs, "<clinit>", "()V");
        if (methods.size() != 1) {
            return false;
        }
        HashMap<String, String> tabMap = new HashMap<String, String>();
        String name = null;
        for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (name == null) {
                name = this.getLdcString(insn);
                continue;
            }
            if (insn.getOpcode() != 179) continue;
            FieldInsnNode fn = (FieldInsnNode)insn;
            if (!fn.desc.equals("L" + creativeTabs.name + ";")) continue;
            tabMap.put(name, fn.name);
            name = null;
        }
        HashMap<String, String> tabToFieldMap = new HashMap<String, String>(){
            {
                this.put("buildingBlocks", "tabBlock");
                this.put("decorations", "tabDecorations");
                this.put("redstone", "tabRedstone");
                this.put("transportation", "tabTransport");
                this.put("misc", "tabMisc");
                this.put("search", "tabAllSearch");
                this.put("food", "tabFood");
                this.put("tools", "tabTools");
                this.put("combat", "tabCombat");
                this.put("brewing", "tabBrewing");
                this.put("materials", "tabMaterials");
                this.put("inventory", "tabInventory");
            }
        };
        for (String key : tabMap.keySet()) {
            if (!tabToFieldMap.containsKey(key)) continue;
            String mappedField = (String)tabToFieldMap.get(key);
            String unmappedField = (String)tabMap.get(key);
            this.addFieldMapping("net/minecraft/creativetab/CreativeTabs " + mappedField + " Lnet/minecraft/creativetab/CreativeTabs;", creativeTabs.name + " " + unmappedField + " L" + creativeTabs.name + ";");
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/util/EnumFacing", "net/minecraft/util/ItemUseResult", "net/minecraft/util/ObjectActionHolder", "net/minecraft/util/MainOrOffHand", "net/minecraft/creativetab/CreativeTabs", "net/minecraft/util/RegistryNamespaced", "net/minecraft/item/state/IItemState", "net/minecraft/util/MovingObjectPosition", "net/minecraft/util/ResourceLocation"}, providesMethods={"net/minecraft/item/Item getMaxStackSize ()I", "net/minecraft/item/Item setMaxStackSize (I)Lnet/minecraft/item/Item;", "net/minecraft/item/Item setCreativeTab (Lnet/minecraft/creativetab/CreativeTabs;)Lnet/minecraft/item/Item;", "net/minecraft/item/Item registerItem (ILjava/lang/String;Lnet/minecraft/item/Item;)V", "net/minecraft/item/Item registerItem (ILnet/minecraft/util/ResourceLocation;Lnet/minecraft/item/Item;)V", "net/minecraft/item/Item registerItemBlock (Lnet/minecraft/block/Block;Lnet/minecraft/item/Item;)V", "net/minecraft/item/Item registerItemBlock (Lnet/minecraft/block/Block;)V", "net/minecraft/item/Item onItemRightClick (Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/MainOrOffHand;)Lnet/minecraft/util/ObjectActionHolder;", "net/minecraft/item/Item onItemUse (Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/MainOrOffHand;Lnet/minecraft/util/EnumFacing;FFF)Lnet/minecraft/util/ItemUseResult;", "net/minecraft/item/Item onItemUseFinish (Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/EntityLivingBase;)Lnet/minecraft/item/ItemStack;", "net/minecraft/item/Item onBlockDestroyed (Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/BlockPos;Lnet/minecraft/entity/EntityLivingBase;)Z"}, providesFields={"net/minecraft/item/Item maxStackSize I", "net/minecraft/item/Item itemRegistry Lnet/minecraft/util/RegistryNamespaced;"}, depends={"net/minecraft/item/Item", "net/minecraft/block/Block", "net/minecraft/item/ItemStack", "net/minecraft/world/World", "net/minecraft/util/BlockPos", "net/minecraft/entity/player/EntityPlayer", "net/minecraft/entity/EntityLivingBase", "net/minecraft/block/state/IBlockState"})
    public boolean processItemClass() {
        String setCreativeTabDesc;
        String className;
        String className2;
        Type[] args;
        Type t;
        String test;
        ClassNode iBlockState;
        ClassNode entityLivingBase;
        ClassNode entityPlayer;
        ClassNode blockPos;
        ClassNode world;
        ClassNode itemStack;
        ClassNode block;
        ClassNode item = this.getClassNodeFromMapping("net/minecraft/item/Item");
        if (!MeddleUtil.notNull((Object[])new Object[]{item, block = this.getClassNodeFromMapping("net/minecraft/block/Block"), itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack"), world = this.getClassNodeFromMapping("net/minecraft/world/World"), blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos"), entityPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayer"), entityLivingBase = this.getClassNodeFromMapping("net/minecraft/entity/EntityLivingBase"), iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState")})) {
            return false;
        }
        String mainOrOffHand = null;
        String enumFacing = null;
        String itemUseResult = null;
        ClassNode objectActionHolder = null;
        Object itemState = null;
        String resourceLocation = null;
        for (Object method : item.methods) {
            if (!this.checkMethodParameters((MethodNode)method, 10, 10, 10, 10, 10, 10, 6, 6, 6) || !((MethodNode)method).desc.startsWith(test = "(L" + itemStack.name + ";L" + entityPlayer.name + ";L" + world.name + ";L" + blockPos.name + ";L")) continue;
            t = Type.getMethodType((String)((MethodNode)method).desc);
            args = t.getArgumentTypes();
            itemUseResult = t.getReturnType().getClassName();
            this.addClassMapping("net/minecraft/util/ItemUseResult", itemUseResult);
            mainOrOffHand = args[4].getClassName();
            this.addClassMapping("net/minecraft/util/MainOrOffHand", mainOrOffHand);
            enumFacing = args[5].getClassName();
            this.addClassMapping("net/minecraft/util/EnumFacing", enumFacing);
            this.addMethodMapping("net/minecraft/item/Item onItemUse (Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/MainOrOffHand;Lnet/minecraft/util/EnumFacing;FFF)Lnet/minecraft/util/ItemUseResult;", item.name + " " + ((MethodNode)method).name + " " + ((MethodNode)method).desc);
        }
        for (Object method : item.methods) {
            test = "(L" + itemStack.name + ";L" + world.name + ";L" + entityPlayer.name + ";L" + mainOrOffHand + ";)";
            if (!((MethodNode)method).desc.startsWith(test)) continue;
            t = Type.getMethodType((String)((MethodNode)method).desc).getReturnType();
            objectActionHolder = this.getClassNode(t.getClassName());
            this.addClassMapping("net/minecraft/util/ObjectActionHolder", objectActionHolder);
            this.addMethodMapping("net/minecraft/item/Item onItemRightClick (Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/MainOrOffHand;)Lnet/minecraft/util/ObjectActionHolder;", item.name + " " + ((MethodNode)method).name + " " + ((MethodNode)method).desc);
        }
        List<Object> methods = new ArrayList();
        methods.clear();
        for (Object method : item.methods) {
            if ((((MethodNode)method).access & 8) == 0 || !this.checkMethodParameters((MethodNode)method, 5, 10, 10) || !((MethodNode)method).desc.startsWith("(IL") || !((MethodNode)method).desc.endsWith(";L" + item.name + ";)V")) continue;
            methods.add(method);
        }
        if (methods.size() == 2) {
            for (Object method : methods) {
                className2 = Type.getMethodType((String)((MethodNode)method).desc).getArgumentTypes()[1].getClassName();
                if (className2.equals("java.lang.String")) {
                    this.addMethodMapping("net/minecraft/item/Item registerItem (ILjava/lang/String;Lnet/minecraft/item/Item;)V", item.name + " " + ((MethodNode)method).name + " " + ((MethodNode)method).desc);
                    continue;
                }
                if (this.searchConstantPoolForStrings(className2, "minecraft")) {
                    resourceLocation = className2;
                    this.addClassMapping("net/minecraft/util/ResourceLocation", className2);
                }
                this.addMethodMapping("net/minecraft/item/Item registerItem (ILnet/minecraft/util/ResourceLocation;Lnet/minecraft/item/Item;)V", item.name + " " + ((MethodNode)method).name + " " + ((MethodNode)method).desc);
            }
        }
        methods = this.getMatchingMethods(item, null, "(L" + block.name + ";L" + item.name + ";)V");
        if ((methods = this.removeMethodsWithoutFlags(methods, 8)).size() == 1) {
            this.addMethodMapping("net/minecraft/item/Item registerItemBlock (Lnet/minecraft/block/Block;Lnet/minecraft/item/Item;)V", item.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        methods = this.getMatchingMethods(item, null, "(L" + block.name + ";)V");
        if ((methods = this.removeMethodsWithoutFlags(methods, 8)).size() == 1) {
            this.addMethodMapping("net/minecraft/item/Item registerItemBlock (Lnet/minecraft/block/Block;)V", item.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        for (FieldNode field : item.fields) {
            if ((field.access & 0x18) != 24 || (className2 = Type.getType((String)field.desc).getClassName()).contains(".") || !this.searchConstantPoolForClasses(className2, "com.google.common.collect.BiMap", "com.google.common.collect.HashBiMap")) continue;
            this.addClassMapping("net/minecraft/util/RegistryNamespaced", className2);
            this.addFieldMapping("net/minecraft/item/Item itemRegistry Lnet/minecraft/util/RegistryNamespaced;", item.name + " " + field.name + " " + field.desc);
        }
        for (Object method : item.methods) {
            ClassNode cn;
            t = Type.getMethodType((String)((MethodNode)method).desc);
            args = t.getArgumentTypes();
            if (args.length != 2 || !args[0].getClassName().equals(resourceLocation) || (cn = this.getClassNode(className = args[1].getClassName())) == null || (cn.access & 0x200) == 0) continue;
            this.addClassMapping("net/minecraft/item/state/IItemState", className);
            break;
        }
        for (Object method : item.methods) {
            if (!((MethodNode)method).desc.startsWith("(L" + world.name + ";L" + entityPlayer.name + ";Z)") || (t = Type.getMethodType((String)((MethodNode)method).desc).getReturnType()).getSort() != 10 || !this.searchConstantPoolForStrings(t.getClassName(), "HitResult{type=")) continue;
            this.addClassMapping("net/minecraft/util/MovingObjectPosition", t.getClassName());
            break;
        }
        ClassNode creativeTab = null;
        for (FieldNode field : item.fields) {
            Type t2 = Type.getType((String)field.desc);
            if (t2.getSort() != 10 || (className = t2.getClassName()).contains(".") || DynamicMappings.reverseClassMappings.containsKey(className) || !this.searchConstantPoolForStrings(className, "buildingBlocks", "decorations", "redstone")) continue;
            this.addClassMapping("net/minecraft/creativetab/CreativeTabs", className);
            creativeTab = this.getClassNode(className);
        }
        if (creativeTab != null && (methods = this.getMatchingMethods(item, null, setCreativeTabDesc = "(L" + creativeTab.name + ";)L" + item.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/item/Item setCreativeTab (Lnet/minecraft/creativetab/CreativeTabs;)Lnet/minecraft/item/Item;", item.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        String maxStackSizeField = null;
        List<MethodNode> initMethod = this.getMatchingMethods(item, "<init>", "()V");
        if (initMethod.size() == 1) {
            for (AbstractInsnNode insn = initMethod.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (!(insn instanceof IntInsnNode)) continue;
                IntInsnNode bipush = (IntInsnNode)insn;
                if (bipush.operand != 64 || insn.getNext().getOpcode() != 181) continue;
                FieldInsnNode fn = (FieldInsnNode)insn.getNext();
                if (!fn.desc.equals("I")) continue;
                maxStackSizeField = fn.name;
                this.addFieldMapping("net/minecraft/item/Item maxStackSize I", item.name + " " + maxStackSizeField + " I");
                break;
            }
        }
        if (maxStackSizeField != null) {
            boolean foundGetter = false;
            List<MethodNode> intGetters = this.getMatchingMethods(item, null, "()I");
            for (MethodNode method : intGetters) {
                for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                    if (insn.getOpcode() < 0) continue;
                    if (insn.getOpcode() != 25 || (insn = insn.getNext()).getOpcode() != 180) break;
                    FieldInsnNode fn = (FieldInsnNode)insn;
                    if (!fn.name.equals(maxStackSizeField)) continue;
                    this.addMethodMapping("net/minecraft/item/Item getMaxStackSize ()I", item.name + " " + method.name + " " + method.desc);
                    foundGetter = true;
                    break;
                }
                if (!foundGetter) continue;
                break;
            }
            boolean foundSetter = false;
            List<MethodNode> intSetters = this.getMatchingMethods(item, null, "(I)L" + item.name + ";");
            for (MethodNode method : intSetters) {
                for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                    if (insn.getOpcode() < 0) continue;
                    if (insn.getOpcode() != 25 || (insn = insn.getNext()).getOpcode() != 21 || (insn = insn.getNext()).getOpcode() != 181) break;
                    FieldInsnNode fn = (FieldInsnNode)insn;
                    if (!fn.name.equals(maxStackSizeField)) continue;
                    this.addMethodMapping("net/minecraft/item/Item setMaxStackSize (I)Lnet/minecraft/item/Item;", item.name + " " + method.name + " " + method.desc);
                    foundSetter = true;
                    break;
                }
                if (!foundSetter) continue;
                break;
            }
        }
        if ((methods = this.getMatchingMethods(item, null, this.assembleDescriptor("(", itemStack, world, entityLivingBase, ")", itemStack))).size() == 1) {
            this.addMethodMapping("net/minecraft/item/Item onItemUseFinish (Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/EntityLivingBase;)Lnet/minecraft/item/ItemStack;", item.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        if ((methods = this.getMatchingMethods(item, null, this.assembleDescriptor("(", itemStack, world, iBlockState, blockPos, entityLivingBase, ")Z"))).size() == 1) {
            this.addMethodMapping("net/minecraft/item/Item onBlockDestroyed (Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/BlockPos;Lnet/minecraft/entity/EntityLivingBase;)Z", item.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/util/EnumFacing$AxisDirection", "net/minecraft/util/EnumFacing$Axis"}, providesFields={"net/minecraft/util/EnumFacing DOWN Lnet/minecraft/util/EnumFacing;", "net/minecraft/util/EnumFacing UP Lnet/minecraft/util/EnumFacing;", "net/minecraft/util/EnumFacing NORTH Lnet/minecraft/util/EnumFacing;", "net/minecraft/util/EnumFacing SOUTH Lnet/minecraft/util/EnumFacing;", "net/minecraft/util/EnumFacing WEST Lnet/minecraft/util/EnumFacing;", "net/minecraft/util/EnumFacing EAST Lnet/minecraft/util/EnumFacing;"}, depends={"net/minecraft/util/EnumFacing"})
    public boolean processEnumFacingClass() {
        ClassNode enumFacing = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing");
        if (!MeddleUtil.notNull((Object[])new Object[]{enumFacing})) {
            return false;
        }
        List<FieldNode> fields = this.getMatchingFields(enumFacing, null, "L" + enumFacing.name + ";");
        if (fields.size() == 6) {
            String[] names = new String[]{"DOWN", "UP", "NORTH", "SOUTH", "WEST", "EAST"};
            for (int n = 0; n < 6; ++n) {
                this.addFieldMapping("net/minecraft/util/EnumFacing " + names[n] + " Lnet/minecraft/util/EnumFacing;", enumFacing.name + " " + fields.get((int)n).name + " " + fields.get((int)n).desc);
            }
        }
        HashSet<String> innerClasses = new HashSet<String>();
        for (FieldNode fn : enumFacing.fields) {
            if (!fn.desc.startsWith("L" + enumFacing.name + "$")) continue;
            innerClasses.add(fn.desc.substring(1, fn.desc.length() - 1));
        }
        if (innerClasses.size() == 2) {
            String axisDirection_name = null;
            String axis_name = null;
            for (String s : innerClasses) {
                if (axisDirection_name == null && this.searchConstantPoolForStrings(s, "POSITIVE", "NEGATIVE")) {
                    axisDirection_name = s;
                    continue;
                }
                if (axis_name != null || !this.searchConstantPoolForStrings(s, "X", "Y", "Z")) continue;
                axis_name = s;
            }
            if (axisDirection_name != null && axis_name != null) {
                this.addClassMapping("net/minecraft/util/EnumFacing$AxisDirection", axisDirection_name);
                this.addClassMapping("net/minecraft/util/EnumFacing$Axis", axis_name);
            }
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/util/EnumFacing$AxisDirection getOffset ()I"}, providesFields={"net/minecraft/util/EnumFacing$AxisDirection POSITIVE Lnet/minecraft/util/EnumFacing$AxisDirection;", "net/minecraft/util/EnumFacing$AxisDirection NEGATIVE Lnet/minecraft/util/EnumFacing$AxisDirection;"}, depends={"net/minecraft/util/EnumFacing$AxisDirection"})
    public boolean processEnumFacingAxisDirectionClass() {
        List<MethodNode> methods;
        ClassNode axisDirection = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing$AxisDirection");
        if (!MeddleUtil.notNull((Object[])new Object[]{axisDirection})) {
            return false;
        }
        MethodNode clinit = this.getMethodNode(axisDirection, "--- <clinit> ()V");
        if (clinit != null) {
            String lastString = null;
            for (AbstractInsnNode insn = clinit.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                String string = this.getLdcString(insn);
                if (string != null && lastString == null) {
                    lastString = string;
                    continue;
                }
                if (insn.getOpcode() != 179) continue;
                FieldInsnNode fn = (FieldInsnNode)insn;
                if (!fn.owner.equals(axisDirection.name) || !fn.desc.equals("L" + axisDirection.name + ";")) continue;
                if (lastString.equals("POSITIVE")) {
                    this.addFieldMapping("net/minecraft/util/EnumFacing$AxisDirection POSITIVE Lnet/minecraft/util/EnumFacing$AxisDirection;", fn);
                } else if (lastString.equals("NEGATIVE")) {
                    this.addFieldMapping("net/minecraft/util/EnumFacing$AxisDirection NEGATIVE Lnet/minecraft/util/EnumFacing$AxisDirection;", fn);
                }
                lastString = null;
            }
        }
        if ((methods = this.getMatchingMethods(axisDirection, null, "()I")).size() == 1) {
            this.addMethodMapping("net/minecraft/util/EnumFacing$AxisDirection getOffset ()I", axisDirection.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    public Map<String, FieldInsnNode> extractEnumFieldsWithNames(ClassNode cn) {
        HashMap<String, FieldInsnNode> enumFields = new HashMap<String, FieldInsnNode>();
        MethodNode clinit = this.getMethodNode(cn, "--- <clinit> ()V");
        if (clinit != null) {
            String lastString = null;
            for (AbstractInsnNode insn = clinit.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                String string = this.getLdcString(insn);
                if (string != null && lastString == null) {
                    lastString = string;
                    continue;
                }
                if (insn.getOpcode() != 179) continue;
                FieldInsnNode fn = (FieldInsnNode)insn;
                if (!fn.owner.equals(cn.name) || !fn.desc.equals("L" + cn.name + ";")) continue;
                enumFields.put(lastString, fn);
                lastString = null;
            }
        }
        return enumFields;
    }

    @Mapping(provides={"net/minecraft/util/EnumFacing$Plane"}, providesMethods={}, providesFields={"net/minecraft/util/EnumFacing$Axis X Lnet/minecraft/util/EnumFacing$Axis;", "net/minecraft/util/EnumFacing$Axis Y Lnet/minecraft/util/EnumFacing$Axis;", "net/minecraft/util/EnumFacing$Axis Z Lnet/minecraft/util/EnumFacing$Axis;"}, depends={"net/minecraft/util/EnumFacing", "net/minecraft/util/EnumFacing$Axis"})
    public boolean processEnumFacingAxisClass() {
        ClassNode axis;
        ClassNode enumFacing = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing");
        if (!MeddleUtil.notNull((Object[])new Object[]{enumFacing, axis = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing$Axis")})) {
            return false;
        }
        Map<String, FieldInsnNode> enumFields = this.extractEnumFieldsWithNames(axis);
        if (enumFields.keySet().size() == 3) {
            for (String key : enumFields.keySet()) {
                if (!"X".equals(key) && !"Y".equals(key) && !"Z".equals(key)) continue;
                this.addFieldMapping("net/minecraft/util/EnumFacing$Axis " + key + " Lnet/minecraft/util/EnumFacing$Axis;", axis.name + " " + enumFields.get((Object)key).name + " " + enumFields.get((Object)key).desc);
            }
        }
        List<FieldNode> fields = this.getMatchingFields(axis, null, null);
        for (FieldNode field : fields) {
            String className;
            Type t = Type.getType((String)field.desc);
            if (t.getSort() != 10 || (className = t.getClassName()).equals(axis.name) || className.equals("java.lang.String") || className.equals("java.util.Map") || !className.startsWith(enumFacing.name) || !this.searchConstantPoolForStrings(className, "HORIZONTAL", "VERTICAL")) continue;
            this.addClassMapping("net/minecraft/util/EnumFacing$Plane", className);
            break;
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/util/EnumFacing$Plane facings ()[Lnet/minecraft/util/EnumFacing;", "net/minecraft/util/EnumFacing$Plane random (Ljava/util/Random;)Lnet/minecraft/util/EnumFacing;", "net/minecraft/util/EnumFacing$Plane apply (Lnet/minecraft/util/EnumFacing;)Z"}, providesFields={"net/minecraft/util/EnumFacing$Plane HORIZONTAL Lnet/minecraft/util/EnumFacing$Plane;", "net/minecraft/util/EnumFacing$Plane VERTICAL Lnet/minecraft/util/EnumFacing$Plane;"}, depends={"net/minecraft/util/EnumFacing", "net/minecraft/util/EnumFacing$Plane"})
    public boolean processEnumFacingPlaneClass() {
        List<MethodNode> methods;
        ClassNode enumFacing = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing");
        ClassNode plane = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing$Plane");
        if (!MeddleUtil.notNull((Object[])new Object[]{enumFacing})) {
            return false;
        }
        Map<String, FieldInsnNode> enumFields = this.extractEnumFieldsWithNames(plane);
        if (enumFields.keySet().size() == 2) {
            for (String key : enumFields.keySet()) {
                if (!"HORIZONTAL".equals(key) && !"VERTICAL".equals(key)) continue;
                this.addFieldMapping("net/minecraft/util/EnumFacing$Plane " + key + " Lnet/minecraft/util/EnumFacing$Plane;", plane.name + " " + enumFields.get((Object)key).name + " " + enumFields.get((Object)key).desc);
            }
        }
        if ((methods = this.getMatchingMethods(plane, null, "()[L" + enumFacing.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/util/EnumFacing$Plane facings ()[Lnet/minecraft/util/EnumFacing;", plane.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(plane, null, "(Ljava/util/Random;)L" + enumFacing.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/util/EnumFacing$Plane random (Ljava/util/Random;)Lnet/minecraft/util/EnumFacing;", plane.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(plane, null, "(L" + enumFacing.name + ";)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/util/EnumFacing$Plane apply (Lnet/minecraft/util/EnumFacing;)Z", plane.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/util/EnumFacing index I", "net/minecraft/util/EnumFacing opposite I", "net/minecraft/util/EnumFacing horizontalIndex I", "net/minecraft/util/EnumFacing name Ljava/lang/String;", "net/minecraft/util/EnumFacing axisDirection Lnet/minecraft/util/EnumFacing$AxisDirection;", "net/minecraft/util/EnumFacing axis Lnet/minecraft/util/EnumFacing$Axis;", "net/minecraft/util/EnumFacing directionVec Lnet/minecraft/util/Vec3i;"}, providesMethods={"net/minecraft/util/EnumFacing getIndex ()I", "net/minecraft/util/EnumFacing getHorizontalIndex ()I"}, depends={"net/minecraft/util/EnumFacing", "net/minecraft/util/EnumFacing$AxisDirection", "net/minecraft/util/EnumFacing$Axis", "net/minecraft/util/Vec3i"})
    public boolean processEnumFacingClass2() {
        ClassNode enumFacing = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing");
        ClassNode axis = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing$Axis");
        ClassNode axisDirection = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing$AxisDirection");
        ClassNode vec3i = this.getClassNodeFromMapping("net/minecraft/util/Vec3i");
        if (!MeddleUtil.notNull((Object[])new Object[]{enumFacing, vec3i, axis, axisDirection})) {
            return false;
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        List<MethodNode> methods = this.getMatchingMethods(enumFacing, "<init>", this.assembleDescriptor("(Ljava/lang/String;IIIILjava/lang/String;", axisDirection, axis, vec3i, ")V"));
        if (methods.size() == 1) {
            FieldInsnNode fn;
            MethodNode method = methods.get(0);
            ArrayList<AbstractInsnNode[]> inits = new ArrayList<AbstractInsnNode[]>();
            for (Object insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                AbstractInsnNode[] nodes = this.getInsnNodeSequenceArray((AbstractInsnNode)insn, VarInsnNode.class, VarInsnNode.class, FieldInsnNode.class);
                if (nodes == null) continue;
                fn = (FieldInsnNode)nodes[2];
                if (((VarInsnNode)nodes[0]).var != 0 || fn.getOpcode() != 181 || !fn.owner.equals(enumFacing.name)) continue;
                inits.add(nodes);
                insn = nodes[2];
            }
            if (inits.size() == 7) {
                for (AbstractInsnNode[] nodes : inits) {
                    fn = (FieldInsnNode)nodes[2];
                    int var = ((VarInsnNode)nodes[1]).var;
                    switch (var) {
                        case 3: {
                            if (fn.desc.equals("I")) {
                                this.addFieldMapping("net/minecraft/util/EnumFacing index I", fn);
                            }
                            fieldMap.put(fn.name, "index");
                            break;
                        }
                        case 4: {
                            if (fn.desc.equals("I")) {
                                this.addFieldMapping("net/minecraft/util/EnumFacing opposite I", fn);
                            }
                            fieldMap.put(fn.name, "opposite");
                            break;
                        }
                        case 5: {
                            if (fn.desc.equals("I")) {
                                this.addFieldMapping("net/minecraft/util/EnumFacing horizontalIndex I", fn);
                            }
                            fieldMap.put(fn.name, "horizontalIndex");
                            break;
                        }
                        case 6: {
                            if (fn.desc.equals("Ljava/lang/String;")) {
                                this.addFieldMapping("net/minecraft/util/EnumFacing name Ljava/lang/String;", fn);
                            }
                            fieldMap.put(fn.name, "name");
                            break;
                        }
                        case 7: {
                            if (fn.desc.equals("L" + axisDirection.name + ";")) {
                                this.addFieldMapping("net/minecraft/util/EnumFacing axisDirection Lnet/minecraft/util/EnumFacing$AxisDirection;", fn);
                            }
                            fieldMap.put(fn.name, "axisDirection");
                            break;
                        }
                        case 8: {
                            if (fn.desc.equals("L" + axis.name + ";")) {
                                this.addFieldMapping("net/minecraft/util/EnumFacing axis Lnet/minecraft/util/EnumFacing$Axis;", fn);
                            }
                            fieldMap.put(fn.name, "axis");
                            break;
                        }
                        case 9: {
                            if (fn.desc.equals("L" + vec3i.name + ";")) {
                                this.addFieldMapping("net/minecraft/util/EnumFacing directionVec Lnet/minecraft/util/Vec3i;", fn);
                            }
                            fieldMap.put(fn.name, "directionVec");
                        }
                    }
                }
            }
        }
        methods = this.getMatchingMethods(enumFacing, null, "()I");
        for (MethodNode method : methods) {
            String field;
            AbstractInsnNode[] nodes = this.getOpcodeSequenceArray(method.instructions.getFirst(), 25, 180, 172);
            if (nodes == null || ((VarInsnNode)nodes[0]).var != 0) continue;
            FieldInsnNode fn = (FieldInsnNode)nodes[1];
            if (!fn.owner.equals(enumFacing.name) || !fn.desc.equals("I") || (field = (String)fieldMap.get(fn.name)) == null) continue;
            if (field.equals("index")) {
                this.addMethodMapping("net/minecraft/util/EnumFacing getIndex ()I", enumFacing.name + " " + method.name + " ()I");
                continue;
            }
            if (!field.equals("horizontalIndex")) continue;
            this.addMethodMapping("net/minecraft/util/EnumFacing getHorizontalIndex ()I", enumFacing.name + " " + method.name + " ()I");
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/util/SoundCategory"}, providesFields={"net/minecraft/world/World isRemote Z"}, providesMethods={"net/minecraft/world/World setBlockState (Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z", "net/minecraft/world/World markBlockForUpdate (Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/state/IBlockState;I)V", "net/minecraft/world/World markBlockRangeForRenderUpdate (Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/BlockPos;)V", "net/minecraft/world/World playAuxSFXAtEntity (Lnet/minecraft/entity/player/EntityPlayer;ILnet/minecraft/util/BlockPos;I)V", "net/minecraft/world/World addBlockEvent (Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/Block;II)V", "net/minecraft/block/Block onBlockEventReceived (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;II)Z", "net/minecraft/world/World setTileEntity (Lnet/minecraft/util/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V", "net/minecraft/world/World markChunkDirty (Lnet/minecraft/util/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V", "net/minecraft/world/World playSoundEffect (Lnet/minecraft/entity/player/EntityPlayer;DDDLnet/minecraft/util/Sound;Lnet/minecraft/util/SoundCategory;FF)V", "net/minecraft/world/World getEntitiesInAABBexcluding (Lnet/minecraft/entity/Entity;Lnet/minecraft/util/AxisAlignedBB;Lcom/google/common/base/Predicate;)Ljava/util/List;", "net/minecraft/world/World getEntitiesWithinAABBExcludingEntity (Lnet/minecraft/entity/Entity;Lnet/minecraft/util/AxisAlignedBB;)Ljava/util/List;", "net/minecraft/world/World getCollidingBoundingBoxes (Lnet/minecraft/entity/Entity;Lnet/minecraft/util/AxisAlignedBB;)Ljava/util/List;"}, depends={"net/minecraft/world/World", "net/minecraft/util/BlockPos", "net/minecraft/block/state/IBlockState", "net/minecraft/entity/player/EntityPlayer", "net/minecraft/block/Block", "net/minecraft/tileentity/TileEntity", "net/minecraft/util/AxisAlignedBB", "net/minecraft/entity/Entity", "net/minecraft/util/Sound"})
    public boolean processWorldClass() {
        MethodNode method;
        ClassNode sound;
        ClassNode entity;
        ClassNode aabb;
        ClassNode tileEntity;
        ClassNode block;
        ClassNode entityPlayer;
        ClassNode iBlockState;
        ClassNode blockPos;
        ClassNode world = this.getClassNodeFromMapping("net/minecraft/world/World");
        if (!MeddleUtil.notNull((Object[])new Object[]{world, blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos"), iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState"), entityPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayer"), block = this.getClassNodeFromMapping("net/minecraft/block/Block"), tileEntity = this.getClassNodeFromMapping("net/minecraft/tileentity/TileEntity"), aabb = this.getClassNodeFromMapping("net/minecraft/util/AxisAlignedBB"), entity = this.getClassNodeFromMapping("net/minecraft/entity/Entity"), sound = this.getClassNodeFromMapping("net/minecraft/util/Sound")})) {
            return false;
        }
        int count = 0;
        String isRemote = null;
        for (FieldNode fn : world.fields) {
            if ((fn.access & 0x10) == 0 || !fn.desc.equals("Z")) continue;
            isRemote = fn.name;
            ++count;
        }
        if (count == 1) {
            this.addFieldMapping("net/minecraft/world/World isRemote Z", world.name + " " + isRemote + " Z");
        } else {
            isRemote = null;
        }
        List<MethodNode> methods = this.getMatchingMethods(world, null, this.assembleDescriptor("(", blockPos, iBlockState, "I)Z"));
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/world/World setBlockState (Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z", world.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(world, null, this.assembleDescriptor("(", blockPos, iBlockState, iBlockState, "I)V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/world/World markBlockForUpdate (Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/state/IBlockState;I)V", world.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(world, null, this.assembleDescriptor("(", blockPos, blockPos, ")V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/world/World markBlockRangeForRenderUpdate (Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/BlockPos;)V", world.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(world, null, this.assembleDescriptor("(", entityPlayer, "I", blockPos, "I)V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/world/World playAuxSFXAtEntity (Lnet/minecraft/entity/player/EntityPlayer;ILnet/minecraft/util/BlockPos;I)V", world.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        methods = this.getMatchingMethods(world, null, this.assembleDescriptor("(", blockPos, block, "II)V"));
        Iterator<MethodNode> it = methods.iterator();
        while (it.hasNext()) {
            method = it.next();
            AbstractInsnNode insn = this.getNextRealOpcode(method.instructions.getFirst());
            if (insn == null || insn.getOpcode() != 177) continue;
            it.remove();
        }
        if (methods.size() == 1) {
            boolean found_onBlockEventReceived = false;
            List<MethodInsnNode> nodes = this.getAllInsnNodesOfType(methods.get((int)0).instructions.getFirst(), MethodInsnNode.class);
            String desc = this.assembleDescriptor("(", world, blockPos, iBlockState, "II)Z");
            for (MethodInsnNode mn : nodes) {
                if (!mn.owner.equals(block.name) || !mn.desc.equals(desc)) continue;
                this.addMethodMapping("net/minecraft/block/Block onBlockEventReceived (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;II)Z", block.name + " " + mn.name + " " + mn.desc);
                found_onBlockEventReceived = true;
                break;
            }
            if (found_onBlockEventReceived) {
                this.addMethodMapping("net/minecraft/world/World addBlockEvent (Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/Block;II)V", world.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            }
        }
        if ((methods = this.getMatchingMethods(world, null, this.assembleDescriptor("(", blockPos, tileEntity, ")V"))).size() == 2) {
            List<VarInsnNode> vars1 = this.getAllInsnNodesOfType(methods.get((int)0).instructions.getFirst(), VarInsnNode.class);
            List<VarInsnNode> vars2 = this.getAllInsnNodesOfType(methods.get((int)1).instructions.getFirst(), VarInsnNode.class);
            Iterator<VarInsnNode> it2 = vars1.iterator();
            while (it2.hasNext()) {
                if (it2.next().var == 2) continue;
                it2.remove();
            }
            it2 = vars2.iterator();
            while (it2.hasNext()) {
                if (it2.next().var == 2) continue;
                it2.remove();
            }
            MethodNode setTileEntity = null;
            MethodNode markChunkDirty = null;
            if (vars1.size() > 0 && vars2.size() == 0) {
                setTileEntity = methods.get(0);
                markChunkDirty = methods.get(1);
            } else if (vars1.size() == 0 && vars2.size() > 0) {
                setTileEntity = methods.get(1);
                markChunkDirty = methods.get(0);
            }
            if (setTileEntity != null && markChunkDirty != null) {
                this.addMethodMapping("net/minecraft/world/World setTileEntity (Lnet/minecraft/util/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V", world.name + " " + setTileEntity.name + " " + setTileEntity.desc);
                this.addMethodMapping("net/minecraft/world/World markChunkDirty (Lnet/minecraft/util/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V", world.name + " " + markChunkDirty.name + " " + markChunkDirty.desc);
            }
        }
        methods = this.getMatchingMethods(world, null, null);
        it = methods.iterator();
        while (it.hasNext()) {
            method = it.next();
            if (method.desc.startsWith("(L" + entityPlayer.name + ";DDDL" + sound.name + ";") && method.desc.endsWith("FF)V")) continue;
            it.remove();
        }
        if (methods.size() == 1) {
            Type t = Type.getMethodType((String)methods.get((int)0).desc);
            Type soundType = t.getArgumentTypes()[5];
            String soundCategory_name = soundType.getClassName();
            if (soundType.getSort() == 10 && this.searchConstantPoolForStrings(soundCategory_name, "MASTER", "MUSIC", "RECORDS")) {
                this.addClassMapping("net/minecraft/util/SoundCategory", soundCategory_name);
                this.addMethodMapping("net/minecraft/world/World playSoundEffect (Lnet/minecraft/entity/player/EntityPlayer;DDDLnet/minecraft/util/Sound;Lnet/minecraft/util/SoundCategory;FF)V", world.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            }
        }
        MethodNode getEntitiesInAABBexcluding = null;
        methods = this.getMatchingMethods(world, null, this.assembleDescriptor("(", entity, aabb, "Lcom/google/common/base/Predicate;)Ljava/util/List;"));
        if (methods.size() == 1) {
            getEntitiesInAABBexcluding = methods.get(0);
            this.addMethodMapping("net/minecraft/world/World getEntitiesInAABBexcluding (Lnet/minecraft/entity/Entity;Lnet/minecraft/util/AxisAlignedBB;Lcom/google/common/base/Predicate;)Ljava/util/List;", world.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(world, null, this.assembleDescriptor("(", entity, aabb, ")Ljava/util/List;"))).size() == 2 && getEntitiesInAABBexcluding != null) {
            Iterator<MethodNode> it3 = methods.iterator();
            while (it3.hasNext()) {
                MethodInsnNode mn;
                MethodNode method2 = it3.next();
                AbstractInsnNode[] nodes = null;
                nodes = this.getOpcodeSequenceArray(method2.instructions.getFirst(), 25, 25, 25, 178, 182, 176);
                if (nodes == null) continue;
                mn = (MethodInsnNode)nodes[4];
                if (!mn.owner.equals(world.name) || !mn.name.equals(getEntitiesInAABBexcluding.name) || !mn.desc.equals(getEntitiesInAABBexcluding.desc)) continue;
                it3.remove();
                this.addMethodMapping("net/minecraft/world/World getEntitiesWithinAABBExcludingEntity (Lnet/minecraft/entity/Entity;Lnet/minecraft/util/AxisAlignedBB;)Ljava/util/List;", world.name + " " + method2.name + " " + method2.desc);
                break;
            }
            if (methods.size() == 1) {
                this.addMethodMapping("net/minecraft/world/World getCollidingBoundingBoxes (Lnet/minecraft/entity/Entity;Lnet/minecraft/util/AxisAlignedBB;)Ljava/util/List;", world.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/inventory/IInventory"}, providesMethods={"net/minecraft/entity/player/EntityPlayer displayGUIChest (Lnet/minecraft/inventory/IInventory;)V", "net/minecraft/block/BlockChest isOcelotSittingOnChest (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)Z", "net/minecraft/block/BlockChest isBlocked (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)Z", "net/minecraft/block/BlockChest isBelowSolidBlock (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)Z", "net/minecraft/block/state/IBlockWrapper isNormalCube ()Z"}, dependsMethods={"net/minecraft/block/Block onBlockActivated (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/MainOrOffHand;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/EnumFacing;FFF)Z"}, depends={"net/minecraft/block/BlockChest", "net/minecraft/entity/player/EntityPlayer", "net/minecraft/world/World", "net/minecraft/util/BlockPos", "net/minecraft/entity/passive/EntityOcelot", "net/minecraft/block/state/IBlockState", "net/minecraft/block/state/IBlockWrapper"})
    public boolean processBlockChestClass() {
        MethodNode isBelowSolidBlock;
        List<MethodInsnNode> nodes;
        List<TypeInsnNode> nodes2;
        ClassNode iBlockWrapper;
        ClassNode iBlockState;
        ClassNode ocelot;
        ClassNode blockPos;
        ClassNode world;
        ClassNode entityPlayer;
        ClassNode blockChest = this.getClassNodeFromMapping("net/minecraft/block/BlockChest");
        if (!MeddleUtil.notNull((Object[])new Object[]{blockChest, entityPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayer"), world = this.getClassNodeFromMapping("net/minecraft/world/World"), blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos"), ocelot = this.getClassNodeFromMapping("net/minecraft/entity/passive/EntityOcelot"), iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState"), iBlockWrapper = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockWrapper")})) {
            return false;
        }
        MethodNode onBlockActivated = this.getMethodNodeFromMapping(blockChest, "net/minecraft/block/Block onBlockActivated (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/MainOrOffHand;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/EnumFacing;FFF)Z");
        if (onBlockActivated == null) {
            return false;
        }
        for (AbstractInsnNode insn = onBlockActivated.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            Type t;
            Type[] args;
            if (!(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode mn = (MethodInsnNode)insn;
            if (!mn.owner.equals(entityPlayer.name) || (args = (t = Type.getMethodType((String)mn.desc)).getArgumentTypes()).length < 1 || args[0].getSort() != 10) continue;
            String className = args[0].getClassName();
            ClassNode cn = this.getClassNode(className);
            if ((cn.access & 0x200) == 0) continue;
            this.addClassMapping("net/minecraft/inventory/IInventory", className);
            this.addMethodMapping("net/minecraft/entity/player/EntityPlayer displayGUIChest (Lnet/minecraft/inventory/IInventory;)V", entityPlayer.name + " " + mn.name + " " + mn.desc);
            break;
        }
        MethodNode isOcelotSittingOnChest = null;
        List<MethodNode> methods = this.getMatchingMethods(blockChest, null, this.assembleDescriptor("(", world, blockPos, ")Z"));
        Iterator<MethodNode> it = methods.iterator();
        while (it.hasNext()) {
            MethodNode method = it.next();
            nodes2 = this.getAllInsnNodesOfType(method, TypeInsnNode.class);
            boolean hasIt = false;
            for (TypeInsnNode node : nodes2) {
                if (!node.desc.equals(ocelot.name)) continue;
                hasIt = true;
            }
            if (hasIt) continue;
            it.remove();
        }
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/block/BlockChest isOcelotSittingOnChest (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)Z", blockChest.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            isOcelotSittingOnChest = methods.get(0);
        }
        MethodNode isBlocked = null;
        if (isOcelotSittingOnChest != null) {
            methods = this.getMatchingMethods(blockChest, null, this.assembleDescriptor("(", world, blockPos, ")Z"));
            Iterator<MethodNode> it2 = methods.iterator();
            while (it2.hasNext()) {
                MethodNode method = it2.next();
                nodes = this.getAllInsnNodesOfType(method, MethodInsnNode.class);
                if (this.filterMethodInsnNodes(nodes, blockChest.name, isOcelotSittingOnChest).size() != 0) continue;
                it2.remove();
            }
            if (methods.size() == 1) {
                this.addMethodMapping("net/minecraft/block/BlockChest isBlocked (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)Z", blockChest.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
                isBlocked = methods.get(0);
            }
        }
        MethodInsnNode isBelowSolidBlockInsnNode = null;
        if (isBlocked != null) {
            nodes2 = this.getAllInsnNodesOfType(isBlocked, MethodInsnNode.class);
            Iterator<TypeInsnNode> it3 = nodes2.iterator();
            while (it3.hasNext()) {
                MethodInsnNode mn = (MethodInsnNode)it3.next();
                if (!mn.desc.equals(isOcelotSittingOnChest.desc)) {
                    it3.remove();
                    continue;
                }
                if (!mn.owner.equals(blockChest.name) || !mn.name.equals(isBlocked.name) && !mn.name.equals(isOcelotSittingOnChest.name)) continue;
                it3.remove();
            }
            if (nodes2.size() == 1) {
                this.addMethodMapping("net/minecraft/block/BlockChest isBelowSolidBlock (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)Z", blockChest.name + " " + ((MethodInsnNode)nodes2.get((int)0)).name + " " + ((MethodInsnNode)nodes2.get((int)0)).desc);
                isBelowSolidBlockInsnNode = (MethodInsnNode)nodes2.get(0);
            }
        }
        if ((isBelowSolidBlock = this.getMethodNode(blockChest, isBelowSolidBlockInsnNode)) != null) {
            nodes = this.getAllInsnNodesOfType(isBelowSolidBlock, MethodInsnNode.class);
            if ((nodes = this.filterMethodInsnNodes(nodes, iBlockState.name, "()Z")).size() == 1) {
                this.addMethodMapping("net/minecraft/block/state/IBlockWrapper isNormalCube ()Z", iBlockWrapper.name + " " + nodes.get((int)0).name + " ()Z");
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/world/IWorldNameable", "net/minecraft/util/IChatComponent"}, providesMethods={"net/minecraft/world/IWorldNameable hasCustomName ()Z", "net/minecraft/world/IWorldNameable getName ()Ljava/lang/String;", "net/minecraft/world/IWorldNameable getDisplayName ()Lnet/minecraft/util/IChatComponent;"}, depends={"net/minecraft/inventory/IInventory"})
    public boolean processIWorldNameable() {
        ClassNode inventory = this.getClassNodeFromMapping("net/minecraft/inventory/IInventory");
        if (inventory == null) {
            return false;
        }
        if (inventory.interfaces.size() != 1) {
            return false;
        }
        String className = (String)inventory.interfaces.get(0);
        this.addClassMapping("net/minecraft/world/IWorldNameable", className);
        ClassNode worldNameable = this.getClassNode(className);
        if (worldNameable == null) {
            return false;
        }
        if (worldNameable.methods.size() != 3) {
            return false;
        }
        for (MethodNode method : worldNameable.methods) {
            Type t = Type.getMethodType((String)method.desc);
            Type returnType = t.getReturnType();
            if (returnType.getSort() == 1) {
                this.addMethodMapping("net/minecraft/world/IWorldNameable hasCustomName ()Z", worldNameable.name + " " + method.name + " ()Z");
                continue;
            }
            if (returnType.getSort() != 10) continue;
            if (returnType.getClassName().equals("java.lang.String")) {
                this.addMethodMapping("net/minecraft/world/IWorldNameable getName ()Ljava/lang/String;", worldNameable.name + " " + method.name + " " + method.desc);
                continue;
            }
            this.addClassMapping("net/minecraft/util/IChatComponent", returnType.getClassName());
            this.addMethodMapping("net/minecraft/world/IWorldNameable getDisplayName ()Lnet/minecraft/util/IChatComponent;", worldNameable.name + " " + method.name + " " + method.desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/util/ChatComponentText"}, depends={"net/minecraft/server/MinecraftServer"})
    public boolean getChatComponentTextClass() {
        ClassNode server = this.getClassNode("net/minecraft/server/MinecraftServer");
        if (server == null) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(server, "run", "()V");
        if (methods.size() != 1) {
            return false;
        }
        for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn.getOpcode() != 187) continue;
            TypeInsnNode tn = (TypeInsnNode)insn;
            if (!this.searchConstantPoolForStrings(tn.desc, "TextComponent{text='")) continue;
            this.addClassMapping("net/minecraft/util/ChatComponentText", tn.desc);
            return true;
        }
        return false;
    }

    @Mapping(provides={"net/minecraft/inventory/InventoryBasic"}, depends={"net/minecraft/entity/passive/EntityVillager", "net/minecraft/inventory/IInventory"})
    public boolean processEntityVillagerClass() {
        ClassNode villager = this.getClassNodeFromMapping("net/minecraft/entity/passive/EntityVillager");
        ClassNode inventory = this.getClassNodeFromMapping("net/minecraft/inventory/IInventory");
        if (villager == null || inventory == null) {
            return false;
        }
        for (MethodNode method : villager.methods) {
            if (!method.name.equals("<init>")) continue;
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 187) continue;
                TypeInsnNode tn = (TypeInsnNode)insn;
                ClassNode node = this.getClassNode(tn.desc);
                if (node == null) continue;
                boolean isInventory = false;
                for (String iface : node.interfaces) {
                    if (!inventory.name.equals(iface)) continue;
                    isInventory = true;
                }
                if (!isInventory) continue;
                this.addClassMapping("net/minecraft/inventory/InventoryBasic", node.name);
                return true;
            }
        }
        return false;
    }

    @Mapping(providesFields={"net/minecraft/entity/player/EntityPlayer inventory Lnet/minecraft/entity/player/InventoryPlayer;"}, depends={"net/minecraft/entity/player/EntityPlayer", "net/minecraft/entity/player/InventoryPlayer"})
    public boolean processEntityPlayerClass() {
        ClassNode entityPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayer");
        ClassNode inventoryPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/InventoryPlayer");
        if (entityPlayer == null || inventoryPlayer == null) {
            return false;
        }
        for (MethodNode method : entityPlayer.methods) {
            Type t = Type.getMethodType((String)method.desc);
            Type[] args = t.getArgumentTypes();
            if (args.length == 1 && args[0].getSort() == 10 && t.getReturnType().getSort() == 0) continue;
        }
        List<FieldNode> fields = this.getMatchingFields(entityPlayer, null, "L" + inventoryPlayer.name + ";");
        if (fields.size() == 1) {
            this.addFieldMapping("net/minecraft/entity/player/EntityPlayer inventory Lnet/minecraft/entity/player/InventoryPlayer;", entityPlayer.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/nbt/NBTTagCompound", "net/minecraft/nbt/NBTBase", "net/minecraft/nbt/NBTTagEnd", "net/minecraft/nbt/NBTTagByte", "net/minecraft/nbt/NBTTagShort", "net/minecraft/nbt/NBTTagInt", "net/minecraft/nbt/NBTTagLong", "net/minecraft/nbt/NBTTagFloat", "net/minecraft/nbt/NBTTagDouble", "net/minecraft/nbt/NBTTagByteArray", "net/minecraft/nbt/NBTTagString", "net/minecraft/nbt/NBTTagList", "net/minecraft/nbt/NBTTagIntArray"}, providesMethods={"net/minecraft/item/ItemStack writeToNBT (Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/nbt/NBTTagCompound;", "net/minecraft/nbt/NBTBase createNewByType (B)Lnet/minecraft/nbt/NBTBase;"}, depends={"net/minecraft/item/ItemStack"})
    public boolean getNBTClasses() {
        ClassNode itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack");
        if (itemStack == null) {
            return false;
        }
        String tagCompoundName = null;
        for (MethodNode method : itemStack.methods) {
            Type t = Type.getMethodType((String)method.desc);
            Type[] args = t.getArgumentTypes();
            Type returnType = t.getReturnType();
            if (args.length != 1 || args[0].getSort() != 10 || returnType.getSort() != 10 || !args[0].getClassName().equals(returnType.getClassName())) continue;
            tagCompoundName = returnType.getClassName();
            if (this.searchConstantPoolForStrings(tagCompoundName, "Tried to read NBT tag with too high complexity, depth > 512")) {
                this.addClassMapping("net/minecraft/nbt/NBTTagCompound", tagCompoundName);
                this.addMethodMapping("net/minecraft/item/ItemStack writeToNBT (Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/nbt/NBTTagCompound;", itemStack.name + " " + method.name + " " + method.desc);
                break;
            }
            tagCompoundName = null;
        }
        if (tagCompoundName == null) {
            return false;
        }
        ClassNode tagCompound = this.getClassNode(tagCompoundName);
        if (tagCompound == null) {
            return false;
        }
        ClassNode tagBase = this.getClassNode(tagCompound.superName);
        if (tagBase == null) {
            return false;
        }
        if (!this.searchConstantPoolForStrings(tagBase.name, "END", "BYTE", "SHORT")) {
            return false;
        }
        this.addClassMapping("net/minecraft/nbt/NBTBase", tagBase.name);
        HashMap<Integer, String> nbtClassesMap = new HashMap<Integer, String>();
        for (MethodNode method : tagBase.methods) {
            Type t = Type.getMethodType((String)method.desc);
            Type[] args = t.getArgumentTypes();
            Type returnType = t.getReturnType();
            if (args.length != 1 || args[0].getSort() != 3 || !returnType.getClassName().equals(tagBase.name)) continue;
            this.addMethodMapping("net/minecraft/nbt/NBTBase createNewByType (B)Lnet/minecraft/nbt/NBTBase;", tagBase.name + " " + method.name + " " + method.desc);
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 170) continue;
                TableSwitchInsnNode table = (TableSwitchInsnNode)insn;
                if (table.labels.size() != 12) continue;
                for (int n = 0; n < 12; ++n) {
                    AbstractInsnNode destInsn = (AbstractInsnNode)table.labels.get(n);
                    AbstractInsnNode nextReal = this.getNextRealOpcode(destInsn);
                    if (nextReal.getOpcode() != 187) {
                        return false;
                    }
                    nbtClassesMap.put(n, ((TypeInsnNode)nextReal).desc);
                }
            }
        }
        block18: for (Integer key : nbtClassesMap.keySet()) {
            String className = (String)nbtClassesMap.get(key);
            if (className == null) continue;
            switch (key) {
                case 0: {
                    this.addClassMapping("net/minecraft/nbt/NBTTagEnd", className);
                    continue block18;
                }
                case 1: {
                    this.addClassMapping("net/minecraft/nbt/NBTTagByte", className);
                    continue block18;
                }
                case 2: {
                    this.addClassMapping("net/minecraft/nbt/NBTTagShort", className);
                    continue block18;
                }
                case 3: {
                    this.addClassMapping("net/minecraft/nbt/NBTTagInt", className);
                    continue block18;
                }
                case 4: {
                    this.addClassMapping("net/minecraft/nbt/NBTTagLong", className);
                    continue block18;
                }
                case 5: {
                    this.addClassMapping("net/minecraft/nbt/NBTTagFloat", className);
                    continue block18;
                }
                case 6: {
                    this.addClassMapping("net/minecraft/nbt/NBTTagDouble", className);
                    continue block18;
                }
                case 7: {
                    this.addClassMapping("net/minecraft/nbt/NBTTagByteArray", className);
                    continue block18;
                }
                case 8: {
                    this.addClassMapping("net/minecraft/nbt/NBTTagString", className);
                    continue block18;
                }
                case 9: {
                    this.addClassMapping("net/minecraft/nbt/NBTTagList", className);
                    continue block18;
                }
                case 10: {
                    continue block18;
                }
                case 11: {
                    this.addClassMapping("net/minecraft/nbt/NBTTagIntArray", className);
                    continue block18;
                }
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/nbt/NBTBase$NBTPrimitive"}, providesMethods={"net/minecraft/nbt/NBTTagCompound getTagList (Ljava/lang/String;I)Lnet/minecraft/nbt/NBTTagList;", "net/minecraft/nbt/NBTBase hashCode ()I", "net/minecraft/nbt/NBTTagCompound tagCount ()I", "net/minecraft/nbt/NBTTagList tagCount ()I", "net/minecraft/nbt/NBTTagList getTagType ()I", "net/minecraft/nbt/NBTTagList getCompoundTagAt (I)Lnet/minecraft/nbt/NBTTagCompound;", "net/minecraft/nbt/NBTTagCompound getByte (Ljava/lang/String;)B", "net/minecraft/nbt/NBTTagCompound setByte (Ljava/lang/String;B)V", "net/minecraft/nbt/NBTTagCompound hasKey (Ljava/lang/String;I)Z", "net/minecraft/nbt/NBTTagCompound getTagType (Ljava/lang/String;)B", "net/minecraft/nbt/NBTTagList appendTag (Lnet/minecraft/nbt/NBTBase;)V", "net/minecraft/nbt/NBTTagCompound setTag (Ljava/lang/String;Lnet/minecraft/nbt/NBTBase;)V", "net/minecraft/nbt/NBTTagCompound getString (Ljava/lang/String;)Ljava/lang/String;", "net/minecraft/nbt/NBTTagCompound setString (Ljava/lang/String;Ljava/lang/String;)V", "net/minecraft/nbt/NBTTagCompound getInteger (Ljava/lang/String;)I", "net/minecraft/nbt/NBTTagCompound setInteger (Ljava/lang/String;I)V", "net/minecraft/nbt/NBTTagCompound removeTag (Ljava/lang/String;)V"}, providesFields={"net/minecraft/nbt/NBTTagList tagType B"}, depends={"net/minecraft/nbt/NBTTagCompound", "net/minecraft/nbt/NBTTagList", "net/minecraft/nbt/NBTBase"})
    public boolean processNBTTagCompound() {
        ClassNode tagCompound = this.getClassNodeFromMapping("net/minecraft/nbt/NBTTagCompound");
        ClassNode tagList = this.getClassNodeFromMapping("net/minecraft/nbt/NBTTagList");
        ClassNode tagBase = this.getClassNodeFromMapping("net/minecraft/nbt/NBTBase");
        if (tagCompound == null || tagList == null || tagBase == null) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(tagCompound, null, "(Ljava/lang/String;I)L" + tagList.name + ";");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/nbt/NBTTagCompound getTagList (Ljava/lang/String;I)Lnet/minecraft/nbt/NBTTagList;", tagCompound.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        String hashCode_name = null;
        methods = this.getMatchingMethods(tagBase, null, "()I");
        if (methods.size() == 1) {
            hashCode_name = methods.get((int)0).name;
            this.addMethodMapping("net/minecraft/nbt/NBTBase hashCode ()I", tagBase.name + " " + hashCode_name + " ()I");
        }
        methods = this.getMatchingMethods(tagCompound, null, "()I");
        Iterator<MethodNode> iterator = methods.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().name.equals(hashCode_name)) continue;
            iterator.remove();
        }
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/nbt/NBTTagCompound tagCount ()I", tagCompound.name + " " + methods.get((int)0).name + " ()I");
        }
        methods = this.getMatchingMethods(tagList, null, "()I");
        iterator = methods.iterator();
        block1: while (iterator.hasNext()) {
            MethodNode method = iterator.next();
            if (method.name.equals(hashCode_name)) {
                iterator.remove();
                continue;
            }
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 180) continue;
                FieldInsnNode fn = (FieldInsnNode)insn;
                if (!fn.owner.equals(tagList.name) || !fn.desc.equals("B")) continue;
                this.addFieldMapping("net/minecraft/nbt/NBTTagList tagType B", tagList.name + " " + fn.name + " B");
                this.addMethodMapping("net/minecraft/nbt/NBTTagList getTagType ()I", tagList.name + " " + method.name + " ()I");
                iterator.remove();
                continue block1;
            }
        }
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/nbt/NBTTagList tagCount ()I", tagList.name + " " + methods.get((int)0).name + " ()I");
        }
        if ((methods = this.getMatchingMethods(tagList, null, "(I)L" + tagCompound.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/nbt/NBTTagList getCompoundTagAt (I)Lnet/minecraft/nbt/NBTTagCompound;", tagList.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tagCompound, null, "(Ljava/lang/String;I)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/nbt/NBTTagCompound hasKey (Ljava/lang/String;I)Z", tagCompound.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tagCompound, null, "(Ljava/lang/String;)B")).size() == 2) {
            for (MethodNode method : methods) {
                boolean hasBase = false;
                boolean hasPrimitive = false;
                for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                    if (insn.getOpcode() != 192) continue;
                    TypeInsnNode tn = (TypeInsnNode)insn;
                    if (tn.desc.equals(tagBase.name)) {
                        hasBase = true;
                        continue;
                    }
                    if (!tn.desc.startsWith(tagBase.name + "$")) continue;
                    hasPrimitive = true;
                    this.addClassMapping("net/minecraft/nbt/NBTBase$NBTPrimitive", tn.desc);
                }
                if (hasPrimitive && !hasBase) {
                    this.addMethodMapping("net/minecraft/nbt/NBTTagCompound getByte (Ljava/lang/String;)B", tagCompound.name + " " + method.name + " " + method.desc);
                    continue;
                }
                if (hasPrimitive || !hasBase) continue;
                this.addMethodMapping("net/minecraft/nbt/NBTTagCompound getTagType (Ljava/lang/String;)B", tagCompound.name + " " + method.name + " " + method.desc);
            }
        }
        if ((methods = this.getMatchingMethods(tagCompound, null, "(Ljava/lang/String;B)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/nbt/NBTTagCompound setByte (Ljava/lang/String;B)V", tagCompound.name + " " + methods.get((int)0).name + " (Ljava/lang/String;B)V");
        }
        if ((methods = this.getMatchingMethods(tagList, null, "(L" + tagBase.name + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/nbt/NBTTagList appendTag (Lnet/minecraft/nbt/NBTBase;)V", tagList.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tagCompound, null, "(Ljava/lang/String;L" + tagBase.name + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/nbt/NBTTagCompound setTag (Ljava/lang/String;Lnet/minecraft/nbt/NBTBase;)V", tagCompound.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tagCompound, null, "(Ljava/lang/String;)Ljava/lang/String;")).size() == 1) {
            this.addMethodMapping("net/minecraft/nbt/NBTTagCompound getString (Ljava/lang/String;)Ljava/lang/String;", tagCompound.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tagCompound, null, "(Ljava/lang/String;Ljava/lang/String;)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/nbt/NBTTagCompound setString (Ljava/lang/String;Ljava/lang/String;)V", tagCompound.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tagCompound, null, "(Ljava/lang/String;)I")).size() == 1) {
            this.addMethodMapping("net/minecraft/nbt/NBTTagCompound getInteger (Ljava/lang/String;)I", tagCompound.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tagCompound, null, "(Ljava/lang/String;I)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/nbt/NBTTagCompound setInteger (Ljava/lang/String;I)V", tagCompound.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(tagCompound, null, "(Ljava/lang/String;)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/nbt/NBTTagCompound removeTag (Ljava/lang/String;)V", tagCompound.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/inventory/InventoryBasic slotsCount I", "net/minecraft/inventory/InventoryBasic inventoryTitle Ljava/lang/String;", "net/minecraft/inventory/InventoryBasic hasCustomName Z", "net/minecraft/inventory/InventoryBasic inventoryContent [Lnet/minecraft/item/ItemStack;"}, providesMethods={"net/minecraft/inventory/IInventory getSizeInventory ()I", "net/minecraft/inventory/IInventory getInventoryStackLimit ()I", "net/minecraft/inventory/IInventory getFieldCount ()I", "net/minecraft/inventory/IInventory setInventorySlotContents (ILnet/minecraft/item/ItemStack;)V", "net/minecraft/inventory/IInventory getStackInSlot (I)Lnet/minecraft/item/ItemStack;", "net/minecraft/inventory/IInventory getStackInSlotOnClosing (I)Lnet/minecraft/item/ItemStack;", "net/minecraft/inventory/IInventory markDirty ()V", "net/minecraft/inventory/IInventory clear ()V", "net/minecraft/inventory/IInventory decrStackSize (II)Lnet/minecraft/item/ItemStack;", "net/minecraft/inventory/IInventory isUseableByPlayer (Lnet/minecraft/entity/player/EntityPlayer;)Z", "net/minecraft/inventory/IInventory isItemValidForSlot (ILnet/minecraft/item/ItemStack;)Z", "net/minecraft/inventory/IInventory getField (I)I", "net/minecraft/inventory/IInventory setField (II)V"}, depends={"net/minecraft/inventory/IInventory", "net/minecraft/inventory/InventoryBasic", "net/minecraft/item/ItemStack", "net/minecraft/entity/player/EntityPlayer"})
    public boolean processInventoryBasicClass() {
        AbstractInsnNode insn;
        List<MethodNode> methods;
        ClassNode entityPlayer;
        ClassNode itemStack;
        ClassNode inventoryBasic;
        ClassNode iInventory = this.getClassNodeFromMapping("net/minecraft/inventory/IInventory");
        if (!MeddleUtil.notNull((Object[])new Object[]{iInventory, inventoryBasic = this.getClassNodeFromMapping("net/minecraft/inventory/InventoryBasic"), itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack"), entityPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayer")})) {
            return false;
        }
        String slotsCountField = null;
        String inventoryTitleField = null;
        String inventoryContentsField = null;
        String hasCustomNameField = null;
        List<FieldNode> fields = this.getMatchingFields(inventoryBasic, null, "I");
        if (fields.size() == 1) {
            slotsCountField = fields.get((int)0).name;
            this.addFieldMapping("net/minecraft/inventory/InventoryBasic slotsCount I", inventoryBasic.name + " " + slotsCountField + " I");
        }
        if ((fields = this.getMatchingFields(inventoryBasic, null, "Ljava/lang/String;")).size() == 1) {
            inventoryTitleField = fields.get((int)0).name;
            this.addFieldMapping("net/minecraft/inventory/InventoryBasic inventoryTitle Ljava/lang/String;", inventoryBasic.name + " " + inventoryTitleField + " Ljava/lang/String;");
        }
        if ((fields = this.getMatchingFields(inventoryBasic, null, "Z")).size() == 1) {
            hasCustomNameField = fields.get((int)0).name;
            this.addFieldMapping("net/minecraft/inventory/InventoryBasic hasCustomName Z", inventoryBasic.name + " " + hasCustomNameField + " Z");
        }
        if ((fields = this.getMatchingFields(inventoryBasic, null, "[L" + itemStack.name + ";")).size() == 1) {
            inventoryContentsField = fields.get((int)0).name;
            this.addFieldMapping("net/minecraft/inventory/InventoryBasic inventoryContent [Lnet/minecraft/item/ItemStack;", inventoryBasic.name + " " + inventoryContentsField + " [L" + itemStack.name + ";");
        }
        if ((methods = this.getMatchingMethods(inventoryBasic, null, "()I")).size() != 3) {
            return false;
        }
        for (MethodNode method : methods) {
            AbstractInsnNode nextNode;
            AbstractInsnNode firstReal = this.getNextRealOpcode(method.instructions.getFirst());
            if (firstReal.getOpcode() == 25 && (nextNode = firstReal.getNext()) != null && nextNode.getOpcode() == 180) {
                FieldInsnNode fn = (FieldInsnNode)nextNode;
                if (fn.owner.equals(inventoryBasic.name) && fn.name.equals(slotsCountField)) {
                    this.addMethodMapping("net/minecraft/inventory/IInventory getSizeInventory ()I", iInventory.name + " " + method.name + " " + method.desc);
                    continue;
                }
            }
            if (firstReal instanceof IntInsnNode) {
                IntInsnNode in = (IntInsnNode)firstReal;
                if (in.operand == 64) {
                    this.addMethodMapping("net/minecraft/inventory/IInventory getInventoryStackLimit ()I", iInventory.name + " " + method.name + " " + method.desc);
                    continue;
                }
            }
            if (firstReal.getOpcode() != 3 || (nextNode = firstReal.getNext()) == null || nextNode.getOpcode() != 172) continue;
            this.addMethodMapping("net/minecraft/inventory/IInventory getFieldCount ()I", iInventory.name + " " + method.name + " " + method.desc);
        }
        methods = this.getMatchingMethods(inventoryBasic, null, "(IL" + itemStack.name + ";)V");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/IInventory setInventorySlotContents (ILnet/minecraft/item/ItemStack;)V", iInventory.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(inventoryBasic, null, "(I)L" + itemStack.name + ";")).size() != 2) {
            return false;
        }
        for (MethodNode method : methods) {
            boolean foundStore = false;
            boolean foundLength = false;
            for (insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() == 83) {
                    foundStore = true;
                    continue;
                }
                if (insn.getOpcode() != 190) continue;
                foundLength = true;
            }
            if (foundLength && !foundStore) {
                this.addMethodMapping("net/minecraft/inventory/IInventory getStackInSlot (I)Lnet/minecraft/item/ItemStack;", iInventory.name + " " + method.name + " " + method.desc);
                continue;
            }
            if (!foundStore || foundLength) continue;
            this.addMethodMapping("net/minecraft/inventory/IInventory getStackInSlotOnClosing (I)Lnet/minecraft/item/ItemStack;", iInventory.name + " " + method.name + " " + method.desc);
        }
        methods = this.getMatchingMethods(inventoryBasic, null, "()V");
        if (methods.size() != 2) {
            return false;
        }
        for (MethodNode method : methods) {
            boolean hasList = false;
            boolean hasArray = false;
            for (insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 180) continue;
                FieldInsnNode fn = (FieldInsnNode)insn;
                if (fn.owner.equals(inventoryBasic.name) && fn.desc.equals("Ljava/util/List;")) {
                    hasList = true;
                }
                if (!fn.owner.equals(inventoryBasic.name) || !fn.desc.equals("[L" + itemStack.name + ";")) continue;
                hasArray = true;
            }
            if (hasList && !hasArray) {
                this.addMethodMapping("net/minecraft/inventory/IInventory markDirty ()V", iInventory.name + " " + method.name + " " + method.desc);
                continue;
            }
            if (hasList || !hasArray) continue;
            this.addMethodMapping("net/minecraft/inventory/IInventory clear ()V", iInventory.name + " " + method.name + " " + method.desc);
        }
        methods = this.getMatchingMethods(inventoryBasic, null, "(II)L" + itemStack.name + ";");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/IInventory decrStackSize (II)Lnet/minecraft/item/ItemStack;", iInventory.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(inventoryBasic, null, "(L" + entityPlayer.name + ";)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/IInventory isUseableByPlayer (Lnet/minecraft/entity/player/EntityPlayer;)Z", iInventory.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(inventoryBasic, null, "(IL" + itemStack.name + ";)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/IInventory isItemValidForSlot (ILnet/minecraft/item/ItemStack;)Z", iInventory.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(inventoryBasic, null, "(I)I")).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/IInventory getField (I)I", iInventory.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(inventoryBasic, null, "(II)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/inventory/IInventory setField (II)V", iInventory.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/item/Item unlocalizedName Ljava/lang/String;"}, providesMethods={"net/minecraft/item/Item getIdFromItem (Lnet/minecraft/item/Item;)I", "net/minecraft/item/Item getItemById (I)Lnet/minecraft/item/Item;", "net/minecraft/item/Item getItemFromBlock (Lnet/minecraft/block/Block;)Lnet/minecraft/item/Item;", "net/minecraft/item/Item getByNameOrId (Ljava/lang/String;)Lnet/minecraft/item/Item;", "net/minecraft/item/Item setUnlocalizedName (Ljava/lang/String;)Lnet/minecraft/item/Item;", "net/minecraft/item/Item getItemStackDisplayName (Lnet/minecraft/item/ItemStack;)Ljava/lang/String;", "net/minecraft/item/Item getUnlocalizedNameInefficiently (Lnet/minecraft/item/ItemStack;)Ljava/lang/String;", "net/minecraft/item/Item getUnlocalizedName (Lnet/minecraft/item/ItemStack;)Ljava/lang/String;", "net/minecraft/item/Item getUnlocalizedName ()Ljava/lang/String;"}, dependsMethods={"net/minecraft/item/ItemStack getDisplayName ()Ljava/lang/String;"}, depends={"net/minecraft/item/Item", "net/minecraft/block/Block", "net/minecraft/item/ItemStack"})
    public boolean getItemClassMethods() {
        MethodInsnNode mn;
        MethodNode itemStack_getDisplayName;
        MethodNode mn2;
        ClassNode itemStack;
        ClassNode block;
        ClassNode item = this.getClassNode(this.getClassMapping("net/minecraft/item/Item"));
        if (!MeddleUtil.notNull((Object[])new Object[]{item, block = this.getClassNode(this.getClassMapping("net/minecraft/block/Block")), itemStack = this.getClassNode(this.getClassMapping("net/minecraft/item/ItemStack"))})) {
            return false;
        }
        ArrayList itemMethods = new ArrayList();
        itemMethods.addAll(item.methods);
        List<MethodNode> methods = this.getMethodsWithDescriptor(itemMethods, "(L" + item.name + ";)I");
        methods = this.removeMethodsWithoutFlags(methods, 8);
        if (methods.size() == 1) {
            mn2 = methods.get(0);
            itemMethods.remove(mn2);
            this.addMethodMapping("net/minecraft/item/Item getIdFromItem (Lnet/minecraft/item/Item;)I", item.name + " " + mn2.name + " " + mn2.desc);
        } else if (methods.size() == 2) {
            MethodNode mn1 = methods.get(0);
            MethodNode mn22 = methods.get(1);
            if (mn1.instructions.size() == mn22.instructions.size()) {
                int size = mn1.instructions.size();
                boolean nomatch = false;
                for (int n = 0; n < size; ++n) {
                    if (mn1.instructions.get(n).getOpcode() == mn22.instructions.get(n).getOpcode()) continue;
                    nomatch = true;
                    break;
                }
                if (!nomatch) {
                    this.addMethodMapping("net/minecraft/item/Item getIdFromItem (Lnet/minecraft/item/Item;)I", item.name + " " + mn22.name + " " + mn22.desc);
                    this.addMethodMapping("net/minecraft/item/Item getIdFromItem2 (Lnet/minecraft/item/Item;)I", item.name + " " + mn1.name + " " + mn1.desc);
                }
            }
        }
        methods = this.getMethodsWithDescriptor(itemMethods, "(I)L" + item.name + ";");
        methods = this.removeMethodsWithoutFlags(methods, 8);
        if (methods.size() == 1) {
            mn2 = methods.get(0);
            itemMethods.remove(mn2);
            this.addMethodMapping("net/minecraft/item/Item getItemById (I)Lnet/minecraft/item/Item;", item.name + " " + mn2.name + " " + mn2.desc);
        }
        methods = this.getMethodsWithDescriptor(itemMethods, "(L" + block.name + ";)L" + item.name + ";");
        if ((methods = this.removeMethodsWithoutFlags(methods, 8)).size() == 1) {
            mn2 = methods.get(0);
            itemMethods.remove(mn2);
            this.addMethodMapping("net/minecraft/item/Item getItemFromBlock (Lnet/minecraft/block/Block;)Lnet/minecraft/item/Item;", item.name + " " + mn2.name + " " + mn2.desc);
        }
        methods = this.getMethodsWithDescriptor(itemMethods, "(Ljava/lang/String;)L" + item.name + ";");
        if ((methods = this.removeMethodsWithoutFlags(methods, 8)).size() == 1) {
            mn2 = methods.get(0);
            itemMethods.remove(mn2);
            this.addMethodMapping("net/minecraft/item/Item getByNameOrId (Ljava/lang/String;)Lnet/minecraft/item/Item;", item.name + " " + mn2.name + " " + mn2.desc);
        }
        methods = this.getMethodsWithDescriptor(itemMethods, "(Ljava/lang/String;)L" + item.name + ";");
        if ((methods = this.removeMethodsWithFlags(methods, 8)).size() == 1) {
            mn2 = methods.get(0);
            itemMethods.remove(mn2);
            this.addMethodMapping("net/minecraft/item/Item setUnlocalizedName (Ljava/lang/String;)Lnet/minecraft/item/Item;", item.name + " " + mn2.name + " " + mn2.desc);
            for (AbstractInsnNode insn = mn2.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 181) continue;
                FieldInsnNode fn = (FieldInsnNode)insn;
                if (!fn.desc.equals("Ljava/lang/String;")) continue;
                this.addFieldMapping("net/minecraft/item/Item unlocalizedName Ljava/lang/String;", item.name + " " + fn.name + " " + fn.desc);
                break;
            }
        }
        if ((itemStack_getDisplayName = this.getMethodNodeFromMapping(itemStack, "net/minecraft/item/ItemStack getDisplayName ()Ljava/lang/String;")) == null) {
            return false;
        }
        String getItemStackDisplayName_name = null;
        String getItemStackDisplayName_desc = "(L" + itemStack.name + ";)Ljava/lang/String;";
        for (AbstractInsnNode insn = itemStack_getDisplayName.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn.getOpcode() != 182) continue;
            MethodInsnNode mn3 = (MethodInsnNode)insn;
            if (!mn3.owner.equals(item.name) || !mn3.desc.equals(getItemStackDisplayName_desc)) continue;
            getItemStackDisplayName_name = mn3.name;
            break;
        }
        if (getItemStackDisplayName_name == null) {
            return false;
        }
        MethodNode getItemStackDisplayName = this.getMethodNode(item, item.name + " " + getItemStackDisplayName_name + " " + getItemStackDisplayName_desc);
        if (getItemStackDisplayName == null) {
            return false;
        }
        this.addMethodMapping("net/minecraft/item/Item getItemStackDisplayName (Lnet/minecraft/item/ItemStack;)Ljava/lang/String;", item.name + " " + getItemStackDisplayName.name + " " + getItemStackDisplayName.desc);
        String getUnlocalizedNameInefficiently_name = null;
        for (AbstractInsnNode insn = getItemStackDisplayName.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn.getOpcode() != 182) continue;
            mn = (MethodInsnNode)insn;
            if (!mn.owner.equals(item.name) || !mn.desc.equals(getItemStackDisplayName_desc)) continue;
            getUnlocalizedNameInefficiently_name = mn.name;
            break;
        }
        if (getUnlocalizedNameInefficiently_name == null) {
            return false;
        }
        this.addMethodMapping("net/minecraft/item/Item getUnlocalizedNameInefficiently (Lnet/minecraft/item/ItemStack;)Ljava/lang/String;", item.name + " " + getUnlocalizedNameInefficiently_name + " " + getItemStackDisplayName_desc);
        methods = this.getMatchingMethods(item, null, "(L" + itemStack.name + ";)Ljava/lang/String;");
        if (methods.size() == 3) {
            Iterator<MethodNode> iterator = methods.iterator();
            while (iterator.hasNext()) {
                mn = iterator.next();
                if (!mn.name.equals(getItemStackDisplayName_name) && !mn.name.equals(getUnlocalizedNameInefficiently_name)) continue;
                iterator.remove();
            }
            if (methods.size() == 1) {
                this.addMethodMapping("net/minecraft/item/Item getUnlocalizedName (Lnet/minecraft/item/ItemStack;)Ljava/lang/String;", item.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            }
        }
        if ((methods = this.getMatchingMethods(item, null, "()Ljava/lang/String;")).size() == 1) {
            this.addMethodMapping("net/minecraft/item/Item getUnlocalizedName ()Ljava/lang/String;", item.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/item/ItemStack stackTagCompound Lnet/minecraft/nbt/NBTTagCompound;", "net/minecraft/item/ItemStack stackSize I", "net/minecraft/item/ItemStack itemDamage I"}, providesMethods={"net/minecraft/item/ItemStack loadItemStackFromNBT (Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/item/ItemStack;", "net/minecraft/item/ItemStack setTagCompound (Lnet/minecraft/nbt/NBTTagCompound;)V", "net/minecraft/item/ItemStack readFromNBT (Lnet/minecraft/nbt/NBTTagCompound;)V", "net/minecraft/item/ItemStack isItemEnchanted ()Z", "net/minecraft/item/ItemStack hasTagCompound ()Z", "net/minecraft/item/ItemStack getItem ()Lnet/minecraft/item/Item;", "net/minecraft/item/ItemStack getTagCompound ()Lnet/minecraft/nbt/NBTTagCompound;", "net/minecraft/item/ItemStack getDisplayName ()Ljava/lang/String;", "net/minecraft/item/ItemStack getUnlocalizedName ()Ljava/lang/String;", "net/minecraft/item/ItemStack copy ()Lnet/minecraft/item/ItemStack;", "net/minecraft/item/ItemStack isItemEqual (Lnet/minecraft/item/ItemStack;)Z", "net/minecraft/item/ItemStack isItemStackEqual (Lnet/minecraft/item/ItemStack;)Z", "net/minecraft/item/ItemStack isDamageableItemEqual (Lnet/minecraft/item/ItemStack;)Z", "net/minecraft/item/ItemStack isItemStackDamageable ()Z", "net/minecraft/item/ItemStack splitStack (I)Lnet/minecraft/item/ItemStack;", "net/minecraft/item/ItemStack setTagInfo (Ljava/lang/String;Lnet/minecraft/nbt/NBTBase;)V"}, depends={"net/minecraft/item/ItemStack", "net/minecraft/item/Item", "net/minecraft/nbt/NBTTagCompound", "net/minecraft/nbt/NBTBase"})
    public boolean processItemStackClass() {
        Object fn;
        ClassNode nbtbase;
        ClassNode item;
        ClassNode tagCompound;
        ClassNode itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack");
        if (!MeddleUtil.notNull((Object[])new Object[]{itemStack, tagCompound = this.getClassNodeFromMapping("net/minecraft/nbt/NBTTagCompound"), item = this.getClassNodeFromMapping("net/minecraft/item/Item"), nbtbase = this.getClassNodeFromMapping("net/minecraft/nbt/NBTBase")})) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(itemStack, null, "(L" + tagCompound.name + ";)L" + itemStack.name + ";");
        if (methods.size() != 1) {
            return false;
        }
        this.addMethodMapping("net/minecraft/item/ItemStack loadItemStackFromNBT (Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/item/ItemStack;", itemStack.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        String stackTagCompoundField = null;
        methods = this.getMatchingMethods(itemStack, null, "(L" + tagCompound.name + ";)V");
        if (methods.size() != 2) {
            return false;
        }
        block0: for (MethodNode method : methods) {
            AbstractInsnNode nextNode;
            AbstractInsnNode firstReal = this.getNextRealOpcode(method.instructions.getFirst());
            if (firstReal.getOpcode() == 25 && (nextNode = firstReal.getNext()) != null && nextNode.getOpcode() == 25 && (nextNode = nextNode.getNext()) != null && nextNode.getOpcode() == 181) {
                fn = (FieldInsnNode)nextNode;
                if (((FieldInsnNode)fn).owner.equals(itemStack.name) && ((FieldInsnNode)fn).desc.equals("L" + tagCompound.name + ";")) {
                    stackTagCompoundField = ((FieldInsnNode)fn).name;
                    this.addFieldMapping("net/minecraft/item/ItemStack stackTagCompound Lnet/minecraft/nbt/NBTTagCompound;", itemStack.name + " " + ((FieldInsnNode)fn).name + " " + ((FieldInsnNode)fn).desc);
                    this.addMethodMapping("net/minecraft/item/ItemStack setTagCompound (Lnet/minecraft/nbt/NBTTagCompound;)V", itemStack.name + " " + method.name + " " + method.desc);
                    continue;
                }
            }
            boolean isReadNBT = false;
            for (AbstractInsnNode insn = firstReal; insn != null; insn = insn.getNext()) {
                if (!this.isLdcWithString(insn, "id")) continue;
                isReadNBT = true;
                this.addMethodMapping("net/minecraft/item/ItemStack readFromNBT (Lnet/minecraft/nbt/NBTTagCompound;)V", itemStack.name + " " + method.name + " " + method.desc);
                break;
            }
            if (!isReadNBT) continue;
            boolean foundCount = false;
            boolean foundDamage = false;
            boolean foundstackSize = false;
            boolean founditemDamage = false;
            for (AbstractInsnNode insn = firstReal; insn != null; insn = insn.getNext()) {
                String s = this.getLdcString(insn);
                if (s != null) {
                    foundCount = false;
                    foundDamage = false;
                    if (s.equals("Count")) {
                        foundCount = true;
                    } else if (s.equals("Damage")) {
                        foundDamage = true;
                    }
                }
                if (insn.getOpcode() != 181) continue;
                FieldInsnNode fn2 = (FieldInsnNode)insn;
                if (!fn2.owner.equals(itemStack.name)) continue;
                if (foundCount && !foundstackSize) {
                    this.addFieldMapping("net/minecraft/item/ItemStack stackSize I", itemStack.name + " " + fn2.name + " I");
                    foundCount = false;
                    foundstackSize = true;
                } else if (foundDamage) {
                    this.addFieldMapping("net/minecraft/item/ItemStack itemDamage I", itemStack.name + " " + fn2.name + " I");
                    foundDamage = false;
                    founditemDamage = true;
                }
                if (foundstackSize && founditemDamage) continue block0;
            }
        }
        if (stackTagCompoundField == null) {
            return false;
        }
        methods = this.getMatchingMethods(itemStack, null, "()Z");
        Iterator<MethodNode> iterator = methods.iterator();
        while (iterator.hasNext()) {
            MethodNode method;
            method = iterator.next();
            if (!this.matchOpcodeSequence(method.instructions.getFirst(), 25, 180, 198)) {
                iterator.remove();
                continue;
            }
            boolean correctField = false;
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 180) continue;
                fn = (FieldInsnNode)insn;
                if (!((FieldInsnNode)fn).owner.equals(itemStack.name) || !((FieldInsnNode)fn).name.equals(stackTagCompoundField)) break;
                correctField = true;
                break;
            }
            if (correctField) continue;
            iterator.remove();
        }
        if (methods.size() == 2) {
            for (MethodNode method : methods) {
                boolean isEnchant = false;
                for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                    if (!this.isLdcWithString(insn, "ench")) continue;
                    isEnchant = true;
                    break;
                }
                if (isEnchant) {
                    this.addMethodMapping("net/minecraft/item/ItemStack isItemEnchanted ()Z", itemStack.name + " " + method.name + " ()Z");
                    continue;
                }
                this.addMethodMapping("net/minecraft/item/ItemStack hasTagCompound ()Z", itemStack.name + " " + method.name + " ()Z");
            }
        }
        if ((methods = this.getMatchingMethods(itemStack, null, "()L" + item.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/item/ItemStack getItem ()Lnet/minecraft/item/Item;", itemStack.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(itemStack, null, "()L" + tagCompound.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/item/ItemStack getTagCompound ()Lnet/minecraft/nbt/NBTTagCompound;", itemStack.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(itemStack, null, "()Ljava/lang/String;")).size() == 3) {
            for (MethodNode method : methods) {
                if (method.name.equals("toString")) continue;
                boolean isDisplayName = false;
                for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                    if (!this.isLdcWithString(insn, "display")) continue;
                    isDisplayName = true;
                    break;
                }
                if (isDisplayName) {
                    this.addMethodMapping("net/minecraft/item/ItemStack getDisplayName ()Ljava/lang/String;", itemStack.name + " " + method.name + " " + method.desc);
                    continue;
                }
                this.addMethodMapping("net/minecraft/item/ItemStack getUnlocalizedName ()Ljava/lang/String;", itemStack.name + " " + method.name + " " + method.desc);
            }
        }
        if ((methods = this.getMatchingMethods(itemStack, null, "()L" + itemStack.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/item/ItemStack copy ()Lnet/minecraft/item/ItemStack;", itemStack.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        methods = this.getMatchingMethods(itemStack, null, "(L" + itemStack.name + ";)Z");
        if ((methods = this.removeMethodsWithoutFlags(methods, 1)).size() == 1) {
            this.addMethodMapping("net/minecraft/item/ItemStack isItemEqual (Lnet/minecraft/item/ItemStack;)Z", itemStack.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        } else if (methods.size() == 2) {
            int count = 0;
            MethodNode isItemEqualMethod = null;
            MethodNode invokerMethod = null;
            ArrayList<MethodInsnNode> mnodes = new ArrayList<MethodInsnNode>();
            for (MethodNode method : methods) {
                boolean invokes = false;
                for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                    if (insn.getOpcode() != 182) continue;
                    invokes = true;
                    mnodes.add((MethodInsnNode)insn);
                }
                if (!invokes) {
                    ++count;
                    isItemEqualMethod = method;
                    continue;
                }
                invokerMethod = method;
            }
            if (count == 1 && isItemEqualMethod != null) {
                this.addMethodMapping("net/minecraft/item/ItemStack isItemEqual (Lnet/minecraft/item/ItemStack;)Z", itemStack.name + " " + isItemEqualMethod.name + " " + isItemEqualMethod.desc);
            }
            if (count == 1 && invokerMethod != null) {
                this.addMethodMapping("net/minecraft/item/ItemStack isDamageableItemEqual (Lnet/minecraft/item/ItemStack;)Z", itemStack.name + " " + invokerMethod.name + " " + invokerMethod.desc);
                MethodInsnNode isItemStackDamageable = null;
                count = 0;
                for (MethodInsnNode mn : mnodes) {
                    if (!mn.owner.equals(itemStack.name) || !mn.desc.equals("()Z")) continue;
                    ++count;
                    isItemStackDamageable = mn;
                }
                if (count == 1 && isItemStackDamageable != null) {
                    this.addMethodMapping("net/minecraft/item/ItemStack isItemStackDamageable ()Z", itemStack.name + " " + isItemStackDamageable.name + " " + isItemStackDamageable.desc);
                }
            }
        }
        methods = this.getMatchingMethods(itemStack, null, "(L" + itemStack.name + ";)Z");
        methods = this.removeMethodsWithoutFlags(methods, 2);
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/item/ItemStack isItemStackEqual (Lnet/minecraft/item/ItemStack;)Z", itemStack.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(itemStack, null, "(I)L" + itemStack.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/item/ItemStack splitStack (I)Lnet/minecraft/item/ItemStack;", itemStack.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(itemStack, null, "(Ljava/lang/String;L" + nbtbase.name + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/item/ItemStack setTagInfo (Ljava/lang/String;Lnet/minecraft/nbt/NBTBase;)V", itemStack.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/item/ItemStack getItemDamage ()I", "net/minecraft/item/ItemStack setItemDamage (I)V", "net/minecraft/item/ItemStack damageItem (ILnet/minecraft/entity/EntityLivingBase;)V", "net/minecraft/item/ItemStack getMaxDamage ()I"}, providesFields={"net/minecraft/item/ItemStack item Lnet/minecraft/item/Item;"}, dependsMethods={"net/minecraft/item/ItemStack getMetadata ()I", "net/minecraft/item/Item getMaxDamage ()I"}, dependsFields={"net/minecraft/item/ItemStack itemDamage I"}, depends={"net/minecraft/item/ItemStack", "net/minecraft/entity/EntityLivingBase", "net/minecraft/item/Item"})
    public boolean processItemStackClass2() {
        List<FieldNode> fields;
        MethodNode getMaxDamage;
        MethodNode method;
        ClassNode item;
        ClassNode entityLivingBase;
        ClassNode itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack");
        if (!MeddleUtil.notNull((Object[])new Object[]{itemStack, entityLivingBase = this.getClassNodeFromMapping("net/minecraft/entity/EntityLivingBase"), item = this.getClassNodeFromMapping("net/minecraft/item/Item")})) {
            return false;
        }
        FieldNode itemDamage = this.getFieldNodeFromMapping(itemStack, "net/minecraft/item/ItemStack itemDamage I");
        MethodNode getMetadata = this.getMethodNodeFromMapping(itemStack, "net/minecraft/item/ItemStack getMetadata ()I");
        if (itemDamage == null || getMetadata == null) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(itemStack, null, "()I");
        Iterator<MethodNode> it = methods.iterator();
        while (it.hasNext()) {
            method = it.next();
            if (this.matchOpcodeSequence(method.instructions.getFirst(), 25, 180, 172) && !method.name.equals(getMetadata.name)) continue;
            it.remove();
        }
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/item/ItemStack getItemDamage ()I", itemStack.name + " " + methods.get((int)0).name + " ()I");
        }
        methods = this.getMatchingMethods(itemStack, null, "(I)V");
        it = methods.iterator();
        while (it.hasNext()) {
            method = it.next();
            List<FieldInsnNode> nodes = this.getAllInsnNodesOfType(method.instructions.getFirst(), FieldInsnNode.class);
            boolean usesItemDamage = false;
            for (FieldInsnNode fn : nodes) {
                if (!fn.owner.equals(itemStack.name) || !fn.name.equals(itemDamage.name)) continue;
                usesItemDamage = true;
            }
            if (usesItemDamage) continue;
            it.remove();
        }
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/item/ItemStack setItemDamage (I)V", itemStack.name + " " + methods.get((int)0).name + " (I)V");
        }
        if ((methods = this.getMatchingMethods(itemStack, null, "(IL" + entityLivingBase.name + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/item/ItemStack damageItem (ILnet/minecraft/entity/EntityLivingBase;)V", itemStack.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((getMaxDamage = this.getMethodNodeFromMapping(item, "net/minecraft/item/Item getMaxDamage ()I")) != null) {
            methods = this.getMatchingMethods(itemStack, null, "()I");
            Iterator<MethodNode> it2 = methods.iterator();
            while (it2.hasNext()) {
                MethodNode method2 = it2.next();
                List<MethodInsnNode> nodes = this.getAllInsnNodesOfType(method2, MethodInsnNode.class);
                boolean hasIt = false;
                for (MethodInsnNode mn : nodes) {
                    if (!mn.owner.equals(item.name) || !mn.name.equals(getMaxDamage.name) || !mn.desc.equals("()I")) continue;
                    hasIt = true;
                }
                if (hasIt) continue;
                it2.remove();
            }
            if (methods.size() == 1) {
                this.addMethodMapping("net/minecraft/item/ItemStack getMaxDamage ()I", itemStack.name + " " + methods.get((int)0).name + " ()I");
            }
        }
        if ((fields = this.getMatchingFields(itemStack, null, "L" + item.name + ";")).size() == 1) {
            this.addFieldMapping("net/minecraft/item/ItemStack item Lnet/minecraft/item/Item;", itemStack.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/util/ItemUseResult SUCCESS Lnet/minecraft/util/ItemUseResult;", "net/minecraft/util/ItemUseResult PASS Lnet/minecraft/util/ItemUseResult;", "net/minecraft/util/ItemUseResult FAIL Lnet/minecraft/util/ItemUseResult;"}, depends={"net/minecraft/util/ItemUseResult"})
    public boolean processItemUseResultClass() {
        ClassNode itemUseResult = this.getClassNodeFromMapping("net/minecraft/util/ItemUseResult");
        if (itemUseResult == null) {
            return false;
        }
        List<FieldNode> fields = this.getMatchingFields(itemUseResult, null, "L" + itemUseResult.name + ";");
        if (fields.size() == 3) {
            this.addFieldMapping("net/minecraft/util/ItemUseResult SUCCESS Lnet/minecraft/util/ItemUseResult;", itemUseResult.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
            this.addFieldMapping("net/minecraft/util/ItemUseResult PASS Lnet/minecraft/util/ItemUseResult;", itemUseResult.name + " " + fields.get((int)1).name + " " + fields.get((int)1).desc);
            this.addFieldMapping("net/minecraft/util/ItemUseResult FAIL Lnet/minecraft/util/ItemUseResult;", itemUseResult.name + " " + fields.get((int)2).name + " " + fields.get((int)2).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/item/crafting/CraftingManager", "net/minecraft/entity/passive/EntityAnimal", "net/minecraft/item/EnumDyeColor"}, depends={"net/minecraft/entity/passive/EntitySheep"})
    public boolean getCraftingManagerClass() {
        String enumDyeColor_name;
        ClassNode entitySheep = this.getClassNodeFromMapping("net/minecraft/entity/passive/EntitySheep");
        if (entitySheep == null) {
            return false;
        }
        ArrayList<MethodNode> methods = new ArrayList<MethodNode>();
        for (MethodNode method : entitySheep.methods) {
            Type t;
            Type[] args;
            String className;
            if (!this.checkMethodParameters(method, 10, 10) || !(className = (args = (t = Type.getMethodType((String)method.desc)).getArgumentTypes())[0].getClassName()).equals(args[1].getClassName()) || !className.equals(entitySheep.superName)) continue;
            methods.add(method);
        }
        MethodNode func_175511_a = null;
        if (methods.size() != 1) {
            return false;
        }
        func_175511_a = (MethodNode)methods.get(0);
        if (this.searchConstantPoolForStrings(entitySheep.superName, "InLove")) {
            this.addClassMapping("net/minecraft/entity/passive/EntityAnimal", entitySheep.superName);
        }
        if (this.searchConstantPoolForStrings(enumDyeColor_name = Type.getMethodType((String)func_175511_a.desc).getReturnType().getClassName(), "white", "lime")) {
            this.addClassMapping("net/minecraft/item/EnumDyeColor", enumDyeColor_name);
        }
        for (AbstractInsnNode insn = func_175511_a.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn.getOpcode() != 184) continue;
            MethodInsnNode mn = (MethodInsnNode)insn;
            if (!mn.desc.equals("()L" + mn.owner + ";") || !this.searchConstantPoolForStrings(mn.owner, "###", "AAA")) continue;
            this.addClassMapping("net/minecraft/item/crafting/CraftingManager", mn.owner);
            return true;
        }
        return false;
    }

    @Mapping(provides={"net/minecraft/item/crafting/ShapedRecipes", "net/minecraft/item/crafting/IRecipe", "net/minecraft/item/crafting/ShapelessRecipes"}, providesMethods={"net/minecraft/item/crafting/CraftingManager addRecipe (Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)Lnet/minecraft/item/crafting/ShapedRecipes;", "net/minecraft/item/crafting/CraftingManager addShapelessRecipe (Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)V", "net/minecraft/item/crafting/CraftingManager getInstance ()Lnet/minecraft/item/crafting/CraftingManager;", "net/minecraft/item/crafting/CraftingManager getRecipeList ()Ljava/util/List;", "net/minecraft/item/crafting/CraftingManager addRecipe (Lnet/minecraft/item/crafting/IRecipe;)V"}, depends={"net/minecraft/item/crafting/CraftingManager", "net/minecraft/item/ItemStack"})
    public boolean processCraftingManagerClass() {
        ClassNode craftingManager = this.getClassNodeFromMapping("net/minecraft/item/crafting/CraftingManager");
        ClassNode itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack");
        if (craftingManager == null || itemStack == null) {
            return false;
        }
        List<Object> methods = new ArrayList<MethodNode>();
        for (MethodNode method : craftingManager.methods) {
            if (!method.desc.startsWith("(L" + itemStack.name + ";[Ljava/lang/Object;)L")) continue;
            methods.add(method);
        }
        if (methods.size() != 1) {
            return false;
        }
        String shapedRecipes_className = Type.getMethodType((String)((MethodNode)methods.get((int)0)).desc).getReturnType().getClassName();
        this.addClassMapping("net/minecraft/item/crafting/ShapedRecipes", shapedRecipes_className);
        this.addMethodMapping("net/minecraft/item/crafting/CraftingManager addRecipe (Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)Lnet/minecraft/item/crafting/ShapedRecipes;", craftingManager.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        methods = this.getMatchingMethods(craftingManager, null, "()L" + craftingManager.name + ";");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/item/crafting/CraftingManager getInstance ()Lnet/minecraft/item/crafting/CraftingManager;", craftingManager.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        if ((methods = this.getMatchingMethods(craftingManager, null, "()Ljava/util/List;")).size() == 1) {
            this.addMethodMapping("net/minecraft/item/crafting/CraftingManager getRecipeList ()Ljava/util/List;", craftingManager.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        String iRecipe_name = null;
        methods.clear();
        for (MethodNode method : craftingManager.methods) {
            Type[] args;
            if (!method.desc.startsWith("(L") || !method.desc.endsWith(";)V") || (args = Type.getMethodType((String)method.desc).getArgumentTypes()).length != 1) continue;
            methods.add(method);
        }
        if (methods.size() == 1) {
            MethodNode method = (MethodNode)methods.get(0);
            iRecipe_name = Type.getMethodType((String)method.desc).getArgumentTypes()[0].getClassName();
            ClassNode iRecipe = this.getClassNode(iRecipe_name);
            if ((iRecipe.access & 0x200) != 0) {
                this.addClassMapping("net/minecraft/item/crafting/IRecipe", iRecipe_name);
                this.addMethodMapping("net/minecraft/item/crafting/CraftingManager addRecipe (Lnet/minecraft/item/crafting/IRecipe;)V", craftingManager.name + " " + method.name + " " + method.desc);
            } else {
                iRecipe_name = null;
            }
        }
        if ((methods = this.getMatchingMethods(craftingManager, null, "(L" + itemStack.name + ";[Ljava/lang/Object;)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/item/crafting/CraftingManager addShapelessRecipe (Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)V", craftingManager.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
            if (iRecipe_name != null) {
                List<TypeInsnNode> nodes = this.getAllInsnNodesOfType(((MethodNode)methods.get((int)0)).instructions.getFirst(), TypeInsnNode.class);
                Iterator<TypeInsnNode> it = nodes.iterator();
                while (it.hasNext()) {
                    TypeInsnNode tn = it.next();
                    if (tn.getOpcode() != 187 || tn.desc.startsWith("java/") || tn.desc.equals(itemStack.name)) {
                        it.remove();
                        continue;
                    }
                    ClassNode cn = this.getClassNode(tn.desc);
                    if (this.classHasInterfaces(cn, iRecipe_name)) continue;
                    it.remove();
                }
                if (nodes.size() == 1) {
                    this.addClassMapping("net/minecraft/item/crafting/ShapelessRecipes", nodes.get((int)0).desc);
                }
            }
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/item/crafting/ShapedRecipes recipeWidth I", "net/minecraft/item/crafting/ShapedRecipes recipeHeight I", "net/minecraft/item/crafting/ShapedRecipes recipeItems [Lnet/minecraft/item/ItemStack;", "net/minecraft/item/crafting/ShapedRecipes recipeOutput Lnet/minecraft/item/ItemStack;", "net/minecraft/item/crafting/ShapedRecipes copyIngredientNBT Z"}, depends={"net/minecraft/item/crafting/ShapedRecipes", "net/minecraft/item/ItemStack"})
    public boolean processShapedRecipesClass() {
        ClassNode shapedRecipes = this.getClassNodeFromMapping("net/minecraft/item/crafting/ShapedRecipes");
        ClassNode itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack");
        if (!MeddleUtil.notNull((Object[])new Object[]{shapedRecipes, itemStack})) {
            return false;
        }
        List<FieldNode> fields = this.getMatchingFields(shapedRecipes, null, "I");
        if (fields.size() == 2) {
            this.addFieldMapping("net/minecraft/item/crafting/ShapedRecipes recipeWidth I", shapedRecipes.name + " " + fields.get((int)0).name + " I");
            this.addFieldMapping("net/minecraft/item/crafting/ShapedRecipes recipeHeight I", shapedRecipes.name + " " + fields.get((int)1).name + " I");
        }
        if ((fields = this.getMatchingFields(shapedRecipes, null, "[L" + itemStack.name + ";")).size() == 1) {
            this.addFieldMapping("net/minecraft/item/crafting/ShapedRecipes recipeItems [Lnet/minecraft/item/ItemStack;", shapedRecipes.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        if ((fields = this.getMatchingFields(shapedRecipes, null, "L" + itemStack.name + ";")).size() == 1) {
            this.addFieldMapping("net/minecraft/item/crafting/ShapedRecipes recipeOutput Lnet/minecraft/item/ItemStack;", shapedRecipes.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        if ((fields = this.getMatchingFields(shapedRecipes, null, "Z")).size() == 1) {
            this.addFieldMapping("net/minecraft/item/crafting/ShapedRecipes copyIngredientNBT Z", shapedRecipes.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/item/crafting/ShapelessRecipes recipeOutput Lnet/minecraft/item/ItemStack;", "net/minecraft/item/crafting/ShapelessRecipes recipeItems Ljava/util/List;"}, depends={"net/minecraft/item/crafting/ShapelessRecipes", "net/minecraft/item/ItemStack"})
    public boolean processShapelessRecipesClass() {
        ClassNode shapelessRecipes = this.getClassNodeFromMapping("net/minecraft/item/crafting/ShapelessRecipes");
        ClassNode itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack");
        if (!MeddleUtil.notNull((Object[])new Object[]{shapelessRecipes, itemStack})) {
            return false;
        }
        List<FieldNode> fields = this.getMatchingFields(shapelessRecipes, null, "L" + itemStack.name + ";");
        if (fields.size() == 1) {
            this.addFieldMapping("net/minecraft/item/crafting/ShapelessRecipes recipeOutput Lnet/minecraft/item/ItemStack;", shapelessRecipes.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        if ((fields = this.getMatchingFields(shapelessRecipes, null, "Ljava/util/List;")).size() == 1) {
            this.addFieldMapping("net/minecraft/item/crafting/ShapelessRecipes recipeItems Ljava/util/List;", shapelessRecipes.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/inventory/InventoryCrafting"}, providesMethods={"net/minecraft/item/crafting/IRecipe getRecipeSize ()I", "net/minecraft/item/crafting/IRecipe getRecipeOutput ()Lnet/minecraft/item/ItemStack;", "net/minecraft/item/crafting/IRecipe matches (Lnet/minecraft/inventory/InventoryCrafting;Lnet/minecraft/world/World;)Z", "net/minecraft/item/crafting/IRecipe getCraftingResult (Lnet/minecraft/inventory/InventoryCrafting;)Lnet/minecraft/item/ItemStack;", "net/minecraft/item/crafting/IRecipe getRemainingItems (Lnet/minecraft/inventory/InventoryCrafting;)[Lnet/minecraft/item/ItemStack;"}, depends={"net/minecraft/item/crafting/IRecipe", "net/minecraft/item/ItemStack", "net/minecraft/world/World"})
    public boolean processIRecipeClass() {
        ClassNode world;
        ClassNode itemStack;
        ClassNode iRecipe = this.getClassNodeFromMapping("net/minecraft/item/crafting/IRecipe");
        if (!MeddleUtil.notNull((Object[])new Object[]{iRecipe, itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack"), world = this.getClassNodeFromMapping("net/minecraft/world/World")})) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(iRecipe, null, "()I");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/item/crafting/IRecipe getRecipeSize ()I", iRecipe.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iRecipe, null, "()L" + itemStack.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/item/crafting/IRecipe getRecipeOutput ()Lnet/minecraft/item/ItemStack;", iRecipe.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        methods.clear();
        for (MethodNode method : iRecipe.methods) {
            if (!method.desc.startsWith("(L") || !method.desc.endsWith(";L" + world.name + ";)Z") || Type.getMethodType((String)method.desc).getArgumentTypes().length != 2) continue;
            methods.add(method);
        }
        String inventoryCrafting_name = null;
        if (methods.size() == 1) {
            MethodNode method;
            method = methods.get(0);
            Type t = Type.getMethodType((String)method.desc);
            inventoryCrafting_name = t.getArgumentTypes()[0].getClassName();
            if (this.searchConstantPoolForStrings(inventoryCrafting_name, "container.crafting")) {
                this.addClassMapping("net/minecraft/inventory/InventoryCrafting", inventoryCrafting_name);
                this.addMethodMapping("net/minecraft/item/crafting/IRecipe matches (Lnet/minecraft/inventory/InventoryCrafting;Lnet/minecraft/world/World;)Z", iRecipe.name + " " + method.name + " " + method.desc);
            } else {
                inventoryCrafting_name = null;
            }
        }
        if (inventoryCrafting_name == null) {
            return false;
        }
        methods = this.getMatchingMethods(iRecipe, null, "(L" + inventoryCrafting_name + ";)L" + itemStack.name + ";");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/item/crafting/IRecipe getCraftingResult (Lnet/minecraft/inventory/InventoryCrafting;)Lnet/minecraft/item/ItemStack;", iRecipe.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iRecipe, null, "(L" + inventoryCrafting_name + ";)[L" + itemStack.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/item/crafting/IRecipe getRemainingItems (Lnet/minecraft/inventory/InventoryCrafting;)[Lnet/minecraft/item/ItemStack;", iRecipe.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/init/Items"}, providesMethods={}, depends={"net/minecraft/entity/passive/EntityVillager", "net/minecraft/item/Item"})
    public boolean getInitItemsClass() {
        ClassNode entityVillager = this.getClassNodeFromMapping("net/minecraft/entity/passive/EntityVillager");
        ClassNode item = this.getClassNodeFromMapping("net/minecraft/item/Item");
        if (entityVillager == null || item == null) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(entityVillager, null, "(L" + item.name + ";)Z");
        if (methods.size() != 1) {
            return false;
        }
        for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn.getOpcode() != 178) continue;
            FieldInsnNode fn = (FieldInsnNode)insn;
            if (!fn.desc.equals("L" + item.name + ";") || !this.searchConstantPoolForStrings(fn.owner, "Accessed Items before Bootstrap!", "coal")) continue;
            this.addClassMapping("net/minecraft/init/Items", fn.owner);
            return true;
        }
        return false;
    }

    @Mapping(providesFields={"net/minecraft/init/Items leather Lnet/minecraft/item/Item;", "net/minecraft/init/Items redstone Lnet/minecraft/item/Item;", "net/minecraft/init/Items ender_pearl Lnet/minecraft/item/Item;", "net/minecraft/init/Items iron_ingot Lnet/minecraft/item/Item;", "net/minecraft/init/Items stick Lnet/minecraft/item/Item;", "net/minecraft/init/Items iron_axe Lnet/minecraft/item/Item;", "net/minecraft/init/Items iron_pickaxe Lnet/minecraft/item/Item;"}, depends={"net/minecraft/init/Items", "net/minecraft/item/Item"})
    public boolean discoverItemsFields() {
        HashMap<String, String> itemsClassFields = new HashMap<String, String>();
        HashMap<String, String> itemsFields = new HashMap<String, String>();
        ClassNode itemsClass = this.getClassNode(this.getClassMapping("net/minecraft/init/Items"));
        ClassNode itemClass = this.getClassNode(this.getClassMapping("net/minecraft/item/Item"));
        if (itemsClass == null || itemClass == null) {
            return false;
        }
        for (MethodNode method : itemsClass.methods) {
            if (!method.name.equals("<clinit>")) continue;
            String lastString = null;
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                String s = this.getLdcString(insn);
                if (s != null) {
                    lastString = s;
                }
                if (lastString == null || lastString.contains(" ") || insn.getOpcode() != 179) continue;
                FieldInsnNode fieldNode = (FieldInsnNode)insn;
                if (!fieldNode.desc.startsWith("L") || fieldNode.desc.contains("/")) continue;
                itemsFields.put(lastString, fieldNode.name);
                if (fieldNode.desc.equals("L" + itemClass.name + ";")) continue;
                itemsClassFields.put(lastString, fieldNode.desc.substring(1, fieldNode.desc.length() - 1));
            }
        }
        String fieldName = (String)itemsFields.get("leather");
        if (fieldName != null) {
            this.addFieldMapping("net/minecraft/init/Items leather Lnet/minecraft/item/Item;", itemsClass.name + " " + fieldName + " L" + itemClass.name + ";");
        }
        if ((fieldName = (String)itemsFields.get("redstone")) != null) {
            this.addFieldMapping("net/minecraft/init/Items redstone Lnet/minecraft/item/Item;", itemsClass.name + " " + fieldName + " L" + itemClass.name + ";");
        }
        if ((fieldName = (String)itemsFields.get("ender_pearl")) != null) {
            this.addFieldMapping("net/minecraft/init/Items ender_pearl Lnet/minecraft/item/Item;", itemsClass.name + " " + fieldName + " L" + itemClass.name + ";");
        }
        if ((fieldName = (String)itemsFields.get("iron_ingot")) != null) {
            this.addFieldMapping("net/minecraft/init/Items iron_ingot Lnet/minecraft/item/Item;", itemsClass.name + " " + fieldName + " L" + itemClass.name + ";");
        }
        if ((fieldName = (String)itemsFields.get("stick")) != null) {
            this.addFieldMapping("net/minecraft/init/Items stick Lnet/minecraft/item/Item;", itemsClass.name + " " + fieldName + " L" + itemClass.name + ";");
        }
        if ((fieldName = (String)itemsFields.get("iron_axe")) != null) {
            this.addFieldMapping("net/minecraft/init/Items iron_axe Lnet/minecraft/item/Item;", itemsClass.name + " " + fieldName + " L" + itemClass.name + ";");
        }
        if ((fieldName = (String)itemsFields.get("iron_pickaxe")) != null) {
            this.addFieldMapping("net/minecraft/init/Items iron_pickaxe Lnet/minecraft/item/Item;", itemsClass.name + " " + fieldName + " L" + itemClass.name + ";");
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/command/ServerCommandManager", "net/minecraft/util/DataVersionManager", "net/minecraft/network/NetworkSystem", "net/minecraft/server/management/PlayerProfileCache"}, providesFields={}, providesMethods={"net/minecraft/server/MinecraftServer createNewCommandManager ()Lnet/minecraft/command/ServerCommandManager;"}, depends={"net/minecraft/server/MinecraftServer"})
    public boolean findServerCommandManagerClass() {
        ClassNode minecraftServer = this.getClassNode("net/minecraft/server/MinecraftServer");
        if (minecraftServer == null) {
            return false;
        }
        String serverCommandManager_name = null;
        for (MethodNode method : minecraftServer.methods) {
            Type t;
            Type[] args;
            if (serverCommandManager_name != null && method.desc.equals("()L" + serverCommandManager_name + ";") || !method.name.equals("<init>") || (args = (t = Type.getMethodType((String)method.desc)).getArgumentTypes()).length != 7) continue;
            String className = args[2].getClassName();
            if (this.searchConstantPoolForStrings(className, "DataVersion")) {
                this.addClassMapping("net/minecraft/util/DataVersionManager", className);
            }
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn instanceof MethodInsnNode) {
                    Type mt;
                    Type returnType;
                    MethodInsnNode mn = (MethodInsnNode)insn;
                    if (mn.name.equals("<init>") || (returnType = (mt = Type.getMethodType((String)mn.desc)).getReturnType()).getSort() != 10 || returnType.getClassName().contains(".")) continue;
                    if (this.searchConstantPoolForStrings(returnType.getClassName(), "chat.type.admin", "logAdminCommands")) {
                        serverCommandManager_name = returnType.getClassName();
                        this.addClassMapping("net/minecraft/command/ServerCommandManager", returnType.getClassName());
                        this.addMethodMapping("net/minecraft/server/MinecraftServer createNewCommandManager ()Lnet/minecraft/command/ServerCommandManager;", minecraftServer.name + " " + mn.name + " " + mn.desc);
                        continue;
                    }
                }
                if (!(insn instanceof FieldInsnNode)) continue;
                FieldInsnNode fn = (FieldInsnNode)insn;
                Type ft = Type.getType((String)fn.desc);
                if (ft.getSort() != 10 || (className = ft.getClassName()).contains(".")) continue;
                if (this.searchConstantPoolForStrings(className, "Ticking memory connection", "Failed to handle packet for")) {
                    this.addClassMapping("net/minecraft/network/NetworkSystem", className);
                    continue;
                }
                if (!this.searchConstantPoolForStrings(className, "yyyy-MM-dd HH:mm:ss Z")) continue;
                this.addClassMapping("net/minecraft/server/management/PlayerProfileCache", className);
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/command/CommandHandler", "net/minecraft/command/ICommandManager"}, providesMethods={"net/minecraft/server/MinecraftServer getCommandManager ()Lnet/minecraft/command/ICommandManager;"}, depends={"net/minecraft/command/ServerCommandManager", "net/minecraft/server/MinecraftServer"})
    public boolean processServerCommandManagerClass() {
        ClassNode serverCommandManager = this.getClassNodeFromMapping("net/minecraft/command/ServerCommandManager");
        ClassNode minecraftServer = this.getClassNodeFromMapping("net/minecraft/server/MinecraftServer");
        if (serverCommandManager == null || minecraftServer == null) {
            return false;
        }
        if (serverCommandManager.superName == null) {
            return false;
        }
        if (!this.searchConstantPoolForStrings(serverCommandManager.superName, "commands.generic.notFound", "commands.generic.usage")) {
            return false;
        }
        this.addClassMapping("net/minecraft/command/CommandHandler", serverCommandManager.superName);
        ClassNode commandHandler = this.getClassNode(serverCommandManager.superName);
        if (commandHandler.interfaces.size() != 1) {
            return false;
        }
        String iCommandManager_name = (String)commandHandler.interfaces.get(0);
        this.addClassMapping("net/minecraft/command/ICommandManager", iCommandManager_name);
        List<MethodNode> methods = this.getMatchingMethods(minecraftServer, null, "()L" + iCommandManager_name + ";");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/server/MinecraftServer getCommandManager ()Lnet/minecraft/command/ICommandManager;", minecraftServer.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/command/ICommand"}, providesMethods={"net/minecraft/command/CommandHandler registerCommand (Lnet/minecraft/command/ICommand;)Lnet/minecraft/command/ICommand;"}, depends={"net/minecraft/command/CommandHandler"})
    public boolean processCommandHandlerClass() {
        ClassNode commandHandler = this.getClassNodeFromMapping("net/minecraft/command/CommandHandler");
        if (commandHandler == null) {
            return false;
        }
        ArrayList<MethodNode> methods = new ArrayList<MethodNode>();
        String className = null;
        for (MethodNode method : commandHandler.methods) {
            Type t = Type.getMethodType((String)method.desc);
            Type[] args = t.getArgumentTypes();
            Type returnType = t.getReturnType();
            if (args.length != 1 || args[0].getSort() != 10 || returnType.getSort() != 10 || !args[0].getClassName().equals(returnType.getClassName())) continue;
            methods.add(method);
            className = returnType.getClassName();
        }
        if (methods.size() != 1 || className == null) {
            return false;
        }
        ClassNode iCommand = this.getClassNode(className);
        if (iCommand == null) {
            return false;
        }
        if ((iCommand.access & 0x200) == 0) {
            return false;
        }
        this.addMethodMapping("net/minecraft/command/CommandHandler registerCommand (Lnet/minecraft/command/ICommand;)Lnet/minecraft/command/ICommand;", commandHandler.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        this.addClassMapping("net/minecraft/command/ICommand", iCommand.name);
        return true;
    }

    @Mapping(provides={"net/minecraft/command/ICommandSender", "net/minecraft/command/CommandException"}, providesMethods={"net/minecraft/command/ICommand getCommandName ()Ljava/lang/String;", "net/minecraft/command/ICommand getCommandUsage (Lnet/minecraft/command/ICommandSender;)Ljava/lang/String;", "net/minecraft/command/ICommand getCommandAliases ()Ljava/util/List;", "net/minecraft/command/ICommand processCommand (Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/command/ICommandSender;[Ljava/lang/String;)V", "net/minecraft/command/ICommand canCommandSenderUseCommand (Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/command/ICommandSender;)Z", "net/minecraft/command/ICommand addTabCompletionOptions (Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/command/ICommandSender;[Ljava/lang/String;Lnet/minecraft/util/BlockPos;)Ljava/util/List;", "net/minecraft/command/ICommand isUsernameIndex ([Ljava/lang/String;I)Z"}, depends={"net/minecraft/command/ICommand", "net/minecraft/util/BlockPos", "net/minecraft/server/MinecraftServer"})
    public boolean processICommandClass() {
        ClassNode iCommand = this.getClassNodeFromMapping("net/minecraft/command/ICommand");
        ClassNode blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos");
        ClassNode server = this.getClassNodeFromMapping("net/minecraft/server/MinecraftServer");
        if (iCommand == null || blockPos == null || server == null) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(iCommand, null, "()Ljava/lang/String;");
        if (methods.size() != 1) {
            return false;
        }
        this.addMethodMapping("net/minecraft/command/ICommand getCommandName ()Ljava/lang/String;", iCommand.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        methods.clear();
        String iCommandSender_name = null;
        for (MethodNode method : iCommand.methods) {
            Type t;
            Type[] args;
            if (!method.desc.endsWith(";)Ljava/lang/String;") || (args = (t = Type.getMethodType((String)method.desc)).getArgumentTypes()).length != 1 || args[0].getSort() != 10) continue;
            methods.add(method);
            iCommandSender_name = args[0].getClassName();
        }
        if (methods.size() != 1 || iCommandSender_name == null) {
            return false;
        }
        ClassNode iCommandSender = this.getClassNode(iCommandSender_name);
        if (iCommandSender == null) {
            return false;
        }
        if ((iCommandSender.access & 0x200) == 0) {
            return false;
        }
        this.addClassMapping("net/minecraft/command/ICommandSender", iCommandSender_name);
        this.addMethodMapping("net/minecraft/command/ICommand getCommandUsage (Lnet/minecraft/command/ICommandSender;)Ljava/lang/String;", iCommand.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        methods = this.getMatchingMethods(iCommand, null, "()Ljava/util/List;");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/command/ICommand getCommandAliases ()Ljava/util/List;", iCommand.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iCommand, null, "(L" + server.name + ";L" + iCommandSender.name + ";[Ljava/lang/String;)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/command/ICommand processCommand (Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/command/ICommandSender;[Ljava/lang/String;)V", iCommand.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            if (methods.get((int)0).exceptions.size() == 1) {
                this.addClassMapping("net/minecraft/command/CommandException", (String)methods.get((int)0).exceptions.get(0));
            }
        }
        if ((methods = this.getMatchingMethods(iCommand, null, "(L" + server.name + ";L" + iCommandSender.name + ";)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/command/ICommand canCommandSenderUseCommand (Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/command/ICommandSender;)Z", iCommand.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iCommand, null, "(L" + server.name + ";L" + iCommandSender.name + ";[Ljava/lang/String;L" + blockPos.name + ";)Ljava/util/List;")).size() == 1) {
            this.addMethodMapping("net/minecraft/command/ICommand addTabCompletionOptions (Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/command/ICommandSender;[Ljava/lang/String;Lnet/minecraft/util/BlockPos;)Ljava/util/List;", iCommand.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iCommand, null, "([Ljava/lang/String;I)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/command/ICommand isUsernameIndex ([Ljava/lang/String;I)Z", iCommand.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/command/CommandResultStats", "net/minecraft/command/CommandResultStats$Type"}, providesMethods={"net/minecraft/command/ICommandSender getCommandSenderName ()Ljava/lang/String;", "net/minecraft/command/ICommandSender getDisplayName ()Lnet/minecraft/util/IChatComponent;", "net/minecraft/command/ICommandSender addChatMessage (Lnet/minecraft/util/IChatComponent;)V", "net/minecraft/command/ICommandSender canCommandSenderUseCommand (ILjava/lang/String;)Z", "net/minecraft/command/ICommandSender getPosition ()Lnet/minecraft/util/BlockPos;", "net/minecraft/command/ICommandSender getPositionVector ()Lnet/minecraft/util/Vec3;", "net/minecraft/command/ICommandSender getEntityWorld ()Lnet/minecraft/world/World;", "net/minecraft/command/ICommandSender getCommandSenderEntity ()Lnet/minecraft/entity/Entity;", "net/minecraft/command/ICommandSender sendCommandFeedback ()Z", "net/minecraft/command/ICommandSender setCommandStat (Lnet/minecraft/command/CommandResultStats$Type;I)V"}, depends={"net/minecraft/command/ICommandSender", "net/minecraft/util/IChatComponent", "net/minecraft/util/BlockPos", "net/minecraft/util/Vec3", "net/minecraft/world/World", "net/minecraft/entity/Entity"})
    public boolean processICommandSenderClass() {
        ClassNode entity;
        ClassNode world;
        ClassNode vec3;
        ClassNode blockPos;
        ClassNode iChatComponent;
        ClassNode iCommandSender = this.getClassNodeFromMapping("net/minecraft/command/ICommandSender");
        if (!MeddleUtil.notNull((Object[])new Object[]{iCommandSender, iChatComponent = this.getClassNodeFromMapping("net/minecraft/util/IChatComponent"), blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos"), vec3 = this.getClassNodeFromMapping("net/minecraft/util/Vec3"), world = this.getClassNodeFromMapping("net/minecraft/world/World"), entity = this.getClassNodeFromMapping("net/minecraft/entity/Entity")})) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(iCommandSender, null, "()Ljava/lang/String;");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/command/ICommandSender getCommandSenderName ()Ljava/lang/String;", iCommandSender.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iCommandSender, null, "()L" + iChatComponent.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/command/ICommandSender getDisplayName ()Lnet/minecraft/util/IChatComponent;", iCommandSender.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iCommandSender, null, "(L" + iChatComponent.name + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/command/ICommandSender addChatMessage (Lnet/minecraft/util/IChatComponent;)V", iCommandSender.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iCommandSender, null, "(ILjava/lang/String;)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/command/ICommandSender canCommandSenderUseCommand (ILjava/lang/String;)Z", iCommandSender.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iCommandSender, null, "()L" + blockPos.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/command/ICommandSender getPosition ()Lnet/minecraft/util/BlockPos;", iCommandSender.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iCommandSender, null, "()L" + vec3.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/command/ICommandSender getPositionVector ()Lnet/minecraft/util/Vec3;", iCommandSender.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iCommandSender, null, "()L" + world.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/command/ICommandSender getEntityWorld ()Lnet/minecraft/world/World;", iCommandSender.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iCommandSender, null, "()L" + entity.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/command/ICommandSender getCommandSenderEntity ()Lnet/minecraft/entity/Entity;", iCommandSender.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(iCommandSender, null, "()Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/command/ICommandSender sendCommandFeedback ()Z", iCommandSender.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        String commandResultStatsType_name = null;
        methods.clear();
        for (MethodNode method : iCommandSender.methods) {
            Type t;
            Type[] args;
            if (!method.desc.endsWith(";I)V") || (args = (t = Type.getMethodType((String)method.desc)).getArgumentTypes()).length != 2) continue;
            commandResultStatsType_name = args[0].getClassName();
            methods.add(method);
        }
        if (methods.size() == 1) {
            if (commandResultStatsType_name.contains("$")) {
                String baseName = commandResultStatsType_name.substring(0, commandResultStatsType_name.indexOf(36));
                this.addClassMapping("net/minecraft/command/CommandResultStats", baseName);
            }
            this.addClassMapping("net/minecraft/command/CommandResultStats$Type", commandResultStatsType_name);
            this.addMethodMapping("net/minecraft/command/ICommandSender setCommandStat (Lnet/minecraft/command/CommandResultStats$Type;I)V", iCommandSender.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/entity/player/EntityPlayerMP"}, depends={"net/minecraft/server/MinecraftServer"})
    public boolean getEntityPlayerMPClass() {
        ClassNode server = this.getClassNodeFromMapping("net/minecraft/server/MinecraftServer");
        if (server == null) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(server, null, "()V");
        for (MethodNode method : methods) {
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 192) continue;
                TypeInsnNode tn = (TypeInsnNode)insn;
                if (!this.searchConstantPoolForStrings(tn.desc, "en_US", "playerGameType", "Player being ticked")) continue;
                this.addClassMapping("net/minecraft/entity/player/EntityPlayerMP", tn.desc);
                return true;
            }
        }
        return false;
    }

    @Mapping(provides={"net/minecraft/network/play/server/S2DPacketOpenWindow", "net/minecraft/network/NetHandlerPlayServer", "net/minecraft/inventory/ICrafting"}, providesFields={"net/minecraft/entity/player/EntityPlayer openContainer Lnet/minecraft/inventory/Container;", "net/minecraft/inventory/Container windowId I"}, providesMethods={"net/minecraft/network/NetHandlerPlayServer sendPacket (Lnet/minecraft/network/Packet;)V", "net/minecraft/inventory/Container onCraftGuiOpened (Lnet/minecraft/inventory/ICrafting;)V"}, depends={"net/minecraft/entity/player/EntityPlayerMP", "net/minecraft/entity/player/EntityPlayer", "net/minecraft/world/IInteractionObject", "net/minecraft/network/Packet", "net/minecraft/inventory/Container"})
    public boolean processEntityPlayerMPClass() {
        List<MethodNode> methods;
        String className;
        ClassNode iCrafting;
        ClassNode container;
        ClassNode packet;
        ClassNode iInteractionObject;
        ClassNode player;
        ClassNode playerMP = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayerMP");
        if (!MeddleUtil.notNull((Object[])new Object[]{playerMP, player = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayer"), iInteractionObject = this.getClassNodeFromMapping("net/minecraft/world/IInteractionObject"), packet = this.getClassNodeFromMapping("net/minecraft/network/Packet"), container = this.getClassNodeFromMapping("net/minecraft/inventory/Container")})) {
            return false;
        }
        String iCrafting_name = null;
        if (playerMP.interfaces.size() == 1 && (iCrafting = this.getClassNode(className = (String)playerMP.interfaces.get(0))) != null) {
            boolean matched = true;
            for (MethodNode method : iCrafting.methods) {
                Type t = Type.getMethodType((String)method.desc);
                if (t.getReturnType().getSort() != 0) {
                    matched = false;
                }
                if (t.getArgumentTypes().length < 1) {
                    matched = false;
                }
                if (t.getArgumentTypes()[0].getClassName().equals(container.name)) continue;
                matched = false;
            }
            if (matched) {
                this.addClassMapping("net/minecraft/inventory/ICrafting", iCrafting);
                iCrafting_name = iCrafting.name;
            }
        }
        if ((methods = this.getMatchingMethods(playerMP, null, "(L" + iInteractionObject.name + ";)V")).size() == 1) {
            for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() == 187) {
                    TypeInsnNode tn = (TypeInsnNode)insn;
                    ClassNode cn = this.getClassNode(tn.desc);
                    if (cn == null) continue;
                    for (String iface : cn.interfaces) {
                        if (!iface.equals(packet.name)) continue;
                        this.addClassMapping("net/minecraft/network/play/server/S2DPacketOpenWindow", cn.name);
                    }
                }
                if (insn.getOpcode() == 182) {
                    MethodInsnNode mn = (MethodInsnNode)insn;
                    if (mn.desc.equals("(L" + packet.name + ";)V") && this.searchConstantPoolForStrings(mn.owner, "keepAlive", "Sending packet")) {
                        this.addClassMapping("net/minecraft/network/NetHandlerPlayServer", mn.owner);
                        this.addMethodMapping("net/minecraft/network/NetHandlerPlayServer sendPacket (Lnet/minecraft/network/Packet;)V", mn.owner + " " + mn.name + " " + mn.desc);
                    }
                    if (mn.owner.equals(container.name) && mn.desc.equals("(L" + iCrafting_name + ";)V")) {
                        this.addMethodMapping("net/minecraft/inventory/Container onCraftGuiOpened (Lnet/minecraft/inventory/ICrafting;)V", container.name + " " + mn.name + " " + mn.desc);
                    }
                }
                if (insn.getOpcode() != 181) continue;
                FieldInsnNode fn = (FieldInsnNode)insn;
                if (fn.owner.equals(playerMP.name) && fn.desc.equals("L" + container.name + ";")) {
                    this.addFieldMapping("net/minecraft/entity/player/EntityPlayer openContainer Lnet/minecraft/inventory/Container;", player.name + " " + fn.name + " " + fn.desc);
                }
                if (!fn.owner.equals(container.name) || !fn.desc.equals("I")) continue;
                this.addFieldMapping("net/minecraft/inventory/Container windowId I", container.name + " " + fn.name + " " + fn.desc);
            }
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/util/AxisAlignedBB minX D", "net/minecraft/util/AxisAlignedBB minY D", "net/minecraft/util/AxisAlignedBB minZ D", "net/minecraft/util/AxisAlignedBB maxX D", "net/minecraft/util/AxisAlignedBB maxY D", "net/minecraft/util/AxisAlignedBB maxZ D"}, providesMethods={"net/minecraft/util/AxisAlignedBB offset (Lnet/minecraft/util/BlockPos;)Lnet/minecraft/util/AxisAlignedBB;"}, depends={"net/minecraft/util/AxisAlignedBB", "net/minecraft/util/BlockPos"})
    public boolean processAxisAlignedBBClass() {
        List<MethodNode> methods;
        ClassNode aabb = this.getClassNodeFromMapping("net/minecraft/util/AxisAlignedBB");
        ClassNode blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos");
        if (!MeddleUtil.notNull((Object[])new Object[]{aabb, blockPos})) {
            return false;
        }
        MethodNode toString = DynamicMappings.getMethodNode(aabb, "- toString ()Ljava/lang/String;");
        if (toString == null) {
            return false;
        }
        List<FieldInsnNode> fieldInsns = DynamicMappings.getAllInsnNodesOfType(toString.instructions.getFirst(), FieldInsnNode.class);
        if (fieldInsns.size() == 6) {
            String[] fieldNames = new String[]{"minX", "minY", "minZ", "maxX", "maxY", "maxZ"};
            for (int n = 0; n < 6; ++n) {
                FieldInsnNode fn = fieldInsns.get(n);
                if (!fn.owner.equals(aabb.name)) continue;
                this.addFieldMapping("net/minecraft/util/AxisAlignedBB " + fieldNames[n] + " D", fn.owner + " " + fn.name + " " + fn.desc);
            }
        }
        if ((methods = this.getMatchingMethods(aabb, null, "(L" + blockPos.name + ";)L" + aabb.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/util/AxisAlignedBB offset (Lnet/minecraft/util/BlockPos;)Lnet/minecraft/util/AxisAlignedBB;", aabb.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/util/RegistryNamespaced getIDForObject (Ljava/lang/Object;)I", "net/minecraft/util/RegistryNamespaced getObjectById (I)Ljava/lang/Object;", "net/minecraft/util/RegistryNamespaced containsKey (Ljava/lang/Object;)Z", "net/minecraft/util/RegistryNamespaced register (ILjava/lang/Object;Ljava/lang/Object;)V", "net/minecraft/util/RegistryNamespaced getObject (Ljava/lang/Object;)Ljava/lang/Object;", "net/minecraft/util/RegistryNamespaced getNameForObject (Ljava/lang/Object;)Ljava/lang/Object;"}, depends={"net/minecraft/util/RegistryNamespaced"})
    public boolean processRegistryNamespacedClass() {
        ClassNode registry = this.getClassNodeFromMapping("net/minecraft/util/RegistryNamespaced");
        if (!MeddleUtil.notNull((Object[])new Object[]{registry})) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(registry, null, "(Ljava/lang/Object;)I");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/util/RegistryNamespaced getIDForObject (Ljava/lang/Object;)I", registry.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(registry, null, "(I)Ljava/lang/Object;")).size() == 1) {
            this.addMethodMapping("net/minecraft/util/RegistryNamespaced getObjectById (I)Ljava/lang/Object;", registry.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(registry, null, "(Ljava/lang/Object;)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/util/RegistryNamespaced containsKey (Ljava/lang/Object;)Z", registry.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(registry, null, "(ILjava/lang/Object;Ljava/lang/Object;)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/util/RegistryNamespaced register (ILjava/lang/Object;Ljava/lang/Object;)V", registry.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(registry, null, "(Ljava/lang/Object;)Ljava/lang/Object;")).size() == 2) {
            MethodNode m1 = methods.get(0);
            MethodNode m2 = methods.get(1);
            if (this.matchOpcodeSequence(m1.instructions.getFirst(), 25, 25, 183, 176) && this.matchOpcodeSequence(m2.instructions.getFirst(), 25, 180, 25, 185, 176)) {
                this.addMethodMapping("net/minecraft/util/RegistryNamespaced getObject (Ljava/lang/Object;)Ljava/lang/Object;", registry.name + " " + m1.name + " " + m1.desc);
                this.addMethodMapping("net/minecraft/util/RegistryNamespaced getNameForObject (Ljava/lang/Object;)Ljava/lang/Object;", registry.name + " " + m2.name + " " + m2.desc);
            }
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/util/MainOrOffHand MAIN_HAND Lnet/minecraft/util/MainOrOffHand;", "net/minecraft/util/MainOrOffHand OFF_HAND Lnet/minecraft/util/MainOrOffHand;"}, depends={"net/minecraft/util/MainOrOffHand"})
    public boolean processMainOrOffHand() {
        ClassNode mainOrOffHand = this.getClassNodeFromMapping("net/minecraft/util/MainOrOffHand");
        if (mainOrOffHand == null) {
            return false;
        }
        List<FieldNode> fields = this.getMatchingFields(mainOrOffHand, null, "L" + mainOrOffHand.name + ";");
        if (fields.size() == 2) {
            this.addFieldMapping("net/minecraft/util/MainOrOffHand MAIN_HAND Lnet/minecraft/util/MainOrOffHand;", mainOrOffHand.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
            this.addFieldMapping("net/minecraft/util/MainOrOffHand OFF_HAND Lnet/minecraft/util/MainOrOffHand;", mainOrOffHand.name + " " + fields.get((int)1).name + " " + fields.get((int)1).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/inventory/EnumEquipSlot"}, providesMethods={"net/minecraft/entity/EntityLivingBase getHeldItem (Lnet/minecraft/util/MainOrOffHand;)Lnet/minecraft/item/ItemStack;", "net/minecraft/entity/EntityLivingBase getHeldMainHandItem ()Lnet/minecraft/item/ItemStack;", "net/minecraft/entity/EntityLivingBase getHeldOffHandItem ()Lnet/minecraft/item/ItemStack;", "net/minecraft/entity/EntityLivingBase setHeldItem (Lnet/minecraft/util/MainOrOffHand;Lnet/minecraft/item/ItemStack;)V", "net/minecraft/entity/Entity setPositionAndUpdate (DDD)V"}, depends={"net/minecraft/entity/Entity", "net/minecraft/entity/EntityLivingBase", "net/minecraft/item/ItemStack", "net/minecraft/util/MainOrOffHand"})
    public boolean processEntityLivingBase() {
        ClassNode mainOrOffHand;
        ClassNode itemStack;
        ClassNode entityLivingBase;
        ClassNode entity = this.getClassNodeFromMapping("net/minecraft/entity/Entity");
        if (!MeddleUtil.notNull((Object[])new Object[]{entity, entityLivingBase = this.getClassNodeFromMapping("net/minecraft/entity/EntityLivingBase"), itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack"), mainOrOffHand = this.getClassNodeFromMapping("net/minecraft/util/MainOrOffHand")})) {
            return false;
        }
        String enumEquipSlot_name = null;
        List<MethodNode> methods = this.getMatchingMethods(entityLivingBase, null, "(L" + mainOrOffHand.name + ";)L" + itemStack.name + ";");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/entity/EntityLivingBase getHeldItem (Lnet/minecraft/util/MainOrOffHand;)Lnet/minecraft/item/ItemStack;", entityLivingBase.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            List<MethodInsnNode> nodes = this.getAllInsnNodesOfType(methods.get(0), MethodInsnNode.class);
            for (MethodInsnNode mn : nodes) {
                Type t;
                Type[] args;
                if (!mn.owner.equals(entityLivingBase.name) || !mn.desc.startsWith("(L") || !mn.desc.endsWith(")L" + itemStack.name + ";") || (args = (t = Type.getMethodType((String)mn.desc)).getArgumentTypes()).length != 1) continue;
                String className = args[0].getClassName();
                if (!this.searchConstantPoolForStrings(className, "MAINHAND", "OFFHAND", "FEET", "LEGS")) continue;
                this.addClassMapping("net/minecraft/inventory/EnumEquipSlot", className);
                enumEquipSlot_name = className;
                break;
            }
        }
        methods = this.getMatchingMethods(entityLivingBase, null, "()L" + itemStack.name + ";");
        Iterator<MethodNode> it = methods.iterator();
        while (it.hasNext()) {
            MethodNode method = it.next();
            if (!this.matchOpcodeSequence(method.instructions.getFirst(), 25, 180, 176)) continue;
            it.remove();
        }
        if (methods.size() == 2 && enumEquipSlot_name != null) {
            List<FieldInsnNode> nodes1 = this.getAllInsnNodesOfType(methods.get(0), FieldInsnNode.class);
            List<FieldInsnNode> nodes2 = this.getAllInsnNodesOfType(methods.get(1), FieldInsnNode.class);
            if (nodes1.size() == 1 && nodes2.size() == 1) {
                FieldInsnNode fn1 = nodes1.get(0);
                FieldInsnNode fn2 = nodes2.get(0);
                if (fn1.owner.equals(enumEquipSlot_name) && fn2.owner.equals(enumEquipSlot_name)) {
                    MethodNode main = null;
                    MethodNode off = null;
                    if (fn1.name.equals("a") && fn2.name.equals("b")) {
                        main = methods.get(0);
                        off = methods.get(1);
                    } else if (fn1.name.equals("b") && fn2.name.equals("a")) {
                        main = methods.get(1);
                        off = methods.get(0);
                    }
                    if (main != null && off != null) {
                        this.addMethodMapping("net/minecraft/entity/EntityLivingBase getHeldMainHandItem ()Lnet/minecraft/item/ItemStack;", entityLivingBase.name + " " + main.name + " " + main.desc);
                        this.addMethodMapping("net/minecraft/entity/EntityLivingBase getHeldOffHandItem ()Lnet/minecraft/item/ItemStack;", entityLivingBase.name + " " + off.name + " " + off.desc);
                    }
                }
            }
        }
        if ((methods = this.getMatchingMethods(entityLivingBase, null, "(L" + mainOrOffHand.name + ";L" + itemStack.name + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/entity/EntityLivingBase setHeldItem (Lnet/minecraft/util/MainOrOffHand;Lnet/minecraft/item/ItemStack;)V", entityLivingBase.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(entityLivingBase, null, "(DDD)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/entity/EntityLivingBase teleportTo (DDD)Z", entityLivingBase.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            List<MethodInsnNode> mnodes = this.getAllInsnNodesOfType(methods.get(0), MethodInsnNode.class);
            ArrayList<String> mnames = new ArrayList<String>();
            Iterator<MethodInsnNode> it2 = mnodes.iterator();
            while (it2.hasNext()) {
                MethodInsnNode mn = it2.next();
                if (!mn.owner.equals(entityLivingBase.name) || !mn.desc.equals("(DDD)V")) {
                    it2.remove();
                    continue;
                }
                if (this.getMethodNode(entity, "--- " + mn.name + " (DDD)V") == null) {
                    it2.remove();
                    continue;
                }
                if (mnames.contains(mn.name)) {
                    it2.remove();
                    continue;
                }
                mnames.add(mn.name);
            }
            if (mnodes.size() == 1) {
                this.addMethodMapping("net/minecraft/entity/Entity setPositionAndUpdate (DDD)V", entity.name + " " + mnodes.get((int)0).name + " (DDD)V");
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/block/properties/PropertyInteger"}, providesFields={"net/minecraft/block/BlockLiquid LEVEL Lnet/minecraft/block/properties/PropertyInteger;"}, providesMethods={"net/minecraft/block/Block isPassable (Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;)Z", "net/minecraft/block/Block tickRate (Lnet/minecraft/world/World;)I", "net/minecraft/block/properties/PropertyInteger create (Ljava/lang/String;II)Lnet/minecraft/block/properties/PropertyInteger;"}, depends={"net/minecraft/block/Block", "net/minecraft/block/BlockLiquid", "net/minecraft/world/IBlockAccess", "net/minecraft/util/BlockPos", "net/minecraft/world/World"})
    public boolean processBlockLiquidClass() {
        ClassNode world;
        ClassNode blockPos;
        ClassNode iBlockAccess;
        ClassNode blockLiquid;
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        if (!MeddleUtil.notNull((Object[])new Object[]{block, blockLiquid = this.getClassNodeFromMapping("net/minecraft/block/BlockLiquid"), iBlockAccess = this.getClassNodeFromMapping("net/minecraft/world/IBlockAccess"), blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos"), world = this.getClassNodeFromMapping("net/minecraft/world/World")})) {
            return false;
        }
        MethodNode clinit = this.getMethodNode(blockLiquid, "--- <clinit> ()V");
        if (clinit != null) {
            String className;
            List<FieldInsnNode> fieldNodes = this.getAllInsnNodesOfType(clinit, FieldInsnNode.class);
            List<MethodInsnNode> methodNodes = this.getAllInsnNodesOfType(clinit, MethodInsnNode.class);
            String propertyInteger = null;
            if (fieldNodes.size() == 1 && fieldNodes.get((int)0).owner.equals(blockLiquid.name) && this.searchConstantPoolForStrings(className = Type.getType((String)fieldNodes.get((int)0).desc).getClassName(), "Min value of ", " must be 0 or greater")) {
                this.addClassMapping("net/minecraft/block/properties/PropertyInteger", className);
                propertyInteger = className;
                this.addFieldMapping("net/minecraft/block/BlockLiquid LEVEL Lnet/minecraft/block/properties/PropertyInteger;", blockLiquid.name + " " + fieldNodes.get((int)0).name + " " + fieldNodes.get((int)0).desc);
            }
            if (methodNodes.size() == 1 && propertyInteger != null) {
                MethodInsnNode mn = methodNodes.get(0);
                if (mn.owner.equals(propertyInteger) && mn.desc.equals("(Ljava/lang/String;II)L" + propertyInteger + ";")) {
                    this.addMethodMapping("net/minecraft/block/properties/PropertyInteger create (Ljava/lang/String;II)Lnet/minecraft/block/properties/PropertyInteger;", propertyInteger + " " + mn.name + " " + mn.desc);
                }
            }
        }
        List<MethodNode> methods = this.getMatchingMethods(blockLiquid, null, this.assembleDescriptor("(", iBlockAccess, blockPos, ")Z"));
        Iterator<MethodNode> it = methods.iterator();
        while (it.hasNext()) {
            MethodNode method = it.next();
            if (this.getMethodNode(block, "--- " + method.name + " " + method.desc) != null) continue;
            it.remove();
        }
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block isPassable (Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;)Z", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(blockLiquid, null, this.assembleDescriptor("(", world, ")I"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block tickRate (Lnet/minecraft/world/World;)I", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/block/Block AIR_ID Lnet/minecraft/util/ResourceLocation;"}, providesMethods={"net/minecraft/block/state/IBlockWrapper getMaterial ()Lnet/minecraft/block/material/Material;", "net/minecraft/block/material/Material isSolid ()Z", "net/minecraft/block/Block isFullBlock (Lnet/minecraft/block/state/IBlockState;)Z", "net/minecraft/block/Block getUseNeighborBrightness (Lnet/minecraft/block/state/IBlockState;)Z"}, dependsFields={"net/minecraft/block/Block fullBlock Z", "net/minecraft/block/Block useNeighborBrightness Z"}, dependsMethods={"net/minecraft/block/Block isBlockSolid (Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/EnumFacing;)Z"}, depends={"net/minecraft/block/Block", "net/minecraft/block/state/IBlockState", "net/minecraft/block/state/IBlockWrapper", "net/minecraft/block/material/Material", "net/minecraft/util/ResourceLocation"})
    public boolean processBlockClass4() {
        MethodNode isBlockSolid;
        ClassNode resourceLocation;
        ClassNode material;
        ClassNode iBlockWrapper;
        ClassNode iBlockState;
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        if (!MeddleUtil.notNull((Object[])new Object[]{block, iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState"), iBlockWrapper = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockWrapper"), material = this.getClassNodeFromMapping("net/minecraft/block/material/Material"), resourceLocation = this.getClassNodeFromMapping("net/minecraft/util/ResourceLocation")})) {
            return false;
        }
        String air_id_name = null;
        int count = 0;
        for (FieldNode field : block.fields) {
            if (!field.desc.equals("L" + resourceLocation.name + ";")) continue;
            air_id_name = field.name;
            ++count;
        }
        if (air_id_name != null && count == 1) {
            this.addFieldMapping("net/minecraft/block/Block AIR_ID Lnet/minecraft/util/ResourceLocation;", block.name + " " + air_id_name + " L" + resourceLocation.name + ";");
        }
        if ((isBlockSolid = this.getMethodNodeFromMapping(block, "net/minecraft/block/Block isBlockSolid (Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/EnumFacing;)Z")) != null) {
            List<MethodInsnNode> nodes = this.getAllInsnNodesOfType(isBlockSolid, MethodInsnNode.class);
            ArrayList<MethodInsnNode> getMaterial = new ArrayList<MethodInsnNode>();
            ArrayList<MethodInsnNode> isSolid = new ArrayList<MethodInsnNode>();
            for (MethodInsnNode mn : nodes) {
                if (mn.owner.equals(iBlockState.name) && mn.desc.equals("()L" + material.name + ";")) {
                    getMaterial.add(mn);
                    continue;
                }
                if (!mn.owner.equals(material.name) || !mn.desc.equals("()Z")) continue;
                isSolid.add(mn);
            }
            if (getMaterial.size() == 1) {
                this.addMethodMapping("net/minecraft/block/state/IBlockWrapper getMaterial ()Lnet/minecraft/block/material/Material;", iBlockWrapper.name + " " + ((MethodInsnNode)getMaterial.get((int)0)).name + " " + ((MethodInsnNode)getMaterial.get((int)0)).desc);
            }
            if (isSolid.size() == 1) {
                this.addMethodMapping("net/minecraft/block/material/Material isSolid ()Z", material.name + " " + ((MethodInsnNode)isSolid.get((int)0)).name + " " + ((MethodInsnNode)isSolid.get((int)0)).desc);
            }
        }
        FieldNode fullBlock = this.getFieldNodeFromMapping(block, "net/minecraft/block/Block fullBlock Z");
        FieldNode useNeighborBrightness = this.getFieldNodeFromMapping(block, "net/minecraft/block/Block useNeighborBrightness Z");
        List<MethodNode> methods = this.getMatchingMethods(block, null, "(L" + iBlockState.name + ";)Z");
        if (fullBlock != null && useNeighborBrightness != null) {
            ArrayList<MethodNode> isFullBlock = new ArrayList<MethodNode>();
            ArrayList<MethodNode> getUseNeighborBrightness = new ArrayList<MethodNode>();
            for (MethodNode method : methods) {
                AbstractInsnNode[] nodes = this.getOpcodeSequenceArray(method.instructions.getFirst(), 25, 180, 172);
                if (nodes == null) continue;
                FieldInsnNode fn = (FieldInsnNode)nodes[1];
                if (fn.name.equals(fullBlock.name)) {
                    isFullBlock.add(method);
                    continue;
                }
                if (!fn.name.equals(useNeighborBrightness.name)) continue;
                getUseNeighborBrightness.add(method);
            }
            if (isFullBlock.size() == 1) {
                this.addMethodMapping("net/minecraft/block/Block isFullBlock (Lnet/minecraft/block/state/IBlockState;)Z", block.name + " " + ((MethodNode)isFullBlock.get((int)0)).name + " " + ((MethodNode)isFullBlock.get((int)0)).desc);
            }
            if (getUseNeighborBrightness.size() == 1) {
                this.addMethodMapping("net/minecraft/block/Block getUseNeighborBrightness (Lnet/minecraft/block/state/IBlockState;)Z", block.name + " " + ((MethodNode)getUseNeighborBrightness.get((int)0)).name + " " + ((MethodNode)getUseNeighborBrightness.get((int)0)).desc);
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/stats/StatBase"}, depends={"net/minecraft/stats/StatList"})
    public boolean processStatListClass() {
        ClassNode statList = this.getClassNodeFromMapping("net/minecraft/stats/StatList");
        if (!MeddleUtil.notNull((Object[])new Object[]{statList})) {
            return false;
        }
        String statBase = null;
        for (FieldNode field : statList.fields) {
            Type t;
            if (!field.desc.startsWith("[") || (t = Type.getType((String)field.desc).getElementType()).getSort() != 10) continue;
            String className = t.getClassName();
            if (!this.searchConstantPoolForStrings(className, "Duplicate stat id: \"", "Stat{id=")) continue;
            this.addClassMapping("net/minecraft/stats/StatBase", className);
            statBase = className;
            break;
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/block/Block getItem (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/item/ItemStack;"}, depends={"net/minecraft/block/Block", "net/minecraft/block/BlockFarmland", "net/minecraft/world/World", "net/minecraft/util/BlockPos", "net/minecraft/block/state/IBlockState", "net/minecraft/item/ItemStack"})
    public boolean processBlockFarmlandClass() {
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        ClassNode farmland = this.getClassNodeFromMapping("net/minecraft/block/BlockFarmland");
        ClassNode world = this.getClassNodeFromMapping("net/minecraft/world/World");
        ClassNode blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos");
        ClassNode iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState");
        ClassNode itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack");
        if (!MeddleUtil.notNull((Object[])new Object[]{block, farmland, world, blockPos, iBlockState, itemStack})) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(farmland, null, this.assembleDescriptor("(", world, blockPos, iBlockState, ")", itemStack));
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getItem (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/item/ItemStack;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/block/BlockBush"}, providesMethods={"net/minecraft/block/BlockBush canPlaceBlockOn (Lnet/minecraft/block/state/IBlockState;)Z", "net/minecraft/block/BlockBush canBlockStay (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z"}, depends={"net/minecraft/block/Block", "net/minecraft/block/BlockLilyPad", "net/minecraft/block/BlockMushroom", "net/minecraft/block/BlockTallGrass", "net/minecraft/world/World", "net/minecraft/util/BlockPos", "net/minecraft/block/state/IBlockState", "net/minecraft/item/ItemStack"})
    public boolean processBlockLilypadClass() {
        List<MethodNode> methods;
        ClassNode itemStack;
        ClassNode iBlockState;
        ClassNode blockPos;
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        ClassNode lilypad = this.getClassNodeFromMapping("net/minecraft/block/BlockLilyPad");
        ClassNode mushroom = this.getClassNodeFromMapping("net/minecraft/block/BlockMushroom");
        ClassNode tallGrass = this.getClassNodeFromMapping("net/minecraft/block/BlockTallGrass");
        ClassNode world = this.getClassNodeFromMapping("net/minecraft/world/World");
        if (!MeddleUtil.notNull((Object[])new Object[]{block, lilypad, world, blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos"), iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState"), itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack")})) {
            return false;
        }
        ClassNode blockBush = this.getClassNode(lilypad.superName);
        if (blockBush != null) {
            Set<String> children = DynamicMappings.classesExtendFrom.get(blockBush.name);
            if (children.contains(tallGrass.name) && children.contains(mushroom.name)) {
                this.addClassMapping("net/minecraft/block/BlockBush", blockBush.name);
            } else {
                return false;
            }
        }
        if ((methods = this.getMatchingMethods(lilypad, null, "(L" + iBlockState.name + ";)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/BlockBush canPlaceBlockOn (Lnet/minecraft/block/state/IBlockState;)Z", blockBush.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(lilypad, null, this.assembleDescriptor("(", world, blockPos, iBlockState, ")Z"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/BlockBush canBlockStay (Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z", blockBush.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/util/MovingObjectPosition$MovingObjectType"}, providesFields={"net/minecraft/util/MovingObjectPosition blockPos Lnet/minecraft/util/BlockPos;", "net/minecraft/util/MovingObjectPosition sideHit Lnet/minecraft/util/EnumFacing;", "net/minecraft/util/MovingObjectPosition hitVec Lnet/minecraft/util/Vec3;", "net/minecraft/util/MovingObjectPosition entityHit Lnet/minecraft/entity/Entity;", "net/minecraft/util/MovingObjectPosition typeOfHit Lnet/minecraft/util/MovingObjectPosition$MovingObjectType;", "net/minecraft/util/MovingObjectPosition$MovingObjectType MISS Lnet/minecraft/util/MovingObjectPosition$MovingObjectType;", "net/minecraft/util/MovingObjectPosition$MovingObjectType BLOCK Lnet/minecraft/util/MovingObjectPosition$MovingObjectType;", "net/minecraft/util/MovingObjectPosition$MovingObjectType ENTITY Lnet/minecraft/util/MovingObjectPosition$MovingObjectType;"}, providesMethods={"net/minecraft/util/MovingObjectPosition getBlockPos ()Lnet/minecraft/util/BlockPos;"}, depends={"net/minecraft/util/MovingObjectPosition", "net/minecraft/entity/Entity", "net/minecraft/util/BlockPos", "net/minecraft/util/EnumFacing", "net/minecraft/util/Vec3"})
    public boolean processMovingObjectPositionClass() {
        List<MethodNode> methods;
        String className;
        ClassNode vec3;
        ClassNode enumFacing;
        ClassNode blockPos;
        ClassNode entity;
        ClassNode mop = this.getClassNodeFromMapping("net/minecraft/util/MovingObjectPosition");
        if (!MeddleUtil.notNull((Object[])new Object[]{mop, entity = this.getClassNodeFromMapping("net/minecraft/entity/Entity"), blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos"), enumFacing = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing"), vec3 = this.getClassNodeFromMapping("net/minecraft/util/Vec3")})) {
            return false;
        }
        List<FieldNode> fields = this.getMatchingFields(mop, null, "L" + blockPos.name + ";");
        if (fields.size() == 1) {
            this.addFieldMapping("net/minecraft/util/MovingObjectPosition blockPos Lnet/minecraft/util/BlockPos;", mop.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        if ((fields = this.getMatchingFields(mop, null, "L" + enumFacing.name + ";")).size() == 1) {
            this.addFieldMapping("net/minecraft/util/MovingObjectPosition sideHit Lnet/minecraft/util/EnumFacing;", mop.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        if ((fields = this.getMatchingFields(mop, null, "L" + vec3.name + ";")).size() == 1) {
            this.addFieldMapping("net/minecraft/util/MovingObjectPosition hitVec Lnet/minecraft/util/Vec3;", mop.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        if ((fields = this.getMatchingFields(mop, null, "L" + entity.name + ";")).size() == 1) {
            this.addFieldMapping("net/minecraft/util/MovingObjectPosition entityHit Lnet/minecraft/entity/Entity;", mop.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
        }
        fields = this.getMatchingFields(mop, null, null);
        Iterator<FieldNode> it = fields.iterator();
        while (it.hasNext()) {
            FieldNode fn = it.next();
            Type t = Type.getType((String)fn.desc);
            if (t.getSort() != 10) {
                it.remove();
                continue;
            }
            String className2 = t.getClassName();
            if (!className2.equals(entity.name) && !className2.equals(vec3.name) && !className2.equals(enumFacing.name) && !className2.equals(blockPos.name)) continue;
            it.remove();
        }
        if (fields.size() == 1 && this.searchConstantPoolForStrings(className = Type.getType((String)fields.get((int)0).desc).getClassName(), "MISS", "BLOCK", "ENTITY")) {
            this.addClassMapping("net/minecraft/util/MovingObjectPosition$MovingObjectType", className);
            this.addFieldMapping("net/minecraft/util/MovingObjectPosition typeOfHit Lnet/minecraft/util/MovingObjectPosition$MovingObjectType;", mop.name + " " + fields.get((int)0).name + " " + fields.get((int)0).desc);
            ClassNode mot = this.getClassNode(className);
            if (mot != null) {
                Map<String, FieldInsnNode> enumFields = this.extractEnumFieldsWithNames(mot);
                for (String key : enumFields.keySet()) {
                    if (!key.equals("MISS") && !key.equals("BLOCK") && !key.equals("ENTITY")) continue;
                    this.addFieldMapping("net/minecraft/util/MovingObjectPosition$MovingObjectType " + key + " Lnet/minecraft/util/MovingObjectPosition$MovingObjectType;", mot.name + " " + enumFields.get((Object)key).name + " L" + mot.name + ";");
                }
            }
        }
        if ((methods = this.getMatchingMethods(mop, null, "()L" + blockPos.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/util/MovingObjectPosition getBlockPos ()Lnet/minecraft/util/BlockPos;", mop.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/block/Block hasComparatorInputOverride (Lnet/minecraft/block/state/IBlockState;)Z"}, depends={"net/minecraft/block/Block", "net/minecraft/block/BlockCommandBlock", "net/minecraft/block/state/IBlockState"})
    public boolean processBlockCommandBlockClass() {
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        ClassNode commandBlock = this.getClassNodeFromMapping("net/minecraft/block/BlockCommandBlock");
        ClassNode iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState");
        if (!MeddleUtil.notNull((Object[])new Object[]{block, commandBlock, iBlockState})) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(commandBlock, null, "(L" + iBlockState.name + ";)Z");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block hasComparatorInputOverride (Lnet/minecraft/block/state/IBlockState;)Z", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/util/SoundCategory MASTER Lnet/minecraft/util/SoundCategory;", "net/minecraft/util/SoundCategory MUSIC Lnet/minecraft/util/SoundCategory;", "net/minecraft/util/SoundCategory RECORDS Lnet/minecraft/util/SoundCategory;", "net/minecraft/util/SoundCategory WEATHER Lnet/minecraft/util/SoundCategory;", "net/minecraft/util/SoundCategory BLOCKS Lnet/minecraft/util/SoundCategory;", "net/minecraft/util/SoundCategory HOSTILE Lnet/minecraft/util/SoundCategory;", "net/minecraft/util/SoundCategory NEUTRAL Lnet/minecraft/util/SoundCategory;", "net/minecraft/util/SoundCategory PLAYERS Lnet/minecraft/util/SoundCategory;", "net/minecraft/util/SoundCategory AMBIENT Lnet/minecraft/util/SoundCategory;", "net/minecraft/util/SoundCategory VOICE Lnet/minecraft/util/SoundCategory;"}, depends={"net/minecraft/util/SoundCategory"})
    public boolean processSoundCategoryClass() {
        ClassNode soundCategory = this.getClassNodeFromMapping("net/minecraft/util/SoundCategory");
        if (!MeddleUtil.notNull((Object[])new Object[]{soundCategory})) {
            return false;
        }
        String[] enumNames = new String[]{"MASTER", "MUSIC", "RECORDS", "WEATHER", "BLOCKS", "HOSTILE", "NEUTRAL", "PLAYERS", "AMBIENT", "VOICE"};
        MethodNode clinit = this.getMethodNode(soundCategory, "--- <clinit> ()V");
        if (clinit == null) {
            return false;
        }
        String lastString = null;
        HashMap<String, String> fields = new HashMap<String, String>();
        for (AbstractInsnNode insn = clinit.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            String s = this.getLdcString(insn);
            if (s != null && lastString == null) {
                lastString = s;
                continue;
            }
            if (insn.getOpcode() != 179 || lastString == null) continue;
            FieldInsnNode fn = (FieldInsnNode)insn;
            if (fn.owner.equals(soundCategory.name) && fn.desc.equals("L" + soundCategory.name + ";")) {
                fields.put(lastString, fn.name);
            }
            lastString = null;
        }
        if (enumNames.length == fields.size()) {
            for (String enumName : enumNames) {
                String fieldName = (String)fields.get(enumName);
                if (fieldName == null) continue;
                this.addFieldMapping("net/minecraft/util/SoundCategory " + enumName + " Lnet/minecraft/util/SoundCategory;", soundCategory.name + " " + fieldName + " L" + soundCategory.name + ";");
            }
        }
        return true;
    }
}

