/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.dynamicmappings.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fybertech.dynamicmappings.DynamicMappings;
import net.fybertech.dynamicmappings.Mapping;
import net.fybertech.dynamicmappings.MappingsClass;
import net.fybertech.dynamicmappings.mappers.MappingsBase;
import net.fybertech.meddle.MeddleUtil;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

@MappingsClass(clientSide=true)
public class ClientMappings
extends MappingsBase {
    @Mapping(provides={"net/minecraft/client/main/Main"})
    public boolean getMainClass() {
        ClassNode main = this.getClassNode("net/minecraft/client/main/Main");
        if (main == null) {
            return false;
        }
        this.addClassMapping("net/minecraft/client/main/Main", main);
        return true;
    }

    @Mapping(provides={"net/minecraft/client/Minecraft", "net/minecraft/client/main/GameConfiguration"}, depends={"net/minecraft/client/main/Main"})
    public boolean getMinecraftClass() {
        ClassNode main = this.getClassNodeFromMapping("net/minecraft/client/main/Main");
        if (main == null) {
            return false;
        }
        List<MethodNode> methods = DynamicMappings.getMatchingMethods(main, "main", "([Ljava/lang/String;)V");
        if (methods.size() != 1) {
            return false;
        }
        MethodNode mainMethod = methods.get(0);
        String minecraftClassName = null;
        String gameConfigClassName = null;
        boolean confirmed = false;
        for (AbstractInsnNode insn = mainMethod.instructions.getLast(); insn != null; insn = insn.getPrevious()) {
            MethodInsnNode mn;
            if (insn.getOpcode() == 182) {
                mn = (MethodInsnNode)insn;
                minecraftClassName = mn.owner;
                continue;
            }
            if (insn.getOpcode() == 183) {
                mn = (MethodInsnNode)insn;
                if (minecraftClassName == null || !mn.owner.equals(minecraftClassName)) {
                    return false;
                }
                Type t = Type.getMethodType((String)mn.desc);
                Type[] args = t.getArgumentTypes();
                if (args.length != 1) {
                    return false;
                }
                gameConfigClassName = args[0].getClassName();
                continue;
            }
            if (insn.getOpcode() != 187) continue;
            TypeInsnNode vn = (TypeInsnNode)insn;
            if (minecraftClassName == null || !vn.desc.equals(minecraftClassName)) continue;
            confirmed = true;
            break;
        }
        if (confirmed) {
            this.addClassMapping("net/minecraft/client/Minecraft", this.getClassNode(minecraftClassName));
            this.addClassMapping("net/minecraft/client/main/GameConfiguration", this.getClassNode(gameConfigClassName));
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Mapping(provides={"net/minecraft/world/WorldSettings", "net/minecraft/server/integrated/IntegratedServer", "net/minecraft/client/multiplayer/WorldClient"}, providesFields={"net/minecraft/client/Minecraft theWorld Lnet/minecraft/client/multiplayer/WorldClient;"}, providesMethods={"net/minecraft/client/Minecraft getMinecraft ()Lnet/minecraft/client/Minecraft;", "net/minecraft/client/Minecraft getRenderItem ()Lnet/minecraft/client/renderer/entity/RenderItem;", "net/minecraft/client/Minecraft refreshResources ()V", "net/minecraft/client/Minecraft launchIntegratedServer (Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/world/WorldSettings;)V", "net/minecraft/client/Minecraft getIntegratedServer ()Lnet/minecraft/server/integrated/IntegratedServer;", "net/minecraft/client/Minecraft getTextureMapBlocks ()Lnet/minecraft/client/renderer/texture/TextureMap;"}, depends={"net/minecraft/client/Minecraft", "net/minecraft/client/renderer/entity/RenderItem", "net/minecraft/world/World", "net/minecraft/client/renderer/texture/TextureMap"})
    public boolean processMinecraftClass() {
        ClassNode textureMap;
        ClassNode world;
        ClassNode renderItem;
        ClassNode minecraft = this.getClassNodeFromMapping("net/minecraft/client/Minecraft");
        if (!MeddleUtil.notNull((Object[])new Object[]{minecraft, renderItem = this.getClassNodeFromMapping("net/minecraft/client/renderer/entity/RenderItem"), world = this.getClassNodeFromMapping("net/minecraft/world/World"), textureMap = this.getClassNodeFromMapping("net/minecraft/client/renderer/texture/TextureMap")})) {
            return false;
        }
        HashSet<String> fieldClasses = new HashSet<String>();
        for (FieldNode field : minecraft.fields) {
            if (!field.desc.startsWith("L")) continue;
            Type t = Type.getType((String)field.desc);
            fieldClasses.add(t.getClassName());
        }
        List<MethodNode> methods = DynamicMappings.getMatchingMethods(minecraft, null, "()L" + minecraft.name + ";");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/client/Minecraft getMinecraft ()Lnet/minecraft/client/Minecraft;", minecraft.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = DynamicMappings.getMatchingMethods(minecraft, null, "()L" + renderItem.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/client/Minecraft getRenderItem ()Lnet/minecraft/client/renderer/entity/RenderItem;", minecraft.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        boolean found = false;
        methods = DynamicMappings.getMatchingMethods(minecraft, null, "()V");
        for (MethodNode methodNode : methods) {
            for (AbstractInsnNode insn = methodNode.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (!DynamicMappings.isLdcWithString(insn, "Caught error stitching, removing all assigned resourcepacks")) continue;
                this.addMethodMapping("net/minecraft/client/Minecraft refreshResources ()V", minecraft.name + " " + methodNode.name + " ()V");
                found = true;
            }
            if (!found) continue;
            break;
        }
        String integratedServer_name = null;
        methods.clear();
        for (MethodNode method : minecraft.methods) {
            if (!DynamicMappings.checkMethodParameters(method, 10, 10, 10) || Type.getMethodType((String)method.desc).getReturnType().getSort() != 0 || !method.desc.startsWith("(Ljava/lang/String;Ljava/lang/String;L")) continue;
            methods.add(method);
        }
        if (methods.size() == 1) {
            MethodNode methodNode = methods.get(0);
            Type t = Type.getMethodType((String)methodNode.desc);
            String worldSettings = t.getArgumentTypes()[2].getClassName();
            this.addClassMapping("net/minecraft/world/WorldSettings", worldSettings);
            this.addMethodMapping("net/minecraft/client/Minecraft launchIntegratedServer (Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/world/WorldSettings;)V", minecraft.name + " " + methodNode.name + " " + methodNode.desc);
            for (AbstractInsnNode insn = methodNode.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 187) continue;
                TypeInsnNode tn = (TypeInsnNode)insn;
                if (!DynamicMappings.searchConstantPoolForStrings(tn.desc, "saves", "Generating keypair", "Saving and pausing game...")) continue;
                integratedServer_name = tn.desc;
                this.addClassMapping("net/minecraft/server/integrated/IntegratedServer", tn.desc);
                break;
            }
        }
        if (integratedServer_name != null && (methods = DynamicMappings.getMatchingMethods(minecraft, null, "()L" + integratedServer_name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/client/Minecraft getIntegratedServer ()Lnet/minecraft/server/integrated/IntegratedServer;", minecraft.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        Object var10_14 = null;
        methods = DynamicMappings.getMatchingMethods(minecraft, null, "(I)V");
        for (MethodNode method : methods) {
            void var10_15;
            List<FieldInsnNode> fieldNodes = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), FieldInsnNode.class);
            String theWorld_name = null;
            int count = 0;
            for (FieldInsnNode f : fieldNodes) {
                if (!f.desc.startsWith("L") || !f.owner.equals(minecraft.name)) continue;
                String className = Type.getType((String)f.desc).getClassName();
                if (var10_15 == null) {
                    ClassNode cn = this.getClassNode(className);
                    if (cn == null) continue;
                    if (cn.superName.equals(world.name) && DynamicMappings.searchConstantPoolForStrings(className, "MpServer", "doDaylightCycle", "Quitting")) {
                        this.addClassMapping("net/minecraft/client/multiplayer/WorldClient", className);
                        ClassNode classNode = cn;
                    }
                }
                if (var10_15 == null || !var10_15.name.equals(className)) continue;
                if (theWorld_name == null) {
                    theWorld_name = f.name;
                    ++count;
                    continue;
                }
                if (theWorld_name.equals(f.name)) continue;
                ++count;
            }
            if (count != true) continue;
            this.addFieldMapping("net/minecraft/client/Minecraft theWorld Lnet/minecraft/client/multiplayer/WorldClient;", minecraft.name + " " + theWorld_name + " L" + var10_15.name + ";");
        }
        methods = DynamicMappings.getMatchingMethods(minecraft, null, "()L" + textureMap.name + ";");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/client/Minecraft getTextureMapBlocks ()Lnet/minecraft/client/renderer/texture/TextureMap;", minecraft.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/client/renderer/entity/RenderItem getItemModelMesher ()Lnet/minecraft/client/renderer/ItemModelMesher;"}, depends={"net/minecraft/client/renderer/entity/RenderItem", "net/minecraft/client/renderer/ItemModelMesher"})
    public boolean parseRenderItemClass() {
        ClassNode renderItem = this.getClassNodeFromMapping("net/minecraft/client/renderer/entity/RenderItem");
        ClassNode modelMesher = this.getClassNodeFromMapping("net/minecraft/client/renderer/ItemModelMesher");
        if (renderItem == null || modelMesher == null) {
            return false;
        }
        List<MethodNode> methods = DynamicMappings.getMatchingMethods(renderItem, null, "()L" + modelMesher.name + ";");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/client/renderer/entity/RenderItem getItemModelMesher ()Lnet/minecraft/client/renderer/ItemModelMesher;", renderItem.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/client/renderer/entity/RenderItem"}, depends={"net/minecraft/client/Minecraft"})
    public boolean getRenderItemClass() {
        ClassNode minecraft = this.getClassNodeFromMapping("net/minecraft/client/Minecraft");
        if (minecraft == null) {
            return false;
        }
        for (MethodNode method : minecraft.methods) {
            String className;
            Type t = Type.getMethodType((String)method.desc);
            if (t.getArgumentTypes().length != 0 || t.getReturnType().getSort() != 10 || (className = t.getReturnType().getClassName()).contains(".") || !DynamicMappings.searchConstantPoolForStrings(className, "textures/misc/enchanted_item_glint.png", "Rendering item")) continue;
            this.addClassMapping("net/minecraft/client/renderer/entity/RenderItem", this.getClassNode(className));
            return true;
        }
        return false;
    }

    @Mapping(provides={"net/minecraft/client/renderer/ItemModelMesher"}, depends={"net/minecraft/client/renderer/entity/RenderItem"})
    public boolean getItemModelMesherClass() {
        ClassNode renderItem = this.getClassNodeFromMapping("net/minecraft/client/renderer/entity/RenderItem");
        if (renderItem == null) {
            return false;
        }
        MethodNode initMethod = null;
        int count = 0;
        for (MethodNode method : renderItem.methods) {
            if (!method.name.equals("<init>") || !DynamicMappings.checkMethodParameters(method, 10, 10, 10)) continue;
            ++count;
            initMethod = method;
        }
        if (count != 1) {
            return false;
        }
        Type t = Type.getMethodType((String)initMethod.desc);
        Type[] args = t.getArgumentTypes();
        String className = null;
        count = 0;
        for (AbstractInsnNode insn = initMethod.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn.getOpcode() != 187) continue;
            TypeInsnNode tn = (TypeInsnNode)insn;
            className = tn.desc;
            ++count;
        }
        if (count != 1 || className == null) {
            return false;
        }
        this.addClassMapping("net/minecraft/client/renderer/ItemModelMesher", this.getClassNode(className));
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/client/Minecraft startGame ()V", "net/minecraft/client/Minecraft getBlockRendererDispatcher ()Lnet/minecraft/client/renderer/BlockRendererDispatcher;"}, provides={"net/minecraft/client/gui/GuiMainMenu", "net/minecraft/client/gui/GuiIngame", "net/minecraft/client/multiplayer/GuiConnecting", "net/minecraft/client/renderer/RenderGlobal", "net/minecraft/client/renderer/BlockRendererDispatcher", "net/minecraft/client/renderer/texture/TextureMap"}, depends={"net/minecraft/client/Minecraft"})
    public boolean processMinecraftClass2() {
        ClassNode minecraft = this.getClassNodeFromMapping("net/minecraft/client/Minecraft");
        if (minecraft == null) {
            return false;
        }
        ArrayList<String> postStartupClasses = new ArrayList<String>();
        ArrayList<String> startupClasses = new ArrayList<String>();
        List<MethodNode> methods = DynamicMappings.getMatchingMethods(minecraft, null, "()V");
        boolean foundMethod = false;
        for (MethodNode method : methods) {
            boolean foundLWJGLVersion = false;
            boolean foundPostStartup = false;
            boolean foundStartup = false;
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                TypeInsnNode tn;
                if (!foundLWJGLVersion && !DynamicMappings.isLdcWithString(insn, "LWJGL Version: ")) continue;
                foundLWJGLVersion = true;
                if (!foundStartup && !DynamicMappings.isLdcWithString(insn, "Startup")) continue;
                foundStartup = true;
                foundMethod = true;
                this.addMethodMapping("net/minecraft/client/Minecraft startGame ()V", minecraft.name + " " + method.name + " ()V");
                if (foundStartup && !foundPostStartup && insn.getOpcode() == 187) {
                    tn = (TypeInsnNode)insn;
                    startupClasses.add(tn.desc);
                }
                if (!foundPostStartup && !DynamicMappings.isLdcWithString(insn, "Post startup")) continue;
                foundPostStartup = true;
                if (insn.getOpcode() != 187) continue;
                tn = (TypeInsnNode)insn;
                postStartupClasses.add(tn.desc);
            }
            if (!foundMethod) continue;
            break;
        }
        String guiIngame = null;
        String guiConnecting = null;
        String guiMainMenu = null;
        Object loadingScreenRenderer = null;
        for (String className : postStartupClasses) {
            if (guiIngame == null && DynamicMappings.searchConstantPoolForStrings(className, "textures/misc/vignette.png", "bossHealth")) {
                guiIngame = className;
                continue;
            }
            if (guiConnecting == null && DynamicMappings.searchConstantPoolForStrings(className, "Connecting to", "connect.connecting")) {
                guiConnecting = className;
                continue;
            }
            if (guiMainMenu != null || !DynamicMappings.searchConstantPoolForStrings(className, "texts/splashes.txt", "Merry X-mas!")) continue;
            guiMainMenu = className;
        }
        String renderGlobal = null;
        String blockRendererDispatcher = null;
        String textureMap = null;
        for (String className : startupClasses) {
            if (textureMap == null && DynamicMappings.searchConstantPoolForStrings(className, "missingno", "textures/atlas/blocks.png")) {
                textureMap = className;
                continue;
            }
            if (renderGlobal == null && DynamicMappings.searchConstantPoolForStrings(className, "textures/environment/moon_phases.png", "Exception while adding particle")) {
                renderGlobal = className;
                continue;
            }
            if (blockRendererDispatcher != null || !DynamicMappings.searchConstantPoolForStrings(className, "Tesselating block in world", "Block being tesselated")) continue;
            blockRendererDispatcher = className;
        }
        if (textureMap != null) {
            this.addClassMapping("net/minecraft/client/renderer/texture/TextureMap", textureMap);
        }
        if (blockRendererDispatcher != null) {
            this.addClassMapping("net/minecraft/client/renderer/BlockRendererDispatcher", blockRendererDispatcher);
            methods = this.getMatchingMethods(minecraft, null, "()L" + blockRendererDispatcher + ";");
            if (methods.size() == 1) {
                this.addMethodMapping("net/minecraft/client/Minecraft getBlockRendererDispatcher ()Lnet/minecraft/client/renderer/BlockRendererDispatcher;", minecraft.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            }
        }
        if (guiMainMenu != null) {
            this.addClassMapping("net/minecraft/client/gui/GuiMainMenu", guiMainMenu);
        }
        if (guiIngame != null) {
            this.addClassMapping("net/minecraft/client/gui/GuiIngame", guiIngame);
        }
        if (guiConnecting != null) {
            this.addClassMapping("net/minecraft/client/multiplayer/GuiConnecting", guiConnecting);
        }
        if (renderGlobal != null) {
            this.addClassMapping("net/minecraft/client/renderer/RenderGlobal", renderGlobal);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/client/resources/model/ModelResourceLocation"}, depends={"net/minecraft/item/Item", "net/minecraft/client/renderer/ItemModelMesher"})
    public boolean getModelResourceLocationClass() {
        ClassNode itemModelMesher;
        ClassNode item = this.getClassNodeFromMapping("net/minecraft/item/Item");
        if (!MeddleUtil.notNull((Object[])new Object[]{item, itemModelMesher = this.getClassNodeFromMapping("net/minecraft/client/renderer/ItemModelMesher")})) {
            return false;
        }
        for (MethodNode method : itemModelMesher.methods) {
            Type t;
            if (!DynamicMappings.checkMethodParameters(method, 10, 5, 10) || !(t = Type.getMethodType((String)method.desc)).getArgumentTypes()[0].getClassName().equals(item.name)) continue;
            this.addClassMapping("net/minecraft/client/resources/model/ModelResourceLocation", this.getClassNode(t.getArgumentTypes()[2].getClassName()));
            return true;
        }
        return false;
    }

    @Mapping(providesMethods={"net/minecraft/client/renderer/ItemModelMesher register (Lnet/minecraft/item/Item;ILnet/minecraft/client/resources/model/ModelResourceLocation;)V"}, depends={"net/minecraft/item/Item", "net/minecraft/client/renderer/ItemModelMesher", "net/minecraft/client/resources/model/ModelResourceLocation"})
    public boolean parseItemModelMesherClass() {
        ClassNode item = this.getClassNodeFromMapping("net/minecraft/item/Item");
        ClassNode modelMesher = this.getClassNodeFromMapping("net/minecraft/client/renderer/ItemModelMesher");
        ClassNode modelResLoc = this.getClassNodeFromMapping("net/minecraft/client/resources/model/ModelResourceLocation");
        if (item == null || modelMesher == null || modelResLoc == null) {
            return false;
        }
        List<MethodNode> methods = DynamicMappings.getMatchingMethods(modelMesher, null, "(L" + item.name + ";IL" + modelResLoc.name + ";)V");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/client/renderer/ItemModelMesher register (Lnet/minecraft/item/Item;ILnet/minecraft/client/resources/model/ModelResourceLocation;)V", modelMesher.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/client/gui/Gui", "net/minecraft/client/gui/GuiScreen", "net/minecraft/client/gui/GuiYesNoCallback"}, depends={"net/minecraft/client/gui/GuiMainMenu"})
    public boolean findGuiStuff() {
        ClassNode guiMainMenu = this.getClassNodeFromMapping("net/minecraft/client/gui/GuiMainMenu");
        if (guiMainMenu == null || guiMainMenu.superName == null) {
            return false;
        }
        ClassNode guiScreen = null;
        String guiScreenName = null;
        if (DynamicMappings.searchConstantPoolForStrings(guiMainMenu.superName, "Invalid Item!", "java.awt.Desktop")) {
            guiScreenName = guiMainMenu.superName;
            guiScreen = this.getClassNode(guiScreenName);
            this.addClassMapping("net/minecraft/client/gui/GuiScreen", guiScreenName);
        }
        if (guiScreen == null || guiScreen.superName == null) {
            return false;
        }
        if (guiScreen.interfaces.size() == 1) {
            this.addClassMapping("net/minecraft/client/gui/GuiYesNoCallback", (String)guiScreen.interfaces.get(0));
        }
        if (DynamicMappings.searchConstantPoolForStrings(guiScreen.superName, "textures/gui/options_background.png", "textures/gui/icons.png")) {
            this.addClassMapping("net/minecraft/client/gui/Gui", guiScreen.superName);
        }
        return true;
    }

    private boolean verifyGuiButtonClass(String className) {
        String soundClick = this.getSoundFieldFull("ui.button.click");
        return this.searchConstantPoolForStrings(className, "textures/gui/widgets.png") && this.searchConstantPoolForFields(className, soundClick);
    }

    @Mapping(provides={"net/minecraft/client/gui/FontRenderer", "net/minecraft/client/gui/GuiButton"}, providesFields={"net/minecraft/client/gui/GuiScreen mc Lnet/minecraft/client/Minecraft;", "net/minecraft/client/gui/GuiScreen itemRender Lnet/minecraft/client/renderer/entity/RenderItem;", "net/minecraft/client/gui/GuiScreen width I", "net/minecraft/client/gui/GuiScreen height I", "net/minecraft/client/gui/GuiScreen fontRendererObj Lnet/minecraft/client/gui/FontRenderer;", "net/minecraft/client/gui/GuiScreen buttonList Ljava/util/List;"}, providesMethods={"net/minecraft/client/Minecraft displayGuiScreen (Lnet/minecraft/client/gui/GuiScreen;)V", "net/minecraft/client/gui/GuiScreen setWorldAndResolution (Lnet/minecraft/client/Minecraft;II)V", "net/minecraft/client/gui/GuiScreen initGui ()V", "net/minecraft/client/gui/GuiScreen drawScreen (IIF)V", "net/minecraft/client/gui/GuiScreen keyTyped (CI)V", "net/minecraft/client/gui/GuiScreen mouseClicked (III)V", "net/minecraft/client/gui/GuiScreen mouseReleased (III)V", "net/minecraft/client/gui/GuiScreen onResize (Lnet/minecraft/client/Minecraft;II)V", "net/minecraft/client/gui/GuiScreen actionPerformed (Lnet/minecraft/client/gui/GuiButton;)V", "net/minecraft/client/gui/GuiScreen drawDefaultBackground ()V", "net/minecraft/client/gui/GuiScreen drawWorldBackground (I)V"}, dependsFields={"net/minecraft/init/Sounds ui_button_click Lnet/minecraft/util/Sound;"}, depends={"net/minecraft/client/gui/GuiScreen", "net/minecraft/client/Minecraft", "net/minecraft/client/renderer/entity/RenderItem"})
    public boolean processGuiScreenClass() {
        Iterator<MethodNode> it;
        FieldInsnNode fn;
        ClassNode guiScreen = this.getClassNodeFromMapping("net/minecraft/client/gui/GuiScreen");
        ClassNode minecraft = this.getClassNodeFromMapping("net/minecraft/client/Minecraft");
        ClassNode renderItem = this.getClassNodeFromMapping("net/minecraft/client/renderer/entity/RenderItem");
        if (guiScreen == null || minecraft == null || renderItem == null) {
            return false;
        }
        List<MethodNode> methods = DynamicMappings.getMatchingMethods(minecraft, null, "(L" + guiScreen.name + ";)V");
        if (methods.size() != 1) {
            return false;
        }
        MethodNode displayGuiScreen = methods.get(0);
        this.addMethodMapping("net/minecraft/client/Minecraft displayGuiScreen (Lnet/minecraft/client/gui/GuiScreen;)V", minecraft.name + " " + displayGuiScreen.name + " " + displayGuiScreen.desc);
        String setWorldAndResolutionName = null;
        String setWorldAndResolutionDesc = "(L" + minecraft.name + ";II)V";
        for (AbstractInsnNode insn = displayGuiScreen.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (!(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode mn = (MethodInsnNode)insn;
            if (!mn.owner.equals(guiScreen.name) || !mn.desc.equals(setWorldAndResolutionDesc)) continue;
            setWorldAndResolutionName = mn.name;
            break;
        }
        if (setWorldAndResolutionName == null) {
            return false;
        }
        this.addMethodMapping("net/minecraft/client/gui/GuiScreen setWorldAndResolution (Lnet/minecraft/client/Minecraft;II)V", guiScreen.name + " " + setWorldAndResolutionName + " " + setWorldAndResolutionDesc);
        methods = DynamicMappings.getMatchingMethods(guiScreen, setWorldAndResolutionName, setWorldAndResolutionDesc);
        MethodNode setWorldAndResolution = methods.get(0);
        if (setWorldAndResolution == null) {
            return false;
        }
        AbstractInsnNode prevInsn = null;
        ArrayList<FieldInsnNode> unknownFields = new ArrayList<FieldInsnNode>();
        ArrayList<FieldInsnNode> unknownListFields = new ArrayList<FieldInsnNode>();
        ArrayList<MethodInsnNode> unknownVoidMethods = new ArrayList<MethodInsnNode>();
        for (AbstractInsnNode insn = setWorldAndResolution.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            FieldInsnNode fn2;
            if (insn.getOpcode() == 181) {
                fn2 = (FieldInsnNode)insn;
                if (fn2.desc.equals("L" + minecraft.name + ";")) {
                    this.addFieldMapping("net/minecraft/client/gui/GuiScreen mc Lnet/minecraft/client/Minecraft;", guiScreen.name + " " + fn2.name + " " + fn2.desc);
                } else if (fn2.desc.equals("L" + renderItem.name + ";")) {
                    this.addFieldMapping("net/minecraft/client/gui/GuiScreen itemRender Lnet/minecraft/client/renderer/entity/RenderItem;", renderItem.name + " " + fn2.name + " " + fn2.desc);
                } else if (fn2.desc.equals("I")) {
                    if (prevInsn.getOpcode() == 21) {
                        VarInsnNode vn = (VarInsnNode)prevInsn;
                        if (vn.var == 2) {
                            this.addFieldMapping("net/minecraft/client/gui/GuiScreen width I", guiScreen.name + " " + fn2.name + " I");
                        } else if (vn.var == 3) {
                            this.addFieldMapping("net/minecraft/client/gui/GuiScreen height I", guiScreen.name + " " + fn2.name + " I");
                        }
                    }
                } else if (fn2.desc.startsWith("L")) {
                    unknownFields.add(fn2);
                }
            } else if (insn.getOpcode() == 180) {
                fn2 = (FieldInsnNode)insn;
                if (fn2.desc.equals("Ljava/util/List;")) {
                    unknownListFields.add(fn2);
                }
            } else if (insn.getOpcode() == 182) {
                MethodInsnNode mn = (MethodInsnNode)insn;
                if (mn.desc.equals("()V")) {
                    unknownVoidMethods.add(mn);
                }
            }
            prevInsn = insn;
        }
        if (unknownFields.size() == 1) {
            fn = (FieldInsnNode)unknownFields.get(0);
            Type t = Type.getType((String)fn.desc);
            String fontRendererName = t.getClassName();
            if (DynamicMappings.searchConstantPoolForStrings(fontRendererName, "0123456789abcdef")) {
                this.addFieldMapping("net/minecraft/client/gui/GuiScreen fontRendererObj Lnet/minecraft/client/gui/FontRenderer;", guiScreen.name + " " + fn.name + " " + fn.desc);
                this.addClassMapping("net/minecraft/client/gui/FontRenderer", fontRendererName);
            }
        }
        if (unknownListFields.size() == 1) {
            fn = (FieldInsnNode)unknownListFields.get(0);
            this.addFieldMapping("net/minecraft/client/gui/GuiScreen buttonList Ljava/util/List;", guiScreen.name + " " + fn.name + " " + fn.desc);
        }
        if (unknownVoidMethods.size() == 1) {
            MethodInsnNode mn = (MethodInsnNode)unknownVoidMethods.get(0);
            this.addMethodMapping("net/minecraft/client/gui/GuiScreen initGui ()V", guiScreen.name + " " + mn.name + " ()V");
        }
        String drawScreenMethodName = null;
        methods = DynamicMappings.getMatchingMethods(guiScreen, null, "(IIF)V");
        if (methods.size() == 1) {
            drawScreenMethodName = methods.get((int)0).name;
            this.addMethodMapping("net/minecraft/client/gui/GuiScreen drawScreen (IIF)V", guiScreen.name + " " + drawScreenMethodName + " (IIF)V");
        }
        if (drawScreenMethodName == null) {
            return false;
        }
        methods = DynamicMappings.getMatchingMethods(guiScreen, null, "(CI)V");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/GuiScreen keyTyped (CI)V", guiScreen.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        String guiButton = null;
        methods = DynamicMappings.getMatchingMethods(guiScreen, null, "(III)V");
        if (methods.size() == 2) {
            MethodNode mouseClicked = null;
            MethodNode mouseReleased = null;
            for (MethodNode method : methods) {
                for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                    if (insn.getOpcode() == 192) {
                        TypeInsnNode tn = (TypeInsnNode)insn;
                        if (!this.verifyGuiButtonClass(tn.desc)) continue;
                        this.addClassMapping("net/minecraft/client/gui/GuiButton", tn.desc);
                        guiButton = tn.desc;
                        continue;
                    }
                    if (insn.getOpcode() != 180) continue;
                    FieldInsnNode fn3 = (FieldInsnNode)insn;
                    if (!fn3.owner.equals(guiScreen.name)) continue;
                    if (fn3.desc.equals("Ljava/util/List;")) {
                        mouseClicked = method;
                        continue;
                    }
                    mouseReleased = method;
                }
            }
            if (mouseClicked != null && mouseReleased != null && mouseClicked != mouseReleased) {
                this.addMethodMapping("net/minecraft/client/gui/GuiScreen mouseClicked (III)V", guiScreen.name + " " + mouseClicked.name + " " + mouseClicked.desc);
                this.addMethodMapping("net/minecraft/client/gui/GuiScreen mouseReleased (III)V", guiScreen.name + " " + mouseReleased.name + " " + mouseReleased.desc);
            }
        }
        if ((methods = this.getMatchingMethods(guiScreen, null, "(L" + minecraft.name + ";II)V")).size() == 2) {
            it = methods.iterator();
            while (it.hasNext()) {
                if (!it.next().name.equals(setWorldAndResolutionName)) continue;
                it.remove();
            }
            if (methods.size() == 1) {
                this.addMethodMapping("net/minecraft/client/gui/GuiScreen onResize (Lnet/minecraft/client/Minecraft;II)V", guiScreen.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            }
        }
        if ((methods = this.getMatchingMethods(guiScreen, null, "(L" + guiButton + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/GuiScreen actionPerformed (Lnet/minecraft/client/gui/GuiButton;)V", guiScreen.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        methods = this.getMatchingMethods(guiScreen, null, "()V");
        it = methods.iterator();
        while (it.hasNext()) {
            MethodNode method = it.next();
            if (this.matchOpcodeSequence(method.instructions.getFirst(), 25, 3, 182, 177)) continue;
            it.remove();
        }
        MethodNode drawWorldBackground = null;
        if (methods.size() == 1) {
            MethodNode tempMethodNode;
            List<MethodInsnNode> nodes = this.getAllInsnNodesOfType(methods.get((int)0).instructions.getFirst(), MethodInsnNode.class);
            MethodInsnNode mn = nodes.get(0);
            if (mn.owner.equals(guiScreen.name) && mn.desc.equals("(I)V") && (tempMethodNode = this.getMethodNode(guiScreen, mn.owner + " " + mn.name + " " + mn.desc)) != null) {
                boolean firstMatch = false;
                boolean secondMatch = false;
                for (AbstractInsnNode insn = tempMethodNode.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                    if (!firstMatch && this.isLdcWithInteger(insn, -1072689136)) {
                        firstMatch = true;
                    }
                    if (secondMatch || !this.isLdcWithInteger(insn, -804253680)) continue;
                    secondMatch = true;
                }
                if (firstMatch && secondMatch) {
                    this.addMethodMapping("net/minecraft/client/gui/GuiScreen drawDefaultBackground ()V", guiScreen.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
                    this.addMethodMapping("net/minecraft/client/gui/GuiScreen drawWorldBackground (I)V", guiScreen.name + " " + tempMethodNode.name + " " + tempMethodNode.desc);
                    drawWorldBackground = tempMethodNode;
                }
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/client/gui/GuiOptions", "net/minecraft/client/gui/GuiLanguage", "net/minecraft/client/gui/GuiSelectWorld", "net/minecraft/client/gui/GuiMultiplayer", "net/minecraft/client/gui/GuiYesNo"}, dependsMethods={"net/minecraft/client/gui/GuiScreen actionPerformed (Lnet/minecraft/client/gui/GuiButton;)V"}, depends={"net/minecraft/client/gui/GuiScreen", "net/minecraft/client/gui/GuiMainMenu"})
    public boolean discoverGuiClasses() {
        ClassNode guiScreen = this.getClassNodeFromMapping("net/minecraft/client/gui/GuiScreen");
        ClassNode guiMainMenu = this.getClassNodeFromMapping("net/minecraft/client/gui/GuiMainMenu");
        if (guiScreen == null || guiMainMenu == null) {
            return false;
        }
        MethodNode actionPerformed = this.getMethodNodeFromMapping(guiMainMenu, "net/minecraft/client/gui/GuiScreen actionPerformed (Lnet/minecraft/client/gui/GuiButton;)V");
        if (actionPerformed == null) {
            return false;
        }
        ClassNode guiOptions = null;
        ClassNode guiLanguage = null;
        ClassNode guiSelectWorld = null;
        ClassNode guiMultiplayer = null;
        ClassNode guiYesNo = null;
        List<TypeInsnNode> nodes = this.getAllInsnNodesOfType(actionPerformed.instructions.getFirst(), TypeInsnNode.class);
        for (TypeInsnNode node : nodes) {
            ClassNode cn;
            if (node.desc.startsWith("java") || (cn = this.getClassNode(node.desc)) == null || !cn.superName.equals(guiScreen.name)) continue;
            if (guiOptions == null && this.searchConstantPoolForStrings(node.desc, "Options", "options.title", "options.video")) {
                this.addClassMapping("net/minecraft/client/gui/GuiOptions", node.desc);
                guiOptions = cn;
            }
            if (guiLanguage == null && this.searchConstantPoolForStrings(node.desc, "options.language", "options.languageWarning")) {
                this.addClassMapping("net/minecraft/client/gui/GuiLanguage", node.desc);
                guiLanguage = cn;
            }
            if (guiSelectWorld == null && this.searchConstantPoolForStrings(node.desc, "Select world", "selectWorld.title")) {
                this.addClassMapping("net/minecraft/client/gui/GuiSelectWorld", node.desc);
                guiSelectWorld = cn;
            }
            if (guiMultiplayer == null && this.searchConstantPoolForStrings(node.desc, "Unable to start LAN server detection: ", "selectServer.edit")) {
                this.addClassMapping("net/minecraft/client/gui/GuiMultiplayer", node.desc);
                guiMultiplayer = cn;
            }
            if (guiYesNo != null || !this.searchConstantPoolForStrings(node.desc, "gui.yes", "gui.no")) continue;
            this.addClassMapping("net/minecraft/client/gui/GuiYesNo", node.desc);
            guiYesNo = cn;
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/client/gui/GuiButton id I", "net/minecraft/client/gui/GuiButton xPosition I", "net/minecraft/client/gui/GuiButton yPosition I", "net/minecraft/client/gui/GuiButton width I", "net/minecraft/client/gui/GuiButton height I", "net/minecraft/client/gui/GuiButton displayString Ljava/lang/String;"}, depends={"net/minecraft/client/gui/GuiButton"})
    public boolean processGuiButtonClass() {
        ClassNode guiButton = this.getClassNodeFromMapping("net/minecraft/client/gui/GuiButton");
        if (guiButton == null) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(guiButton, "<init>", "(IIIIILjava/lang/String;)V");
        if (methods.size() == 1) {
            HashMap<Integer, String> fieldMap = new HashMap<Integer, String>();
            AbstractInsnNode insn = this.getNextRealOpcode(methods.get((int)0).instructions.getFirst());
            while (insn != null) {
                AbstractInsnNode[] nodes = this.getInsnNodeSequenceArray(insn, VarInsnNode.class, VarInsnNode.class, FieldInsnNode.class);
                if (nodes != null) {
                    insn = nodes[2];
                    FieldInsnNode fn = (FieldInsnNode)nodes[2];
                    if (fn.owner.equals(guiButton.name)) {
                        fieldMap.put(((VarInsnNode)nodes[1]).var, fn.name);
                    }
                }
                insn = this.getNextRealOpcode(insn.getNext());
            }
            if (fieldMap.size() == 6) {
                block9: for (int n = 1; n <= 6; ++n) {
                    switch (n) {
                        case 1: {
                            this.addFieldMapping("net/minecraft/client/gui/GuiButton id I", guiButton.name + " " + (String)fieldMap.get(n) + " I");
                            continue block9;
                        }
                        case 2: {
                            this.addFieldMapping("net/minecraft/client/gui/GuiButton xPosition I", guiButton.name + " " + (String)fieldMap.get(n) + " I");
                            continue block9;
                        }
                        case 3: {
                            this.addFieldMapping("net/minecraft/client/gui/GuiButton yPosition I", guiButton.name + " " + (String)fieldMap.get(n) + " I");
                            continue block9;
                        }
                        case 4: {
                            this.addFieldMapping("net/minecraft/client/gui/GuiButton width I", guiButton.name + " " + (String)fieldMap.get(n) + " I");
                            continue block9;
                        }
                        case 5: {
                            this.addFieldMapping("net/minecraft/client/gui/GuiButton height I", guiButton.name + " " + (String)fieldMap.get(n) + " I");
                            continue block9;
                        }
                        case 6: {
                            this.addFieldMapping("net/minecraft/client/gui/GuiButton displayString Ljava/lang/String;", guiButton.name + " " + (String)fieldMap.get(n) + " Ljava/lang/String;");
                        }
                    }
                }
            }
        }
        return true;
    }

    @Mapping(provides={}, providesFields={}, providesMethods={"net/minecraft/client/gui/FontRenderer getStringWidth (Ljava/lang/String;)I", "net/minecraft/client/gui/Gui drawCenteredString (Lnet/minecraft/client/gui/FontRenderer;Ljava/lang/String;III)V", "net/minecraft/client/gui/Gui drawString (Lnet/minecraft/client/gui/FontRenderer;Ljava/lang/String;III)V"}, depends={"net/minecraft/client/gui/GuiMainMenu", "net/minecraft/client/gui/GuiScreen", "net/minecraft/client/gui/Gui", "net/minecraft/client/Minecraft", "net/minecraft/client/gui/FontRenderer"})
    public boolean processGuiMainMenuClass() {
        ClassNode fontRenderer;
        ClassNode minecraft;
        ClassNode gui;
        ClassNode guiScreen;
        ClassNode guiMainMenu = this.getClassNodeFromMapping("net/minecraft/client/gui/GuiMainMenu");
        if (!MeddleUtil.notNull((Object[])new Object[]{guiMainMenu, guiScreen = this.getClassNodeFromMapping("net/minecraft/client/gui/GuiScreen"), gui = this.getClassNodeFromMapping("net/minecraft/client/gui/Gui"), minecraft = this.getClassNodeFromMapping("net/minecraft/client/Minecraft"), fontRenderer = this.getClassNodeFromMapping("net/minecraft/client/gui/FontRenderer")})) {
            return false;
        }
        String drawScreenDesc = "net/minecraft/client/gui/GuiScreen drawScreen (IIF)V";
        MethodNode drawScreenMethod = DynamicMappings.getMethodNodeFromMapping(guiMainMenu, drawScreenDesc);
        if (drawScreenMethod == null) {
            return false;
        }
        String drawStringMethodsDesc = "(L" + fontRenderer.name + ";Ljava/lang/String;III)V";
        String getStringWidthName = null;
        String drawCenteredStringName = null;
        String drawStringName = null;
        for (AbstractInsnNode insn = drawScreenMethod.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn.getOpcode() != 182) continue;
            MethodInsnNode mn = (MethodInsnNode)insn;
            if (getStringWidthName == null && mn.owner.equals(fontRenderer.name) && mn.desc.equals("(Ljava/lang/String;)I")) {
                getStringWidthName = mn.name;
                this.addMethodMapping("net/minecraft/client/gui/FontRenderer getStringWidth (Ljava/lang/String;)I", fontRenderer.name + " " + mn.name + " " + mn.desc);
            }
            if (!mn.owner.equals(guiMainMenu.name) || !mn.desc.equals(drawStringMethodsDesc)) continue;
            if (drawCenteredStringName == null) {
                drawCenteredStringName = mn.name;
                this.addMethodMapping("net/minecraft/client/gui/Gui drawCenteredString (Lnet/minecraft/client/gui/FontRenderer;Ljava/lang/String;III)V", gui.name + " " + mn.name + " " + mn.desc);
                continue;
            }
            if (drawStringName != null) continue;
            drawStringName = mn.name;
            this.addMethodMapping("net/minecraft/client/gui/Gui drawString (Lnet/minecraft/client/gui/FontRenderer;Ljava/lang/String;III)V", gui.name + " " + mn.name + " " + mn.desc);
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/block/state/BlockState getProperty (Ljava/lang/String;)Lnet/minecraft/block/properties/IProperty;"}, depends={"net/minecraft/block/state/BlockState", "net/minecraft/block/properties/IProperty"})
    public boolean processBlockStateClass() {
        ClassNode blockState = this.getClassNodeFromMapping("net/minecraft/block/state/BlockState");
        ClassNode iProperty = this.getClassNodeFromMapping("net/minecraft/block/properties/IProperty");
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        if (!MeddleUtil.notNull((Object[])new Object[]{blockState, iProperty, block})) {
            return false;
        }
        List<Object> methods = new ArrayList();
        methods = DynamicMappings.getMatchingMethods(blockState, null, "(Ljava/lang/String;)L" + iProperty.name + ";");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/block/state/BlockState getProperty (Ljava/lang/String;)Lnet/minecraft/block/properties/IProperty;", blockState.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/client/entity/EntityPlayerSP", "net/minecraft/client/entity/AbstractClientPlayer"}, dependsFields={"net/minecraft/init/Sounds block_portal_trigger Lnet/minecraft/util/Sound;"}, depends={"net/minecraft/client/Minecraft", "net/minecraft/entity/player/EntityPlayer"})
    public boolean getEntityPlayerSPClass() {
        ClassNode minecraft = this.getClassNodeFromMapping("net/minecraft/client/Minecraft");
        ClassNode entityPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayer");
        if (minecraft == null || entityPlayer == null) {
            return false;
        }
        String entityPlayerSP_name = null;
        String portalSound = this.getSoundFieldFull("block.portal.trigger");
        List<MethodNode> methods = DynamicMappings.getMatchingMethods(minecraft, null, "(I)V");
        block0: for (MethodNode method : methods) {
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 181) continue;
                FieldInsnNode fn = (FieldInsnNode)insn;
                if (!fn.owner.equals(minecraft.name) || fn.desc.contains("/")) continue;
                String className = fn.desc.substring(1, fn.desc.length() - 1);
                if (!DynamicMappings.searchConstantPoolForStrings(className, "minecraft:chest", "minecraft:anvil") || !this.searchConstantPoolForFields(className, portalSound)) continue;
                entityPlayerSP_name = className;
                break block0;
            }
        }
        if (entityPlayerSP_name == null) {
            return false;
        }
        ClassNode entityPlayerSP = this.getClassNode(entityPlayerSP_name);
        if (entityPlayerSP == null) {
            return false;
        }
        if (DynamicMappings.searchConstantPoolForStrings(entityPlayerSP.superName, "http://skins.minecraft.net/MinecraftSkins/%s.png")) {
            ClassNode abstractClientPlayer = this.getClassNode(entityPlayerSP.superName);
            if (abstractClientPlayer == null) {
                return false;
            }
            if (!abstractClientPlayer.superName.equals(entityPlayer.name)) {
                return false;
            }
        }
        this.addClassMapping("net/minecraft/client/entity/EntityPlayerSP", entityPlayerSP);
        this.addClassMapping("net/minecraft/client/entity/AbstractClientPlayer", entityPlayerSP.superName);
        return true;
    }

    @Mapping(provides={}, depends={"net/minecraft/entity/player/EntityPlayer", "net/minecraft/client/entity/EntityPlayerSP", "net/minecraft/world/IInteractionObject"})
    public boolean processEntityPlayerSPClass() {
        ClassNode entityPlayer = this.getClassNodeFromMapping("net/minecraft/entity/player/EntityPlayer");
        ClassNode entityPlayerSP = this.getClassNodeFromMapping("net/minecraft/client/entity/EntityPlayerSP");
        ClassNode iInteractionObject = this.getClassNodeFromMapping("net/minecraft/world/IInteractionObject");
        return MeddleUtil.notNull((Object[])new Object[]{entityPlayer, entityPlayerSP, iInteractionObject});
    }

    @Mapping(provides={"net/minecraft/client/gui/inventory/GuiChest", "net/minecraft/client/gui/inventory/GuiContainer"}, dependsMethods={"net/minecraft/entity/player/EntityPlayer displayGUIChest (Lnet/minecraft/inventory/IInventory;)V"}, depends={"net/minecraft/client/gui/GuiScreen", "net/minecraft/client/entity/EntityPlayerSP"})
    public boolean getGuiChestClass() {
        ClassNode guiScreen = this.getClassNodeFromMapping("net/minecraft/client/gui/GuiScreen");
        ClassNode entityPlayerSP = this.getClassNodeFromMapping("net/minecraft/client/entity/EntityPlayerSP");
        if (!MeddleUtil.notNull((Object[])new Object[]{guiScreen, entityPlayerSP})) {
            return false;
        }
        MethodNode displayGuiChest = DynamicMappings.getMethodNodeFromMapping(entityPlayerSP, "net/minecraft/entity/player/EntityPlayer displayGUIChest (Lnet/minecraft/inventory/IInventory;)V");
        if (displayGuiChest == null) {
            return false;
        }
        HashMap<String, String> guiMap = new HashMap<String, String>();
        String lastString = null;
        for (AbstractInsnNode insn = displayGuiChest.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            String s = DynamicMappings.getLdcString(insn);
            if (s != null) {
                lastString = s;
                continue;
            }
            if (insn.getOpcode() != 187) continue;
            TypeInsnNode tn = (TypeInsnNode)insn;
            if (lastString == null) continue;
            guiMap.put(lastString, tn.desc);
        }
        String className = (String)guiMap.get("minecraft:chest");
        if (className != null) {
            if (!DynamicMappings.searchConstantPoolForStrings(className, "textures/gui/container/generic_54.png")) {
                return false;
            }
            ClassNode guiChest = this.getClassNode(className);
            if (guiChest == null) {
                return false;
            }
            ClassNode guiContainer = this.getClassNode(guiChest.superName);
            if (!DynamicMappings.searchConstantPoolForStrings(guiContainer.name, "textures/gui/container/inventory.png")) {
                return false;
            }
            if (!guiContainer.superName.equals(guiScreen.name)) {
                return false;
            }
            this.addClassMapping("net/minecraft/client/gui/inventory/GuiChest", guiChest);
            this.addClassMapping("net/minecraft/client/gui/inventory/GuiContainer", guiContainer);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/client/settings/GameSettings"}, providesFields={"net/minecraft/client/Minecraft thePlayer Lnet/minecraft/client/entity/EntityPlayerSP;", "net/minecraft/client/gui/inventory/GuiContainer guiLeft I", "net/minecraft/client/gui/inventory/GuiContainer guiTop I"}, providesMethods={"net/minecraft/client/gui/inventory/GuiContainer handleMouseClick (Lnet/minecraft/inventory/Slot;III)V", "net/minecraft/client/gui/inventory/GuiContainer checkHotbarKeys (I)Z", "net/minecraft/client/gui/inventory/GuiContainer drawItemStack (Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V", "net/minecraft/client/gui/inventory/GuiContainer drawGuiContainerForegroundLayer (II)V", "net/minecraft/client/gui/inventory/GuiContainer drawGuiContainerBackgroundLayer (FII)V", "net/minecraft/client/gui/inventory/GuiContainer drawSlot (Lnet/minecraft/inventory/Slot;)V", "net/minecraft/client/gui/inventory/GuiContainer getSlotAtPosition (II)Lnet/minecraft/inventory/Slot;", "net/minecraft/client/gui/GuiScreen mouseClickMove (IIIJ)V", "net/minecraft/client/gui/inventory/GuiContainer isMouseOverSlot (Lnet/minecraft/inventory/Slot;II)Z", "net/minecraft/client/gui/inventory/GuiContainer isPointInRegion (IIIIII)Z", "net/minecraft/client/gui/GuiScreen doesGuiPauseGame ()Z", "net/minecraft/client/gui/GuiScreen onGuiClosed ()V", "net/minecraft/client/gui/GuiScreen updateScreen ()V", "net/minecraft/client/gui/inventory/GuiContainer updateDragSplitting ()V"}, dependsMethods={"net/minecraft/inventory/Container onContainerClosed (Lnet/minecraft/entity/player/EntityPlayer;)V", "net/minecraft/client/gui/GuiScreen initGui ()V"}, depends={"net/minecraft/client/gui/inventory/GuiContainer", "net/minecraft/inventory/Slot", "net/minecraft/client/Minecraft", "net/minecraft/client/entity/EntityPlayerSP", "net/minecraft/item/ItemStack", "net/minecraft/client/gui/GuiScreen", "net/minecraft/inventory/EnumContainerAction"})
    public boolean processGuiContainerClass() {
        ClassNode containerAction;
        ClassNode guiScreen;
        ClassNode itemStack;
        ClassNode playerSP;
        ClassNode minecraft;
        ClassNode slot;
        ClassNode guiContainer = this.getClassNodeFromMapping("net/minecraft/client/gui/inventory/GuiContainer");
        if (!MeddleUtil.notNull((Object[])new Object[]{guiContainer, slot = this.getClassNodeFromMapping("net/minecraft/inventory/Slot"), minecraft = this.getClassNodeFromMapping("net/minecraft/client/Minecraft"), playerSP = this.getClassNodeFromMapping("net/minecraft/client/entity/EntityPlayerSP"), itemStack = this.getClassNodeFromMapping("net/minecraft/item/ItemStack"), guiScreen = this.getClassNodeFromMapping("net/minecraft/client/gui/GuiScreen"), containerAction = this.getClassNodeFromMapping("net/minecraft/inventory/EnumContainerAction")})) {
            return false;
        }
        List<MethodNode> methods = DynamicMappings.getMatchingMethods(guiContainer, null, "(L" + slot.name + ";IIL" + containerAction.name + ";)V");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/inventory/GuiContainer handleMouseClick (Lnet/minecraft/inventory/Slot;III)V", guiContainer.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = DynamicMappings.getMatchingMethods(guiContainer, null, "(I)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/inventory/GuiContainer checkHotbarKeys (I)Z", guiContainer.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
                Type t;
                if (insn.getOpcode() != 180) continue;
                FieldInsnNode fn = (FieldInsnNode)insn;
                if (!fn.owner.equals(minecraft.name) || (t = Type.getType((String)fn.desc)).getSort() != 10) continue;
                if (t.getClassName().equals(playerSP.name)) {
                    this.addFieldMapping("net/minecraft/client/Minecraft thePlayer Lnet/minecraft/client/entity/EntityPlayerSP;", minecraft.name + " " + fn.name + " " + fn.desc);
                    continue;
                }
                if (!DynamicMappings.searchConstantPoolForStrings(t.getClassName(), "options.particles.all", "key.forward", "enableVsync:")) continue;
                this.addClassMapping("net/minecraft/client/settings/GameSettings", t.getClassName());
                this.addFieldMapping("net/minecraft/client/Minecraft gameSettings Lnet/minecraft/client/entity/EntityPlayerSP;", minecraft.name + " " + fn.name + " " + fn.desc);
            }
        }
        if ((methods = DynamicMappings.getMatchingMethods(guiContainer, null, "(L" + itemStack.name + ";IILjava/lang/String;)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/inventory/GuiContainer drawItemStack (Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V", guiContainer.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = DynamicMappings.getMatchingMethods(guiContainer, null, "(II)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/inventory/GuiContainer drawGuiContainerForegroundLayer (II)V", guiContainer.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = DynamicMappings.getMatchingMethods(guiContainer, null, "(FII)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/inventory/GuiContainer drawGuiContainerBackgroundLayer (FII)V", guiContainer.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = DynamicMappings.getMatchingMethods(guiContainer, null, "(L" + slot.name + ";)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/inventory/GuiContainer drawSlot (Lnet/minecraft/inventory/Slot;)V", guiContainer.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = DynamicMappings.getMatchingMethods(guiContainer, null, "(II)L" + slot.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/inventory/GuiContainer getSlotAtPosition (II)Lnet/minecraft/inventory/Slot;", guiContainer.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = DynamicMappings.getMatchingMethods(guiContainer, null, "(IIIJ)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/GuiScreen mouseClickMove (IIIJ)V", guiScreen.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = DynamicMappings.getMatchingMethods(guiContainer, null, "(L" + slot.name + ";II)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/inventory/GuiContainer isMouseOverSlot (Lnet/minecraft/inventory/Slot;II)Z", guiContainer.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = DynamicMappings.getMatchingMethods(guiContainer, null, "(IIIIII)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/inventory/GuiContainer isPointInRegion (IIIIII)Z", guiContainer.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            ArrayList<String> fields = new ArrayList<String>();
            for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 180) continue;
                FieldInsnNode fn = (FieldInsnNode)insn;
                if (!fn.owner.equals(guiContainer.name) || !fn.desc.equals("I")) continue;
                fields.add(fn.name);
            }
            if (fields.size() == 2) {
                this.addFieldMapping("net/minecraft/client/gui/inventory/GuiContainer guiLeft I", guiContainer.name + " " + (String)fields.get(0) + " I");
                this.addFieldMapping("net/minecraft/client/gui/inventory/GuiContainer guiTop I", guiContainer.name + " " + (String)fields.get(1) + " I");
            }
        }
        if ((methods = DynamicMappings.getMatchingMethods(guiContainer, null, "()Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/GuiScreen doesGuiPauseGame ()Z", guiScreen.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        String onContainerClosed = DynamicMappings.getMethodMapping("net/minecraft/inventory/Container onContainerClosed (Lnet/minecraft/entity/player/EntityPlayer;)V");
        String initGui = DynamicMappings.getMethodMapping("net/minecraft/client/gui/GuiScreen initGui ()V");
        methods = DynamicMappings.getMatchingMethods(guiContainer, null, "()V");
        if (methods.size() == 5 && onContainerClosed != null && initGui != null) {
            MethodNode onGuiClosed = null;
            MethodNode updateScreen = null;
            MethodNode updateDragSplitting = null;
            Iterator<MethodNode> it = methods.iterator();
            block2: while (it.hasNext()) {
                MethodNode method = it.next();
                if (method.name.contains("<")) {
                    it.remove();
                    continue;
                }
                if (initGui.endsWith(" " + method.name + " " + method.desc)) {
                    it.remove();
                    continue;
                }
                for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                    if (insn.getOpcode() != 182) continue;
                    MethodInsnNode mn = (MethodInsnNode)insn;
                    if (!onContainerClosed.equals(mn.owner + " " + mn.name + " " + mn.desc)) continue;
                    onGuiClosed = method;
                    it.remove();
                    continue block2;
                }
            }
            if (methods.size() == 2) {
                for (MethodNode method : methods) {
                    if ((method.access & 2) > 0) {
                        updateDragSplitting = method;
                        continue;
                    }
                    updateScreen = method;
                }
            }
            if (MeddleUtil.notNull((Object[])new Object[]{onGuiClosed, updateScreen, updateDragSplitting})) {
                this.addMethodMapping("net/minecraft/client/gui/GuiScreen onGuiClosed ()V", guiScreen.name + " " + onGuiClosed.name + " " + onGuiClosed.desc);
                this.addMethodMapping("net/minecraft/client/gui/GuiScreen updateScreen ()V", guiScreen.name + " " + updateScreen.name + " " + updateScreen.desc);
                this.addMethodMapping("net/minecraft/client/gui/inventory/GuiContainer updateDragSplitting ()V", guiContainer.name + " " + updateDragSplitting.name + " " + updateDragSplitting.desc);
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/client/network/NetHandlerPlayClient"}, depends={"net/minecraft/client/entity/EntityPlayerSP"})
    public boolean getNetHandlerPlayClientClass() {
        ClassNode playerSP = this.getClassNodeFromMapping("net/minecraft/client/entity/EntityPlayerSP");
        if (playerSP == null) {
            return false;
        }
        for (FieldNode field : playerSP.fields) {
            Type t = Type.getType((String)field.desc);
            if (t.getSort() != 10) continue;
            if (!DynamicMappings.searchConstantPoolForStrings(t.getClassName(), "MC|Brand", "disconnect.lost", "minecraft:container")) continue;
            this.addClassMapping("net/minecraft/client/network/NetHandlerPlayClient", t.getClassName());
            return true;
        }
        return false;
    }

    @Mapping(provides={}, providesMethods={"net/minecraft/client/network/NetHandlerPlayClient handleOpenWindow (Lnet/minecraft/network/play/server/S2DPacketOpenWindow;)V"}, depends={"net/minecraft/client/network/NetHandlerPlayClient", "net/minecraft/network/play/server/S2DPacketOpenWindow"})
    public boolean processNetHandlerPlayClientClass() {
        ClassNode clientHandler = this.getClassNodeFromMapping("net/minecraft/client/network/NetHandlerPlayClient");
        ClassNode openWindow = this.getClassNodeFromMapping("net/minecraft/network/play/server/S2DPacketOpenWindow");
        if (!MeddleUtil.notNull((Object[])new Object[]{clientHandler, openWindow})) {
            return false;
        }
        List<MethodNode> methods = DynamicMappings.getMatchingMethods(clientHandler, null, "(L" + openWindow.name + ";)V");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/client/network/NetHandlerPlayClient handleOpenWindow (Lnet/minecraft/network/play/server/S2DPacketOpenWindow;)V", clientHandler.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(providesFields={"net/minecraft/network/play/server/S2DPacketOpenWindow windowId I", "net/minecraft/network/play/server/S2DPacketOpenWindow inventoryType Ljava/lang/String", "net/minecraft/network/play/server/S2DPacketOpenWindow windowTitle Lnet/minecraft/util/IChatComponent;", "net/minecraft/network/play/server/S2DPacketOpenWindow slotCount I"}, providesMethods={"net/minecraft/network/play/server/S2DPacketOpenWindow getGuiId ()Ljava/lang/String;", "net/minecraft/network/play/server/S2DPacketOpenWindow getWindowTitle ()Lnet/minecraft/util/IChatComponent;", "net/minecraft/network/play/server/S2DPacketOpenWindow getWindowId ()I", "net/minecraft/network/play/server/S2DPacketOpenWindow getSlotCount ()I", "net/minecraft/network/play/server/S2DPacketOpenWindow hasSlots ()Z"}, depends={"net/minecraft/network/play/server/S2DPacketOpenWindow", "net/minecraft/util/IChatComponent"})
    public boolean processS2DPacketOpenWindowClass() {
        ClassNode packet = this.getClassNodeFromMapping("net/minecraft/network/play/server/S2DPacketOpenWindow");
        ClassNode iChatComponent = this.getClassNodeFromMapping("net/minecraft/util/IChatComponent");
        if (packet == null || iChatComponent == null) {
            return false;
        }
        String windowId = null;
        String inventoryType = null;
        String windowTitle = null;
        String slotCount = null;
        List<MethodNode> methods = DynamicMappings.getMatchingMethods(packet, "<init>", "(ILjava/lang/String;L" + iChatComponent.name + ";I)V");
        if (methods.size() == 1) {
            for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 181) continue;
                FieldInsnNode fn = (FieldInsnNode)insn;
                if (!fn.owner.equals(packet.name)) continue;
                if (windowId == null && fn.desc.equals("I")) {
                    windowId = fn.name;
                    continue;
                }
                if (windowId != null && inventoryType == null && fn.desc.equals("Ljava/lang/String;")) {
                    inventoryType = fn.name;
                    continue;
                }
                if (windowId != null && inventoryType != null && windowTitle == null && fn.desc.equals("L" + iChatComponent.name + ";")) {
                    windowTitle = fn.name;
                    continue;
                }
                if (windowId == null || inventoryType == null || windowTitle == null || slotCount != null || !fn.desc.equals("I")) continue;
                slotCount = fn.name;
            }
        }
        if (MeddleUtil.notNull((Object[])new Object[]{windowId, inventoryType, windowTitle, slotCount})) {
            this.addFieldMapping("net/minecraft/network/play/server/S2DPacketOpenWindow windowId I", packet.name + " " + windowId + " I");
            this.addFieldMapping("net/minecraft/network/play/server/S2DPacketOpenWindow inventoryType Ljava/lang/String", packet.name + " " + inventoryType + " Ljava/lang/String;");
            this.addFieldMapping("net/minecraft/network/play/server/S2DPacketOpenWindow windowTitle Lnet/minecraft/util/IChatComponent;", packet.name + " " + windowTitle + " L" + iChatComponent.name + ";");
            this.addFieldMapping("net/minecraft/network/play/server/S2DPacketOpenWindow slotCount I", packet.name + " " + slotCount + " I");
        }
        if ((methods = DynamicMappings.getMatchingMethods(packet, null, "()Ljava/lang/String;")).size() == 1) {
            this.addMethodMapping("net/minecraft/network/play/server/S2DPacketOpenWindow getGuiId ()Ljava/lang/String;", packet.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = DynamicMappings.getMatchingMethods(packet, null, "()L" + iChatComponent.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/network/play/server/S2DPacketOpenWindow getWindowTitle ()Lnet/minecraft/util/IChatComponent;", packet.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        methods = DynamicMappings.getMatchingMethods(packet, null, "()I");
        block1: for (MethodNode method : methods) {
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 180) continue;
                FieldInsnNode fn = (FieldInsnNode)insn;
                if (!fn.owner.equals(packet.name)) continue;
                if (fn.name.equals(windowId)) {
                    this.addMethodMapping("net/minecraft/network/play/server/S2DPacketOpenWindow getWindowId ()I", packet.name + " " + method.name + " " + method.desc);
                    continue block1;
                }
                if (!fn.name.equals(slotCount)) continue;
                this.addMethodMapping("net/minecraft/network/play/server/S2DPacketOpenWindow getSlotCount ()I", packet.name + " " + method.name + " " + method.desc);
                continue block1;
            }
        }
        methods = DynamicMappings.getMatchingMethods(packet, null, "()Z");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/network/play/server/S2DPacketOpenWindow hasSlots ()Z", packet.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/client/settings/KeyBinding"}, depends={"net/minecraft/client/settings/GameSettings", "net/minecraft/client/Minecraft"})
    public boolean getKeybindingClass() {
        ClassNode gameSettings = this.getClassNodeFromMapping("net/minecraft/client/settings/GameSettings");
        ClassNode minecraft = this.getClassNodeFromMapping("net/minecraft/client/Minecraft");
        if (gameSettings == null || minecraft == null) {
            return false;
        }
        List<MethodNode> methods = DynamicMappings.getMatchingMethods(gameSettings, "<init>", "(L" + minecraft.name + ";Ljava/io/File;)V");
        if (methods.size() == 1) {
            TallyKeeper<String> tallies = new TallyKeeper<String>();
            for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 187) continue;
                TypeInsnNode tn = (TypeInsnNode)insn;
                tallies.put(tn.desc);
            }
            String keyBinding_name = (String)tallies.getHighestObj();
            ClassNode keyBinding = this.getClassNode(keyBinding_name);
            boolean comparable = false;
            for (String iface : keyBinding.interfaces) {
                if (!iface.equals("java/lang/Comparable")) continue;
                comparable = true;
            }
            if (comparable) {
                this.addClassMapping("net/minecraft/client/settings/KeyBinding", keyBinding_name);
                return true;
            }
        }
        return false;
    }

    @Mapping(providesFields={"net/minecraft/client/settings/KeyBinding keyDescription Ljava/lang/String;", "net/minecraft/client/settings/KeyBinding keyCode I", "net/minecraft/client/settings/KeyBinding keyCodeDefault I", "net/minecraft/client/settings/KeyBinding keyCategory Ljava/lang/String;", "net/minecraft/client/settings/KeyBinding pressed Z", "net/minecraft/client/settings/KeyBinding pressTime I"}, providesMethods={"net/minecraft/client/settings/KeyBinding onTick (I)V", "net/minecraft/client/settings/KeyBinding setKeyBindState (IZ)V", "net/minecraft/client/settings/KeyBinding getKeybinds ()Ljava/util/Set;", "net/minecraft/client/settings/KeyBinding unpressKey ()V", "net/minecraft/client/settings/KeyBinding unPressAllKeys ()V", "net/minecraft/client/settings/KeyBinding resetKeyBindingArrayAndHash ()V", "net/minecraft/client/settings/KeyBinding setKeyCode (I)V", "net/minecraft/client/settings/KeyBinding isKeyDown ()Z", "net/minecraft/client/settings/KeyBinding isPressed ()Z", "net/minecraft/client/settings/KeyBinding updateAllKeys ()V"}, depends={"net/minecraft/client/settings/KeyBinding"})
    public boolean processKeybindingClass() {
        ClassNode keyBinding = this.getClassNodeFromMapping("net/minecraft/client/settings/KeyBinding");
        if (keyBinding == null) {
            return false;
        }
        String keyDescription = null;
        String keyCode = null;
        String keyCodeDefault = null;
        String keyCategory = null;
        List<MethodNode> methods = DynamicMappings.getMatchingMethods(keyBinding, "<init>", "(Ljava/lang/String;ILjava/lang/String;)V");
        if (methods.size() == 1) {
            ArrayList<FieldInsnNode> fields = new ArrayList<FieldInsnNode>();
            for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 181) continue;
                fields.add((FieldInsnNode)insn);
            }
            if (fields.size() == 4) {
                if (((FieldInsnNode)fields.get((int)0)).desc.equals("Ljava/lang/String;")) {
                    keyDescription = ((FieldInsnNode)fields.get((int)0)).name;
                    this.addFieldMapping("net/minecraft/client/settings/KeyBinding keyDescription Ljava/lang/String;", keyBinding.name + " " + ((FieldInsnNode)fields.get((int)0)).name + " Ljava/lang/String;");
                }
                if (((FieldInsnNode)fields.get((int)1)).desc.equals("I") && ((FieldInsnNode)fields.get((int)2)).desc.equals("I")) {
                    keyCode = ((FieldInsnNode)fields.get((int)1)).name;
                    keyCodeDefault = ((FieldInsnNode)fields.get((int)2)).name;
                    this.addFieldMapping("net/minecraft/client/settings/KeyBinding keyCode I", keyBinding.name + " " + ((FieldInsnNode)fields.get((int)1)).name + " I");
                    this.addFieldMapping("net/minecraft/client/settings/KeyBinding keyCodeDefault I", keyBinding.name + " " + ((FieldInsnNode)fields.get((int)2)).name + " I");
                }
                if (((FieldInsnNode)fields.get((int)3)).desc.equals("Ljava/lang/String;")) {
                    keyCategory = ((FieldInsnNode)fields.get((int)3)).name;
                    this.addFieldMapping("net/minecraft/client/settings/KeyBinding keyCategory Ljava/lang/String;", keyBinding.name + " " + ((FieldInsnNode)fields.get((int)3)).name + " Ljava/lang/String;");
                }
            }
        }
        methods = DynamicMappings.getMatchingMethods(keyBinding, null, "(I)V");
        if ((methods = DynamicMappings.removeMethodsWithoutFlags(methods, 8)).size() == 1) {
            this.addMethodMapping("net/minecraft/client/settings/KeyBinding onTick (I)V", keyBinding.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        methods = DynamicMappings.getMatchingMethods(keyBinding, null, "(IZ)V");
        if ((methods = DynamicMappings.removeMethodsWithoutFlags(methods, 8)).size() == 1) {
            this.addMethodMapping("net/minecraft/client/settings/KeyBinding setKeyBindState (IZ)V", keyBinding.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        methods = DynamicMappings.getMatchingMethods(keyBinding, null, "()Ljava/util/Set;");
        if ((methods = DynamicMappings.removeMethodsWithoutFlags(methods, 8)).size() == 1) {
            this.addMethodMapping("net/minecraft/client/settings/KeyBinding getKeybinds ()Ljava/util/Set;", keyBinding.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        String unpressKey = null;
        methods = DynamicMappings.getMatchingMethods(keyBinding, null, "()V");
        methods = DynamicMappings.removeMethodsWithFlags(methods, 8);
        Iterator<MethodNode> it = methods.iterator();
        while (it.hasNext()) {
            if (!it.next().name.contains("<")) continue;
            it.remove();
        }
        if (methods.size() == 1) {
            unpressKey = methods.get((int)0).name;
            this.addMethodMapping("net/minecraft/client/settings/KeyBinding unpressKey ()V", keyBinding.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            String pressTime = null;
            int count = 0;
            for (AbstractInsnNode insn = methods.get((int)0).instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 181) continue;
                FieldInsnNode fn = (FieldInsnNode)insn;
                if (!fn.owner.equals(keyBinding.name) || !fn.desc.equals("I")) continue;
                ++count;
                pressTime = fn.name;
            }
            if (count == 1 && pressTime != null) {
                this.addFieldMapping("net/minecraft/client/settings/KeyBinding pressTime I", keyBinding.name + " " + pressTime + " I");
            }
        }
        methods = DynamicMappings.getMatchingMethods(keyBinding, null, "()V");
        methods = DynamicMappings.removeMethodsWithoutFlags(methods, 8);
        it = methods.iterator();
        while (it.hasNext()) {
            if (!it.next().name.contains("<")) continue;
            it.remove();
        }
        if (methods.size() == 3 && unpressKey != null) {
            Object updateAllKeys = null;
            MethodNode unPressAllKeys = null;
            MethodNode resetKeyBindingArrayAndHash = null;
            Iterator<MethodNode> it2 = methods.iterator();
            block4: while (it2.hasNext()) {
                MethodNode method = it2.next();
                List<MethodInsnNode> list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
                for (MethodInsnNode mn : list) {
                    if (!mn.owner.equals("org/lwjgl/input/Keyboard") || !mn.name.equals("isKeyDown")) continue;
                    this.addMethodMapping("net/minecraft/client/settings/KeyBinding updateAllKeys ()V", keyBinding.name + " " + method.name + " " + method.desc);
                    it2.remove();
                    break block4;
                }
            }
            if (methods.size() == 2) {
                for (MethodNode method : methods) {
                    boolean is_unpressAllKeys = false;
                    for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                        MethodInsnNode mn;
                        if (insn.getOpcode() != 183) continue;
                        mn = (MethodInsnNode)insn;
                        if (!mn.owner.equals(keyBinding.name) || !mn.name.equals(unpressKey) || !mn.desc.equals("()V")) continue;
                        unPressAllKeys = method;
                        is_unpressAllKeys = true;
                        break;
                    }
                    if (is_unpressAllKeys) continue;
                    resetKeyBindingArrayAndHash = method;
                }
            }
            if (unPressAllKeys != null && resetKeyBindingArrayAndHash != null) {
                this.addMethodMapping("net/minecraft/client/settings/KeyBinding unPressAllKeys ()V", keyBinding.name + " " + unPressAllKeys.name + " " + unPressAllKeys.desc);
                this.addMethodMapping("net/minecraft/client/settings/KeyBinding resetKeyBindingArrayAndHash ()V", keyBinding.name + " " + resetKeyBindingArrayAndHash.name + " " + resetKeyBindingArrayAndHash.desc);
            }
        }
        methods = DynamicMappings.getMatchingMethods(keyBinding, null, "(I)V");
        if ((methods = DynamicMappings.removeMethodsWithFlags(methods, 8)).size() == 1) {
            this.addMethodMapping("net/minecraft/client/settings/KeyBinding setKeyCode (I)V", keyBinding.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = DynamicMappings.getMatchingMethods(keyBinding, null, "()Z")).size() == 2) {
            boolean isGetter0 = DynamicMappings.matchOpcodeSequence(methods.get((int)0).instructions.getFirst(), 25, 180, 172);
            boolean isGetter1 = DynamicMappings.matchOpcodeSequence(methods.get((int)1).instructions.getFirst(), 25, 180, 172);
            MethodNode isKeyDown = null;
            MethodNode isPressed = null;
            if (isGetter0 && !isGetter1) {
                isKeyDown = methods.get(0);
                isPressed = methods.get(1);
            }
            if (!isGetter0 && isGetter1) {
                isKeyDown = methods.get(1);
                isPressed = methods.get(0);
            }
            if (isKeyDown != null && isPressed != null) {
                this.addMethodMapping("net/minecraft/client/settings/KeyBinding isKeyDown ()Z", keyBinding.name + " " + isKeyDown.name + " " + isKeyDown.desc);
                this.addMethodMapping("net/minecraft/client/settings/KeyBinding isPressed ()Z", keyBinding.name + " " + isPressed.name + " " + isPressed.desc);
                for (AbstractInsnNode insn = isKeyDown.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                    if (insn.getOpcode() != 180) continue;
                    FieldInsnNode fn = (FieldInsnNode)insn;
                    if (!fn.owner.equals(keyBinding.name) || !fn.desc.equals("Z")) continue;
                    this.addFieldMapping("net/minecraft/client/settings/KeyBinding pressed Z", keyBinding.name + " " + fn.name + " " + fn.desc);
                }
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/client/renderer/RenderHelper"}, dependsMethods={"net/minecraft/client/gui/GuiScreen drawScreen (IIF)V"}, depends={"net/minecraft/client/gui/inventory/GuiContainer", "net/minecraft/util/Vec3"})
    public boolean getRenderHelperClass() {
        ClassNode guiContainer = this.getClassNodeFromMapping("net/minecraft/client/gui/inventory/GuiContainer");
        ClassNode vec3 = this.getClassNodeFromMapping("net/minecraft/util/Vec3");
        if (guiContainer == null || vec3 == null) {
            return false;
        }
        MethodNode drawScreen = DynamicMappings.getMethodNodeFromMapping(guiContainer, "net/minecraft/client/gui/GuiScreen drawScreen (IIF)V");
        if (drawScreen == null) {
            return false;
        }
        String renderHelper = null;
        int count = 0;
        for (AbstractInsnNode insn = drawScreen.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn.getOpcode() != 184) continue;
            MethodInsnNode mn = (MethodInsnNode)insn;
            if (!DynamicMappings.searchConstantPoolForClasses(mn.owner, vec3.name, "java/nio/FloatBuffer") || mn.owner.equals(renderHelper)) continue;
            renderHelper = mn.owner;
            ++count;
        }
        if (count == 1) {
            this.addClassMapping("net/minecraft/client/renderer/RenderHelper", renderHelper);
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/client/renderer/RenderHelper enableStandardItemLighting ()V", "net/minecraft/client/renderer/RenderHelper enableGUIStandardItemLighting ()V", "net/minecraft/client/renderer/RenderHelper disableStandardItemLighting ()V"}, depends={"net/minecraft/client/renderer/RenderHelper"})
    public boolean processRenderHelperClass() {
        ClassNode renderHelper = this.getClassNodeFromMapping("net/minecraft/client/renderer/RenderHelper");
        if (renderHelper == null) {
            return false;
        }
        List<MethodNode> methods = DynamicMappings.getMatchingMethods(renderHelper, null, "()V");
        Iterator<MethodNode> it = methods.iterator();
        while (it.hasNext()) {
            MethodNode method = it.next();
            if ((method.access & 8) == 0) {
                it.remove();
            }
            if ((method.access & 2) > 0) {
                it.remove();
            }
            if (!method.name.contains("<")) continue;
            it.remove();
        }
        if (methods.size() != 3) {
            return false;
        }
        MethodNode enableStandardItemLighting = null;
        block1: for (MethodNode method : methods) {
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 184) continue;
                MethodInsnNode mn = (MethodInsnNode)insn;
                if (!mn.desc.equals("(IILjava/nio/FloatBuffer;)V")) continue;
                if (enableStandardItemLighting != null) {
                    return false;
                }
                enableStandardItemLighting = method;
                continue block1;
            }
        }
        if (enableStandardItemLighting == null) {
            return false;
        }
        this.addMethodMapping("net/minecraft/client/renderer/RenderHelper enableStandardItemLighting ()V", renderHelper.name + " " + enableStandardItemLighting.name + " ()V");
        methods.remove(enableStandardItemLighting);
        MethodNode enableGUIStandardItemLighting = null;
        block3: for (MethodNode method : methods) {
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 184) continue;
                MethodInsnNode mn = (MethodInsnNode)insn;
                if (!mn.owner.equals(renderHelper.name) || !mn.name.equals(enableStandardItemLighting.name)) continue;
                if (enableGUIStandardItemLighting != null) {
                    return false;
                }
                enableGUIStandardItemLighting = method;
                continue block3;
            }
        }
        if (enableGUIStandardItemLighting == null) {
            return false;
        }
        this.addMethodMapping("net/minecraft/client/renderer/RenderHelper enableGUIStandardItemLighting ()V", renderHelper.name + " " + enableGUIStandardItemLighting.name + " ()V");
        methods.remove(enableGUIStandardItemLighting);
        this.addMethodMapping("net/minecraft/client/renderer/RenderHelper disableStandardItemLighting ()V", renderHelper.name + " " + methods.get((int)0).name + " ()V");
        return true;
    }

    @Mapping(providesMethods={}, depends={"net/minecraft/block/BlockLiquid", "net/minecraft/block/Block"})
    public boolean processBlockDynamicLiquidClass() {
        ClassNode liquid = this.getClassNodeFromMapping("net/minecraft/block/BlockLiquid");
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        return MeddleUtil.notNull((Object[])new Object[]{liquid, block});
    }

    @Mapping(provides={"net/minecraft/client/renderer/WorldRenderer", "net/minecraft/client/renderer/BlockModelShapes"}, providesFields={"net/minecraft/client/renderer/BlockRendererDispatcher blockModelShapes Lnet/minecraft/client/renderer/BlockModelShapes;"}, providesMethods={"net/minecraft/client/renderer/BlockRendererDispatcher renderBlock (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/BlockPos;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/WorldRenderer;)Z", "net/minecraft/client/renderer/BlockRendererDispatcher getBlockModelShapes ()Lnet/minecraft/client/renderer/BlockModelShapes;"}, depends={"net/minecraft/client/renderer/BlockRendererDispatcher", "net/minecraft/block/state/IBlockState", "net/minecraft/util/BlockPos", "net/minecraft/world/IBlockAccess"})
    public boolean processBlockRendererDispatcherClass() {
        ClassNode iBlockAccess;
        ClassNode blockPos;
        ClassNode iBlockState;
        ClassNode blockRenderer = this.getClassNodeFromMapping("net/minecraft/client/renderer/BlockRendererDispatcher");
        if (!MeddleUtil.notNull((Object[])new Object[]{blockRenderer, iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState"), blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos"), iBlockAccess = this.getClassNodeFromMapping("net/minecraft/world/IBlockAccess")})) {
            return false;
        }
        String blockModelShapes_name = null;
        for (FieldNode field : blockRenderer.fields) {
            Type t = Type.getType((String)field.desc);
            if (t.getSort() != 10) continue;
            String className = t.getClassName();
            if (blockModelShapes_name != null || !this.searchConstantPoolForStrings(className, "minecraft:blocks/planks_oak", "minecraft:items/barrier")) continue;
            this.addClassMapping("net/minecraft/client/renderer/BlockModelShapes", className);
            blockModelShapes_name = className;
            if (this.countFieldsWithDesc(blockRenderer, "L" + blockModelShapes_name + ";") != 1) continue;
            this.addFieldMapping("net/minecraft/client/renderer/BlockRendererDispatcher blockModelShapes Lnet/minecraft/client/renderer/BlockModelShapes;", blockRenderer.name + " " + field.name + " " + field.desc);
        }
        List<MethodNode> methods = this.getMatchingMethods(blockRenderer, null, "()L" + blockModelShapes_name + ";");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/client/renderer/BlockRendererDispatcher getBlockModelShapes ()Lnet/minecraft/client/renderer/BlockModelShapes;", blockRenderer.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        String worldRenderer_name = null;
        String desc_front = DynamicMappings.assembleDescriptor("(", iBlockState, blockPos, iBlockAccess);
        methods.clear();
        for (MethodNode method : blockRenderer.methods) {
            if (!method.desc.startsWith(desc_front) || !method.desc.endsWith(";)Z")) continue;
            methods.add(method);
        }
        if (methods.size() == 1) {
            Type t = Type.getMethodType((String)methods.get((int)0).desc);
            Type[] args = t.getArgumentTypes();
            worldRenderer_name = args[3].getClassName();
            if (DynamicMappings.searchConstantPoolForStrings(worldRenderer_name, "Already building!", "Not building!")) {
                this.addClassMapping("net/minecraft/client/renderer/WorldRenderer", worldRenderer_name);
                this.addMethodMapping("net/minecraft/client/renderer/BlockRendererDispatcher renderBlock (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/BlockPos;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/WorldRenderer;)Z", blockRenderer.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            } else {
                worldRenderer_name = null;
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/client/renderer/vertex/VertexFormat"}, providesMethods={"net/minecraft/client/renderer/WorldRenderer startDrawing (ILnet/minecraft/client/renderer/vertex/VertexFormat;)V", "net/minecraft/client/renderer/WorldRenderer finishDrawing ()V"}, depends={"net/minecraft/client/renderer/WorldRenderer"})
    public boolean processWorldRendererClass() {
        ClassNode worldRenderer = this.getClassNodeFromMapping("net/minecraft/client/renderer/WorldRenderer");
        if (!MeddleUtil.notNull((Object[])new Object[]{worldRenderer})) {
            return false;
        }
        List<Object> methods = new ArrayList();
        String vertexFormat_name = null;
        for (MethodNode method : worldRenderer.methods) {
            Type[] typeArray;
            Type t = Type.getMethodType((String)method.desc);
            if (t.getReturnType().getSort() != 0 || (typeArray = t.getArgumentTypes()).length != 2 || typeArray[0].getSort() != 5 || typeArray[1].getSort() != 10) continue;
            methods.add(method);
            vertexFormat_name = typeArray[1].getClassName();
        }
        if (methods.size() == 1 && DynamicMappings.searchConstantPoolForStrings(vertexFormat_name, "VertexFormat error: Trying to add a position VertexFormatElement when one already exists, ignoring.")) {
            this.addClassMapping("net/minecraft/client/renderer/vertex/VertexFormat", vertexFormat_name);
            this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer startDrawing (ILnet/minecraft/client/renderer/vertex/VertexFormat;)V", worldRenderer.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        } else {
            vertexFormat_name = null;
        }
        methods = DynamicMappings.getMatchingMethods(worldRenderer, null, "()V");
        int count = 0;
        String finishDrawing = null;
        for (MethodNode methodNode : methods) {
            for (AbstractInsnNode insn = methodNode.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (!DynamicMappings.isLdcWithString(insn, "Not building!")) continue;
                finishDrawing = methodNode.name;
                ++count;
            }
        }
        if (count == 1 && finishDrawing != null) {
            this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer finishDrawing ()V", worldRenderer.name + " " + finishDrawing + " ()V");
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/client/renderer/WorldRenderer sortQuads (FFF)V", "net/minecraft/client/renderer/WorldRenderer putColor4 (I)V", "net/minecraft/client/renderer/WorldRenderer getByteBuffer ()Ljava/nio/ByteBuffer;", "net/minecraft/client/renderer/WorldRenderer postNormal (FFF)V", "net/minecraft/client/renderer/WorldRenderer getDrawMode ()I", "net/minecraft/client/renderer/WorldRenderer setTranslation (DDD)V", "net/minecraft/client/renderer/WorldRenderer endVertex ()V", "net/minecraft/client/renderer/WorldRenderer setNormal (FFF)Lnet/minecraft/client/renderer/WorldRenderer;", "net/minecraft/client/renderer/WorldRenderer setColorRGBA (IIII)Lnet/minecraft/client/renderer/WorldRenderer;", "net/minecraft/client/renderer/WorldRenderer setColorRGBA_F (FFFF)Lnet/minecraft/client/renderer/WorldRenderer;", "net/minecraft/client/renderer/WorldRenderer setBrightness (II)Lnet/minecraft/client/renderer/WorldRenderer;", "net/minecraft/client/renderer/WorldRenderer setTextureUV (DD)Lnet/minecraft/client/renderer/WorldRenderer;", "net/minecraft/client/renderer/WorldRenderer addVertex (DDD)Lnet/minecraft/client/renderer/WorldRenderer;", "net/minecraft/client/renderer/WorldRenderer putBrightness4 (IIII)V", "net/minecraft/client/renderer/WorldRenderer putPosition (DDD)V", "net/minecraft/client/renderer/WorldRenderer putColorRGB_F (FFFI)V", "net/minecraft/client/renderer/WorldRenderer putColorMultiplier (FFFI)V", "net/minecraft/client/renderer/WorldRenderer putBulkData ([I)V", "net/minecraft/client/renderer/WorldRenderer getVertexCount ()I", "net/minecraft/client/renderer/WorldRenderer reset ()V", "net/minecraft/client/renderer/WorldRenderer putColorRGB_F4 (FFF)V", "net/minecraft/client/renderer/WorldRenderer markDirty ()V"}, depends={"net/minecraft/client/renderer/WorldRenderer", "net/minecraft/client/renderer/vertex/VertexFormat"})
    public boolean processRealmsBufferBuilderClass() {
        List<MethodInsnNode> list;
        ClassNode vertexFormat;
        ClassNode worldRenderer;
        ClassNode bufferBuilder = this.getClassNode("net/minecraft/realms/RealmsBufferBuilder");
        if (!MeddleUtil.notNull((Object[])new Object[]{bufferBuilder, worldRenderer = this.getClassNodeFromMapping("net/minecraft/client/renderer/WorldRenderer"), vertexFormat = this.getClassNodeFromMapping("net/minecraft/client/renderer/vertex/VertexFormat")})) {
            return false;
        }
        MethodNode method = null;
        method = this.getMethodNode(bufferBuilder, "- sortQuads (FFF)V");
        if (method != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("(FFF)V")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer sortQuads (FFF)V", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- fixupQuadColor (I)V")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("(I)V")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer putColor4 (I)V", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- getBuffer ()Ljava/nio/ByteBuffer;")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("()Ljava/nio/ByteBuffer;")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer getByteBuffer ()Ljava/nio/ByteBuffer;", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- postNormal (FFF)V")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("(FFF)V")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer postNormal (FFF)V", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- getDrawMode ()I")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("()I")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer getDrawMode ()I", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- offset (DDD)V")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("(DDD)V")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer setTranslation (DDD)V", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- endVertex ()V")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("()V")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer endVertex ()V", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- normal (FFF)Lnet/minecraft/realms/RealmsBufferBuilder;")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("(FFF)L" + worldRenderer.name + ";")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer setNormal (FFF)Lnet/minecraft/client/renderer/WorldRenderer;", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- color (IIII)Lnet/minecraft/realms/RealmsBufferBuilder;")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("(IIII)L" + worldRenderer.name + ";")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer setColorRGBA (IIII)Lnet/minecraft/client/renderer/WorldRenderer;", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- color (FFFF)Lnet/minecraft/realms/RealmsBufferBuilder;")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("(FFFF)L" + worldRenderer.name + ";")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer setColorRGBA_F (FFFF)Lnet/minecraft/client/renderer/WorldRenderer;", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- tex2 (II)Lnet/minecraft/realms/RealmsBufferBuilder;")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("(II)L" + worldRenderer.name + ";")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer setBrightness (II)Lnet/minecraft/client/renderer/WorldRenderer;", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- tex (DD)Lnet/minecraft/realms/RealmsBufferBuilder;")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("(DD)L" + worldRenderer.name + ";")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer setTextureUV (DD)Lnet/minecraft/client/renderer/WorldRenderer;", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- vertex (DDD)Lnet/minecraft/realms/RealmsBufferBuilder;")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("(DDD)L" + worldRenderer.name + ";")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer addVertex (DDD)Lnet/minecraft/client/renderer/WorldRenderer;", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- faceTex2 (IIII)V")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("(IIII)V")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer putBrightness4 (IIII)V", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- postProcessFacePosition (DDD)V")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("(DDD)V")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer putPosition (DDD)V", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- fixupVertexColor (FFFI)V")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("(FFFI)V")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer putColorRGB_F (FFFI)V", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- faceTint (FFFI)V")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("(FFFI)V")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer putColorMultiplier (FFFI)V", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- putBulkData ([I)V")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("([I)V")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer putBulkData ([I)V", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- getVertexCount ()I")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("()I")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer getVertexCount ()I", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- clear ()V")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("()V")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer reset ()V", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- fixupQuadColor (FFF)V")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("(FFF)V")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer putColorRGB_F4 (FFF)V", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        if ((method = this.getMethodNode(bufferBuilder, "- noColor ()V")) != null) {
            list = DynamicMappings.getAllInsnNodesOfType(method.instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : list) {
                if (!mn.owner.equals(worldRenderer.name) || !mn.desc.equals("()V")) continue;
                this.addMethodMapping("net/minecraft/client/renderer/WorldRenderer markDirty ()V", worldRenderer.name + " " + mn.name + " " + mn.desc);
                break;
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/util/EnumWorldBlockLayer"}, providesMethods={"net/minecraft/client/renderer/RenderGlobal renderBlockLayer (Lnet/minecraft/util/EnumWorldBlockLayer;)V"}, depends={"net/minecraft/client/renderer/RenderGlobal", "net/minecraft/client/renderer/vertex/VertexFormat"})
    public boolean processRenderGlobalClass() {
        List<MethodNode> methods;
        ClassNode vertexFormat;
        ClassNode renderGlobal = this.getClassNodeFromMapping("net/minecraft/client/renderer/RenderGlobal");
        if (!MeddleUtil.notNull((Object[])new Object[]{renderGlobal, vertexFormat = this.getClassNodeFromMapping("net/minecraft/client/renderer/vertex/VertexFormat")})) {
            return false;
        }
        Object renderBlockLayer_name = null;
        String enumWorldBlockLayer_name = null;
        MethodNode renderBlockLayer = null;
        HashSet<String> matches = new HashSet<String>();
        for (MethodNode method : renderGlobal.methods) {
            Type[] args;
            Type t = Type.getMethodType((String)method.desc);
            if (t.getReturnType().getSort() != 0 || (args = t.getArgumentTypes()).length != 1 || args[0].getSort() != 10) continue;
            matches.add(args[0].getClassName());
        }
        for (String className : matches) {
            if (!DynamicMappings.searchConstantPoolForStrings(className, "Solid", "Mipped Cutout", "Cutout", "Translucent")) continue;
            this.addClassMapping("net/minecraft/util/EnumWorldBlockLayer", className);
            enumWorldBlockLayer_name = className;
            break;
        }
        if ((methods = DynamicMappings.getMatchingMethods(renderGlobal, null, "(L" + enumWorldBlockLayer_name + ";)V")).size() == 1) {
            renderBlockLayer = methods.get(0);
            this.addMethodMapping("net/minecraft/client/renderer/RenderGlobal renderBlockLayer (Lnet/minecraft/util/EnumWorldBlockLayer;)V", renderGlobal.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/client/renderer/texture/TextureAtlasSprite"}, providesMethods={"net/minecraft/client/renderer/texture/TextureMap getAtlasSprite (Ljava/lang/String;)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;"}, depends={"net/minecraft/client/renderer/texture/TextureMap"})
    public boolean processTextureMapClass() {
        ClassNode textureMap = this.getClassNodeFromMapping("net/minecraft/client/renderer/texture/TextureMap");
        if (!MeddleUtil.notNull((Object[])new Object[]{textureMap})) {
            return false;
        }
        ArrayList<MethodNode> methods = new ArrayList<MethodNode>();
        Object textureAtlasSprite_name = null;
        for (MethodNode method : textureMap.methods) {
            if (!method.desc.startsWith("(Ljava/lang/String;)L")) continue;
            Type t = Type.getMethodType((String)method.desc);
            String className = t.getReturnType().getClassName();
            if (textureAtlasSprite_name == null && DynamicMappings.searchConstantPoolForStrings(className, "TextureAtlasSprite{name='", "Generating mipmaps for frame", "broken aspect ratio and not an animation")) {
                this.addClassMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite", className);
                methods.add(method);
                continue;
            }
            if (textureAtlasSprite_name == null || !className.equals(textureAtlasSprite_name)) continue;
            methods.add(method);
        }
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/client/renderer/texture/TextureMap getAtlasSprite (Ljava/lang/String;)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", textureMap.name + " " + ((MethodNode)methods.get((int)0)).name + " " + ((MethodNode)methods.get((int)0)).desc);
        }
        return true;
    }

    @Mapping(provides={}, providesFields={"net/minecraft/client/renderer/texture/TextureAtlasSprite iconName Ljava/lang/String;", "net/minecraft/client/renderer/texture/TextureAtlasSprite framesTextureData Ljava/util/List;", "net/minecraft/client/renderer/texture/TextureAtlasSprite rotated Z", "net/minecraft/client/renderer/texture/TextureAtlasSprite originX I", "net/minecraft/client/renderer/texture/TextureAtlasSprite originY I", "net/minecraft/client/renderer/texture/TextureAtlasSprite height I", "net/minecraft/client/renderer/texture/TextureAtlasSprite width I", "net/minecraft/client/renderer/texture/TextureAtlasSprite minU F", "net/minecraft/client/renderer/texture/TextureAtlasSprite maxU F", "net/minecraft/client/renderer/texture/TextureAtlasSprite minV F", "net/minecraft/client/renderer/texture/TextureAtlasSprite maxV F"}, providesMethods={"net/minecraft/client/renderer/texture/TextureAtlasSprite getIconName ()Ljava/lang/String;", "net/minecraft/client/renderer/texture/TextureAtlasSprite getMinU ()F", "net/minecraft/client/renderer/texture/TextureAtlasSprite getMinV ()F", "net/minecraft/client/renderer/texture/TextureAtlasSprite getMaxU ()F", "net/minecraft/client/renderer/texture/TextureAtlasSprite getMaxV ()F", "net/minecraft/client/renderer/texture/TextureAtlasSprite getInterpolatedU (D)F", "net/minecraft/client/renderer/texture/TextureAtlasSprite getInterpolatedV (D)F"}, depends={"net/minecraft/client/renderer/texture/TextureAtlasSprite"})
    public boolean processTextureAtlasSpriteClass() {
        List<MethodNode> methods;
        MethodNode method;
        ClassNode sprite = this.getClassNodeFromMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite");
        if (!MeddleUtil.notNull((Object[])new Object[]{sprite})) {
            return false;
        }
        MethodNode toString = DynamicMappings.getMethodNode(sprite, "- toString ()Ljava/lang/String;");
        if (toString == null) {
            return false;
        }
        String iconName = null;
        String framesTextureData = null;
        String rotated = null;
        String originX = null;
        String originY = null;
        String height = null;
        String width = null;
        String minU = null;
        String maxU = null;
        String minV = null;
        String maxV = null;
        for (AbstractInsnNode insn = toString.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            FieldInsnNode fn;
            if (iconName == null && DynamicMappings.isLdcWithString(insn, "TextureAtlasSprite{name='")) {
                fn = DynamicMappings.getNextInsnNodeOfType(insn, FieldInsnNode.class);
                if (fn == null || !fn.owner.equals(sprite.name) || !fn.desc.equals("Ljava/lang/String;")) continue;
                iconName = fn.name;
                insn = fn;
                continue;
            }
            if (framesTextureData == null && DynamicMappings.isLdcWithString(insn, ", frameCount=")) {
                fn = DynamicMappings.getNextInsnNodeOfType(insn, FieldInsnNode.class);
                if (fn == null || !fn.owner.equals(sprite.name) || !fn.desc.equals("Ljava/util/List;")) continue;
                framesTextureData = fn.name;
                insn = fn;
                continue;
            }
            if (rotated == null && DynamicMappings.isLdcWithString(insn, ", rotated=")) {
                fn = DynamicMappings.getNextInsnNodeOfType(insn, FieldInsnNode.class);
                if (fn == null || !fn.owner.equals(sprite.name) || !fn.desc.equals("Z")) continue;
                rotated = fn.name;
                insn = fn;
                continue;
            }
            if (originX == null && DynamicMappings.isLdcWithString(insn, ", x=")) {
                fn = DynamicMappings.getNextInsnNodeOfType(insn, FieldInsnNode.class);
                if (fn == null || !fn.owner.equals(sprite.name) || !fn.desc.equals("I")) continue;
                originX = fn.name;
                insn = fn;
                continue;
            }
            if (originY == null && DynamicMappings.isLdcWithString(insn, ", y=")) {
                fn = DynamicMappings.getNextInsnNodeOfType(insn, FieldInsnNode.class);
                if (fn == null || !fn.owner.equals(sprite.name) || !fn.desc.equals("I")) continue;
                originY = fn.name;
                insn = fn;
                continue;
            }
            if (height == null && DynamicMappings.isLdcWithString(insn, ", height=")) {
                fn = DynamicMappings.getNextInsnNodeOfType(insn, FieldInsnNode.class);
                if (fn == null || !fn.owner.equals(sprite.name) || !fn.desc.equals("I")) continue;
                height = fn.name;
                insn = fn;
                continue;
            }
            if (width == null && DynamicMappings.isLdcWithString(insn, ", width=")) {
                fn = DynamicMappings.getNextInsnNodeOfType(insn, FieldInsnNode.class);
                if (fn == null || !fn.owner.equals(sprite.name) || !fn.desc.equals("I")) continue;
                width = fn.name;
                insn = fn;
                continue;
            }
            if (minU == null && DynamicMappings.isLdcWithString(insn, ", u0=")) {
                fn = DynamicMappings.getNextInsnNodeOfType(insn, FieldInsnNode.class);
                if (fn == null || !fn.owner.equals(sprite.name) || !fn.desc.equals("F")) continue;
                minU = fn.name;
                insn = fn;
                continue;
            }
            if (maxU == null && DynamicMappings.isLdcWithString(insn, ", u1=")) {
                fn = DynamicMappings.getNextInsnNodeOfType(insn, FieldInsnNode.class);
                if (fn == null || !fn.owner.equals(sprite.name) || !fn.desc.equals("F")) continue;
                maxU = fn.name;
                insn = fn;
                continue;
            }
            if (minV == null && DynamicMappings.isLdcWithString(insn, ", v0=")) {
                fn = DynamicMappings.getNextInsnNodeOfType(insn, FieldInsnNode.class);
                if (fn == null || !fn.owner.equals(sprite.name) || !fn.desc.equals("F")) continue;
                minV = fn.name;
                insn = fn;
                continue;
            }
            if (maxV != null || !DynamicMappings.isLdcWithString(insn, ", v1=") || (fn = DynamicMappings.getNextInsnNodeOfType(insn, FieldInsnNode.class)) == null || !fn.owner.equals(sprite.name) || !fn.desc.equals("F")) continue;
            maxV = fn.name;
            insn = fn;
        }
        if (iconName != null) {
            this.addFieldMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite iconName Ljava/lang/String;", sprite.name + " " + iconName + " Ljava/lang/String;");
        }
        if (framesTextureData != null) {
            this.addFieldMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite framesTextureData Ljava/util/List;", sprite.name + " " + framesTextureData + " Ljava/util/List;");
        }
        if (rotated != null) {
            this.addFieldMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite rotated Z", sprite.name + " " + rotated + " Z");
        }
        if (originX != null) {
            this.addFieldMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite originX I", sprite.name + " " + originX + " I");
        }
        if (originY != null) {
            this.addFieldMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite originY I", sprite.name + " " + originY + " I");
        }
        if (height != null) {
            this.addFieldMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite height I", sprite.name + " " + height + " I");
        }
        if (width != null) {
            this.addFieldMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite width I", sprite.name + " " + width + " I");
        }
        if (minU != null) {
            this.addFieldMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite minU F", sprite.name + " " + minU + " F");
        }
        if (maxU != null) {
            this.addFieldMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite maxU F", sprite.name + " " + maxU + " F");
        }
        if (minV != null) {
            this.addFieldMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite minV F", sprite.name + " " + minV + " F");
        }
        if (maxV != null) {
            this.addFieldMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite maxV F", sprite.name + " " + maxV + " F");
        }
        if ((method = ClientMappings.findGetterMethod(sprite, iconName, "Ljava/lang/String;")) != null) {
            this.addMethodMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite getIconName ()Ljava/lang/String;", sprite.name + " " + method.name + " " + method.desc);
        }
        if ((method = ClientMappings.findGetterMethod(sprite, minU, "F")) != null) {
            this.addMethodMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite getMinU ()F", sprite.name + " " + method.name + " " + method.desc);
        }
        if ((method = ClientMappings.findGetterMethod(sprite, minV, "F")) != null) {
            this.addMethodMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite getMinV ()F", sprite.name + " " + method.name + " " + method.desc);
        }
        if ((method = ClientMappings.findGetterMethod(sprite, maxU, "F")) != null) {
            this.addMethodMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite getMaxU ()F", sprite.name + " " + method.name + " " + method.desc);
        }
        if ((method = ClientMappings.findGetterMethod(sprite, maxV, "F")) != null) {
            this.addMethodMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite getMaxV ()F", sprite.name + " " + method.name + " " + method.desc);
        }
        if ((methods = DynamicMappings.getMatchingMethods(sprite, null, "(D)F")).size() == 2) {
            FieldInsnNode fn1 = DynamicMappings.getNextInsnNodeOfType(methods.get((int)0).instructions.getFirst(), FieldInsnNode.class);
            FieldInsnNode fn2 = DynamicMappings.getNextInsnNodeOfType(methods.get((int)1).instructions.getFirst(), FieldInsnNode.class);
            if (fn1.owner.equals(sprite.name) && fn2.owner.equals(sprite.name)) {
                MethodNode getInterpolatedU = null;
                MethodNode getInterpolatedV = null;
                if (fn1.name.equals(maxU) && fn2.name.equals(maxV)) {
                    getInterpolatedU = methods.get(0);
                    getInterpolatedV = methods.get(1);
                } else if (fn1.name.equals(maxV) && fn2.name.equals(maxU)) {
                    getInterpolatedU = methods.get(1);
                    getInterpolatedV = methods.get(0);
                }
                if (getInterpolatedU != null && getInterpolatedV != null) {
                    this.addMethodMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite getInterpolatedU (D)F", sprite.name + " " + getInterpolatedU.name + " (D)F");
                    this.addMethodMapping("net/minecraft/client/renderer/texture/TextureAtlasSprite getInterpolatedV (D)F", sprite.name + " " + getInterpolatedV.name + " (D)F");
                }
            }
        }
        return true;
    }

    @Mapping(providesMethods={"net/minecraft/block/Block getMixedBrightnessForBlock (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;)I", "net/minecraft/block/Block getSelectedBoundingBox (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)Lnet/minecraft/util/AxisAlignedBB;", "net/minecraft/block/Block shouldSideBeRendered (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/EnumFacing;)Z", "net/minecraft/block/Block randomDisplayTick (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Ljava/util/Random;)V", "net/minecraft/block/Block getSubBlocks (Lnet/minecraft/item/Item;Lnet/minecraft/creativetab/CreativeTabs;Ljava/util/List;)V", "net/minecraft/block/Block getCreativeTabToDisplayOn ()Lnet/minecraft/creativetab/CreativeTabs;", "net/minecraft/block/Block getBlockLayer ()Lnet/minecraft/util/EnumWorldBlockLayer;"}, dependsMethods={"net/minecraft/block/Block getCollisionBoundingBox (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)Lnet/minecraft/util/AxisAlignedBB;"}, depends={"net/minecraft/block/Block", "net/minecraft/world/IBlockAccess", "net/minecraft/util/BlockPos", "net/minecraft/block/state/IBlockState", "net/minecraft/world/World", "net/minecraft/util/AxisAlignedBB", "net/minecraft/util/EnumFacing", "net/minecraft/item/Item", "net/minecraft/creativetab/CreativeTabs", "net/minecraft/util/EnumWorldBlockLayer"})
    public boolean processBlockClass() {
        ClassNode enumWorldBlockLayer;
        ClassNode creativeTabs;
        ClassNode item;
        ClassNode enumFacing;
        ClassNode aabb;
        ClassNode block = this.getClassNodeFromMapping("net/minecraft/block/Block");
        ClassNode iBlockAccess = this.getClassNodeFromMapping("net/minecraft/world/IBlockAccess");
        ClassNode blockPos = this.getClassNodeFromMapping("net/minecraft/util/BlockPos");
        ClassNode iBlockState = this.getClassNodeFromMapping("net/minecraft/block/state/IBlockState");
        ClassNode world = this.getClassNodeFromMapping("net/minecraft/world/World");
        if (!MeddleUtil.notNull((Object[])new Object[]{block, iBlockAccess, blockPos, world, aabb = this.getClassNodeFromMapping("net/minecraft/util/AxisAlignedBB"), enumFacing = this.getClassNodeFromMapping("net/minecraft/util/EnumFacing"), item = this.getClassNodeFromMapping("net/minecraft/item/Item"), creativeTabs = this.getClassNodeFromMapping("net/minecraft/creativetab/CreativeTabs"), enumWorldBlockLayer = this.getClassNodeFromMapping("net/minecraft/util/EnumWorldBlockLayer")})) {
            return false;
        }
        List<MethodNode> methods = DynamicMappings.getMatchingMethods(block, null, DynamicMappings.assembleDescriptor("(", iBlockState, iBlockAccess, blockPos, ")I"));
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getMixedBrightnessForBlock (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;)I", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        MethodNode getCollisionBoundingBox = this.getMethodNodeFromMapping(block, "net/minecraft/block/Block getCollisionBoundingBox (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)Lnet/minecraft/util/AxisAlignedBB;");
        methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", iBlockState, world, blockPos, ")", aabb));
        if (methods.size() == 2 && getCollisionBoundingBox != null) {
            Iterator<MethodNode> it = methods.iterator();
            while (it.hasNext()) {
                MethodNode method = it.next();
                if (!method.name.equals(getCollisionBoundingBox.name)) continue;
                it.remove();
            }
            if (methods.size() == 1) {
                this.addMethodMapping("net/minecraft/block/Block getSelectedBoundingBox (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)Lnet/minecraft/util/AxisAlignedBB;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            }
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", iBlockState, iBlockAccess, blockPos, enumFacing, ")Z"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block shouldSideBeRendered (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/EnumFacing;)Z", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", iBlockState, world, blockPos, "Ljava/util/Random;)V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block randomDisplayTick (Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;Ljava/util/Random;)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("(", item, creativeTabs, "Ljava/util/List;)V"))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getSubBlocks (Lnet/minecraft/item/Item;Lnet/minecraft/creativetab/CreativeTabs;Ljava/util/List;)V", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, this.assembleDescriptor("()", creativeTabs))).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getCreativeTabToDisplayOn ()Lnet/minecraft/creativetab/CreativeTabs;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(block, null, "()L" + enumWorldBlockLayer.name + ";")).size() == 1) {
            this.addMethodMapping("net/minecraft/block/Block getBlockLayer ()Lnet/minecraft/util/EnumWorldBlockLayer;", block.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/client/gui/GuiSlot", "net/minecraft/client/gui/GuiListExtended", "net/minecraft/client/gui/ServerSelectionList", "net/minecraft/client/multiplayer/ServerList"}, dependsMethods={"net/minecraft/client/gui/GuiScreen initGui ()V"}, depends={"net/minecraft/client/gui/GuiMultiplayer", "net/minecraft/client/Minecraft"})
    public boolean processGuiMultiplayerClass() {
        ClassNode minecraft;
        ClassNode guiMultiplayer = this.getClassNodeFromMapping("net/minecraft/client/gui/GuiMultiplayer");
        if (!MeddleUtil.notNull((Object[])new Object[]{guiMultiplayer, minecraft = this.getClassNodeFromMapping("net/minecraft/client/Minecraft")})) {
            return false;
        }
        MethodNode initGui = this.getMethodNodeFromMapping(guiMultiplayer, "net/minecraft/client/gui/GuiScreen initGui ()V");
        if (initGui == null) {
            return false;
        }
        String serverList = null;
        List<TypeInsnNode> nodes = this.getAllInsnNodesOfType(initGui.instructions.getFirst(), TypeInsnNode.class);
        for (TypeInsnNode node : nodes) {
            if (node.desc.startsWith("java/") || serverList != null || !this.searchConstantPoolForStrings(node.desc, "servers.dat", "servers", "Couldn't load server list")) continue;
            this.addClassMapping("net/minecraft/client/multiplayer/ServerList", node.desc);
            serverList = node.desc;
        }
        List<MethodInsnNode> miNodes = this.getAllInsnNodesOfType(initGui.instructions.getFirst(), MethodInsnNode.class);
        Iterator<MethodInsnNode> it = miNodes.iterator();
        while (it.hasNext()) {
            MethodInsnNode mn = it.next();
            if (mn.name.equals("<init>") && mn.desc.equals("(L" + guiMultiplayer.name + ";L" + minecraft.name + ";IIIII)V")) continue;
            it.remove();
        }
        ClassNode serverSelectionList = null;
        if (miNodes.size() == 1) {
            serverSelectionList = this.getClassNode(miNodes.get((int)0).owner);
            if (serverSelectionList.superName.equals("java/lang/Object")) {
                return false;
            }
            ClassNode guiListExtended = this.getClassNode(serverSelectionList.superName);
            if (guiListExtended.superName.equals("java/lang/Object")) {
                return false;
            }
            if ((guiListExtended.access & 0x400) == 0) {
                return false;
            }
            ClassNode guiSlot = this.getClassNode(guiListExtended.superName);
            if ((guiSlot.access & 0x400) == 0) {
                return false;
            }
            if (guiSlot.superName.equals("java/lang/Object")) {
                this.addClassMapping("net/minecraft/client/gui/ServerSelectionList", serverSelectionList.name);
                this.addClassMapping("net/minecraft/client/gui/GuiListExtended", guiListExtended.name);
                this.addClassMapping("net/minecraft/client/gui/GuiSlot", guiSlot.name);
            } else {
                serverSelectionList = null;
                guiListExtended = null;
                guiSlot = null;
            }
        }
        return true;
    }

    @Mapping(provides={"net/minecraft/client/gui/GuiListExtended$IGuiListEntry"}, providesMethods={"net/minecraft/client/gui/GuiSlot elementClicked (IZII)V", "net/minecraft/client/gui/GuiSlot isSelected (I)Z", "net/minecraft/client/gui/GuiSlot drawBackground ()V", "net/minecraft/client/gui/GuiSlot drawSlot (IIIIII)V", "net/minecraft/client/gui/GuiSlot func_178040_a (III)V", "net/minecraft/client/gui/GuiListExtended getListEntry (I)Lnet/minecraft/client/gui/GuiListExtended$IGuiListEntry;", "net/minecraft/client/gui/GuiListExtended mouseClicked (III)Z", "net/minecraft/client/gui/GuiListExtended mouseReleased (III)Z"}, depends={"net/minecraft/client/gui/GuiListExtended", "net/minecraft/client/gui/GuiSlot"})
    public boolean processGuiListExtendedClass() {
        ClassNode guiSlot;
        ClassNode guiListExtended = this.getClassNodeFromMapping("net/minecraft/client/gui/GuiListExtended");
        if (!MeddleUtil.notNull((Object[])new Object[]{guiListExtended, guiSlot = this.getClassNodeFromMapping("net/minecraft/client/gui/GuiSlot")})) {
            return false;
        }
        List<MethodNode> methods = this.getMatchingMethods(guiListExtended, null, "(IZII)V");
        if (methods.size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/GuiSlot elementClicked (IZII)V", guiSlot.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(guiListExtended, null, "(I)Z")).size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/GuiSlot isSelected (I)Z", guiSlot.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(guiListExtended, null, "()V")).size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/GuiSlot drawBackground ()V", guiSlot.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(guiListExtended, null, "(IIIIII)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/GuiSlot drawSlot (IIIIII)V", guiSlot.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        if ((methods = this.getMatchingMethods(guiListExtended, null, "(III)V")).size() == 1) {
            this.addMethodMapping("net/minecraft/client/gui/GuiSlot func_178040_a (III)V", guiSlot.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
        }
        methods.clear();
        for (MethodNode mn : guiListExtended.methods) {
            if (!mn.desc.startsWith("(I)L")) continue;
            methods.add(mn);
        }
        ClassNode iGuiListEntry = null;
        if (methods.size() == 1) {
            Type t = Type.getMethodType((String)methods.get((int)0).desc);
            Type returnType = t.getReturnType();
            iGuiListEntry = this.getClassNode(returnType.getClassName());
            if (iGuiListEntry != null && (iGuiListEntry.access & 0x200) != 0) {
                this.addClassMapping("net/minecraft/client/gui/GuiListExtended$IGuiListEntry", iGuiListEntry.name);
                this.addMethodMapping("net/minecraft/client/gui/GuiListExtended getListEntry (I)Lnet/minecraft/client/gui/GuiListExtended$IGuiListEntry;", guiListExtended.name + " " + methods.get((int)0).name + " " + methods.get((int)0).desc);
            } else {
                iGuiListEntry = null;
            }
        }
        if ((methods = this.getMatchingMethods(guiListExtended, null, "(III)Z")).size() == 2) {
            ArrayList<String> mousePressed = new ArrayList<String>();
            ArrayList<String> mouseReleased = new ArrayList<String>();
            List<MethodInsnNode> mnList1 = this.getAllInsnNodesOfType(methods.get((int)0).instructions.getFirst(), MethodInsnNode.class);
            List<MethodInsnNode> mnList2 = this.getAllInsnNodesOfType(methods.get((int)1).instructions.getFirst(), MethodInsnNode.class);
            for (MethodInsnNode mn : mnList1) {
                if (mn.desc.equals("(IIIIII)Z")) {
                    mousePressed.add(methods.get((int)0).name);
                    continue;
                }
                if (!mn.desc.equals("(IIIIII)V")) continue;
                mouseReleased.add(methods.get((int)0).name);
            }
            for (MethodInsnNode mn : mnList2) {
                if (mn.desc.equals("(IIIIII)Z")) {
                    mousePressed.add(methods.get((int)1).name);
                    continue;
                }
                if (!mn.desc.equals("(IIIIII)V")) continue;
                mouseReleased.add(methods.get((int)1).name);
            }
            if (mousePressed.size() == 1 && mouseReleased.size() == 1) {
                this.addMethodMapping("net/minecraft/client/gui/GuiListExtended mouseClicked (III)Z", guiListExtended.name + " " + (String)mousePressed.get(0) + " (III)Z");
                this.addMethodMapping("net/minecraft/client/gui/GuiListExtended mouseReleased (III)Z", guiListExtended.name + " " + (String)mouseReleased.get(0) + " (III)Z");
            }
        }
        return true;
    }

    public static MethodNode findGetterMethod(ClassNode cn, String fieldName, String fieldDesc) {
        int returnOpcode = 176;
        if (fieldDesc.equals("I")) {
            returnOpcode = 172;
        } else if (fieldDesc.equals("F")) {
            returnOpcode = 174;
        } else if (fieldDesc.equals("D")) {
            returnOpcode = 175;
        } else if (fieldDesc.equals("J")) {
            returnOpcode = 173;
        }
        ArrayList<MethodNode> methods = new ArrayList<MethodNode>();
        for (MethodNode method : cn.methods) {
            AbstractInsnNode[] list = DynamicMappings.getOpcodeSequenceArray(method.instructions.getFirst(), 25, 180, returnOpcode);
            if (list == null) continue;
            FieldInsnNode fn = (FieldInsnNode)list[1];
            if (!fn.owner.equals(cn.name) || !fn.name.equals(fieldName)) continue;
            methods.add(method);
        }
        if (methods.size() == 1) {
            return (MethodNode)methods.get(0);
        }
        return null;
    }

    public static void main(String[] args) {
        DynamicMappings.main(args);
    }

    @Mapping(providesFields={"net/minecraft/util/EnumWorldBlockLayer SOLID Lnet/minecraft/util/EnumWorldBlockLayer;", "net/minecraft/util/EnumWorldBlockLayer CUTOUT_MIPPED Lnet/minecraft/util/EnumWorldBlockLayer;", "net/minecraft/util/EnumWorldBlockLayer CUTOUT Lnet/minecraft/util/EnumWorldBlockLayer;", "net/minecraft/util/EnumWorldBlockLayer TRANSLUCENT Lnet/minecraft/util/EnumWorldBlockLayer;"}, depends={"net/minecraft/util/EnumWorldBlockLayer"})
    public boolean processEnumWorldBlockLayerClass() {
        ClassNode blockLayer = this.getClassNodeFromMapping("net/minecraft/util/EnumWorldBlockLayer");
        if (blockLayer == null) {
            return false;
        }
        MethodNode clinit = this.getMethodNode(blockLayer, "--- <clinit> ()V");
        if (clinit != null) {
            String name = null;
            for (AbstractInsnNode insn = clinit.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                String temp = this.getLdcString(insn);
                if (name == null && temp != null) {
                    name = temp;
                    continue;
                }
                if (name == null || insn.getOpcode() != 179) continue;
                FieldInsnNode fn = (FieldInsnNode)insn;
                if (!fn.desc.equals("L" + blockLayer.name + ";")) continue;
                this.addFieldMapping("net/minecraft/util/EnumWorldBlockLayer " + name + " Lnet/minecraft/util/EnumWorldBlockLayer;", blockLayer.name + " " + fn.name + " " + fn.desc);
                name = null;
            }
        }
        return true;
    }

    public static class TallyKeeper<T> {
        private Map<T, Integer> counts = new HashMap<T, Integer>();

        public void put(T t) {
            Integer count = this.counts.get(t);
            if (count == null) {
                count = new Integer(0);
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            this.counts.put(t, count);
        }

        public T getHighestObj() {
            int maxCount = -1;
            T maxKey = null;
            for (T key : this.counts.keySet()) {
                int count = this.counts.get(key);
                if (count <= maxCount) continue;
                maxCount = count;
                maxKey = key;
            }
            return maxKey;
        }

        public int getHighestCount() {
            int maxCount = -1;
            for (T key : this.counts.keySet()) {
                int count = this.counts.get(key);
                if (count <= maxCount) continue;
                maxCount = count;
            }
            return maxCount;
        }
    }
}

