/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.dynamicmappings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fybertech.dynamicmappings.DynamicMappings;
import net.fybertech.dynamicmappings.InheritanceMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class ModMappings {
    static String[] exclusions = new String[]{"org/objectweb/", "java/", "net/minecraft/launchwrapper/", "net/fybertech/dynamicmappings/", "org/apache/", "net/fybertech/meddle/", "net/fybertech/meddleapi/"};

    public static boolean isExcluded(String owner) {
        for (String exclusion : exclusions) {
            if (!owner.startsWith(exclusion)) continue;
            return true;
        }
        return false;
    }

    public static List<File> walkTreeForClasses(File dir) {
        ArrayList<File> files = new ArrayList<File>();
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                files.addAll(ModMappings.walkTreeForClasses(f));
                continue;
            }
            if (!f.getName().endsWith(".class")) continue;
            files.add(f);
        }
        return files;
    }

    public static Set<String> searchConstantPoolForClasses(File classFile) {
        ClassReader reader;
        HashSet<String> classes = new HashSet<String>();
        try {
            FileInputStream stream = new FileInputStream(classFile);
            reader = new ClassReader((InputStream)stream);
        }
        catch (Exception e1) {
            return classes;
        }
        int itemCount = reader.getItemCount();
        char[] buffer = new char[reader.getMaxStringLength()];
        for (int n = 1; n < itemCount; ++n) {
            int pos = reader.getItem(n);
            if (pos == 0 || reader.b[pos - 1] != 7) continue;
            Arrays.fill(buffer, '\u0000');
            reader.readUTF8(pos, buffer);
            String string = new String(buffer).trim();
            if (string.length() < 1) continue;
            while (string != null && string.startsWith("[")) {
                string = ModMappings.getArrayType(string);
            }
            if (string == null || ModMappings.isExcluded(string)) continue;
            classes.add(string);
        }
        return classes;
    }

    public static Set<Holder> searchConstantPoolForFields(File classFile) {
        ClassReader reader;
        HashSet<Holder> fields = new HashSet<Holder>();
        try {
            FileInputStream stream = new FileInputStream(classFile);
            reader = new ClassReader((InputStream)stream);
        }
        catch (Exception e1) {
            return fields;
        }
        int itemCount = reader.getItemCount();
        char[] buffer = new char[reader.getMaxStringLength()];
        for (int n = 1; n < itemCount; ++n) {
            byte cpType;
            int pos = reader.getItem(n);
            if (pos == 0 || (cpType = reader.b[pos - 1]) != 9) continue;
            String owner = reader.readClass(pos, buffer);
            int cpIndex = reader.getItem(reader.readUnsignedShort(pos + 2));
            String name = reader.readUTF8(cpIndex, buffer);
            String desc = reader.readUTF8(cpIndex + 2, buffer);
            if (ModMappings.isExcluded(owner)) continue;
            fields.add(new Holder(cpType, owner, name, desc));
        }
        return fields;
    }

    public static Set<Holder> searchConstantPoolForMethods(File classFile) {
        ClassReader reader;
        HashSet<Holder> fields = new HashSet<Holder>();
        try {
            FileInputStream stream = new FileInputStream(classFile);
            reader = new ClassReader((InputStream)stream);
        }
        catch (Exception e1) {
            return fields;
        }
        int itemCount = reader.getItemCount();
        char[] buffer = new char[reader.getMaxStringLength()];
        for (int n = 1; n < itemCount; ++n) {
            byte cpType;
            int pos = reader.getItem(n);
            if (pos == 0 || (cpType = reader.b[pos - 1]) != 10 && cpType != 11) continue;
            String owner = reader.readClass(pos, buffer);
            int cpIndex = reader.getItem(reader.readUnsignedShort(pos + 2));
            String name = reader.readUTF8(cpIndex, buffer);
            String desc = reader.readUTF8(cpIndex + 2, buffer);
            if (ModMappings.isExcluded(owner)) continue;
            fields.add(new Holder(cpType, owner, name, desc));
        }
        return fields;
    }

    public static Set<Holder> getClassFields(File classFile) {
        ClassReader reader;
        HashSet<Holder> fields = new HashSet<Holder>();
        ClassNode cn = new ClassNode();
        try {
            FileInputStream stream = new FileInputStream(classFile);
            reader = new ClassReader((InputStream)stream);
        }
        catch (Exception e1) {
            return fields;
        }
        reader.accept((ClassVisitor)cn, 0);
        for (FieldNode field : cn.fields) {
            fields.add(new Holder(9, cn.name, field.name, field.desc));
        }
        return fields;
    }

    public static Set<Holder> getClassMethods(File classFile) {
        ClassReader reader;
        HashSet<Holder> methods = new HashSet<Holder>();
        ClassNode cn = new ClassNode();
        try {
            FileInputStream stream = new FileInputStream(classFile);
            reader = new ClassReader((InputStream)stream);
        }
        catch (Exception e1) {
            return methods;
        }
        reader.accept((ClassVisitor)cn, 0);
        for (MethodNode method : cn.methods) {
            methods.add(new Holder(10, cn.name, method.name, method.desc));
        }
        return methods;
    }

    public static String getArrayType(String array) {
        Type t = Type.getType((String)array);
        if (t.getSort() != 9) {
            return array;
        }
        if ((t = t.getElementType()).getSort() != 10) {
            return null;
        }
        return t.getClassName().replace(".", "/");
    }

    public static int getMappingSide(String mapping) {
        if (DynamicMappings.clientMappingsSet.contains(mapping)) {
            return 1;
        }
        if (DynamicMappings.serverMappingsSet.contains(mapping)) {
            return 2;
        }
        return 3;
    }

    public static void main(String[] args) {
        boolean hasMapping;
        String mapping;
        if (args.length < 1) {
            System.out.println("No input directory specified!");
            return;
        }
        File classDir = new File(args[0]);
        if (!classDir.exists() || !classDir.isDirectory()) {
            System.out.println("Doesn't exist or isn't directory: " + args[0]);
            return;
        }
        File outputFile = null;
        if (args.length < 2) {
            System.out.println("No output file specified, printing to console.");
        } else {
            outputFile = new File(args[1]);
        }
        DynamicMappings.simulatedMappings = true;
        DynamicMappings.generateClassMappings();
        HashSet<String> classes = new HashSet<String>();
        HashSet<Holder> fields = new HashSet<Holder>();
        HashSet<Holder> methods = new HashSet<Holder>();
        List<File> classFiles = ModMappings.walkTreeForClasses(classDir);
        for (File f : classFiles) {
            classes.addAll(ModMappings.searchConstantPoolForClasses(f));
            fields.addAll(ModMappings.searchConstantPoolForFields(f));
            fields.addAll(ModMappings.getClassFields(f));
            methods.addAll(ModMappings.searchConstantPoolForMethods(f));
            methods.addAll(ModMappings.getClassMethods(f));
        }
        InheritanceMap inheritanceMap = new InheritanceMap();
        ArrayList<String> output = new ArrayList<String>();
        for (String string : classes) {
            boolean hasMapping2 = DynamicMappings.classMappings.containsKey(string);
            if (!hasMapping2) continue;
            output.add("C " + ModMappings.getMappingSide(string) + " " + string);
        }
        for (Holder holder : fields) {
            InheritanceMap im = null;
            try {
                im = inheritanceMap.buildMap(holder.owner);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (im == null) {
                System.out.println("COULDN'T BUILD MAP: " + holder.owner);
                continue;
            }
            HashSet<InheritanceMap.FieldHolder> fh = im.fields.get(holder.name + " " + holder.desc);
            for (InheritanceMap.FieldHolder f : fh) {
                mapping = f.cn.name + " " + f.fn.name + " " + f.fn.desc;
                hasMapping = DynamicMappings.fieldMappings.containsKey(mapping);
                if (!hasMapping) continue;
                output.add("F " + ModMappings.getMappingSide(mapping) + " " + mapping);
            }
        }
        for (Holder holder : methods) {
            InheritanceMap im = null;
            try {
                im = inheritanceMap.buildMap(holder.owner);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (im == null) {
                System.out.println("COULDN'T BUILD MAP: " + holder.owner);
                continue;
            }
            HashSet<InheritanceMap.MethodHolder> mh = im.methods.get(holder.name + " " + holder.desc);
            if (mh == null) continue;
            for (InheritanceMap.MethodHolder m : mh) {
                mapping = m.cn.name + " " + m.mn.name + " " + m.mn.desc;
                hasMapping = DynamicMappings.methodMappings.containsKey(mapping);
                if (!hasMapping) continue;
                output.add("M " + ModMappings.getMappingSide(mapping) + " " + mapping);
            }
        }
        if (outputFile != null) {
            outputFile.toPath().getParent().toFile().mkdirs();
            try {
                PrintWriter pw = new PrintWriter(new FileOutputStream(outputFile));
                for (String line : output) {
                    pw.println(line);
                }
                pw.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            for (String string : output) {
                System.out.println(string);
            }
        }
    }

    static class Holder {
        public int type;
        public String owner;
        public String name;
        public String desc;

        public Holder(int t, String o, String n, String d) {
            this.type = t;
            this.owner = o;
            this.name = n;
            this.desc = d;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.type;
            result = 31 * result + this.owner.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.desc.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            return obj.hashCode() == this.hashCode();
        }
    }
}

