/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.dynamicmappings;

import java.util.Iterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class MethodCallIterator
implements Iterator<MethodCall> {
    private MethodNode method;
    private AbstractInsnNode insn;
    private MethodCall next;
    private boolean printWarnings;
    private boolean printDebug;
    private int index;
    private Object[] stack;
    private Object[] vars;
    private int sp;

    public MethodCallIterator(MethodNode method, boolean printWarnings, boolean printDebug) {
        this.method = method;
        this.insn = this.method.instructions.getFirst();
        this.stack = new Object[100];
        this.vars = new Object[100];
        this.sp = 0;
        this.index = 0;
        this.printWarnings = printWarnings;
        this.printDebug = printDebug;
        this.next = null;
        this.loadNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public MethodCall next() {
        MethodCall result = this.next;
        this.loadNext();
        return result;
    }

    private boolean loadNext() {
        boolean foundNext = false;
        while (this.insn != null && !foundNext) {
            int opCode;
            if (this.insn instanceof LabelNode || this.insn instanceof LineNumberNode) {
                ++this.index;
            } else if (this.insn instanceof InsnNode) {
                int opCode2 = ((InsnNode)this.insn).getOpcode();
                switch (opCode2) {
                    case 3: {
                        this.stack[this.sp++] = 0;
                        break;
                    }
                    case 4: {
                        this.stack[this.sp++] = 1;
                        break;
                    }
                    case 5: {
                        this.stack[this.sp++] = 2;
                        break;
                    }
                    case 6: {
                        this.stack[this.sp++] = 3;
                        break;
                    }
                    case 7: {
                        this.stack[this.sp++] = 4;
                        break;
                    }
                    case 8: {
                        this.stack[this.sp++] = 5;
                        break;
                    }
                    case 89: {
                        this.stack[this.sp] = this.stack[this.sp - 1];
                        ++this.sp;
                        break;
                    }
                    case 11: {
                        this.stack[this.sp++] = Float.valueOf(0.0f);
                        break;
                    }
                    case 12: {
                        this.stack[this.sp++] = Float.valueOf(1.0f);
                        break;
                    }
                    case 13: {
                        this.stack[this.sp++] = Float.valueOf(2.0f);
                        break;
                    }
                    default: {
                        if (this.printWarnings) {
                            System.out.println("WARNING: discoverBlocks Unhandled InsnNode opcode: " + opCode2);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (this.insn instanceof FieldInsnNode) {
                FieldInsnNode fi = (FieldInsnNode)this.insn;
                opCode = fi.getOpcode();
                switch (opCode) {
                    case 178: {
                        this.stack[this.sp++] = fi.name;
                        break;
                    }
                    default: {
                        if (this.printWarnings) {
                            System.out.println("WARNING: discoverBlocks Unhandled FieldInsnNode opcode: " + opCode);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (this.insn instanceof TypeInsnNode) {
                TypeInsnNode ti = (TypeInsnNode)this.insn;
                opCode = ti.getOpcode();
                switch (opCode) {
                    case 187: {
                        this.stack[this.sp++] = ti.desc;
                        break;
                    }
                    case 189: {
                        this.stack[this.sp++] = ti.desc;
                        break;
                    }
                    default: {
                        if (this.printWarnings) {
                            System.out.println("WARNING: discoverBlocks Unhandled TypeInsnNode opcode: " + opCode);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (this.insn instanceof MethodInsnNode) {
                MethodInsnNode mi = (MethodInsnNode)this.insn;
                int argCount = MethodCallIterator.argCount(mi.desc);
                if (this.insn.getOpcode() == 183) {
                    ++argCount;
                }
                if (this.printDebug) {
                    System.out.print(this.index + ": " + mi.name + " (");
                }
                Object[] tempArgs = new Object[argCount];
                for (int i = argCount - 1; i >= 0; --i) {
                    tempArgs[i] = this.stack[--this.sp];
                    if (!this.printDebug) continue;
                    System.out.print(this.stack[this.sp] + ",");
                }
                if (this.printDebug) {
                    System.out.println(")");
                }
                this.next = new MethodCall(mi, tempArgs);
                foundNext = true;
            } else if (this.insn instanceof LdcInsnNode) {
                LdcInsnNode li = (LdcInsnNode)this.insn;
                this.stack[this.sp++] = li.cst;
            } else if (this.insn instanceof VarInsnNode) {
                VarInsnNode vi = (VarInsnNode)this.insn;
                opCode = vi.getOpcode();
                switch (opCode) {
                    case 25: {
                        this.stack[this.sp++] = this.vars[vi.var];
                        break;
                    }
                    case 58: {
                        this.vars[vi.var] = this.stack[--this.sp];
                        break;
                    }
                    default: {
                        if (this.printWarnings) {
                            System.out.println("WARNING: discoverBlocks Unhandled VarInsnNode opcode: " + opCode);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (this.insn instanceof IntInsnNode) {
                IntInsnNode ii = (IntInsnNode)this.insn;
                opCode = ii.getOpcode();
                switch (opCode) {
                    case 16: {
                        this.stack[this.sp++] = ii.operand;
                        break;
                    }
                    case 17: {
                        this.stack[this.sp++] = ii.operand;
                        break;
                    }
                    default: {
                        if (this.printWarnings) {
                            System.out.println("WARNING: discoverBlocks Unhandled IntInsnNode opcode: " + opCode);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (this.printWarnings) {
                System.out.println("WARNING: Unhandled IsnsNode " + this.index + ": " + this.insn.toString());
            }
            this.insn = this.insn.getNext();
        }
        if (!foundNext) {
            this.next = null;
        }
        return foundNext;
    }

    public static int argCount(String methodDesc) {
        int count = 0;
        boolean complexType = false;
        for (int i = 1; i < methodDesc.length() && methodDesc.charAt(i) != ')'; ++i) {
            if (complexType) {
                if (methodDesc.charAt(i) != ';') continue;
                complexType = false;
                ++count;
                continue;
            }
            if (methodDesc.charAt(i) == '[' || methodDesc.charAt(i) == 'L') {
                complexType = true;
                continue;
            }
            ++count;
        }
        return count;
    }

    public class MethodCall {
        public MethodInsnNode methodNode;
        public Object[] args;

        public MethodCall(MethodInsnNode methodNode, Object[] args) {
            this.methodNode = methodNode;
            this.args = args;
        }
    }
}

