/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.dynamicmappings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.fybertech.dynamicmappings.DynamicMappings;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class InheritanceMap {
    public Map<String, InheritanceMap> mapCache = new HashMap<String, InheritanceMap>();
    public List<String> privatefields = new ArrayList<String>();
    public List<String> privatemethods = new ArrayList<String>();
    public String className;
    public Map<String, HashSet<FieldHolder>> fields = new HashMap<String, HashSet<FieldHolder>>();
    public Map<String, HashSet<MethodHolder>> methods = new HashMap<String, HashSet<MethodHolder>>();

    public InheritanceMap() {
    }

    private InheritanceMap(ClassNode jc) {
        this.className = jc.name;
        for (FieldNode jf : jc.fields) {
            HashSet<FieldHolder> fieldslist;
            String fielddesc = jf.name + " " + jf.desc;
            if ((jf.access & 2) > 0) {
                this.privatefields.add(fielddesc);
            }
            if ((fieldslist = this.fields.get(fielddesc)) == null) {
                fieldslist = new HashSet();
                this.fields.put(fielddesc, fieldslist);
            }
            fieldslist.add(new FieldHolder(jc, jf));
        }
        for (MethodNode jm : jc.methods) {
            HashSet<MethodHolder> methodslist;
            String methoddesc = jm.name + " " + jm.desc;
            if ((jm.access & 2) > 0) {
                this.privatemethods.add(methoddesc);
            }
            if ((methodslist = this.methods.get(methoddesc)) == null) {
                methodslist = new HashSet();
                this.methods.put(methoddesc, methodslist);
            }
            methodslist.add(new MethodHolder(jc, jm));
        }
    }

    private void mergeMap(InheritanceMap cm) {
        for (String fielddesc : cm.fields.keySet()) {
            if (cm.privatefields.contains(fielddesc)) continue;
            if (this.fields.get(fielddesc) != null) {
                this.fields.get(fielddesc).addAll((Collection<FieldHolder>)cm.fields.get(fielddesc));
                continue;
            }
            HashSet f = new HashSet();
            f.addAll(cm.fields.get(fielddesc));
            this.fields.put(fielddesc, f);
        }
        for (String methoddesc : cm.methods.keySet()) {
            if (cm.privatemethods.contains(methoddesc)) continue;
            if (this.methods.get(methoddesc) != null) {
                this.methods.get(methoddesc).addAll((Collection<MethodHolder>)cm.methods.get(methoddesc));
                continue;
            }
            HashSet m = new HashSet();
            m.addAll(cm.methods.get(methoddesc));
            this.methods.put(methoddesc, m);
        }
    }

    public InheritanceMap buildMap(String paramClassname) throws IOException {
        ClassNode jc = this.locateClass(paramClassname);
        if (jc == null) {
            return null;
        }
        return this.buildMap(jc);
    }

    public InheritanceMap buildMap(ClassNode paramClass) throws IOException {
        InheritanceMap classmap = this.mapCache.get(paramClass.name);
        if (classmap != null) {
            return classmap;
        }
        classmap = new InheritanceMap(paramClass);
        for (String interfaceclassname : paramClass.interfaces) {
            ClassNode interfaceclass = this.locateClass(interfaceclassname);
            if (interfaceclass == null) {
                System.out.println("ERROR: Unable to locate " + interfaceclassname);
                continue;
            }
            classmap.mergeMap(this.buildMap(interfaceclass));
        }
        if (paramClass.superName != null) {
            String superclassname = paramClass.superName;
            ClassNode superclass = this.locateClass(superclassname);
            if (superclass == null) {
                System.out.println("ERROR: Unable to locate " + superclassname);
            } else {
                classmap.mergeMap(this.buildMap(superclass));
            }
        }
        this.mapCache.put(paramClass.name, classmap);
        return classmap;
    }

    public static ClassNode locateClassInJAR(String classname, String filename) throws IOException {
        JarFile jf = new JarFile(filename);
        Enumeration<JarEntry> e = jf.entries();
        while (e.hasMoreElements()) {
            JarEntry je = e.nextElement();
            String name = je.getName();
            if (!name.endsWith(".class") || !classname.equals(name.replace(".class", ""))) continue;
            ClassReader reader = new ClassReader(jf.getInputStream(je));
            ClassNode jc = new ClassNode();
            reader.accept((ClassVisitor)jc, 0);
            if (!jc.name.equals(classname)) continue;
            jf.close();
            return jc;
        }
        jf.close();
        return null;
    }

    public ClassNode locateClass(String classname) throws IOException {
        return DynamicMappings.getClassNode(classname);
    }

    public static void main(String[] args) throws IOException {
        InheritanceMap base = new InheritanceMap();
        InheritanceMap map = base.buildMap("ake");
        System.out.println("Fields: ");
        for (String key : map.fields.keySet()) {
            System.out.println("  " + key);
            for (FieldHolder fieldHolder : map.fields.get(key)) {
                System.out.println("    " + fieldHolder.cn.name);
            }
        }
        System.out.println("Methods: ");
        for (String key : map.methods.keySet()) {
            System.out.println("  " + key);
            for (MethodHolder methodHolder : map.methods.get(key)) {
                System.out.println("    " + methodHolder.cn.name);
            }
        }
    }

    public static class MethodHolder {
        public ClassNode cn;
        public MethodNode mn;

        public MethodHolder(ClassNode c, MethodNode m) {
            this.cn = c;
            this.mn = m;
        }
    }

    public static class FieldHolder {
        public ClassNode cn;
        public FieldNode fn;

        public FieldHolder(ClassNode c, FieldNode f) {
            this.cn = c;
            this.fn = f;
        }
    }
}

