/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.dynamicmappings;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.fybertech.dynamicmappings.AccessUtil;
import net.fybertech.dynamicmappings.DynamicMappings;
import net.fybertech.dynamicmappings.InheritanceMap;
import net.fybertech.dynamicmappings.ParmParser;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public class DynamicRemap {
    Map<String, String> classMappings;
    Map<String, String> fieldMappings;
    Map<String, String> methodMappings;
    public String unpackagedPrefix = "net/minecraft/class_";
    public String unpackagedInnerPrefix = "innerclass_";
    public InheritanceMap inheritanceMapper = new InheritanceMap();

    public DynamicRemap(Map<String, String> cm, Map<String, String> fm, Map<String, String> mm) {
        this.classMappings = cm;
        this.fieldMappings = fm;
        this.methodMappings = mm;
    }

    public ClassNode getClassNode(String className) {
        return DynamicMappings.getClassNode(className);
    }

    private boolean isObfInner(String s) {
        try {
            Integer.parseInt(s);
            return false;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    public ClassNode remapClass(String className) {
        if (className == null) {
            return null;
        }
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(className + ".class");
        return this.remapClass(stream);
    }

    public ClassNode remapClass(InputStream stream) {
        if (stream == null) {
            return null;
        }
        ClassReader reader = null;
        try {
            reader = new ClassReader(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.remapClass(reader);
    }

    public byte[] remapClass(byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        ClassReader reader = new ClassReader(basicClass);
        ClassNode cn = this.remapClass(reader);
        if (cn == null) {
            return null;
        }
        ClassWriter cw = new ClassWriter(0);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public ClassNode remapClass(ClassReader reader) {
        boolean showDebug = false;
        ClassNode cn = new ClassNode();
        reader.accept((ClassVisitor)new CustomRemappingClassAdapter((ClassVisitor)cn, new MyRemapper(cn, showDebug)), 8);
        for (MethodNode method : cn.methods) {
            int paramCount = 0;
            int varCount = 0;
            if (method.localVariables == null) continue;
            for (LocalVariableNode lvn : method.localVariables) {
                if (!lvn.name.equals("\u2603")) continue;
                if (lvn.start == method.instructions.getFirst()) {
                    lvn.name = "param" + paramCount++;
                    continue;
                }
                lvn.name = "var" + varCount++;
            }
        }
        if (showDebug) {
            System.out.println(cn.name);
            for (MethodNode method : cn.methods) {
                System.out.println("  " + method.name + " " + method.desc);
            }
        }
        return cn;
    }

    public static byte[] getFileFromZip(ZipEntry entry, ZipFile zipFile) {
        byte[] buffer = null;
        if (entry != null) {
            try {
                int read;
                InputStream stream = zipFile.getInputStream(entry);
                int pos = 0;
                buffer = new byte[(int)entry.getSize()];
                do {
                    read = stream.read(buffer, pos, Math.min(1024, (int)entry.getSize() - pos));
                    pos += read;
                } while (read >= 1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return buffer;
    }

    public static void remapUnknownChildren(JarFile mcJar, String ... baseClasses) {
        Enumeration<JarEntry> enumerator = mcJar.entries();
        block0: while (enumerator.hasMoreElements()) {
            String className;
            JarEntry entry = enumerator.nextElement();
            String filename = entry.getName();
            if (!filename.endsWith(".class") || (className = filename.substring(0, filename.length() - 6)).contains("$")) continue;
            for (String mappedClass : baseClasses) {
                String baseClass = DynamicMappings.getClassMapping(mappedClass);
                String classPrefix = mappedClass + "Unknown_";
                if (baseClass == null || !DynamicMappings.doesInheritFrom(className, baseClass) || DynamicMappings.reverseClassMappings.containsKey(className)) continue;
                DynamicMappings.addClassMapping(classPrefix + className, className);
                continue block0;
            }
        }
    }

    public static void main(String[] args) {
        ParmParser pp = new ParmParser();
        ParmParser.Parm outputParm = pp.addParm("-o", 1);
        pp.processArgs(args);
        File outputFile = new File("mcremapped.jar");
        if (outputParm.found) {
            outputFile = new File(outputParm.getFirstResult());
        }
        DynamicMappings.generateClassMappings();
        AccessUtil accessUtil = new AccessUtil();
        accessUtil.readAllTransformerConfigs();
        JarFile mcJar = DynamicMappings.getMinecraftJar();
        if (mcJar != null) {
            DynamicRemap.remapUnknownChildren(mcJar, "net/minecraft/block/Block", "net/minecraft/item/Item", "net/minecraft/entity/monster/EntityMob", "net/minecraft/entity/Entity", "net/minecraft/tileentity/TileEntity", "net/minecraft/inventory/Container", "net/minecraft/client/gui/inventory/GuiContainer", "net/minecraft/client/gui/Gui", "net/minecraft/stats/StatBase");
            try {
                mcJar.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        DynamicRemap remapper = new DynamicRemap(DynamicMappings.reverseClassMappings, DynamicMappings.reverseFieldMappings, DynamicMappings.reverseMethodMappings);
        URL url = DynamicRemap.class.getClassLoader().getResource("net/minecraft/server/MinecraftServer.class");
        if (url == null) {
            System.out.println("Couldn't locate server class!");
            return;
        }
        JarFile jar = null;
        if ("jar".equals(url.getProtocol())) {
            JarURLConnection connection = null;
            try {
                connection = (JarURLConnection)url.openConnection();
                jar = connection.getJarFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (jar == null) {
            System.out.println("Couldn't locate Minecraft jar!");
            return;
        }
        JarOutputStream outJar = null;
        try {
            outJar = new JarOutputStream(new FileOutputStream(outputFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Enumeration<JarEntry> enumerator = jar.entries();
        while (enumerator.hasMoreElements()) {
            JarEntry entry = enumerator.nextElement();
            String name = entry.getName();
            byte[] bytes = null;
            if (name.startsWith("META-INF/") && (name.endsWith(".RSA") || name.endsWith(".SF"))) continue;
            if (name.endsWith(".class")) {
                name = name.substring(0, name.length() - 6);
                ClassNode mapped = remapper.remapClass(name);
                accessUtil.transformDeobfuscatedClass(mapped);
                ClassWriter writer = new ClassWriter(0);
                mapped.accept((ClassVisitor)writer);
                name = mapped.name + ".class";
                bytes = writer.toByteArray();
            } else {
                bytes = DynamicRemap.getFileFromZip(entry, jar);
            }
            ZipEntry ze = new ZipEntry(name);
            try {
                outJar.putNextEntry(ze);
                outJar.write(bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            outJar.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class CustomRemappingClassAdapter
    extends RemappingClassAdapter {
        public CustomRemappingClassAdapter(ClassVisitor cv, Remapper remapper) {
            super(cv, remapper);
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (DynamicRemap.this.classMappings.containsKey(name)) {
                String outer = DynamicRemap.this.classMappings.get(outerName);
                if (outer == null) {
                    outer = outerName;
                }
                outerName = outer;
                name = DynamicRemap.this.classMappings.get(name);
                innerName = name.substring(name.lastIndexOf("$") + 1);
                super.visitInnerClass(name, outerName, innerName, access);
                return;
            }
            if (!name.contains("/") && innerName != null && DynamicRemap.this.unpackagedInnerPrefix != null && DynamicRemap.this.isObfInner(innerName)) {
                innerName = DynamicRemap.this.unpackagedInnerPrefix + innerName;
            }
            super.visitInnerClass(name, outerName, innerName, access);
        }
    }

    private class MyRemapper
    extends Remapper {
        boolean showMapMethod = false;
        final ClassNode classNode;

        public MyRemapper(ClassNode cn, boolean debug) {
            this.classNode = cn;
            this.showMapMethod = debug;
        }

        public String map(String typeName) {
            boolean originallyUnpackaged;
            boolean bl = originallyUnpackaged = !typeName.contains("/");
            if (DynamicRemap.this.classMappings.containsKey(typeName)) {
                return DynamicRemap.this.classMappings.get(typeName);
            }
            String[] split = typeName.split("\\$");
            if (DynamicRemap.this.classMappings.containsKey(split[0])) {
                split[0] = DynamicRemap.this.classMappings.get(split[0]);
            }
            typeName = split[0];
            for (int n = 1; n < split.length; ++n) {
                String inner = split[n];
                if (originallyUnpackaged && DynamicRemap.this.isObfInner(inner) && DynamicRemap.this.unpackagedInnerPrefix != null) {
                    inner = DynamicRemap.this.unpackagedInnerPrefix + inner + n;
                }
                typeName = typeName + "$" + inner;
            }
            if (!typeName.contains("/") && DynamicRemap.this.unpackagedPrefix != null) {
                typeName = DynamicRemap.this.unpackagedPrefix + typeName;
            }
            return super.map(typeName);
        }

        public String mapFieldName(String owner, String name, String desc) {
            ClassNode cn = DynamicRemap.this.getClassNode(owner);
            if (cn == null) {
                return super.mapFieldName(owner, name, desc);
            }
            InheritanceMap map = null;
            try {
                map = DynamicRemap.this.inheritanceMapper.buildMap(cn);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Set fields = map.fields.get(name + " " + desc);
            if (fields == null) {
                return super.mapFieldName(owner, name, desc);
            }
            for (InheritanceMap.FieldHolder holder : fields) {
                String key = holder.cn.name + " " + holder.fn.name + " " + holder.fn.desc;
                if (!DynamicRemap.this.fieldMappings.containsKey(key)) continue;
                String mapping = DynamicRemap.this.fieldMappings.get(key);
                String[] split = mapping.split(" ");
                return super.mapFieldName(owner, split[1], desc);
            }
            return super.mapFieldName(owner, name, desc);
        }

        public String mapMethodName(String owner, String name, String desc) {
            ClassNode cn;
            if (owner.startsWith("[") || name.startsWith("<")) {
                return super.mapMethodName(owner, name, desc);
            }
            if (this.showMapMethod) {
                System.out.println("mapMethod: " + owner + " " + name + " " + desc);
            }
            if ((cn = DynamicRemap.this.getClassNode(owner)) == null) {
                return super.mapMethodName(owner, name, desc);
            }
            InheritanceMap map = null;
            try {
                map = DynamicRemap.this.inheritanceMapper.buildMap(cn);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Set methods = map.methods.get(name + " " + desc);
            if (methods == null) {
                return super.mapMethodName(owner, name, desc);
            }
            for (InheritanceMap.MethodHolder holder : methods) {
                String key = holder.cn.name + " " + holder.mn.name + " " + holder.mn.desc;
                if (this.showMapMethod) {
                    System.out.println("Key: " + key);
                }
                if (!DynamicRemap.this.methodMappings.containsKey(key)) continue;
                if (this.showMapMethod) {
                    System.out.println("    HAS KEY");
                }
                String mapping = DynamicRemap.this.methodMappings.get(key);
                String[] split = mapping.split(" ");
                return super.mapMethodName(owner, split[1], desc);
            }
            return super.mapMethodName(owner, name, desc);
        }
    }
}

