/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.dynamicmappings;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import net.fybertech.dynamicmappings.Mapping;
import net.fybertech.dynamicmappings.MappingsClass;
import net.fybertech.dynamicmappings.ModMappings;
import net.fybertech.dynamicmappings.mappers.ClientMappings;
import net.fybertech.dynamicmappings.mappers.SharedMappings;
import net.fybertech.meddle.MeddleUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class DynamicMappings {
    public static final Logger LOGGER = LogManager.getLogger((String)"Meddle");
    public static final Map<String, String> classMappings = new HashMap<String, String>();
    public static final Map<String, String> reverseClassMappings = new HashMap<String, String>();
    public static final Map<String, String> fieldMappings = new HashMap<String, String>();
    public static final Map<String, String> reverseFieldMappings = new HashMap<String, String>();
    public static final Map<String, String> methodMappings = new HashMap<String, String>();
    public static final Map<String, String> reverseMethodMappings = new HashMap<String, String>();
    public static final Set<String> clientMappingsSet = new HashSet<String>();
    public static final Set<String> serverMappingsSet = new HashSet<String>();
    private static Map<String, ClassNode> cachedClassNodes = new HashMap<String, ClassNode>();
    public static boolean simulatedMappings = false;
    public static Map<String, Set<String>> classDeps = new HashMap<String, Set<String>>();
    public static Map<String, Set<String>> classesExtendFrom = new HashMap<String, Set<String>>();
    public static Map<String, Set<String>> classesImplementFrom = new HashMap<String, Set<String>>();
    static String[] classSearchExceptions = new String[]{"java/", "javax/", "sun/", "com/google/", "org/apache/", "com/sun/", "io/netty/", "jdk/internal/", "org/xml/", "org/w3c/", "jdk/net/", "com/ibm/", "org/lwjgl/", "com/jcraft/", "joptsimple/", "net/java/", "paulscode/", "com/mojang/"};

    public static void generateClassMappings() {
        DynamicMappings.generateClassLinkages();
        DynamicMappings.registerMappingsClass(SharedMappings.class);
        DynamicMappings.registerMappingsClass(ClientMappings.class);
    }

    public static boolean registerMappingsClass(Class<? extends Object> mappingsClass) {
        int startSize;
        ArrayList<MappingMethod> mappingMethods = new ArrayList<MappingMethod>();
        boolean clientSide = false;
        boolean serverSide = false;
        if (mappingsClass.isAnnotationPresent(MappingsClass.class)) {
            Method[] mc = mappingsClass.getAnnotation(MappingsClass.class);
            clientSide = mc.clientSide();
            serverSide = mc.serverSide();
        }
        if (!simulatedMappings && clientSide && !MeddleUtil.isClientJar()) {
            System.out.println("[DynamicMappings] Ignoring client-side class " + mappingsClass.getName());
            return false;
        }
        if (!simulatedMappings && serverSide && MeddleUtil.isClientJar()) {
            System.out.println("[DynamicMappings] Ignoring server-side class " + mappingsClass.getName());
            return false;
        }
        System.out.println("[DynamicMappings] Processing class " + mappingsClass.getName());
        for (Method method : mappingsClass.getMethods()) {
            if (!method.isAnnotationPresent(Mapping.class)) continue;
            Mapping mapping = method.getAnnotation(Mapping.class);
            mappingMethods.add(new MappingMethod(method, mapping));
        }
        Object mappingsObject = null;
        try {
            Constructor<? extends Object> mappingsConstructor = mappingsClass.getConstructor(new Class[0]);
            mappingsObject = mappingsConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        do {
            startSize = mappingMethods.size();
            Iterator it = mappingMethods.iterator();
            while (it.hasNext()) {
                MappingMethod mm;
                block27: {
                    mm = (MappingMethod)it.next();
                    boolean isStatic = Modifier.isStatic(mm.method.getModifiers());
                    boolean hasDepends = true;
                    for (String depend : mm.depends) {
                        if (classMappings.keySet().contains(depend)) continue;
                        hasDepends = false;
                    }
                    for (String depend : mm.dependsFields) {
                        if (fieldMappings.keySet().contains(depend)) continue;
                        hasDepends = false;
                    }
                    for (String depend : mm.dependsMethods) {
                        if (methodMappings.keySet().contains(depend)) continue;
                        hasDepends = false;
                    }
                    if (!hasDepends) continue;
                    if (!simulatedMappings) {
                        try {
                            if (isStatic) {
                                mm.method.invoke(null, new Object[0]);
                                break block27;
                            }
                            mm.method.invoke(mappingsObject, (Object[])null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        for (String s : mm.provides) {
                            classMappings.put(s, "---");
                            if (clientSide) {
                                clientMappingsSet.add(s);
                            }
                            if (!serverSide) continue;
                            serverMappingsSet.add(s);
                        }
                        for (String s : mm.providesFields) {
                            fieldMappings.put(s, "--- --- ---");
                            if (clientSide) {
                                clientMappingsSet.add(s);
                            }
                            if (!serverSide) continue;
                            serverMappingsSet.add(s);
                        }
                        for (String s : mm.providesMethods) {
                            methodMappings.put(s, "--- --- ---");
                            if (clientSide) {
                                clientMappingsSet.add(s);
                            }
                            if (!serverSide) continue;
                            serverMappingsSet.add(s);
                        }
                    }
                }
                for (String provider : mm.provides) {
                    if (classMappings.keySet().contains(provider)) continue;
                    System.out.println(mm.method.getName() + " didn't provide mapping for class " + provider);
                }
                for (String provider : mm.providesFields) {
                    if (fieldMappings.keySet().contains(provider)) continue;
                    System.out.println(mm.method.getName() + " didn't provide mapping for field " + provider);
                }
                for (String provider : mm.providesMethods) {
                    if (methodMappings.keySet().contains(provider)) continue;
                    System.out.println(mm.method.getName() + " didn't provide mapping for method " + provider);
                }
                it.remove();
            }
            if (mappingMethods.size() != 0) continue;
            return true;
        } while (startSize != mappingMethods.size());
        System.out.println("Unmet mapping dependencies in " + mappingsClass.getName() + "!");
        for (MappingMethod mm : mappingMethods) {
            System.out.println("  Method: " + mm.method.getName());
            for (String depend : mm.depends) {
                if (classMappings.keySet().contains(depend)) continue;
                System.out.println("    " + depend);
            }
        }
        return false;
    }

    public static void getConstantPoolClassesRecursive(String className) {
        Set<String> classes;
        if (DynamicMappings.startsWithAny(className, classSearchExceptions)) {
            return;
        }
        ClassReader reader = null;
        try {
            reader = new ClassReader(className);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (reader != null) {
            String superName = reader.getSuperName();
            Set<String> extendSet = classesExtendFrom.get(superName);
            if (extendSet == null) {
                extendSet = new HashSet<String>();
                classesExtendFrom.put(superName, extendSet);
            }
            extendSet.add(className);
            for (String iface : reader.getInterfaces()) {
                Set<String> implementSet = classesImplementFrom.get(iface);
                if (implementSet == null) {
                    implementSet = new HashSet<String>();
                    classesImplementFrom.put(iface, implementSet);
                }
                implementSet.add(className);
            }
        }
        if ((classes = classDeps.get(className)) == null) {
            classes = DynamicMappings.getConstantPoolClasses(className, true);
            if (classes == null) {
                return;
            }
            classDeps.put(className, classes);
        }
        for (String s : classes) {
            if (classDeps.containsKey(s)) continue;
            DynamicMappings.getConstantPoolClassesRecursive(s);
        }
    }

    public static boolean startsWithAny(String string, String[] list) {
        for (String s : list) {
            if (!string.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getChildClasses(String className) {
        HashSet<String> outSet = new HashSet<String>();
        HashSet tempSet = new HashSet();
        if (classesExtendFrom.containsKey(className)) {
            tempSet.addAll(classesExtendFrom.get(className));
        }
        if (classesImplementFrom.containsKey(className)) {
            tempSet.addAll(classesImplementFrom.get(className));
        }
        outSet.addAll(tempSet);
        for (String s : tempSet) {
            outSet.addAll(DynamicMappings.getChildClasses(s));
        }
        return outSet;
    }

    public static void generateClassLinkages() {
        System.out.print("[DynamicMappings] Generating linkages...");
        DynamicMappings.getConstantPoolClassesRecursive("net/minecraft/server/MinecraftServer");
        DynamicMappings.getConstantPoolClassesRecursive("net/minecraft/client/main/Main");
        System.out.println("done");
    }

    public static void log(boolean toConsole, PrintWriter writer, String text) {
        if (toConsole) {
            System.out.println(text);
        }
        if (writer != null) {
            writer.println(text);
        }
    }

    public static void main(String[] args) {
        boolean showMappings = false;
        boolean saveMappings = true;
        PrintWriter writer = null;
        try {
            if (saveMappings) {
                writer = new PrintWriter("currentmappings.txt");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        DynamicMappings.generateClassMappings();
        DynamicMappings.log(true, writer, "[DynamicMappings] Minecraft version: " + MeddleUtil.findMinecraftVersion());
        DynamicMappings.log(true, writer, "[DynamicMappings] Minecraft jar type: " + (MeddleUtil.isClientJar() ? "client" : "server"));
        if (!showMappings && !saveMappings) {
            return;
        }
        DynamicMappings.log(showMappings, writer, "\nCLASSES:");
        ArrayList<String> sorted = new ArrayList<String>();
        sorted.addAll(classMappings.keySet());
        Collections.sort(sorted);
        for (String s : sorted) {
            DynamicMappings.log(showMappings, writer, s + " -> " + classMappings.get(s));
        }
        DynamicMappings.log(showMappings, writer, "\nFIELDS:");
        sorted.clear();
        sorted.addAll(fieldMappings.keySet());
        Collections.sort(sorted);
        for (String s : sorted) {
            DynamicMappings.log(showMappings, writer, s + " -> " + fieldMappings.get(s));
        }
        DynamicMappings.log(showMappings, writer, "\nMETHODS:");
        sorted.clear();
        sorted.addAll(methodMappings.keySet());
        Collections.sort(sorted);
        for (String s : sorted) {
            DynamicMappings.log(showMappings, writer, s + " -> " + methodMappings.get(s));
        }
        writer.close();
    }

    public static ClassNode getClassNode(String className) {
        if (className == null) {
            return null;
        }
        if (cachedClassNodes.containsKey(className = className.replace(".", "/"))) {
            return cachedClassNodes.get(className);
        }
        InputStream stream = DynamicMappings.class.getClassLoader().getResourceAsStream(className + ".class");
        if (stream == null) {
            return null;
        }
        ClassReader reader = null;
        try {
            reader = new ClassReader(stream);
        }
        catch (IOException e) {
            return null;
        }
        ClassNode cn = new ClassNode();
        reader.accept((ClassVisitor)cn, 0);
        cachedClassNodes.put(className, cn);
        return cn;
    }

    public static String getLdcString(AbstractInsnNode node) {
        if (!(node instanceof LdcInsnNode)) {
            return null;
        }
        LdcInsnNode ldc = (LdcInsnNode)node;
        if (!(ldc.cst instanceof String)) {
            return null;
        }
        return new String((String)ldc.cst);
    }

    public static String getLdcClass(AbstractInsnNode node) {
        if (!(node instanceof LdcInsnNode)) {
            return null;
        }
        LdcInsnNode ldc = (LdcInsnNode)node;
        if (!(ldc.cst instanceof Type)) {
            return null;
        }
        return ((Type)ldc.cst).getClassName();
    }

    public static boolean isLdcWithString(AbstractInsnNode node, String string) {
        String s = DynamicMappings.getLdcString(node);
        return s != null && string.equals(s);
    }

    public static boolean isLdcWithInteger(AbstractInsnNode node, int val) {
        if (!(node instanceof LdcInsnNode)) {
            return false;
        }
        LdcInsnNode ldc = (LdcInsnNode)node;
        if (!(ldc.cst instanceof Integer)) {
            return false;
        }
        return (Integer)ldc.cst == val;
    }

    public static boolean isLdcWithFloat(AbstractInsnNode node, float val) {
        if (!(node instanceof LdcInsnNode)) {
            return false;
        }
        LdcInsnNode ldc = (LdcInsnNode)node;
        if (!(ldc.cst instanceof Float)) {
            return false;
        }
        return ((Float)ldc.cst).floatValue() == val;
    }

    public static String getFieldDesc(ClassNode cn, String fieldName) {
        for (FieldNode field : cn.fields) {
            if (!field.name.equals(fieldName)) continue;
            return field.desc;
        }
        return null;
    }

    public static FieldNode getFieldByName(ClassNode cn, String fieldName) {
        for (FieldNode field : cn.fields) {
            if (!field.name.equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static boolean searchConstantPoolForStrings(String className, String ... matchStrings) {
        if (className == null) {
            return false;
        }
        className = className.replace(".", "/");
        InputStream stream = DynamicMappings.class.getClassLoader().getResourceAsStream(className + ".class");
        if (stream == null) {
            return false;
        }
        ClassReader reader = null;
        try {
            reader = new ClassReader(stream);
        }
        catch (IOException e) {
            return false;
        }
        int itemCount = reader.getItemCount();
        char[] buffer = new char[reader.getMaxStringLength()];
        int matches = 0;
        block2: for (int n = 1; n < itemCount; ++n) {
            int pos = reader.getItem(n);
            if (pos == 0 || reader.b[pos - 1] != 8) continue;
            Arrays.fill(buffer, '\u0000');
            String string = reader.readUTF8(pos, buffer).trim();
            for (int n2 = 0; n2 < matchStrings.length; ++n2) {
                if (!string.equals(matchStrings[n2].trim())) continue;
                ++matches;
                continue block2;
            }
        }
        return matches == matchStrings.length;
    }

    public static boolean searchConstantPoolForClasses(String className, String ... matchStrings) {
        className = className.replace(".", "/");
        InputStream stream = DynamicMappings.class.getClassLoader().getResourceAsStream(className + ".class");
        if (stream == null) {
            return false;
        }
        ClassReader reader = null;
        try {
            reader = new ClassReader(stream);
        }
        catch (IOException e) {
            return false;
        }
        int itemCount = reader.getItemCount();
        char[] buffer = new char[reader.getMaxStringLength()];
        int matches = 0;
        block2: for (int n = 1; n < itemCount; ++n) {
            int pos = reader.getItem(n);
            if (pos == 0 || reader.b[pos - 1] != 7) continue;
            Arrays.fill(buffer, '\u0000');
            String string = reader.readUTF8(pos, buffer);
            for (int n2 = 0; n2 < matchStrings.length; ++n2) {
                if (!string.equals(matchStrings[n2].replace(".", "/"))) continue;
                ++matches;
                continue block2;
            }
        }
        return matches == matchStrings.length;
    }

    public static List<String> getConstantPoolStrings(String className) {
        ArrayList<String> strings = new ArrayList<String>();
        className = className.replace(".", "/");
        InputStream stream = DynamicMappings.class.getClassLoader().getResourceAsStream(className + ".class");
        if (stream == null) {
            return null;
        }
        ClassReader reader = null;
        try {
            reader = new ClassReader(stream);
        }
        catch (IOException e) {
            return null;
        }
        int itemCount = reader.getItemCount();
        char[] buffer = new char[reader.getMaxStringLength()];
        for (int n = 1; n < itemCount; ++n) {
            int pos = reader.getItem(n);
            if (pos == 0 || reader.b[pos - 1] != 8) continue;
            Arrays.fill(buffer, '\u0000');
            String string = reader.readUTF8(pos, buffer);
            strings.add(string);
        }
        return strings;
    }

    public static Set<String> getConstantPoolClasses(String className, boolean processArrays) {
        HashSet<String> strings = new HashSet<String>();
        className = className.replace(".", "/");
        InputStream stream = DynamicMappings.class.getClassLoader().getResourceAsStream(className + ".class");
        if (stream == null) {
            return null;
        }
        ClassReader reader = null;
        try {
            reader = new ClassReader(stream);
        }
        catch (IOException e) {
            return null;
        }
        int itemCount = reader.getItemCount();
        char[] buffer = new char[reader.getMaxStringLength()];
        for (int n = 1; n < itemCount; ++n) {
            int pos = reader.getItem(n);
            if (pos == 0 || reader.b[pos - 1] != 7) continue;
            Arrays.fill(buffer, '\u0000');
            String string = reader.readUTF8(pos, buffer);
            if (string.startsWith("[") && processArrays && (string = ModMappings.getArrayType(string)) == null || string.length() < 1) continue;
            strings.add(string);
        }
        return strings;
    }

    public static boolean checkMethodParameters(MethodNode method, int ... types) {
        Type t = Type.getMethodType((String)method.desc);
        Type[] args = t.getArgumentTypes();
        if (args.length != types.length) {
            return false;
        }
        int len = args.length;
        for (int n = 0; n < len; ++n) {
            if (args[n].getSort() == types[n]) continue;
            return false;
        }
        return true;
    }

    public static List<MethodNode> getMatchingMethods(ClassNode cn, String name, String desc) {
        ArrayList<MethodNode> output = new ArrayList<MethodNode>();
        for (MethodNode method : cn.methods) {
            if (name != null && (name == null || !method.name.equals(name)) || desc != null && (desc == null || !method.desc.equals(desc))) continue;
            output.add(method);
        }
        return output;
    }

    public static List<FieldNode> getMatchingFields(ClassNode cn, String name, String desc) {
        ArrayList<FieldNode> output = new ArrayList<FieldNode>();
        for (FieldNode field : cn.fields) {
            if (name != null && (name == null || !field.name.equals(name)) || desc != null && (desc == null || !field.desc.equals(desc))) continue;
            output.add(field);
        }
        return output;
    }

    public static ClassNode getClassNodeFromMapping(String deobfClass) {
        return DynamicMappings.getClassNode(DynamicMappings.getClassMapping(deobfClass));
    }

    public static boolean matchOpcodeSequence(AbstractInsnNode insn, int ... opcodes) {
        for (int opcode : opcodes) {
            if ((insn = DynamicMappings.getNextRealOpcode(insn)) == null) {
                return false;
            }
            if (opcode != insn.getOpcode()) {
                return false;
            }
            insn = insn.getNext();
        }
        return true;
    }

    public static AbstractInsnNode[] getOpcodeSequenceArray(AbstractInsnNode insn, int ... opcodes) {
        AbstractInsnNode[] outNodes = new AbstractInsnNode[opcodes.length];
        int pos = 0;
        for (int opcode : opcodes) {
            if ((insn = DynamicMappings.getNextRealOpcode(insn)) == null) {
                return null;
            }
            if (opcode != insn.getOpcode()) {
                return null;
            }
            outNodes[pos++] = insn;
            insn = insn.getNext();
        }
        return outNodes;
    }

    public static boolean matchInsnNodeSequence(AbstractInsnNode insn, Class<? extends AbstractInsnNode> ... nodeClasses) {
        for (Class<? extends AbstractInsnNode> nodeClass : nodeClasses) {
            if ((insn = DynamicMappings.getNextRealOpcode(insn)) == null) {
                return false;
            }
            if (nodeClass != insn.getClass()) {
                return false;
            }
            insn = insn.getNext();
        }
        return true;
    }

    public static AbstractInsnNode[] getInsnNodeSequenceArray(AbstractInsnNode insn, Class<? extends AbstractInsnNode> ... nodeClasses) {
        AbstractInsnNode[] outNodes = new AbstractInsnNode[nodeClasses.length];
        int pos = 0;
        for (Class<? extends AbstractInsnNode> nodeClass : nodeClasses) {
            if ((insn = DynamicMappings.getNextRealOpcode(insn)) == null) {
                return null;
            }
            if (nodeClass != insn.getClass()) {
                return null;
            }
            outNodes[pos++] = insn;
            insn = insn.getNext();
        }
        return outNodes;
    }

    public static <T> List<T> getAllInsnNodesOfType(AbstractInsnNode startInsn, Class<T> classType) {
        ArrayList<AbstractInsnNode> list = new ArrayList<AbstractInsnNode>();
        for (AbstractInsnNode insn = startInsn; insn != null; insn = insn.getNext()) {
            if (insn.getClass() != classType) continue;
            list.add(insn);
        }
        return list;
    }

    public static <T> T getNextInsnNodeOfType(AbstractInsnNode startInsn, Class<T> classType) {
        for (AbstractInsnNode insn = startInsn; insn != null; insn = insn.getNext()) {
            if (insn.getClass() != classType) continue;
            return (T)insn;
        }
        return null;
    }

    public static String getClassMapping(String deobfClassName) {
        return classMappings.get(deobfClassName.replace(".", "/"));
    }

    public static String getReverseClassMapping(String obfClassName) {
        return reverseClassMappings.get(obfClassName.replace(".", "/"));
    }

    public static void addClassMapping(String deobfClassName, ClassNode node) {
        if (deobfClassName == null) {
            return;
        }
        deobfClassName = deobfClassName.replace(".", "/");
        DynamicMappings.addClassMapping(deobfClassName, node.name);
    }

    public static void addClassMapping(String deobfClassName, String obfClassName) {
        deobfClassName = deobfClassName.replace(".", "/");
        obfClassName = obfClassName.replace(".", "/");
        if (classMappings.containsKey(deobfClassName) && !classMappings.get(deobfClassName).equals(obfClassName)) {
            System.out.println("WARNING: " + deobfClassName + " has been remapped from " + classMappings.get(deobfClassName) + " to " + obfClassName);
        }
        if (reverseClassMappings.containsKey(obfClassName) && !reverseClassMappings.get(obfClassName).equals(deobfClassName)) {
            System.out.println("WARNING: " + obfClassName + " has been remapped from " + reverseClassMappings.get(obfClassName) + " to " + deobfClassName);
        }
        classMappings.put(deobfClassName, obfClassName);
        reverseClassMappings.put(obfClassName, deobfClassName);
    }

    public static void addMethodMapping(String deobfMethodDesc, String obfMethodDesc) {
        if (classMappings.containsKey(deobfMethodDesc) && !classMappings.get(deobfMethodDesc).equals(obfMethodDesc)) {
            System.out.println("WARNING: " + deobfMethodDesc + " has been remapped from " + classMappings.get(deobfMethodDesc) + " to " + obfMethodDesc);
        }
        if (reverseClassMappings.containsKey(obfMethodDesc) && !reverseClassMappings.get(obfMethodDesc).equals(deobfMethodDesc)) {
            System.out.println("WARNING: " + obfMethodDesc + " has been remapped from " + reverseClassMappings.get(obfMethodDesc) + " to " + deobfMethodDesc);
        }
        methodMappings.put(deobfMethodDesc, obfMethodDesc);
        reverseMethodMappings.put(obfMethodDesc, deobfMethodDesc);
    }

    public static void addFieldMapping(String deobfFieldDesc, String obfFieldDesc) {
        if (classMappings.containsKey(deobfFieldDesc) && !classMappings.get(deobfFieldDesc).equals(obfFieldDesc)) {
            System.out.println("WARNING: " + deobfFieldDesc + " has been remapped from " + classMappings.get(deobfFieldDesc) + " to " + obfFieldDesc);
        }
        if (reverseClassMappings.containsKey(obfFieldDesc) && !reverseClassMappings.get(obfFieldDesc).equals(deobfFieldDesc)) {
            System.out.println("WARNING: " + obfFieldDesc + " has been remapped from " + reverseClassMappings.get(obfFieldDesc) + " to " + deobfFieldDesc);
        }
        fieldMappings.put(deobfFieldDesc, obfFieldDesc);
        reverseFieldMappings.put(obfFieldDesc, deobfFieldDesc);
    }

    public static String getMethodMapping(String className, String methodName, String methodDesc) {
        return methodMappings.get(className + " " + methodName + " " + methodDesc);
    }

    public static String getMethodMapping(String mapping) {
        return methodMappings.get(mapping);
    }

    public static String getReverseMethodMapping(String obfMethod) {
        return reverseMethodMappings.get(obfMethod);
    }

    public static String getFieldMapping(String mapping) {
        return fieldMappings.get(mapping);
    }

    public static String getReverseFieldMapping(String obfField) {
        return reverseFieldMappings.get(obfField);
    }

    public static FieldNode getFieldNode(ClassNode cn, String obfMapping) {
        if (cn == null || obfMapping == null) {
            return null;
        }
        String[] split = obfMapping.split(" ");
        if (split.length < 3) {
            return null;
        }
        for (FieldNode field : cn.fields) {
            if (!field.name.equals(split[1]) || !field.desc.equals(split[2])) continue;
            return field;
        }
        return null;
    }

    public static FieldNode getFieldNodeFromMapping(ClassNode cn, String deobfMapping) {
        String mapping = DynamicMappings.getFieldMapping(deobfMapping);
        if (cn == null || mapping == null) {
            return null;
        }
        String[] split = mapping.split(" ");
        if (split.length < 3) {
            return null;
        }
        for (FieldNode field : cn.fields) {
            if (!field.name.equals(split[1]) || !field.desc.equals(split[2])) continue;
            return field;
        }
        return null;
    }

    public static String getMethodMappingName(String className, String methodName, String methodDesc) {
        String mapping = DynamicMappings.getMethodMapping(className, methodName, methodDesc);
        if (mapping == null) {
            return null;
        }
        String[] split = mapping.split(" ");
        return split.length >= 3 ? split[1] : null;
    }

    public static MethodNode getMethodNode(ClassNode cn, String obfMapping) {
        if (cn == null || obfMapping == null) {
            return null;
        }
        String[] split = obfMapping.split(" ");
        if (split.length < 3) {
            return null;
        }
        for (MethodNode method : cn.methods) {
            if (!method.name.equals(split[1]) || !method.desc.equals(split[2])) continue;
            return method;
        }
        return null;
    }

    public static MethodNode getMethodNodeFromMapping(ClassNode cn, String deobfMapping) {
        String mapping = DynamicMappings.getMethodMapping(deobfMapping);
        if (cn == null || mapping == null) {
            return null;
        }
        String[] split = mapping.split(" ");
        if (split.length < 3) {
            return null;
        }
        for (MethodNode method : cn.methods) {
            if (!method.name.equals(split[1]) || !method.desc.equals(split[2])) continue;
            return method;
        }
        return null;
    }

    public static JarFile getMinecraftJar() {
        URL url = MeddleUtil.class.getClassLoader().getResource("net/minecraft/server/MinecraftServer.class");
        if (url == null) {
            return null;
        }
        JarFile jar = null;
        if ("jar".equals(url.getProtocol())) {
            JarURLConnection connection = null;
            try {
                connection = (JarURLConnection)url.openConnection();
                jar = connection.getJarFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return jar;
    }

    public static boolean isSubclassOf(String className, String superClassName) {
        InputStream stream = DynamicMappings.class.getClassLoader().getResourceAsStream(className + ".class");
        if (stream == null) {
            return false;
        }
        ClassReader reader = null;
        try {
            reader = new ClassReader(stream);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (reader == null) {
            return false;
        }
        String superName = reader.getSuperName();
        if (superName.equals(superClassName)) {
            return true;
        }
        if (superName.equals("java/lang/Object")) {
            return false;
        }
        return DynamicMappings.isSubclassOf(superName, superClassName);
    }

    public static List<MethodNode> getMethodsWithDescriptor(List methods, String desc) {
        ArrayList<MethodNode> list = new ArrayList<MethodNode>();
        for (MethodNode method : methods) {
            if (!method.desc.equals(desc)) continue;
            list.add(method);
        }
        return list;
    }

    public static List<MethodNode> removeMethodsWithFlags(List<MethodNode> methods, int accFlags) {
        ArrayList<MethodNode> outList = new ArrayList<MethodNode>();
        for (MethodNode mn : methods) {
            if ((mn.access & accFlags) != 0) continue;
            outList.add(mn);
        }
        return outList;
    }

    public static List<MethodNode> removeMethodsWithoutFlags(List<MethodNode> methods, int accFlags) {
        ArrayList<MethodNode> outList = new ArrayList<MethodNode>();
        for (MethodNode mn : methods) {
            if ((mn.access & accFlags) == 0) continue;
            outList.add(mn);
        }
        return outList;
    }

    public static AbstractInsnNode findNextOpcodeNum(AbstractInsnNode insn, int opcode) {
        while (insn != null && insn.getOpcode() != opcode) {
            insn = insn.getNext();
        }
        return insn;
    }

    public static AbstractInsnNode getNextRealOpcode(AbstractInsnNode insn) {
        while (insn != null && insn.getOpcode() < 0) {
            insn = insn.getNext();
        }
        return insn;
    }

    public static String assembleDescriptor(Object ... objects) {
        String output = "";
        for (Object o : objects) {
            if (o instanceof String) {
                output = output + (String)o;
                continue;
            }
            if (!(o instanceof ClassNode)) continue;
            output = output + "L" + ((ClassNode)o).name + ";";
        }
        return output;
    }

    public static boolean classHasInterfaces(ClassNode classNode, String ... ifaces) {
        boolean implementsAll = true;
        List implemented = classNode.interfaces;
        for (String iface : ifaces) {
            if (implemented.contains(iface)) continue;
            implementsAll = false;
            break;
        }
        return implementsAll;
    }

    public static boolean doesInheritFrom(String className, String inheritFrom) {
        if (className.equals(inheritFrom)) {
            return true;
        }
        ClassNode cn = DynamicMappings.getClassNode(className);
        if (cn == null) {
            return false;
        }
        ArrayList<String> classes = new ArrayList<String>();
        if (cn.superName != null) {
            classes.add(cn.superName);
        }
        classes.addAll(cn.interfaces);
        for (String c : classes) {
            if (!c.equals(inheritFrom)) continue;
            return true;
        }
        for (String c : classes) {
            if (!DynamicMappings.doesInheritFrom(c, inheritFrom)) continue;
            return true;
        }
        return false;
    }

    private static class MappingMethod {
        final Method method;
        final String[] provides;
        final String[] depends;
        final String[] providesMethods;
        final String[] dependsMethods;
        final String[] providesFields;
        final String[] dependsFields;

        public MappingMethod(Method m, Mapping mapping) {
            this.method = m;
            this.provides = mapping.provides();
            this.depends = mapping.depends();
            this.providesMethods = mapping.providesMethods();
            this.dependsMethods = mapping.dependsMethods();
            this.providesFields = mapping.providesFields();
            this.dependsFields = mapping.dependsFields();
        }
    }
}

