/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.dynamicmappings;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class AccessUtil {
    public static final int allAccess = 7;
    public List<String> accessTransformerFields = new ArrayList<String>();
    public List<String> accessTransformerMethods = new ArrayList<String>();
    public List<String> accessTransformerClasses = new ArrayList<String>();
    private boolean debug = false;

    public void readAllTransformerConfigs() {
        System.out.println("Discovering access transformers...");
        Enumeration<URL> urls = null;
        try {
            urls = AccessUtil.class.getClassLoader().getResources("accesstransformer.cfg");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (urls == null) {
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                System.out.println("Processing access transformer at " + url);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String[] split;
                    if (line.startsWith("#") || line.length() < 1 || (split = line.split(" ", 2)).length < 2) continue;
                    String mode = split[0].toUpperCase();
                    String ac = split[1];
                    if (mode.equals("F")) {
                        this.accessTransformerFields.add(ac);
                        continue;
                    }
                    if (mode.equals("M")) {
                        this.accessTransformerMethods.add(ac);
                        continue;
                    }
                    if (!mode.equals("C")) continue;
                    this.accessTransformerClasses.add(ac);
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void transformDeobfuscatedClass(ClassNode cn) {
        boolean wildcardDesc;
        int access;
        String className;
        String[] split;
        for (String transformer : this.accessTransformerFields) {
            split = transformer.split(" ");
            if (split.length != 4) continue;
            className = split[0];
            String fieldName = split[1];
            String fieldDesc = split[2];
            access = 0;
            try {
                access = Integer.parseInt(split[3]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (access < 1 || !cn.name.equals(className)) continue;
            boolean wildcardName = fieldName.equals("*");
            wildcardDesc = fieldDesc.equals("*");
            for (FieldNode field : cn.fields) {
                if (!field.name.equals(fieldName) && !wildcardName || !field.desc.equals(fieldDesc) && !wildcardDesc) continue;
                field.access = field.access & 0xFFFFFFF8 | access;
                if (!this.debug) continue;
                System.out.println("Modifying access of " + className + " " + field.name + " " + field.desc);
            }
        }
        for (String transformer : this.accessTransformerMethods) {
            split = transformer.split(" ");
            if (split.length != 4) continue;
            className = split[0];
            String methodName = split[1];
            String methodDesc = split[2];
            access = 0;
            try {
                access = Integer.parseInt(split[3]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (access < 1 || !cn.name.equals(className)) continue;
            boolean wildcardName = methodName.equals("*");
            wildcardDesc = methodDesc.equals("*");
            for (MethodNode method : cn.methods) {
                if (!method.name.equals(methodName) && !wildcardName || !method.desc.equals(methodDesc) && !wildcardDesc) continue;
                method.access = method.access & 0xFFFFFFF8 | access;
                if (!this.debug) continue;
                System.out.println("Modifying access of " + className + " " + method.name + " " + method.desc);
            }
        }
    }
}

