/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.intrmd;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.fybertech.ClassParser.ConstantPoolItem;
import net.fybertech.ClassParser.JavaClass;
import net.fybertech.ClassParser.JavaField;
import net.fybertech.ClassParser.JavaMethod;

public class IntermediaryConnection
extends URLConnection {
    static Map<String, byte[]> archives = new HashMap<String, byte[]>();

    protected IntermediaryConnection(URL arg0) {
        super(arg0);
        System.out.println("IntermediaryConnection: " + arg0);
    }

    @Override
    public void connect() throws IOException {
        System.out.println("IntermediaryConnection.connect()");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        System.out.println("IntermediaryConnection.getInputStream() - " + this.getURL().toString());
        String modArchive = this.getURL().toString().replace("intrmd://", "mods-1.2.5/");
        System.out.println(modArchive);
        if (archives.containsKey(modArchive)) {
            System.out.println("Returning cached stream");
            return new ByteArrayInputStream(archives.get(modArchive));
        }
        System.out.println("Creating cached stream");
        File f = new File(modArchive);
        if (!f.exists() || !f.isFile()) {
            return null;
        }
        ZipFile zip = new ZipFile(f);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zipout = new ZipOutputStream(baos);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory()) continue;
            Object[] mapResult = this.remapEntry(entry.getName(), this.readStreamBytes(zip.getInputStream(entry)));
            String entryName = (String)mapResult[0];
            byte[] entryBytes = (byte[])mapResult[1];
            if (!(entryName = entryName.replace("net/minecraft", "intermediary/minecraft")).startsWith("intermediary/minecraft/src")) {
                entryName = "intermediary/minecraft/src/" + entryName;
            }
            zipout.putNextEntry(new ZipEntry(entryName));
            zipout.write(entryBytes);
            zipout.closeEntry();
        }
        zipout.close();
        zip.close();
        byte[] array = baos.toByteArray();
        archives.put(modArchive, array);
        FileOutputStream fos = new FileOutputStream(modArchive.replace("mods-1.2.5/", "cache/"));
        fos.write(array);
        fos.close();
        return new ByteArrayInputStream(array);
    }

    private Object[] remapEntry(String name, byte[] bytes) {
        String desc;
        ConstantPoolItem cpi;
        if (!name.toLowerCase().endsWith(".class")) {
            return new Object[]{name, bytes};
        }
        JavaClass jc = null;
        try {
            jc = new JavaClass(new DataInputStream(new ByteArrayInputStream(bytes)));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (jc == null) {
            return new Object[]{name, bytes};
        }
        for (ConstantPoolItem cpi2 : jc.constant_pool.getPool()) {
            if (cpi2.ctype == 7) {
                ConstantPoolItem innerItem = jc.constant_pool.getItemByIndex((Integer)cpi2.data);
                String classname = (String)innerItem.getData();
                if (classname.contains("net/minecraft/")) {
                    classname = classname.replace("net/minecraft/", "intermediary/minecraft/");
                    innerItem.setData(new String(classname));
                    continue;
                }
                if (!classname.contains("cpw/mods/fml/")) continue;
                classname = classname.replace("cpw/mods/fml/", "intermediary/fml/");
                innerItem.setData(new String(classname));
                continue;
            }
            if (cpi2.ctype == 9 || cpi2.ctype == 10 || cpi2.ctype == 11) {
                int[] innerArray = (int[])cpi2.getData();
                ConstantPoolItem nameAndType = jc.constant_pool.getItemByIndex(innerArray[1]);
                int[] nameAndTypeArray = (int[])nameAndType.getData();
                ConstantPoolItem typeItem = jc.constant_pool.getItemByIndex(nameAndTypeArray[1]);
                String typeString = (String)typeItem.getData();
                if (typeString.contains("net/minecraft/")) {
                    typeString = typeString.replace("net/minecraft/", "intermediary/minecraft/");
                    typeItem.setData(new String(typeString));
                    continue;
                }
                if (!typeString.contains("cpw/mods/fml/")) continue;
                typeString = typeString.replace("cpw/mods/fml/", "intermediary/fml/");
                typeItem.setData(new String(typeString));
                continue;
            }
            if (cpi2.ctype != 1) continue;
            String classname = (String)cpi2.data;
            if (classname.contains("net.minecraft.src")) {
                classname = classname.replace("net.minecraft.src", "intermediary.minecraft.src");
                cpi2.setData(new String(classname));
                continue;
            }
            if (!classname.contains("net/minecraft/src")) continue;
            classname = classname.replace("net/minecraft/src", "intermediary/minecraft/src");
            cpi2.setData(new String(classname));
        }
        for (JavaField field : jc.fields) {
            cpi = jc.constant_pool.getItemByIndex(field.descriptor_index);
            desc = (String)cpi.getData();
            if (desc.contains("Lnet/minecraft/")) {
                desc = desc.replace("Lnet/minecraft/", "Lintermediary/minecraft/");
                cpi.setData(new String(desc));
                continue;
            }
            if (!desc.contains("Lcpw/mods/fml/")) continue;
            desc = desc.replace("Lcpw/mods/fml/", "Lintermediary/fml/");
            cpi.setData(new String(desc));
        }
        for (JavaMethod method : jc.methods) {
            cpi = jc.constant_pool.getItemByIndex(method.descriptor_index);
            desc = (String)cpi.getData();
            if (desc.contains("Lnet/minecraft/")) {
                desc = desc.replace("Lnet/minecraft/", "Lintermediary/minecraft/");
                cpi.setData(new String(desc));
                continue;
            }
            if (!desc.contains("Lcpw/mods/fml/")) continue;
            desc = desc.replace("Lcpw/mods/fml/", "Lintermediary/fml/");
            cpi.setData(new String(desc));
        }
        name = jc.getClassName() + ".class";
        bytes = jc.toByteArray();
        return new Object[]{name, bytes};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readStreamBytes(InputStream classStream) {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(classStream);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            int count = 0;
            while ((count = bis.read(bytes)) > 0) {
                baos.write(bytes, 0, count);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }
}

