/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.intermediary;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.fybertech.intermediary.IntermediaryMod;

public class TextureHelper {
    public static BufferedImage generateClassicIconAtlas(String filename) {
        List<String> lines = TextureHelper.readTextFile(filename);
        BufferedImage atlas = new BufferedImage(256, 256, 2);
        for (String line : lines) {
            String[] split = line.split(" ");
            if (split.length < 3) continue;
            int x = Integer.parseInt(split[0]);
            int y = Integer.parseInt(split[1]);
            String icon = split[2];
            BufferedImage bufferedIcon = null;
            String imageFilename = "/assets/minecraft/textures/" + icon + ".png";
            if (icon.equals("MISSING")) {
                imageFilename = "/assets/intermediary/missing.png";
            }
            InputStream iconstream = IntermediaryMod.class.getResourceAsStream(imageFilename);
            try {
                bufferedIcon = ImageIO.read(iconstream);
            }
            catch (Exception e) {
                System.out.println("Error reading " + imageFilename);
                e.printStackTrace();
            }
            int[] rgbArray = new int[256];
            bufferedIcon.getRGB(0, 0, 16, 16, rgbArray, 0, 16);
            atlas.setRGB(x * 16, y * 16, 16, 16, rgbArray, 0, 16);
        }
        return atlas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readTextFile(String filename) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(IntermediaryMod.class.getResourceAsStream(filename)));
        try {
            StringBuilder sb2 = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                lines.add(line);
                line = br.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return lines;
    }
}

