/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.intermediary;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.fybertech.ClassParser.ConstantPoolItem;
import net.fybertech.ClassParser.DisassembledMethod;
import net.fybertech.ClassParser.JavaClass;
import net.fybertech.ClassParser.JavaField;
import net.fybertech.ClassParser.JavaMethod;
import net.fybertech.intermediary.IntermediaryMod;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class ModHandler {
    public static Map<String, String> classMappings = null;
    public static List<String> allClasses = new ArrayList<String>();
    public static List<String> mappedClasses = new ArrayList<String>();
    public File modsDir;

    public ModHandler(File dir) {
        this.modsDir = dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMappings(String filename) {
        classMappings = new HashMap<String, String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(filename)));
        try {
            StringBuilder sb2 = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                String[] split = line.split(" ");
                classMappings.put(split[0], split[1]);
                line = br.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }

    public List<String> discoverArchives(File dir) {
        ArrayList<String> list = new ArrayList<String>();
        if (dir == null || !dir.isDirectory()) {
            IntermediaryMod.logger.warn("Mods directory \"" + dir + "\" not found!");
            return list;
        }
        for (String filename : dir.list()) {
            if (!filename.toLowerCase().endsWith(".zip") && !filename.toLowerCase().endsWith(".jar")) continue;
            list.add(filename);
        }
        return list;
    }

    public String getClassMapping(String classname) {
        String prefix = "";
        if (classname.startsWith("net/minecraft/src")) {
            classname = classname.replace("net/minecraft/src", "intermediary/minecraft/src");
        }
        if (classname.startsWith("net/minecraft/client")) {
            classname = classname.replace("net/minecraft/client", "intermediary/minecraft/client");
        }
        if (classname.startsWith("cpw/mods/fml")) {
            classname = classname.replace("cpw/mods/fml", "intermediary/fml");
        }
        if (allClasses.contains(classname)) {
            classname = "intermediary/minecraft/src/" + classname;
        }
        if (classMappings.containsKey(classname)) {
            classname = classMappings.get(classname);
        }
        return classname;
    }

    public String remapDescriptor(String descriptor) {
        String newdescriptor = "";
        if (descriptor.length() < 3) {
            return descriptor;
        }
        boolean didmap = false;
        do {
            char thischar;
            if ((thischar = descriptor.charAt(0)) == 'L') {
                String desc = descriptor.substring(1, descriptor.indexOf(59));
                descriptor = descriptor.substring(desc.length() + 2);
                String mapto = this.getClassMapping(desc);
                if (mapto != null) {
                    desc = mapto;
                }
                newdescriptor = newdescriptor + "L" + desc + ";";
                continue;
            }
            descriptor = descriptor.substring(1);
            newdescriptor = newdescriptor + thischar;
        } while (descriptor.length() >= 1);
        return newdescriptor;
    }

    private Object[] remapEntry(String name, byte[] bytes) {
        String desc;
        ConstantPoolItem cpi;
        if (!name.toLowerCase().endsWith(".class")) {
            return new Object[]{name, bytes};
        }
        JavaClass jc = null;
        try {
            jc = new JavaClass(new DataInputStream(new ByteArrayInputStream(bytes)));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (jc == null) {
            return new Object[]{name, bytes};
        }
        for (ConstantPoolItem cpi2 : jc.constant_pool.getPool()) {
            if (cpi2.ctype == 7) {
                ConstantPoolItem innerItem = jc.constant_pool.getItemByIndex((Integer)cpi2.data);
                String classname = (String)innerItem.getData();
                if ((classname = this.getClassMapping(classname)).startsWith("[")) {
                    classname = this.remapDescriptor(classname);
                }
                innerItem.setData(new String(classname));
                continue;
            }
            if (cpi2.ctype != 9 && cpi2.ctype != 10 && cpi2.ctype != 11) continue;
            int[] innerArray = (int[])cpi2.getData();
            ConstantPoolItem nameAndType = jc.constant_pool.getItemByIndex(innerArray[1]);
            int[] nameAndTypeArray = (int[])nameAndType.getData();
            ConstantPoolItem typeItem = jc.constant_pool.getItemByIndex(nameAndTypeArray[1]);
            String typeString = (String)typeItem.getData();
            typeString = this.remapDescriptor(typeString);
            typeItem.setData(new String(typeString));
        }
        for (JavaField field : jc.fields) {
            cpi = jc.constant_pool.getItemByIndex(field.descriptor_index);
            desc = (String)cpi.getData();
            desc = this.remapDescriptor(desc);
            cpi.setData(new String(desc));
        }
        for (JavaMethod method : jc.methods) {
            cpi = jc.constant_pool.getItemByIndex(method.descriptor_index);
            desc = (String)cpi.getData();
            desc = this.remapDescriptor(desc);
            cpi.setData(new String(desc));
        }
        for (ConstantPoolItem cpi2 : jc.constant_pool.getPool()) {
            if (cpi2.ctype != 1) continue;
            String classname = (String)cpi2.data;
            if (classname.contains("net.minecraft.src")) {
                classname = classname.replace("net.minecraft.src", "intermediary.minecraft.src");
                cpi2.setData(new String(classname));
                continue;
            }
            if (classname.contains("net/minecraft/src")) {
                classname = classname.replace("net/minecraft/src", "intermediary/minecraft/src");
                cpi2.setData(new String(classname));
                continue;
            }
            if (!classname.contains("cpw.mods.")) continue;
            classname = classname.replace("cpw.mods.", "intermediary.minecraft.src.cpw.mods.");
            cpi2.setData(new String(classname));
        }
        if (jc.getClassName().equals("intermediary/minecraft/src/forestry/plugins/PluginManager")) {
            for (int methodnum = 0; methodnum < 2; ++methodnum) {
                JavaMethod method;
                method = methodnum == 0 ? jc.findMethod("loadIncludedPlugins", "()V") : jc.findMethod("loadExternalPlugins", "()V");
                DisassembledMethod dm = new DisassembledMethod(method);
                String asm = dm.toString();
                asm = asm.replace("invokevirtual #methodref:java/net/URL/toURI:()Ljava/net/URI;", "invokevirtual #methodref:java/net/URL/getFile:()Ljava/lang/String;");
                asm = asm.replace("invokespecial #methodref:java/io/File/<init>:(Ljava/net/URI;)V", "astore_0\naload_0\nbipush 6\naload_0\nbipush 33\ninvokevirtual #methodref:java/lang/String/lastIndexOf:(I)I\ninvokevirtual #methodref:java/lang/String/substring:(II)Ljava/lang/String;\ninvokespecial #methodref:java/io/File/<init>:(Ljava/lang/String;)V");
                dm.labels.clear();
                dm.methodops.clear();
                try {
                    dm.methodops = dm.assembleCode(asm);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                dm.attributes.clear();
                method.setCodeArray(dm.toByteArray());
            }
        }
        name = jc.getClassName() + ".class";
        bytes = jc.toByteArray();
        return new Object[]{name, bytes};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readStreamBytes(InputStream classStream) {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(classStream);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            int count = 0;
            while ((count = bis.read(bytes)) > 0) {
                baos.write(bytes, 0, count);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    private void scanArchivesForClasses(List<String> archives) {
        for (String archiveName : archives) {
            try {
                ZipFile zip = new ZipFile(new File(this.modsDir, archiveName));
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !entry.getName().toLowerCase().endsWith(".class")) continue;
                    allClasses.add(entry.getName().substring(0, entry.getName().length() - 6));
                }
                zip.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void remapArchives() {
        List<String> archives = this.discoverArchives(this.modsDir);
        this.scanArchivesForClasses(archives);
        for (String modArchive : archives) {
            File f = new File(this.modsDir, modArchive);
            if (!f.exists() || !f.isFile()) continue;
            try {
                ZipFile zip = new ZipFile(f);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ZipOutputStream zipout = new ZipOutputStream(baos);
                Enumeration<? extends ZipEntry> e = zip.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    if (entry.isDirectory()) continue;
                    Object[] mapResult = this.remapEntry(entry.getName(), this.readStreamBytes(zip.getInputStream(entry)));
                    String entryName = (String)mapResult[0];
                    byte[] entryBytes = (byte[])mapResult[1];
                    if ((entryName = entryName.replace("net/minecraft", "intermediary/minecraft")).toLowerCase().endsWith(".class")) {
                        mappedClasses.add(entryName);
                    }
                    zipout.putNextEntry(new ZipEntry(entryName));
                    zipout.write(entryBytes);
                    zipout.closeEntry();
                }
                zipout.close();
                zip.close();
                modArchive = modArchive.replace(".zip", "-reobf.zip");
                modArchive = modArchive.replace(".jar", "-reobf.jar");
                File cacheDir = new File(this.modsDir, "cache");
                cacheDir.mkdirs();
                byte[] array = baos.toByteArray();
                FileOutputStream fos = new FileOutputStream(new File(cacheDir, modArchive));
                fos.write(array);
                fos.close();
                File newurl = new File(cacheDir, modArchive);
                System.out.println("Adding " + newurl);
                ((LaunchClassLoader)IntermediaryMod.class.getClassLoader()).addURL(newurl.toURI().toURL());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

