/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.intermediary;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forge.IHighlightHandler;
import forge.MinecraftForgeClient;
import intermediary.fml.common.FMLCommonHandler;
import intermediary.fml.common.ITickHandler;
import intermediary.fml.common.TickType;
import intermediary.fml.common.modloader.BaseMod;
import intermediary.minecraft.src.Block;
import intermediary.minecraft.src.ModLoader;
import intermediary.minecraft.src.aan;
import intermediary.minecraft.src.ahu;
import intermediary.minecraft.src.fr;
import intermediary.minecraft.src.pb;
import intermediary.minecraft.src.pl;
import intermediary.minecraft.src.vd;
import intermediary.minecraft.src.wf;
import intermediary.minecraft.src.xd;
import intermediary.minecraft.src.yr;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.fybertech.intermediary.BlockBridge;
import net.fybertech.intermediary.BlockBridgeItem;
import net.fybertech.intermediary.BlockRenderLater;
import net.fybertech.intermediary.BridgeUtil;
import net.fybertech.intermediary.CustomBlockRenderer;
import net.fybertech.intermediary.EntityPlayerBridge;
import net.fybertech.intermediary.GuiHelper;
import net.fybertech.intermediary.ItemBridge;
import net.fybertech.intermediary.ItemRendererBridge;
import net.fybertech.intermediary.ModHandler;
import net.fybertech.intermediary.RecipeBridge;
import net.fybertech.intermediary.RecipeHolder;
import net.fybertech.intermediary.RenderGlobalBridge;
import net.fybertech.intermediary.TESRBridge;
import net.fybertech.intermediary.TextureHelper;
import net.fybertech.intermediary.TextureSprite;
import net.fybertech.intermediary.TileEntityBridge;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderWorldEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

@Mod(modid="IntermediaryMod", name="Intermediary", version="MC1.7.10-002")
public class IntermediaryMod {
    @Mod.Instance
    public static IntermediaryMod instance;
    public static final String MODID = "IntermediaryMod";
    public static final String VERSION = "MC1.7.10-002";
    public static final Logger logger;
    public static int renderID_3DInventory;
    public static int renderID_2DInventory;
    public static boolean initComplete;
    public static BufferedImage classicBlockAtlas;
    public static BufferedImage classicItemAtlas;
    public static CreativeTabs tabCustom;
    public static Map<Block, net.minecraft.block.Block> blockMap;
    public static Map<intermediary.minecraft.src.Item, Item> itemMap;
    public static List<TextureSprite> blocksprites;
    public static List<TextureSprite> itemsprites;
    public static boolean inWorldRenderer;
    public static boolean inWorldRenderer2;
    public static List<BlockRenderLater> blocksToRender;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        int n;
        File outputfile;
        logger.info("Generating classic texture atlases");
        classicBlockAtlas = TextureHelper.generateClassicIconAtlas("/assets/intermediary/blocks.txt");
        classicItemAtlas = TextureHelper.generateClassicIconAtlas("/assets/intermediary/items.txt");
        try {
            outputfile = new File("classicBlockAtlas.png");
            ImageIO.write((RenderedImage)classicBlockAtlas, "png", outputfile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            outputfile = new File("classicItemAtlas.png");
            ImageIO.write((RenderedImage)classicItemAtlas, "png", outputfile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.info("Initializing vanilla compatibility blocks");
        ArrayList<pb> vanillaBlocks = new ArrayList<pb>();
        ArrayList<yr> vanillaItems = new ArrayList<yr>();
        yr[] itemsArray = yr.e;
        pb[] blocksArray = pb.m;
        for (int n2 = 0; n2 < itemsArray.length; ++n2) {
            if (itemsArray[n2] == null) continue;
            if (n2 != 31999) {
                itemsArray[n2].isVanillaItem = true;
            }
            vanillaItems.add(itemsArray[n2]);
        }
        for (int n2 = 0; n2 < blocksArray.length; ++n2) {
            if (blocksArray[n2] == null) continue;
            blocksArray[n2].isVanillaBlock = true;
            vanillaBlocks.add(blocksArray[n2]);
        }
        logger.info("Initializing mods");
        File modsDir = new File(Minecraft.func_71410_x().field_71412_D, "Intermediary/mods");
        modsDir.mkdirs();
        ModHandler modHandler = new ModHandler(modsDir);
        modHandler.loadMappings("/assets/intermediary/classes.txt");
        modHandler.remapArchives();
        ArrayList<BaseMod> loadedMods = new ArrayList<BaseMod>();
        for (String classname : ModHandler.mappedClasses) {
            if (!(classname = classname.substring(0, classname.length() - 6)).startsWith("mod_") && !classname.contains("/mod_") || classname.contains("$")) continue;
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(classname.replace("/", "."));
                Class<BaseMod> baseclass = clazz.asSubclass(BaseMod.class);
                BaseMod m = baseclass.newInstance();
                loadedMods.add(m);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        cpw.mods.fml.common.FMLCommonHandler.instance().bus().register((Object)this);
        for (yr item : vanillaItems) {
            itemMap.put((intermediary.minecraft.src.Item)item, Item.func_150899_d((int)item.bQ));
        }
        for (pb block : vanillaBlocks) {
            blockMap.put((Block)block, net.minecraft.block.Block.func_149729_e((int)block.bO));
        }
        for (BaseMod mod : loadedMods) {
            System.out.println("DEBUG: load(): ");
            mod.load();
        }
        for (BaseMod mod : loadedMods) {
            System.out.println("DEBUG: modsLoaded(): ");
            mod.modsLoaded();
        }
        renderID_2DInventory = RenderingRegistry.getNextAvailableRenderId();
        renderID_3DInventory = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new CustomBlockRenderer(renderID_2DInventory));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new CustomBlockRenderer(renderID_3DInventory));
        ClientRegistry.registerTileEntity(TileEntityBridge.class, (String)"IntermediaryTE", (TileEntitySpecialRenderer)new TESRBridge());
        HashMap<Integer, vd> itemBlocks = new HashMap<Integer, vd>();
        logger.info("Processing items added... ");
        for (n = 0; n < itemsArray.length; ++n) {
            String name;
            if (itemsArray[n] == null || vanillaItems.contains(itemsArray[n])) continue;
            yr yr2 = itemsArray[n];
            boolean isItemBlock = false;
            if (yr2 instanceof vd) {
                isItemBlock = true;
            }
            if ((name = yr2.e()) == null) {
                name = "UNNAMED_ITEM_" + n;
                yr2.a(name);
            }
            name = name.replace("item.", "");
            if (!isItemBlock) {
                String fullname;
                Item newitem = new ItemBridge(yr2).func_77637_a(tabCustom);
                logger.info("ITEM: " + newitem.func_77658_a());
                GameRegistry.registerItem((Item)newitem, (String)("intermediary_" + name + "_" + n));
                if (yr2.itemRenderer != null) {
                    net.minecraftforge.client.MinecraftForgeClient.registerItemRenderer((Item)newitem, (IItemRenderer)new ItemRendererBridge(yr2.itemRenderer));
                }
                if ((fullname = ModLoader.nameMap.get(yr2)) != null) {
                    LanguageRegistry.addName((Object)newitem, (String)fullname);
                }
                itemMap.put((intermediary.minecraft.src.Item)yr2, newitem);
                continue;
            }
            logger.info("ITEM (ITEMBLOCK): " + yr2);
            itemBlocks.put(((vd)yr2).d(), (vd)yr2);
        }
        logger.info("Processing blocks added... ");
        for (n = 0; n < blocksArray.length; ++n) {
            if (blocksArray[n] == null || vanillaBlocks.contains(blocksArray[n])) continue;
            pb pb2 = blocksArray[n];
            String name = pb2.s();
            if (name == null) {
                name = "UNNAMED_BLOCK_" + n;
                pb2.a(name);
            }
            name = name.replace("tile.", "");
            net.minecraft.block.Block newblock = null;
            if (itemBlocks.containsKey(pb2.bO)) {
                newblock = new BlockBridge(pb2, (vd)itemBlocks.get(pb2.bO)).func_149647_a(tabCustom);
                logger.info("BLOCK+ITEMBLOCK: " + newblock.func_149739_a());
                logger.info("  bID: " + pb2.bO + " iID: " + ((vd)itemBlocks.get((Object)Integer.valueOf((int)pb2.bO))).bQ + " " + pb2.getClass() + " " + ((vd)itemBlocks.get(pb2.bO)).getClass());
                GameRegistry.registerBlock((net.minecraft.block.Block)newblock, BlockBridgeItem.class, (String)("intermediary_" + name + "_" + n));
                itemMap.put((intermediary.minecraft.src.Item)itemBlocks.get(pb2.bO), Item.func_150898_a((net.minecraft.block.Block)newblock));
            } else {
                newblock = new BlockBridge(pb2).func_149647_a(tabCustom);
                logger.info("BLOCK: " + newblock.func_149739_a() + " bID: " + pb2.bO);
                GameRegistry.registerBlock((net.minecraft.block.Block)newblock, (String)("intermediary_" + name + "_" + n));
            }
            blockMap.put((Block)pb2, newblock);
            String fullname = ModLoader.nameMap.get(pb2);
            if (fullname == null) continue;
            LanguageRegistry.addName((Object)newblock, (String)fullname);
        }
        for (RecipeHolder recipeHolder : RecipeHolder.list) {
            yr resultItem = recipeHolder.stack.a();
            if (resultItem == null) continue;
            if (itemMap.get(resultItem) == null) {
                System.out.println("Can't find map for " + resultItem);
                continue;
            }
            int resultDamage = recipeHolder.stack.i();
            int resultCount = recipeHolder.stack.a;
            ItemStack newStack = new ItemStack(itemMap.get(resultItem), resultCount, resultDamage);
            ArrayList<Object> objects = new ArrayList<Object>();
            boolean abort = false;
            for (int n3 = 0; n3 < recipeHolder.o.length; ++n3) {
                Object o = recipeHolder.o[n3];
                if (o instanceof yr) {
                    Item item = itemMap.get((yr)o);
                    if (item == null) {
                        System.out.println("Can't find map for " + o);
                        abort = true;
                        break;
                    }
                    objects.add(new ItemStack(item));
                    continue;
                }
                if (o instanceof pb) {
                    net.minecraft.block.Block block = blockMap.get((pb)o);
                    if (block == null) {
                        System.out.println("Can't find map for " + o);
                        abort = true;
                        break;
                    }
                    objects.add(new ItemStack(block));
                    continue;
                }
                if (o instanceof aan) {
                    aan oldStack = (aan)o;
                    Item item = itemMap.get(oldStack.a());
                    if (item == null) {
                        System.out.println("Can't find map for " + oldStack.a());
                        abort = true;
                        break;
                    }
                    objects.add(new ItemStack(item, oldStack.a, oldStack.i()));
                    continue;
                }
                if (o instanceof String) {
                    objects.add(o);
                    continue;
                }
                if (!(o instanceof Character)) continue;
                objects.add(o);
            }
            if (abort) {
                logger.info("Bad Recipe: " + resultItem + " Damage: " + resultDamage + " Count: " + resultCount);
                continue;
            }
            if (recipeHolder.isShapeless) {
                GameRegistry.addShapelessRecipe((ItemStack)newStack, (Object[])objects.toArray());
                continue;
            }
            GameRegistry.addRecipe((ItemStack)newStack, (Object[])objects.toArray());
        }
        for (wf wf2 : fr.a().b()) {
            CraftingManager.func_77594_a();
            CraftingManager.func_77594_a().func_77592_b().add(new RecipeBridge(wf2));
        }
        initComplete = true;
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHelper());
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        List<TextureSprite> list = null;
        if (event.map.func_130086_a() == 0) {
            list = blocksprites;
        } else if (event.map.func_130086_a() == 1) {
            list = itemsprites;
        }
        if (list == null) {
            return;
        }
        for (TextureAtlasSprite textureAtlasSprite : list) {
            event.map.setTextureEntry(textureAtlasSprite.func_94215_i(), textureAtlasSprite);
        }
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Post event) {
    }

    @SubscribeEvent
    public void onPreRender(RenderWorldEvent.Pre event) {
        inWorldRenderer = true;
        inWorldRenderer2 = true;
        blocksToRender.clear();
    }

    @SubscribeEvent
    public void onPostRender(RenderWorldEvent.Post event) {
        inWorldRenderer = false;
        for (BlockRenderLater later : blocksToRender) {
            if (!(later.block instanceof BlockBridge)) continue;
            BlockBridge block = (BlockBridge)later.block;
            pb oldblock = block.bridgedBlock;
            if (!block.canRenderInPass(event.pass)) continue;
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78373_b((double)(-event.renderer.field_78923_c), (double)(-event.renderer.field_78920_d), (double)(-event.renderer.field_78921_e));
            if (oldblock.getTextureFile() != null && !oldblock.getTextureFile().equals("/terrain.png")) {
                int texID = ahu.a.e.b(oldblock.getTextureFile());
                GL11.glBindTexture((int)3553, (int)texID);
            } else {
                GL11.glBindTexture((int)3553, (int)ModLoader.getMinecraftInstance().p.b("terrain.png"));
            }
            event.renderBlocks.func_147805_b((net.minecraft.block.Block)block, later.x, later.y, later.z);
            Tessellator.field_78398_a.func_78381_a();
        }
        blocksToRender.clear();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        inWorldRenderer2 = false;
    }

    @SubscribeEvent
    public void onPostRender(DrawBlockHighlightEvent event) {
        if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.MISS) {
            return;
        }
        pl mop = new pl(event.target);
        aan stack = BridgeUtil.bridgeItemStackIn(event.currentItem);
        for (IHighlightHandler handler : MinecraftForgeClient.highlightHandlers) {
            boolean result = handler.onBlockHighlight(new RenderGlobalBridge(event.context), new EntityPlayerBridge(event.player), mop, event.subID, stack, event.partialTicks);
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.WorldTickEvent event) {
        xd w = BridgeUtil.bridgeWorld(event.world);
        intermediary.minecraft.client.Minecraft mc = new intermediary.minecraft.client.Minecraft();
        for (ITickHandler handler : FMLCommonHandler.tickHandlers) {
            try {
                if (event.phase != TickEvent.Phase.START) continue;
                handler.tickStart(EnumSet.of(TickType.WORLD), null, null, w);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        if (!event.world.field_72995_K) {
            return;
        }
        for (intermediary.minecraft.src.BaseMod mod : ModLoader.inGameHooks.keySet()) {
            mod.onTickInGame(0.0f, mc);
        }
    }

    @SubscribeEvent
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
        intermediary.minecraft.client.Minecraft mc = new intermediary.minecraft.client.Minecraft();
        if (mc.h == null || mc.f == null) {
            return;
        }
        for (intermediary.minecraft.src.BaseMod mod : ModLoader.inGameHooks.keySet()) {
            mod.onTickInGame(0.0f, mc);
        }
    }

    static {
        logger = LogManager.getLogger((String)"Intermediary");
        renderID_3DInventory = -1;
        renderID_2DInventory = -1;
        initComplete = false;
        tabCustom = new CreativeTabs("Intermediary"){

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return Items.field_151061_bv;
            }
        };
        blockMap = new HashMap<Block, net.minecraft.block.Block>();
        itemMap = new HashMap<intermediary.minecraft.src.Item, Item>();
        blocksprites = new ArrayList<TextureSprite>();
        itemsprites = new ArrayList<TextureSprite>();
        inWorldRenderer = false;
        inWorldRenderer2 = false;
        blocksToRender = new ArrayList<BlockRenderLater>();
    }
}

