/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.ClassParser.opcodes;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fybertech.ClassParser.ClassPool;
import net.fybertech.ClassParser.ConstantPoolItem;
import net.fybertech.ClassParser.DisassembledMethod;
import net.fybertech.ClassParser.JavaClass;
import net.fybertech.ClassParser.JavaField;
import net.fybertech.ClassParser.JavaMethod;
import net.fybertech.ClassParser.opcodes.OpJump;
import net.fybertech.ClassParser.opcodes.OpLookupswitch;
import net.fybertech.ClassParser.opcodes.OpTableswitch;
import net.fybertech.ClassParser.opcodes.OpWide;

public class Opcode {
    public static Map<Integer, Opcode> opcodesByNum = new HashMap<Integer, Opcode>();
    public static Map<String, Opcode> opcodesByName = new HashMap<String, Opcode>();
    public static final Opcode NOP = new Opcode(0, "nop");
    public static final Opcode ACONST_NULL = new Opcode(1, "aconst_null");
    public static final Opcode ICONST_M1 = new Opcode(2, "iconst_m1");
    public static final Opcode ICONST_0 = new Opcode(3, "iconst_0");
    public static final Opcode ICONST_1 = new Opcode(4, "iconst_1");
    public static final Opcode ICONST_2 = new Opcode(5, "iconst_2");
    public static final Opcode ICONST_3 = new Opcode(6, "iconst_3");
    public static final Opcode ICONST_4 = new Opcode(7, "iconst_4");
    public static final Opcode ICONST_5 = new Opcode(8, "iconst_5");
    public static final Opcode LCONST_0 = new Opcode(9, "lconst_0");
    public static final Opcode LCONST_1 = new Opcode(10, "lconst_1");
    public static final Opcode FCONST_0 = new Opcode(11, "fconst_0");
    public static final Opcode FCONST_1 = new Opcode(12, "fconst_1");
    public static final Opcode FCONST_2 = new Opcode(13, "fconst_2");
    public static final Opcode DCONST_0 = new Opcode(14, "dconst_0");
    public static final Opcode DCONST_1 = new Opcode(15, "dconst_1");
    public static final Opcode BIPUSH = new Opcode(16, "bipush", new EnumType[]{EnumType.SBYTE});
    public static final Opcode SIPUSH = new Opcode(17, "sipush", new EnumType[]{EnumType.SSHORT});
    public static final Opcode LDC = new Opcode(18, "ldc", new EnumType[]{EnumType.CP8});
    public static final Opcode LDC_W = new Opcode(19, "ldc_w", new EnumType[]{EnumType.CP16});
    public static final Opcode LDC2_W = new Opcode(20, "ldc2_w", new EnumType[]{EnumType.CP16});
    public static final Opcode ILOAD = new Opcode(21, "iload", new EnumType[]{EnumType.UBYTE});
    public static final Opcode LLOAD = new Opcode(22, "lload", new EnumType[]{EnumType.UBYTE});
    public static final Opcode FLOAD = new Opcode(23, "fload", new EnumType[]{EnumType.UBYTE});
    public static final Opcode DLOAD = new Opcode(24, "dload", new EnumType[]{EnumType.UBYTE});
    public static final Opcode ALOAD = new Opcode(25, "aload", new EnumType[]{EnumType.UBYTE});
    public static final Opcode ILOAD_0 = new Opcode(26, "iload_0");
    public static final Opcode ILOAD_1 = new Opcode(27, "iload_1");
    public static final Opcode ILOAD_2 = new Opcode(28, "iload_2");
    public static final Opcode ILOAD_3 = new Opcode(29, "iload_3");
    public static final Opcode LLOAD_0 = new Opcode(30, "lload_0");
    public static final Opcode LLOAD_1 = new Opcode(31, "lload_1");
    public static final Opcode LLOAD_2 = new Opcode(32, "lload_2");
    public static final Opcode LLOAD_3 = new Opcode(33, "lload_3");
    public static final Opcode FLOAD_0 = new Opcode(34, "fload_0");
    public static final Opcode FLOAD_1 = new Opcode(35, "fload_1");
    public static final Opcode FLOAD_2 = new Opcode(36, "fload_2");
    public static final Opcode FLOAD_3 = new Opcode(37, "fload_3");
    public static final Opcode DLOAD_0 = new Opcode(38, "dload_0");
    public static final Opcode DLOAD_1 = new Opcode(39, "dload_1");
    public static final Opcode DLOAD_2 = new Opcode(40, "dload_2");
    public static final Opcode DLOAD_3 = new Opcode(41, "dload_3");
    public static final Opcode ALOAD_0 = new Opcode(42, "aload_0");
    public static final Opcode ALOAD_1 = new Opcode(43, "aload_1");
    public static final Opcode ALOAD_2 = new Opcode(44, "aload_2");
    public static final Opcode ALOAD_3 = new Opcode(45, "aload_3");
    public static final Opcode IALOAD = new Opcode(46, "iaload");
    public static final Opcode LALOAD = new Opcode(47, "laload");
    public static final Opcode FALOAD = new Opcode(48, "faload");
    public static final Opcode DALOAD = new Opcode(49, "daload");
    public static final Opcode AALOAD = new Opcode(50, "aaload");
    public static final Opcode BALOAD = new Opcode(51, "baload");
    public static final Opcode CALOAD = new Opcode(52, "caload");
    public static final Opcode SALOAD = new Opcode(53, "saload");
    public static final Opcode ISTORE = new Opcode(54, "istore", new EnumType[]{EnumType.UBYTE});
    public static final Opcode LSTORE = new Opcode(55, "lstore", new EnumType[]{EnumType.UBYTE});
    public static final Opcode FSTORE = new Opcode(56, "fstore", new EnumType[]{EnumType.UBYTE});
    public static final Opcode DSTORE = new Opcode(57, "dstore", new EnumType[]{EnumType.UBYTE});
    public static final Opcode ASTORE = new Opcode(58, "astore", new EnumType[]{EnumType.UBYTE});
    public static final Opcode ISTORE_0 = new Opcode(59, "istore_0");
    public static final Opcode ISTORE_1 = new Opcode(60, "istore_1");
    public static final Opcode ISTORE_2 = new Opcode(61, "istore_2");
    public static final Opcode ISTORE_3 = new Opcode(62, "istore_3");
    public static final Opcode LSTORE_0 = new Opcode(63, "lstore_0");
    public static final Opcode LSTORE_1 = new Opcode(64, "lstore_1");
    public static final Opcode LSTORE_2 = new Opcode(65, "lstore_2");
    public static final Opcode LSTORE_3 = new Opcode(66, "lstore_3");
    public static final Opcode FSTORE_0 = new Opcode(67, "fstore_0");
    public static final Opcode FSTORE_1 = new Opcode(68, "fstore_1");
    public static final Opcode FSTORE_2 = new Opcode(69, "fstore_2");
    public static final Opcode FSTORE_3 = new Opcode(70, "fstore_3");
    public static final Opcode DSTORE_0 = new Opcode(71, "dstore_0");
    public static final Opcode DSTORE_1 = new Opcode(72, "dstore_1");
    public static final Opcode DSTORE_2 = new Opcode(73, "dstore_2");
    public static final Opcode DSTORE_3 = new Opcode(74, "dstore_3");
    public static final Opcode ASTORE_0 = new Opcode(75, "astore_0");
    public static final Opcode ASTORE_1 = new Opcode(76, "astore_1");
    public static final Opcode ASTORE_2 = new Opcode(77, "astore_2");
    public static final Opcode ASTORE_3 = new Opcode(78, "astore_3");
    public static final Opcode IASTORE = new Opcode(79, "iastore");
    public static final Opcode LASTORE = new Opcode(80, "lastore");
    public static final Opcode FASTORE = new Opcode(81, "fastore");
    public static final Opcode DASTORE = new Opcode(82, "dastore");
    public static final Opcode AASTORE = new Opcode(83, "aastore");
    public static final Opcode BASTORE = new Opcode(84, "bastore");
    public static final Opcode CASTORE = new Opcode(85, "castore");
    public static final Opcode SASTORE = new Opcode(86, "sastore");
    public static final Opcode POP = new Opcode(87, "pop");
    public static final Opcode POP2 = new Opcode(88, "pop2");
    public static final Opcode DUP = new Opcode(89, "dup");
    public static final Opcode DUP_X1 = new Opcode(90, "dup_x1");
    public static final Opcode DUP_X2 = new Opcode(91, "dup_x2");
    public static final Opcode DUP2 = new Opcode(92, "dup2");
    public static final Opcode DUP2_X1 = new Opcode(93, "dup2_x1");
    public static final Opcode DUP2_X2 = new Opcode(94, "dup2_x2");
    public static final Opcode SWAP = new Opcode(95, "swap");
    public static final Opcode IADD = new Opcode(96, "iadd");
    public static final Opcode LADD = new Opcode(97, "ladd");
    public static final Opcode FADD = new Opcode(98, "fadd");
    public static final Opcode DADD = new Opcode(99, "dadd");
    public static final Opcode ISUB = new Opcode(100, "isub");
    public static final Opcode LSUB = new Opcode(101, "lsub");
    public static final Opcode FSUB = new Opcode(102, "fsub");
    public static final Opcode DSUB = new Opcode(103, "dsub");
    public static final Opcode IMUL = new Opcode(104, "imul");
    public static final Opcode LMUL = new Opcode(105, "lmul");
    public static final Opcode FMUL = new Opcode(106, "fmul");
    public static final Opcode DMUL = new Opcode(107, "dmul");
    public static final Opcode IDIV = new Opcode(108, "idiv");
    public static final Opcode LDIV = new Opcode(109, "ldiv");
    public static final Opcode FDIV = new Opcode(110, "fdiv");
    public static final Opcode DDIV = new Opcode(111, "ddiv");
    public static final Opcode IREM = new Opcode(112, "irem");
    public static final Opcode LREM = new Opcode(113, "lrem");
    public static final Opcode FREM = new Opcode(114, "frem");
    public static final Opcode DREM = new Opcode(115, "drem");
    public static final Opcode INEG = new Opcode(116, "ineg");
    public static final Opcode LNEG = new Opcode(117, "lneg");
    public static final Opcode FNEG = new Opcode(118, "fneg");
    public static final Opcode DNEG = new Opcode(119, "dneg");
    public static final Opcode ISHL = new Opcode(120, "ishl");
    public static final Opcode LSHL = new Opcode(121, "lshl");
    public static final Opcode ISHR = new Opcode(122, "ishr");
    public static final Opcode LSHR = new Opcode(123, "lshr");
    public static final Opcode IUSHR = new Opcode(124, "iushr");
    public static final Opcode LUSHR = new Opcode(125, "lushr");
    public static final Opcode IAND = new Opcode(126, "iand");
    public static final Opcode LAND = new Opcode(127, "land");
    public static final Opcode IOR = new Opcode(128, "ior");
    public static final Opcode LOR = new Opcode(129, "lor");
    public static final Opcode IXOR = new Opcode(130, "ixor");
    public static final Opcode LXOR = new Opcode(131, "lxor");
    public static final Opcode IINC = new Opcode(132, "iinc", new EnumType[]{EnumType.UBYTE, EnumType.SBYTE});
    public static final Opcode I2L = new Opcode(133, "i2l");
    public static final Opcode I2F = new Opcode(134, "i2f");
    public static final Opcode I2D = new Opcode(135, "i2d");
    public static final Opcode L2I = new Opcode(136, "l2i");
    public static final Opcode L2F = new Opcode(137, "l2f");
    public static final Opcode L2D = new Opcode(138, "l2d");
    public static final Opcode F2I = new Opcode(139, "f2i");
    public static final Opcode F2L = new Opcode(140, "f2l");
    public static final Opcode F2D = new Opcode(141, "f2d");
    public static final Opcode D2I = new Opcode(142, "d2i");
    public static final Opcode D2L = new Opcode(143, "d2l");
    public static final Opcode D2F = new Opcode(144, "d2f");
    public static final Opcode I2B = new Opcode(145, "i2b");
    public static final Opcode I2C = new Opcode(146, "i2c");
    public static final Opcode I2S = new Opcode(147, "i2s");
    public static final Opcode LCMP = new Opcode(148, "lcmp");
    public static final Opcode FCMPL = new Opcode(149, "fcmpl");
    public static final Opcode FCMPG = new Opcode(150, "fcmpg");
    public static final Opcode DCMPL = new Opcode(151, "dcmpl");
    public static final Opcode DCMPG = new Opcode(152, "dcmpg");
    public static final Opcode IFEQ = new OpJump(153, "ifeq", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode IFNE = new OpJump(154, "ifne", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode IFLT = new OpJump(155, "iflt", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode IFGE = new OpJump(156, "ifge", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode IFGT = new OpJump(157, "ifgt", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode IFLE = new OpJump(158, "ifle", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode IF_ICMPEQ = new OpJump(159, "if_icmpeq", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode IF_ICMPNE = new OpJump(160, "if_icmpne", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode IF_ICMPLT = new OpJump(161, "if_icmplt", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode IF_ICMPGE = new OpJump(162, "if_icmpge", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode IF_ICMPGT = new OpJump(163, "if_icmpgt", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode IF_ICMPLE = new OpJump(164, "if_icmple", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode IF_ACMPEQ = new OpJump(165, "if_acmpeq", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode IF_ACMPNE = new OpJump(166, "if_acmpne", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode GOTO = new OpJump(167, "goto", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode JSR = new OpJump(168, "jsr", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode RET = new Opcode(169, "ret", new EnumType[]{EnumType.UBYTE});
    public static final Opcode TABLESWITCH = new OpTableswitch(170, "tableswitch");
    public static final Opcode LOOKUPSWITCH = new OpLookupswitch(171, "lookupswitch");
    public static final Opcode IRETURN = new Opcode(172, "ireturn");
    public static final Opcode LRETURN = new Opcode(173, "lreturn");
    public static final Opcode FRETURN = new Opcode(174, "freturn");
    public static final Opcode DRETURN = new Opcode(175, "dreturn");
    public static final Opcode ARETURN = new Opcode(176, "areturn");
    public static final Opcode RETURN = new Opcode(177, "return");
    public static final Opcode GETSTATIC = new Opcode(178, "getstatic", new EnumType[]{EnumType.CP16});
    public static final Opcode PUTSTATIC = new Opcode(179, "putstatic", new EnumType[]{EnumType.CP16});
    public static final Opcode GETFIELD = new Opcode(180, "getfield", new EnumType[]{EnumType.CP16});
    public static final Opcode PUTFIELD = new Opcode(181, "putfield", new EnumType[]{EnumType.CP16});
    public static final Opcode INVOKEVIRTUAL = new Opcode(182, "invokevirtual", new EnumType[]{EnumType.CP16});
    public static final Opcode INVOKESPECIAL = new Opcode(183, "invokespecial", new EnumType[]{EnumType.CP16});
    public static final Opcode INVOKESTATIC = new Opcode(184, "invokestatic", new EnumType[]{EnumType.CP16});
    public static final Opcode INVOKEINTERFACE = new Opcode(185, "invokeinterface", new EnumType[]{EnumType.CP16, EnumType.UBYTE, EnumType.UBYTE});
    public static final Opcode INVOKEDYNAMIC = new Opcode(186, "invokedynamic", new EnumType[]{EnumType.CP16, EnumType.UBYTE, EnumType.UBYTE});
    public static final Opcode NEW = new Opcode(187, "new", new EnumType[]{EnumType.CP16});
    public static final Opcode NEWARRAY = new Opcode(188, "newarray", new EnumType[]{EnumType.UBYTE});
    public static final Opcode ANEWARRAY = new Opcode(189, "anewarray", new EnumType[]{EnumType.CP16});
    public static final Opcode ARRAYLENGTH = new Opcode(190, "arraylength");
    public static final Opcode ATHROW = new Opcode(191, "athrow");
    public static final Opcode CHECKCAST = new Opcode(192, "checkcast", new EnumType[]{EnumType.CP16});
    public static final Opcode INSTANCEOF = new Opcode(193, "instanceof", new EnumType[]{EnumType.CP16});
    public static final Opcode MONITORENTER = new Opcode(194, "monitorenter");
    public static final Opcode MONITOREXIT = new Opcode(195, "monitorexit");
    public static final Opcode WIDE = new OpWide(196, "wide");
    public static final Opcode MULTIANEWARRAY = new Opcode(197, "multianewarray", new EnumType[]{EnumType.CP16, EnumType.UBYTE});
    public static final Opcode IFNULL = new OpJump(198, "ifnull", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode IFNONNULL = new OpJump(199, "ifnonnull", new EnumType[]{EnumType.OFFSET16});
    public static final Opcode GOTO_W = new OpJump(200, "goto_w", new EnumType[]{EnumType.OFFSET32});
    public static final Opcode JSR_W = new OpJump(201, "jsr_w", new EnumType[]{EnumType.OFFSET32});
    public static final Opcode BREAKPOINT = new Opcode(202, "breakpoint");
    public static final Opcode IMPDEP1 = new Opcode(254, "impdep1");
    public static final Opcode IMPDEP2 = new Opcode(255, "impdep2");
    public final int opcode;
    public final String opname;
    public final EnumType[] signature;
    protected int length = 0;
    public int[] parameters = null;
    protected DisassembledMethod method = null;
    public int position = -1;
    public List<Integer> labels = new ArrayList<Integer>();

    public static Opcode getByNum(int n) {
        return opcodesByNum.get(n);
    }

    public static Opcode getByName(String s) {
        return opcodesByName.get(s);
    }

    public static String getName(int n) {
        return opcodesByNum.get(n).getName();
    }

    public static int getNum(String s) {
        return opcodesByName.get(s).getNum();
    }

    protected Opcode(int opcode, String name) {
        this.opname = name;
        this.opcode = opcode;
        this.signature = new EnumType[0];
        opcodesByNum.put(opcode, this);
        opcodesByName.put(name, this);
    }

    protected Opcode(int opcode, String name, EnumType[] sig) {
        this.opname = name;
        this.opcode = opcode;
        this.signature = sig;
        int n = 0;
        while (n < sig.length) {
            switch (sig[n]) {
                case UBYTE: 
                case SBYTE: 
                case CP8: {
                    ++this.length;
                    break;
                }
                case USHORT: 
                case SSHORT: 
                case CP16: 
                case OFFSET16: {
                    this.length += 2;
                    break;
                }
                case UINT: 
                case SINT: 
                case OFFSET32: {
                    this.length += 4;
                    break;
                }
            }
            ++n;
        }
        this.parameters = new int[sig.length];
        opcodesByNum.put(opcode, this);
        opcodesByName.put(name, this);
    }

    public Opcode(DisassembledMethod dm, Opcode op) {
        this.method = dm;
        this.opname = op.opname;
        this.opcode = op.opcode;
        this.length = op.length;
        this.position = op.position;
        this.signature = op.signature != null ? (EnumType[])op.signature.clone() : null;
        this.parameters = (int[])(op.parameters != null ? (int[])op.parameters.clone() : null);
    }

    public Opcode clone(DisassembledMethod dm) {
        return new Opcode(dm, this);
    }

    public int readParameters(byte[] codeblock, int startIndex) {
        this.position = startIndex - 1;
        ByteBuffer wrapper = ByteBuffer.wrap(codeblock);
        wrapper.position(startIndex);
        int read = 0;
        if (this.signature != null) {
            int n = 0;
            while (n < this.signature.length) {
                switch (this.signature[n]) {
                    case UBYTE: 
                    case CP8: {
                        this.parameters[n] = wrapper.get() & 0xFF;
                        ++read;
                        break;
                    }
                    case SBYTE: {
                        this.parameters[n] = wrapper.get();
                        ++read;
                        break;
                    }
                    case USHORT: 
                    case CP16: {
                        this.parameters[n] = wrapper.getShort() & 0xFFFF;
                        read += 2;
                        break;
                    }
                    case SSHORT: 
                    case OFFSET16: {
                        this.parameters[n] = wrapper.getShort();
                        read += 2;
                        break;
                    }
                    case UINT: {
                        this.parameters[n] = wrapper.getInt() & 0xFFFFFFFF;
                        read += 4;
                        break;
                    }
                    case SINT: 
                    case OFFSET32: {
                        this.parameters[n] = wrapper.getInt();
                        read += 4;
                    }
                }
                if (this.signature[n] == EnumType.OFFSET16 || this.signature[n] == EnumType.OFFSET32) {
                    this.labels.add(this.parameters[n] + this.position);
                }
                ++n;
            }
        }
        return read;
    }

    public String getName() {
        return this.opname;
    }

    public int getNum() {
        return this.opcode;
    }

    public int getLength() {
        return 1 + this.length;
    }

    public String toString() {
        String out = this.getName();
        if (this.parameters != null) {
            int n = 0;
            while (n < this.parameters.length) {
                if (this.signature == null) {
                    out = String.valueOf(out) + " " + this.parameters[n];
                } else {
                    switch (this.signature[n]) {
                        case CP8: 
                        case CP16: {
                            ConstantPoolItem cpi = this.method.javaMethod.javaClass.constant_pool.getItemByIndex(this.parameters[n]);
                            out = String.valueOf(out) + " " + cpi.getText();
                            break;
                        }
                        default: {
                            out = String.valueOf(out) + " " + this.parameters[n];
                        }
                    }
                }
                ++n;
            }
        }
        return out;
    }

    public byte[] toByteArray() {
        byte[] output = new byte[this.getLength()];
        ByteBuffer outbuf = ByteBuffer.wrap(output);
        outbuf.rewind();
        outbuf.put((byte)this.opcode);
        if (this.signature != null) {
            int n = 0;
            while (n < this.signature.length) {
                switch (this.signature[n]) {
                    case UBYTE: 
                    case SBYTE: 
                    case CP8: {
                        outbuf.put((byte)this.parameters[n]);
                        break;
                    }
                    case USHORT: 
                    case SSHORT: 
                    case CP16: 
                    case OFFSET16: {
                        outbuf.putShort((short)this.parameters[n]);
                        break;
                    }
                    case UINT: 
                    case SINT: 
                    case OFFSET32: {
                        outbuf.putInt(this.parameters[n]);
                    }
                }
                ++n;
            }
        }
        return output;
    }

    public static void main(String[] args) throws Exception {
        ClassPool pool = new ClassPool();
        pool.addJAR("1.8-mapped.jar");
        String sep = System.getProperty("line.separator");
        JavaClass jc = pool.getClass("net/minecraft/FontRenderer");
        for (JavaField javaField : jc.fields) {
        }
        String newopstring = "  bipush 5\n  pop\n  iload_0\n  new #class:net/minecraft/ResourceLocation\n  dup\n  aload_1\n  invokespecial #methodref:net/minecraft/ResourceLocation/<init>:(Ljava/lang/String;)V\n  aload_2\n  invokestatic #methodref:net/minecraft/Block/registerBlock:(ILnet/minecraft/ResourceLocation;Lnet/minecraft/Block;)V\n  return\n";
        System.out.println("START");
        for (JavaClass jcc : pool.getPool().values()) {
            for (JavaMethod jm : jcc.methods) {
                if (jm.getCodeArray() == null) continue;
                DisassembledMethod dm = new DisassembledMethod(jm);
                String disassembly = dm.toString();
                dm.methodops.clear();
                dm.labels.clear();
                List<Opcode> newcode = null;
                try {
                    newcode = dm.assembleCode(disassembly);
                }
                catch (Exception e) {
                    System.out.println(disassembly);
                    e.printStackTrace();
                    System.out.flush();
                    System.exit(0);
                }
                if (newcode == null) continue;
                dm.methodops = newcode;
                byte[] array = dm.toByteArray();
                jm.setCodeArray(array);
                try {
                    dm = new DisassembledMethod(jm);
                }
                catch (Exception e) {
                    System.out.flush();
                    System.exit(0);
                }
                String disassembly2 = dm.toString();
                byte[] array1 = jm.getCodeArray();
                byte[] array2 = dm.toByteArray();
                boolean binaryMatch = true;
                if (array1 != null && array2 != null) {
                    if (array1.length != array2.length) {
                        binaryMatch = false;
                    } else {
                        int n = 0;
                        while (n < array1.length) {
                            if (array1[n] != array2[n]) {
                                binaryMatch = false;
                                break;
                            }
                            ++n;
                        }
                    }
                }
                if (!binaryMatch) {
                    System.out.println("Method: " + jcc.getClassName() + "/" + jm.getName() + " " + jm.getDescriptor());
                }
                if (disassembly.equals(disassembly2)) continue;
                System.out.println("Method: " + jcc.getClassName() + "/" + jm.getName() + " " + jm.getDescriptor());
                System.out.println(String.valueOf(disassembly) + "\n2:\n" + disassembly2);
                System.out.flush();
                System.exit(0);
            }
        }
        System.out.println("END");
    }

    public static enum EnumType {
        UBYTE,
        SBYTE,
        USHORT,
        SSHORT,
        UINT,
        SINT,
        CP8,
        CP16,
        OFFSET16,
        OFFSET32;

    }
}

