/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.ClassParser.opcodes;

import java.nio.ByteBuffer;
import net.fybertech.ClassParser.DisassembledMethod;
import net.fybertech.ClassParser.opcodes.Opcode;

public class OpWide
extends Opcode {
    public int wideop = 0;

    OpWide(int opcode, String name) {
        super(opcode, name);
    }

    public OpWide(DisassembledMethod jm, Opcode op) {
        super(jm, op);
    }

    @Override
    public Opcode clone(DisassembledMethod jm) {
        return new OpWide(jm, this);
    }

    @Override
    public int readParameters(byte[] codeblock, int startIndex) {
        this.position = startIndex - 1;
        ByteBuffer wrapper = ByteBuffer.wrap(codeblock);
        wrapper.position(startIndex);
        int read = 0;
        this.wideop = wrapper.get() & 0xFF;
        ++read;
        if (this.wideop == Opcode.IINC.getNum()) {
            this.parameters = new int[2];
            this.parameters[0] = wrapper.getShort() & 0xFFFF;
            this.parameters[1] = wrapper.getShort();
            read += 4;
        } else {
            this.parameters = new int[1];
            this.parameters[0] = wrapper.getShort() & 0xFFFF;
            read += 2;
        }
        this.length = read;
        return read;
    }

    @Override
    public int getLength() {
        if (this.wideop == Opcode.IINC.getNum()) {
            return 6;
        }
        return 4;
    }

    @Override
    public String toString() {
        String out = "wide\n";
        String widename = Opcode.getByNum(this.wideop).getName();
        out = String.valueOf(out) + "    " + widename + " " + this.parameters[0];
        if (this.wideop == Opcode.IINC.getNum()) {
            out = String.valueOf(out) + " " + this.parameters[1];
        }
        return out;
    }

    @Override
    public byte[] toByteArray() {
        byte[] output = new byte[this.getLength()];
        ByteBuffer outbuf = ByteBuffer.wrap(output);
        outbuf.rewind();
        outbuf.put((byte)this.opcode);
        outbuf.put((byte)this.wideop);
        outbuf.putShort((short)this.parameters[0]);
        if (this.wideop == Opcode.IINC.getNum()) {
            outbuf.putShort((short)this.parameters[1]);
        }
        return output;
    }
}

