/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.ClassParser.opcodes;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.fybertech.ClassParser.DisassembledMethod;
import net.fybertech.ClassParser.opcodes.Opcode;

public class OpTableswitch
extends Opcode {
    public int defaultLabel = 0;
    public int lowbyte = 0;
    public int highbyte = 0;
    public List<DisassembledMethod.DMLabel> jumpDests = new ArrayList<DisassembledMethod.DMLabel>();
    public DisassembledMethod.DMLabel defaultJump = null;

    public OpTableswitch(DisassembledMethod jm, Opcode op) {
        super(jm, op);
    }

    OpTableswitch(int i, String string) {
        super(i, string);
    }

    @Override
    public Opcode clone(DisassembledMethod jm) {
        return new OpTableswitch(jm, this);
    }

    @Override
    public int readParameters(byte[] codeblock, int startIndex) {
        this.position = startIndex - 1;
        ByteBuffer wrapper = ByteBuffer.wrap(codeblock);
        wrapper.position(startIndex);
        int read = 0;
        int padding = Math.abs(startIndex % 4 - 4);
        if (padding < 4) {
            int n = 0;
            while (n < padding) {
                wrapper.get();
                ++read;
                ++n;
            }
        }
        this.defaultLabel = wrapper.getInt();
        read += 4;
        this.lowbyte = wrapper.getInt();
        read += 4;
        this.highbyte = wrapper.getInt();
        read += 4;
        int total = this.highbyte - this.lowbyte + 1;
        this.parameters = new int[total];
        int n = 0;
        while (n < total) {
            this.parameters[n] = wrapper.getInt();
            read += 4;
            this.labels.add(this.parameters[n] + this.position);
            ++n;
        }
        this.labels.add(this.defaultLabel + this.position);
        this.length = read;
        return read;
    }

    @Override
    public String toString() {
        String out = String.valueOf(this.opname) + " " + this.lowbyte + "\n";
        for (DisassembledMethod.DMLabel label : this.jumpDests) {
            out = String.valueOf(out) + "    " + label.name + "\n";
        }
        out = String.valueOf(out) + "    default: " + this.defaultJump.name;
        return out;
    }

    @Override
    public int getLength() {
        int padpos = this.position + 1;
        int padding = Math.abs(padpos % 4 - 4);
        if (padding == 4) {
            padding = 0;
        }
        this.length = padding + 4 + 4 + 4 + this.jumpDests.size() * 4;
        return 1 + this.length;
    }

    @Override
    public byte[] toByteArray() {
        byte[] output = new byte[this.getLength()];
        ByteBuffer outbuf = ByteBuffer.wrap(output);
        outbuf.rewind();
        outbuf.put((byte)this.opcode);
        int padding = Math.abs((this.position + 1) % 4 - 4);
        if (padding < 4) {
            int n = 0;
            while (n < padding) {
                outbuf.put((byte)0);
                ++n;
            }
        }
        outbuf.putInt(this.defaultJump.op.position - this.position);
        outbuf.putInt(this.lowbyte);
        outbuf.putInt(this.highbyte);
        int total = this.highbyte - this.lowbyte + 1;
        int n = 0;
        while (n < total) {
            int dest = this.jumpDests.get((int)n).op.position - this.position;
            outbuf.putInt(dest);
            ++n;
        }
        return output;
    }
}

