/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.ClassParser;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.fybertech.ClassParser.AttributeInfo;
import net.fybertech.ClassParser.JavaClass;

public class JavaMethod {
    public int access_flags;
    public int name_index;
    public int descriptor_index;
    public List<AttributeInfo> attributes = new ArrayList<AttributeInfo>();
    public JavaClass javaClass;

    public JavaMethod(JavaClass jc, DataInputStream dis) throws IOException {
        this.javaClass = jc;
        this.access_flags = dis.readUnsignedShort();
        this.name_index = dis.readUnsignedShort();
        this.descriptor_index = dis.readUnsignedShort();
        int attributes_count = dis.readUnsignedShort();
        int n = 0;
        while (n < attributes_count) {
            this.attributes.add(new AttributeInfo(this.javaClass, dis));
            ++n;
        }
    }

    public void writeMethod(DataOutputStream dos) throws IOException {
        dos.writeShort(this.access_flags);
        dos.writeShort(this.name_index);
        dos.writeShort(this.descriptor_index);
        dos.writeShort((short)this.attributes.size());
        for (AttributeInfo ai : this.attributes) {
            ai.writeAttribute(dos);
        }
    }

    public String getName() {
        return this.javaClass.getConstantUTF(this.name_index);
    }

    public String getDescriptor() {
        return this.javaClass.getConstantUTF(this.descriptor_index);
    }

    public String toString() {
        return String.valueOf(this.javaClass.getClassName()) + "." + this.getName() + " " + this.getDescriptor();
    }

    public byte[] getCodeArray() {
        int attributes_count = this.attributes.size();
        int n = 0;
        while (n < attributes_count) {
            if (this.javaClass.getConstantUTF(this.attributes.get((int)n).attribute_name_index).equals("Code")) {
                return this.attributes.get((int)n).info;
            }
            ++n;
        }
        return null;
    }

    public void setCodeArray(byte[] codeArray) {
        int attributes_count = this.attributes.size();
        int n = 0;
        while (n < attributes_count) {
            if (this.javaClass.getConstantUTF(this.attributes.get((int)n).attribute_name_index).equals("Code")) {
                this.attributes.get((int)n).info = codeArray;
                this.attributes.get((int)n).attribute_length = codeArray.length;
                return;
            }
            ++n;
        }
        System.out.println("Error: Code attribute not found when adding code array!");
    }
}

