/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.ClassParser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.fybertech.ClassParser.AttributeInfo;
import net.fybertech.ClassParser.ConstantPool;
import net.fybertech.ClassParser.JavaField;
import net.fybertech.ClassParser.JavaMethod;

public class JavaClass
implements Cloneable {
    public int magic;
    public int minor_version;
    public int major_version;
    public ConstantPool constant_pool;
    public int access_flags;
    public int this_class;
    public int super_class;
    public int interfaces_count;
    public int[] interfaces;
    public List<JavaField> fields = new ArrayList<JavaField>();
    public List<JavaMethod> methods = new ArrayList<JavaMethod>();
    public List<AttributeInfo> attributes = new ArrayList<AttributeInfo>();

    public JavaClass(DataInputStream dis) throws IOException {
        this.readClass(dis);
    }

    public JavaClass(String classfilename) throws IOException {
        FileInputStream classfile = new FileInputStream(classfilename);
        DataInputStream classfiledata = new DataInputStream(classfile);
        this.readClass(classfiledata);
        classfiledata.close();
    }

    public void readClass(DataInputStream dis) throws IOException {
        this.magic = dis.readInt();
        this.minor_version = dis.readUnsignedShort();
        this.major_version = dis.readUnsignedShort();
        this.constant_pool = new ConstantPool(this, dis);
        this.access_flags = dis.readUnsignedShort();
        this.this_class = dis.readUnsignedShort();
        this.super_class = dis.readUnsignedShort();
        this.interfaces_count = dis.readUnsignedShort();
        this.interfaces = new int[this.interfaces_count];
        int n = 0;
        while (n < this.interfaces_count) {
            this.interfaces[n] = dis.readUnsignedShort();
            ++n;
        }
        int fields_count = dis.readUnsignedShort();
        int n2 = 0;
        while (n2 < fields_count) {
            this.fields.add(new JavaField(this, dis));
            ++n2;
        }
        int methods_count = dis.readUnsignedShort();
        int n3 = 0;
        while (n3 < methods_count) {
            this.methods.add(new JavaMethod(this, dis));
            ++n3;
        }
        int attributes_count = dis.readUnsignedShort();
        int n4 = 0;
        while (n4 < attributes_count) {
            this.attributes.add(new AttributeInfo(this, dis));
            ++n4;
        }
    }

    public void writeClass(DataOutputStream dos) throws IOException {
        dos.writeInt(this.magic);
        dos.writeShort(this.minor_version);
        dos.writeShort(this.major_version);
        this.constant_pool.writePool(dos);
        dos.writeShort(this.access_flags);
        dos.writeShort(this.this_class);
        dos.writeShort(this.super_class);
        dos.writeShort(this.interfaces_count);
        int n = 0;
        while (n < this.interfaces_count) {
            dos.writeShort(this.interfaces[n]);
            ++n;
        }
        dos.writeShort((short)this.fields.size());
        for (JavaField jf : this.fields) {
            jf.writeField(dos);
        }
        dos.writeShort((short)this.methods.size());
        for (JavaMethod jm : this.methods) {
            jm.writeMethod(dos);
        }
        dos.writeShort((short)this.attributes.size());
        for (AttributeInfo ai : this.attributes) {
            ai.writeAttribute(dos);
        }
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeClass(new DataOutputStream(baos));
            return baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeClass(String filename) throws IOException {
        Path path = Paths.get(filename, new String[0]).getParent();
        path.toFile().mkdirs();
        DataOutputStream classoutfile = new DataOutputStream(new FileOutputStream(filename));
        this.writeClass(classoutfile);
        classoutfile.close();
    }

    public String getConstantUTF(int index) {
        return (String)this.constant_pool.getItemByIndex(index).getData();
    }

    public int getConstantInt(int index) {
        return (Integer)this.constant_pool.getItemByIndex(index).getData();
    }

    public boolean getConstantBoolean(int index) {
        return (Integer)this.constant_pool.getItemByIndex(index).getData() == 1;
    }

    public String getConstantUTFIndirect(int index) {
        return (String)this.constant_pool.getItemByIndex(this.getConstantInt(index)).getData();
    }

    public String getClassName() {
        return this.getConstantUTFIndirect(this.this_class);
    }

    public String getSuperClassName() {
        return this.getConstantUTFIndirect(this.super_class);
    }

    public byte[] getCodeArray(JavaMethod jm) {
        int attributes_count = jm.attributes.size();
        int n = 0;
        while (n < attributes_count) {
            if (this.getConstantUTF(jm.attributes.get((int)n).attribute_name_index).equals("Code")) {
                return jm.attributes.get((int)n).info;
            }
            ++n;
        }
        return null;
    }

    public JavaMethod findMethod(String mname, String mdesc) {
        for (JavaMethod jm : this.methods) {
            if (!jm.getName().equals(mname) || !jm.getDescriptor().equals(mdesc)) continue;
            return jm;
        }
        return null;
    }

    public JavaField findField(String mname, String mdesc) {
        for (JavaField jf : this.fields) {
            if (!jf.getName().equals(mname) || !jf.getDescriptor().equals(mdesc)) continue;
            return jf;
        }
        return null;
    }

    public String getConstantClassNameType(int fieldid) {
        int[] data = (int[])this.constant_pool.getItemByIndex(fieldid).getData();
        int class_index = data[0];
        int name_and_type_index = data[1];
        int[] nandt = (int[])this.constant_pool.getItemByIndex(name_and_type_index).getData();
        return String.valueOf(this.getConstantUTFIndirect(class_index)) + "." + this.getConstantUTF(nandt[0]) + " " + this.getConstantUTF(nandt[1]);
    }

    public JavaClass clone() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            this.writeClass(dos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream dis = new DataInputStream(bais);
        JavaClass jc = null;
        try {
            jc = new JavaClass(dis);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jc;
    }
}

