/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.ClassParser;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.fybertech.ClassParser.AttributeInfo;
import net.fybertech.ClassParser.ConstantPool;
import net.fybertech.ClassParser.ConstantPoolItem;
import net.fybertech.ClassParser.JavaMethod;
import net.fybertech.ClassParser.opcodes.OpJump;
import net.fybertech.ClassParser.opcodes.OpLookupswitch;
import net.fybertech.ClassParser.opcodes.OpTableswitch;
import net.fybertech.ClassParser.opcodes.OpWide;
import net.fybertech.ClassParser.opcodes.Opcode;

public class DisassembledMethod {
    int max_stack;
    int max_locals;
    int code_length;
    public List<Opcode> methodops = new ArrayList<Opcode>();
    public LabelHolder labels = new LabelHolder();
    public final JavaMethod javaMethod;
    public List<DMException> exceptions = new ArrayList<DMException>();
    public List<AttributeInfo> attributes = new ArrayList<AttributeInfo>();

    public Opcode getOpcodeBefore(int pos) {
        Opcode lastOp = null;
        for (Opcode op : this.methodops) {
            if (op.position >= pos) break;
            lastOp = op;
        }
        return lastOp;
    }

    public DisassembledMethod(JavaMethod jm) {
        this.javaMethod = jm;
        byte[] codearray = this.javaMethod.getCodeArray();
        if (codearray == null) {
            return;
        }
        ByteBuffer outerbuffer = ByteBuffer.wrap(codearray);
        outerbuffer.rewind();
        this.max_stack = outerbuffer.getShort();
        this.max_locals = outerbuffer.getShort();
        this.code_length = outerbuffer.getInt();
        byte[] code = Arrays.copyOfRange(codearray, 8, 8 + this.code_length);
        int pos = 0;
        ArrayList<Integer> methodlabels = new ArrayList<Integer>();
        while (pos < code.length) {
            int opcode = code[pos++] & 0xFF;
            Opcode op = Opcode.getByNum(opcode).clone(this);
            int read = op.readParameters(code, pos);
            pos += read;
            this.methodops.add(op);
            methodlabels.addAll(op.labels);
        }
        for (Opcode op : this.methodops) {
            int n;
            Opcode defaultJump;
            if (op instanceof OpJump) {
                OpJump oj = (OpJump)op;
                Opcode jumpDest = this.getOpcodeAtPos(oj.position + oj.parameters[0]);
                oj.jumpDest = this.labels.findOrAddNew(jumpDest);
                continue;
            }
            if (op instanceof OpTableswitch) {
                OpTableswitch ots = (OpTableswitch)op;
                defaultJump = this.getOpcodeAtPos(ots.defaultLabel + ots.position);
                ots.defaultJump = this.labels.findOrAddNew(defaultJump);
                n = 0;
                while (n < ots.parameters.length) {
                    Opcode jump = this.getOpcodeAtPos(ots.parameters[n] + ots.position);
                    ots.jumpDests.add(this.labels.findOrAddNew(jump));
                    ++n;
                }
                continue;
            }
            if (!(op instanceof OpLookupswitch)) continue;
            OpLookupswitch ols = (OpLookupswitch)op;
            defaultJump = this.getOpcodeAtPos(ols.defaultLabel + ols.position);
            ols.defaultJump = this.labels.findOrAddNew(defaultJump);
            n = 0;
            while (n < ols.parameters.length) {
                int id = ols.parameters[n++];
                Opcode jump = this.getOpcodeAtPos(ols.parameters[n] + ols.position);
                ols.jumpKeys.add(id);
                ols.jumpDests.add(this.labels.findOrAddNew(jump));
                ++n;
            }
        }
        outerbuffer.position(8 + this.code_length);
        int exception_count = outerbuffer.getShort();
        int n = 0;
        while (n < exception_count) {
            DMException dme = new DMException();
            dme.num = n;
            int start_pc = outerbuffer.getShort() & 0xFFFF;
            int end_pc = outerbuffer.getShort() & 0xFFFF;
            int handler_pc = outerbuffer.getShort() & 0xFFFF;
            dme.catch_type = outerbuffer.getShort() & 0xFFFF;
            dme.start = this.getOpcodeAtPos(start_pc);
            dme.end = this.getOpcodeBefore(end_pc);
            dme.handler = this.getOpcodeAtPos(handler_pc);
            this.exceptions.add(dme);
            ++n;
        }
        int attribute_count = outerbuffer.getShort();
        int n2 = 0;
        while (n2 < attribute_count) {
            AttributeInfo ai = new AttributeInfo(this.javaMethod.javaClass);
            ai.attribute_name_index = outerbuffer.getShort() & 0xFFFF;
            ai.attribute_length = outerbuffer.getInt();
            byte[] infoArray = new byte[ai.attribute_length];
            outerbuffer.get(infoArray);
            ai.info = infoArray;
            this.attributes.add(ai);
            ++n2;
        }
    }

    public Opcode getOpcodeAtPos(int pos) {
        for (Opcode op : this.methodops) {
            if (op.position != pos) continue;
            return op;
        }
        return null;
    }

    public void recalculatePositions() {
        int pos = 0;
        for (Opcode op : this.methodops) {
            op.position = pos;
            pos += op.getLength();
        }
    }

    public String toString() {
        String output = "";
        for (Opcode op : this.methodops) {
            String line = "";
            String finalline = "";
            for (DMException dme : this.exceptions) {
                if (dme.start == op) {
                    line = String.valueOf(line) + "[exception:" + dme.num + ":begin:" + (dme.catch_type != 0 ? this.javaMethod.javaClass.getConstantUTFIndirect(dme.catch_type) : "") + "]\n";
                }
                if (dme.handler == op) {
                    line = String.valueOf(line) + "[exception:" + dme.num + ":handler]\n";
                }
                if (dme.end != op) continue;
                finalline = "[exception:" + dme.num + ":end]\n";
            }
            DMLabel lab = this.labels.findByOp(op);
            if (lab != null) {
                line = String.valueOf(line) + lab.name + ":\n";
            }
            line = String.valueOf(line) + "  " + op.toString() + "\n";
            output = String.valueOf(output) + line + finalline;
        }
        return output;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DataOutputStream dOut = new DataOutputStream(bOut);
        ArrayList<byte[]> rawops = new ArrayList<byte[]>();
        this.recalculatePositions();
        this.code_length = 0;
        for (Opcode op : this.methodops) {
            byte[] ca2 = op.toByteArray();
            rawops.add(ca2);
            this.code_length += ca2.length;
        }
        try {
            dOut.writeShort(this.max_stack);
            dOut.writeShort(this.max_locals);
            dOut.writeInt(this.code_length);
            for (byte[] rop : rawops) {
                dOut.write(rop);
            }
            dOut.writeShort(this.exceptions.size());
            for (DMException dme : this.exceptions) {
                dOut.writeShort(dme.start.position);
                dOut.writeShort(dme.end.position + dme.end.getLength());
                dOut.writeShort(dme.handler.position);
                dOut.writeShort(dme.catch_type);
            }
            dOut.writeShort(this.attributes.size());
            for (AttributeInfo ai : this.attributes) {
                ai.writeAttribute(dOut);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bOut.toByteArray();
    }

    private List<String> splitOpParms(String parmString, char splitChar) {
        ArrayList<String> parms = new ArrayList<String>();
        String currentParm = "";
        boolean inString = false;
        boolean isEscaping = false;
        while (parmString.length() > 0) {
            char currentChar = parmString.charAt(0);
            parmString = parmString.substring(1);
            if (currentChar == splitChar && !inString) {
                if (currentParm.length() > 0) {
                    parms.add(currentParm);
                }
                currentParm = "";
                continue;
            }
            currentParm = String.valueOf(currentParm) + currentChar;
            if (!inString && currentChar == '\"') {
                inString = true;
                continue;
            }
            if (inString && !isEscaping && currentChar == '\"') {
                inString = false;
                isEscaping = false;
                continue;
            }
            isEscaping = inString && currentChar == '\\';
        }
        if (currentParm.length() > 0) {
            parms.add(currentParm);
        }
        return parms;
    }

    public static String removeOuterQuotes(String s) {
        return s.substring(1, s.length() - 1);
    }

    public static String escapeString(String s) {
        String output = "";
        try {
            output = DisassembledMethod.removeOuterQuotes(s.replace("\\n", "\\\\n"));
        }
        catch (Exception e) {
            System.out.println("TRIED TO DO: " + s);
        }
        return output;
    }

    public static String unescapeString(String s) {
        String output = "";
        boolean isEscaping = false;
        while (s.length() > 0) {
            char c = s.charAt(0);
            if (isEscaping) {
                char lowc = Character.toLowerCase(c);
                if (lowc == 'n') {
                    c = '\n';
                } else if (lowc == 'r') {
                    c = '\r';
                } else if (lowc == 't') {
                    c = '\t';
                }
                output = String.valueOf(output) + c;
                isEscaping = false;
            } else if (c == '\\') {
                isEscaping = true;
            } else {
                output = String.valueOf(output) + c;
            }
            s = s.substring(1);
        }
        return output;
    }

    public int parseConstantPoolEntry(String entry) {
        List<String> parms = this.splitOpParms(entry, ':');
        String cpType = parms.get(0).toLowerCase();
        ConstantPoolItem cpItem = null;
        ConstantPool pool = this.javaMethod.javaClass.constant_pool;
        if (cpType.equals("#class")) {
            cpItem = pool.findOrCreateClass(parms.get(1));
        } else if (cpType.equals("#string")) {
            cpItem = pool.findOrCreateString(DisassembledMethod.unescapeString(DisassembledMethod.removeOuterQuotes(parms.get(1))));
        } else if (cpType.equals("#fieldref")) {
            cpItem = pool.findOrCreateRef(9, parms.get(1), parms.get(2));
        } else if (cpType.equals("#methodref")) {
            cpItem = pool.findOrCreateRef(10, parms.get(1), parms.get(2));
        } else if (cpType.equals("#interfacemethodref")) {
            cpItem = pool.findOrCreateRef(11, parms.get(1), parms.get(2));
        } else if (cpType.equals("#integer")) {
            cpItem = pool.findOrCreateInteger(Integer.parseInt(parms.get(1)));
        } else if (cpType.equals("#float")) {
            cpItem = pool.findOrCreateFloat(Float.parseFloat(parms.get(1)));
        } else if (cpType.equals("#long")) {
            cpItem = pool.findOrCreateLong(Long.parseLong(parms.get(1)));
        } else if (cpType.equals("#double")) {
            cpItem = pool.findOrCreateDouble(Double.parseDouble(parms.get(1)));
        } else if (cpType.equals("#utf")) {
            cpItem = pool.findOrCreateUTF(DisassembledMethod.unescapeString(DisassembledMethod.removeOuterQuotes(parms.get(1))));
        } else if (cpType.equals("#nameandtype")) {
            cpItem = pool.findOrCreateNameAndType(parms.get(1), parms.get(2));
        } else {
            System.out.println(" Unhandled constant pool type: " + cpType);
        }
        return cpItem == null ? 0 : cpItem.getIndex();
    }

    public DMException findExceptionByNum(int n) {
        for (DMException e : this.exceptions) {
            if (e.num != n) continue;
            return e;
        }
        return null;
    }

    public boolean insertBefore(Opcode startOp, String opString) {
        List<Opcode> newCode = null;
        try {
            newCode = this.assembleCode(opString);
        }
        catch (Exception e) {
            System.out.println("ASSEMBLE ERROR: " + e.toString());
            return false;
        }
        if (newCode == null || newCode.size() < 1) {
            return false;
        }
        this.methodops.addAll(this.methodops.indexOf(startOp), newCode);
        Opcode newStart = newCode.get(0);
        for (DMLabel label : this.labels.labels) {
            if (label.op != startOp) continue;
            label.op = newStart;
        }
        for (DMException exception : this.exceptions) {
            if (exception.start == startOp) {
                exception.start = newStart;
            }
            if (exception.handler != startOp) continue;
            exception.handler = newStart;
        }
        return true;
    }

    public boolean insertAfter(Opcode startOp, String opString) {
        List<Opcode> newCode = null;
        try {
            newCode = this.assembleCode(opString);
        }
        catch (Exception e) {
            return false;
        }
        if (newCode == null || newCode.size() < 1) {
            return false;
        }
        this.methodops.addAll(this.methodops.indexOf(startOp) + 1, newCode);
        return true;
    }

    public List<Opcode> assembleCode(String opString) throws Exception {
        ConstantPool cp = this.javaMethod.javaClass.constant_pool;
        ArrayList<Opcode> newops = new ArrayList<Opcode>();
        ArrayList<String> nextLabels = new ArrayList<String>();
        boolean inLookupSwitch = false;
        boolean inTableSwitch = false;
        boolean inWide = false;
        Opcode tempOp = null;
        Opcode lastOp = null;
        HashMap fixLabels = new HashMap();
        ArrayList<DMException> exceptionsBegin = new ArrayList<DMException>();
        ArrayList<DMException> exceptionsHandler = new ArrayList<DMException>();
        String[] opLines = opString.split("\n");
        int n = 0;
        while (n < opLines.length) {
            block38: {
                String opName;
                Opcode op;
                Object split;
                String currentLine;
                block42: {
                    block41: {
                        Opcode opswitch;
                        block40: {
                            block39: {
                                String exType;
                                currentLine = opLines[n].trim();
                                if (currentLine.length() < 1) break block38;
                                if (!currentLine.startsWith("[exception:") || !currentLine.endsWith("]")) break block39;
                                split = this.splitOpParms(currentLine = currentLine.substring(1, currentLine.length() - 1), ':');
                                int exceptionNum = Integer.parseInt((String)split.get(1));
                                DMException thisException = this.findExceptionByNum(exceptionNum);
                                if (thisException == null) {
                                    thisException = new DMException();
                                    thisException.num = exceptionNum;
                                }
                                if ((exType = ((String)split.get(2)).toLowerCase()).equals("begin")) {
                                    String classname = split.size() >= 4 ? (String)split.get(3) : null;
                                    thisException.catch_type = classname == null || classname.length() < 1 ? 0 : this.javaMethod.javaClass.constant_pool.findOrCreateClass(classname).getIndex();
                                    exceptionsBegin.add(thisException);
                                } else if (exType.equals("end")) {
                                    thisException.end = lastOp;
                                } else if (exType.equals("handler")) {
                                    exceptionsHandler.add(thisException);
                                }
                                break block38;
                            }
                            if (!inLookupSwitch) break block40;
                            opswitch = (OpLookupswitch)tempOp;
                            String[] split2 = currentLine.split(":");
                            if (split2[0].trim().toLowerCase().equals("default")) {
                                String defaultLabel = split2[1].trim();
                                ((List)fixLabels.get(tempOp)).add(defaultLabel);
                                inLookupSwitch = false;
                                newops.add(tempOp);
                                tempOp = null;
                            } else {
                                int val = Integer.parseInt(split2[0]);
                                String label = split2[1].trim();
                                opswitch.jumpKeys.add(val);
                                ((List)fixLabels.get(tempOp)).add(label);
                            }
                            break block38;
                        }
                        if (!inTableSwitch) break block41;
                        opswitch = (OpTableswitch)tempOp;
                        String[] split3 = currentLine.split(":");
                        if (split3[0].trim().toLowerCase().equals("default")) {
                            String defaultLabel = split3[1].trim();
                            ((List)fixLabels.get(tempOp)).add(defaultLabel);
                            inTableSwitch = false;
                            newops.add(tempOp);
                            tempOp = null;
                        } else {
                            ((List)fixLabels.get(tempOp)).add(currentLine);
                        }
                        break block38;
                    }
                    split = currentLine.split(" ");
                    if (!split[0].endsWith(":")) break block42;
                    nextLabels.add(split[0].substring(0, ((String)split[0]).length() - 1));
                    if (((Object)split).length == 1) break block38;
                    currentLine = currentLine.substring(((String)split[0]).length());
                    split = currentLine.split(" ");
                }
                if ((op = Opcode.getByName(opName = split[0].toLowerCase())) == null) {
                    throw new Exception("Unknown opcode: " + opName + " " + currentLine);
                }
                op = op.clone(this);
                if (!inWide) {
                    lastOp = op;
                    for (DMException e : exceptionsBegin) {
                        e.start = op;
                    }
                    for (DMException e : exceptionsHandler) {
                        e.handler = op;
                    }
                    exceptionsBegin.clear();
                    exceptionsHandler.clear();
                }
                List<String> parms = this.splitOpParms(currentLine.substring(((String)split[0]).length()).trim(), ' ');
                if (op.opcode == Opcode.LOOKUPSWITCH.opcode) {
                    inLookupSwitch = true;
                    tempOp = op;
                    fixLabels.put(op, new ArrayList());
                } else if (op.opcode == Opcode.TABLESWITCH.opcode) {
                    int lowVal;
                    OpTableswitch optable = (OpTableswitch)op;
                    optable.lowbyte = lowVal = Integer.parseInt(parms.get(0));
                    inTableSwitch = true;
                    tempOp = op;
                    fixLabels.put(op, new ArrayList());
                } else {
                    if (op.signature.length != parms.size()) {
                        System.out.println("INVALID PARM COUNT");
                    }
                    op.parameters = new int[op.signature.length];
                    int parmnum = 0;
                    while (parmnum < op.signature.length) {
                        int result = 0;
                        String thisParm = parms.get(parmnum);
                        if (op.signature[parmnum] == Opcode.EnumType.OFFSET16 || op.signature[parmnum] == Opcode.EnumType.OFFSET32) {
                            ArrayList<String> labellist = new ArrayList<String>();
                            labellist.add(thisParm);
                            fixLabels.put(op, labellist);
                        } else {
                            result = thisParm.startsWith("#") ? this.parseConstantPoolEntry(thisParm) : Integer.parseInt(thisParm);
                        }
                        op.parameters[parmnum] = result;
                        ++parmnum;
                    }
                    if (inWide) {
                        inWide = false;
                        OpWide wide = (OpWide)tempOp;
                        wide.wideop = op.opcode;
                        wide.parameters = op.parameters;
                    } else {
                        if (op.opcode == Opcode.WIDE.opcode) {
                            inWide = true;
                            tempOp = op;
                        }
                        for (String s : nextLabels) {
                            this.labels.add(op, s);
                        }
                        nextLabels.clear();
                        newops.add(op);
                    }
                }
            }
            ++n;
        }
        if (nextLabels.size() > 0) {
            Opcode op = Opcode.NOP.clone(this);
            newops.add(op);
            for (String s : nextLabels) {
                this.labels.add(op, s);
            }
        }
        for (Opcode op : fixLabels.keySet()) {
            List labelList = (List)fixLabels.get(op);
            if (op instanceof OpTableswitch) {
                OpTableswitch optable = (OpTableswitch)op;
                int n2 = 0;
                while (n2 < labelList.size() - 1) {
                    optable.jumpDests.add(this.labels.findByName((String)labelList.get(n2)));
                    ++n2;
                }
                optable.highbyte = optable.lowbyte + optable.jumpDests.size() - 1;
                optable.defaultJump = this.labels.findByName((String)labelList.get(labelList.size() - 1));
                continue;
            }
            if (op instanceof OpLookupswitch) {
                OpLookupswitch opswitch = (OpLookupswitch)op;
                int n3 = 0;
                while (n3 < labelList.size() - 1) {
                    opswitch.jumpDests.add(this.labels.findByName((String)labelList.get(n3)));
                    ++n3;
                }
                opswitch.defaultJump = this.labels.findByName((String)labelList.get(labelList.size() - 1));
                continue;
            }
            if (!(op instanceof OpJump)) continue;
            OpJump opjump = (OpJump)op;
            opjump.jumpDest = this.labels.findByName((String)labelList.get(0));
        }
        return newops;
    }

    public class DMException {
        int num;
        int catch_type;
        Opcode start;
        Opcode end;
        Opcode handler;
    }

    public class DMLabel {
        public Opcode op = null;
        public String name = null;
        public int position = -1;
    }

    public class LabelHolder {
        public List<DMLabel> labels = new ArrayList<DMLabel>();

        public DMLabel findbyPos(int pos) {
            for (DMLabel l2 : this.labels) {
                if (l2.position != pos) continue;
                return l2;
            }
            return null;
        }

        public DMLabel findByOp(Opcode opcode) {
            for (DMLabel l2 : this.labels) {
                if (l2.op != opcode) continue;
                return l2;
            }
            return null;
        }

        public DMLabel findByName(String name) {
            for (DMLabel l2 : this.labels) {
                if (!l2.name.equals(name)) continue;
                return l2;
            }
            return null;
        }

        public DMLabel add(Opcode op, String name) {
            DMLabel newlabel = new DMLabel();
            newlabel.op = op;
            newlabel.name = name;
            newlabel.position = op.position;
            this.labels.add(newlabel);
            return newlabel;
        }

        public DMLabel add(Opcode op) {
            DMLabel newlabel = new DMLabel();
            newlabel.op = op;
            newlabel.name = "label_" + (this.labels.size() + 1);
            newlabel.position = op.position;
            this.labels.add(newlabel);
            return newlabel;
        }

        public void clear() {
            this.labels.clear();
        }

        public DMLabel findOrAddNew(Opcode op) {
            DMLabel label = this.findByOp(op);
            if (label != null) {
                return label;
            }
            return this.add(op);
        }
    }
}

