/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.ClassParser;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.fybertech.ClassParser.JavaClass;

public class ConstantPoolItem {
    public int ctype;
    public int index;
    public Object data;
    public JavaClass javaClass;

    public ConstantPoolItem(JavaClass jc, int ct, int idx) {
        this.javaClass = jc;
        this.ctype = ct;
        this.index = idx;
    }

    public ConstantPoolItem(JavaClass jc, int i, DataInputStream dis) throws IOException {
        this.javaClass = jc;
        this.index = i;
        this.ctype = dis.readUnsignedByte();
        switch (this.ctype) {
            case 7: {
                this.setData(dis.readUnsignedShort());
                break;
            }
            case 9: {
                this.setData(new int[]{dis.readUnsignedShort(), dis.readUnsignedShort()});
                break;
            }
            case 10: {
                this.setData(new int[]{dis.readUnsignedShort(), dis.readUnsignedShort()});
                break;
            }
            case 11: {
                this.setData(new int[]{dis.readUnsignedShort(), dis.readUnsignedShort()});
                break;
            }
            case 8: {
                this.setData(dis.readUnsignedShort());
                break;
            }
            case 3: {
                this.setData(dis.readInt());
                break;
            }
            case 4: {
                this.setData(Float.valueOf(dis.readFloat()));
                break;
            }
            case 5: {
                this.setData(dis.readLong());
                break;
            }
            case 6: {
                this.setData(dis.readDouble());
                break;
            }
            case 12: {
                this.setData(new int[]{dis.readUnsignedShort(), dis.readUnsignedShort()});
                break;
            }
            case 1: {
                this.setData(dis.readUTF());
                break;
            }
            case 15: {
                this.setData(new int[]{dis.readUnsignedByte(), dis.readUnsignedShort()});
                break;
            }
            case 16: {
                this.setData(dis.readUnsignedShort());
                break;
            }
            case 18: {
                this.setData(new int[]{dis.readUnsignedShort(), dis.readUnsignedShort()});
            }
        }
    }

    public void writeItem(DataOutputStream dos) throws IOException {
        dos.writeByte(this.ctype);
        switch (this.ctype) {
            case 7: {
                dos.writeShort((Integer)this.getData());
                break;
            }
            case 9: {
                dos.writeShort(((int[])this.getData())[0]);
                dos.writeShort(((int[])this.getData())[1]);
                break;
            }
            case 10: {
                dos.writeShort(((int[])this.getData())[0]);
                dos.writeShort(((int[])this.getData())[1]);
                break;
            }
            case 11: {
                dos.writeShort(((int[])this.getData())[0]);
                dos.writeShort(((int[])this.getData())[1]);
                break;
            }
            case 8: {
                dos.writeShort((Integer)this.getData());
                break;
            }
            case 3: {
                dos.writeInt((Integer)this.getData());
                break;
            }
            case 4: {
                dos.writeFloat(((Float)this.getData()).floatValue());
                break;
            }
            case 5: {
                dos.writeLong((Long)this.getData());
                break;
            }
            case 6: {
                dos.writeDouble((Double)this.getData());
                break;
            }
            case 12: {
                dos.writeShort(((int[])this.getData())[0]);
                dos.writeShort(((int[])this.getData())[1]);
                break;
            }
            case 1: {
                dos.writeUTF((String)this.getData());
                break;
            }
            case 15: {
                dos.writeByte(((int[])this.getData())[0]);
                dos.writeShort(((int[])this.getData())[1]);
                break;
            }
            case 16: {
                dos.writeShort((Integer)this.getData());
                break;
            }
            case 18: {
                dos.writeShort(((int[])this.getData())[0]);
                dos.writeShort(((int[])this.getData())[1]);
            }
        }
    }

    public int getType() {
        return this.ctype;
    }

    public int getIndex() {
        return this.index;
    }

    public void setData(Object o) {
        this.data = o;
    }

    public Object getData() {
        return this.data;
    }

    public String toString() {
        switch (this.ctype) {
            case 7: {
                return "CONSTANT_Class";
            }
            case 9: {
                return "CONSTANT_Fieldref";
            }
            case 10: {
                return "CONSTANT_Methodref";
            }
            case 11: {
                return "CONSTANT_InterfaceMethodref";
            }
            case 8: {
                return "CONSTANT_String";
            }
            case 3: {
                return "CONSTANT_Integer";
            }
            case 4: {
                return "CONSTANT_Float";
            }
            case 5: {
                return "CONSTANT_Long";
            }
            case 6: {
                return "CONSTANT_Double";
            }
            case 12: {
                return "CONSTANT_NameAndType";
            }
            case 1: {
                return "CONSTANT_Utf8";
            }
            case 15: {
                return "CONSTANT_MethodHandle";
            }
            case 16: {
                return "CONSTANT_MethodType";
            }
            case 18: {
                return "CONSTANT_InvokeDynamic";
            }
        }
        return "CONSTANT_UNKNOWN";
    }

    public static String escapeString(String s) {
        String output = "";
        while (s.length() > 0) {
            char c = s.charAt(0);
            output = c == '\n' ? String.valueOf(output) + "\\n" : (c == '\r' ? String.valueOf(output) + "\\r" : (c == '\"' ? String.valueOf(output) + "\\\"" : (c == '\t' ? String.valueOf(output) + "\\t" : (c == '\\' ? String.valueOf(output) + "\\\\" : String.valueOf(output) + c))));
            s = s.substring(1);
        }
        return output;
    }

    public String getText() {
        String out = "";
        switch (this.ctype) {
            case 7: {
                return "#class:" + this.javaClass.getConstantUTF((Integer)this.data);
            }
            case 8: {
                return "#string:\"" + ConstantPoolItem.escapeString(this.javaClass.getConstantUTF((Integer)this.data)) + "\"";
            }
            case 9: 
            case 10: 
            case 11: {
                if (this.ctype == 9) {
                    out = "#fieldref:";
                } else if (this.ctype == 10) {
                    out = "#methodref:";
                } else if (this.ctype == 11) {
                    out = "#interfacemethodref:";
                }
                int[] dataarray = (int[])this.data;
                out = String.valueOf(out) + this.javaClass.getConstantUTFIndirect(dataarray[0]);
                int[] dataarray2 = (int[])this.javaClass.constant_pool.getItemByIndex((int)dataarray[1]).data;
                out = String.valueOf(out) + "/" + this.javaClass.getConstantUTF(dataarray2[0]);
                out = String.valueOf(out) + ":" + this.javaClass.getConstantUTF(dataarray2[1]);
                return out;
            }
            case 3: {
                return "#integer:" + (Integer)this.data;
            }
            case 4: {
                return "#float:" + (Float)this.data;
            }
            case 5: {
                return "#long:" + (Long)this.data;
            }
            case 6: {
                return "#double:" + (Double)this.data;
            }
            case 1: {
                return "#utf:\"" + ConstantPoolItem.escapeString((String)this.data) + "\"";
            }
            case 12: {
                int[] dataarray = (int[])this.data;
                return "#nameandtype:" + this.javaClass.getConstantUTF(dataarray[0]) + ":" + this.javaClass.getConstantUTF(dataarray[1]);
            }
            case 15: {
                return "CONSTANT_MethodHandle UNIMPLEMENTED";
            }
            case 16: {
                return "CONSTANT_MethodType UNIMPLEMENTED";
            }
            case 18: {
                return "CONSTANT_InvokeDynamic UNIMPLEMENTED";
            }
        }
        return this.toString();
    }

    public String getRawText() {
        String out = "";
        switch (this.ctype) {
            case 7: {
                return this.javaClass.getConstantUTF((Integer)this.data);
            }
            case 8: {
                return "\"" + this.javaClass.getConstantUTF((Integer)this.data).replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
            }
            case 9: 
            case 10: 
            case 11: {
                int[] dataarray = (int[])this.data;
                out = String.valueOf(out) + this.javaClass.getConstantUTFIndirect(dataarray[0]);
                int[] dataarray2 = (int[])this.javaClass.constant_pool.getItemByIndex((int)dataarray[1]).data;
                out = String.valueOf(out) + "/" + this.javaClass.getConstantUTF(dataarray2[0]);
                out = String.valueOf(out) + ":" + this.javaClass.getConstantUTF(dataarray2[1]);
                return out;
            }
            case 3: {
                return "" + (Integer)this.data;
            }
            case 4: {
                return "" + (Float)this.data;
            }
            case 5: {
                return "" + (Long)this.data;
            }
            case 6: {
                return "" + (Double)this.data;
            }
            case 1: {
                return "\"" + ((String)this.data).replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
            }
            case 12: {
                int[] dataarray = (int[])this.data;
                return this.javaClass.getConstantUTF(dataarray[0]) + ":" + this.javaClass.getConstantUTF(dataarray[1]);
            }
            case 15: {
                return "CONSTANT_MethodHandle UNIMPLEMENTED";
            }
            case 16: {
                return "CONSTANT_MethodType UNIMPLEMENTED";
            }
            case 18: {
                return "CONSTANT_InvokeDynamic UNIMPLEMENTED";
            }
        }
        return this.toString();
    }
}

