/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.ClassParser;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.fybertech.ClassParser.ConstantPoolItem;
import net.fybertech.ClassParser.JavaClass;

public class ConstantPool {
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_NameAndType = 12;
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_MethodHandle = 15;
    public static final int CONSTANT_MethodType = 16;
    public static final int CONSTANT_InvokeDynamic = 18;
    public ArrayList<ConstantPoolItem> constant_pool = new ArrayList();
    public int constant_pool_count;
    JavaClass javaClass;

    public ConstantPool(JavaClass jc, DataInputStream dis) throws IOException {
        this.javaClass = jc;
        this.constant_pool_count = dis.readUnsignedShort();
        int current_constant = 1;
        while (current_constant < this.constant_pool_count) {
            ConstantPoolItem ct = new ConstantPoolItem(this.javaClass, current_constant, dis);
            this.constant_pool.add(ct);
            if (ct.getType() == 5 || ct.getType() == 6) {
                ++current_constant;
            }
            ++current_constant;
        }
    }

    public void writePool(DataOutputStream dos) throws IOException {
        dos.writeShort(this.constant_pool_count);
        for (ConstantPoolItem cpi : this.constant_pool) {
            cpi.writeItem(dos);
        }
    }

    public int getPoolCount() {
        return this.constant_pool_count;
    }

    public ArrayList<ConstantPoolItem> getPool() {
        return this.constant_pool;
    }

    public ConstantPoolItem getItemByIndex(int index) {
        for (ConstantPoolItem cpi : this.constant_pool) {
            if (cpi.getIndex() != index) continue;
            return cpi;
        }
        return null;
    }

    public ConstantPoolItem findUTF(String s) {
        for (ConstantPoolItem cpi : this.constant_pool) {
            if (cpi.getType() != 1 || !s.equals((String)cpi.getData())) continue;
            return cpi;
        }
        return null;
    }

    public ConstantPoolItem addUTFItem(String s) {
        ConstantPoolItem cpi = new ConstantPoolItem(this.javaClass, 1, this.constant_pool_count++);
        this.constant_pool.add(cpi);
        cpi.setData(new String(s));
        return cpi;
    }

    public ConstantPoolItem addClassItem(String s) {
        int class_utf_index = this.addUTFItem(s).getIndex();
        ConstantPoolItem cpi = new ConstantPoolItem(this.javaClass, 7, this.constant_pool_count++);
        this.constant_pool.add(cpi);
        cpi.setData(class_utf_index);
        return cpi;
    }

    public ConstantPoolItem addStringItem(String s) {
        int string_utf_index = this.addUTFItem(s).getIndex();
        ConstantPoolItem cpi = new ConstantPoolItem(this.javaClass, 8, this.constant_pool_count++);
        this.constant_pool.add(cpi);
        cpi.setData(string_utf_index);
        return cpi;
    }

    public ArrayList<ConstantPoolItem> getMatchingType(int t) {
        ArrayList<ConstantPoolItem> matchlist = new ArrayList<ConstantPoolItem>();
        for (ConstantPoolItem cpi : this.constant_pool) {
            if (cpi.getType() != t) continue;
            matchlist.add(cpi);
        }
        return matchlist;
    }

    public ConstantPoolItem findOrCreateClass(String name) {
        for (ConstantPoolItem cpi : this.constant_pool) {
            if (cpi.getType() != 7 || !this.getConstantUTF((Integer)cpi.getData()).equals(name)) continue;
            return cpi;
        }
        ConstantPoolItem nameItem = this.findUTF(name);
        if (nameItem == null) {
            nameItem = this.addUTFItem(name);
        }
        ConstantPoolItem cpi = new ConstantPoolItem(this.javaClass, 7, this.constant_pool_count++);
        cpi.setData(nameItem.getIndex());
        this.constant_pool.add(cpi);
        return cpi;
    }

    public ConstantPoolItem findOrCreateRef(int reftype, String name, String descriptor) {
        int lastslash = name.lastIndexOf("/");
        String className = name.substring(0, lastslash);
        String fieldName = name.substring(lastslash + 1);
        for (ConstantPoolItem cpi : this.constant_pool) {
            if (cpi.getType() != reftype) continue;
            int[] fieldarray = (int[])cpi.data;
            ConstantPoolItem nameandtype = this.getItemByIndex(fieldarray[1]);
            int[] typearray = (int[])nameandtype.data;
            String thisclassname = this.getConstantUTFIndirect(fieldarray[0]);
            String thisfieldname = this.getConstantUTF(typearray[0]);
            String thisdescriptor = this.getConstantUTF(typearray[1]);
            if (!thisclassname.equals(className) || !thisfieldname.equals(fieldName) || !thisdescriptor.equals(descriptor)) continue;
            return cpi;
        }
        ConstantPoolItem classItem = this.findOrCreateClass(className);
        ConstantPoolItem typeItem = this.findNameAndType(fieldName, descriptor);
        if (typeItem == null) {
            typeItem = this.createNameAndType(fieldName, descriptor);
        }
        ConstantPoolItem cpi = new ConstantPoolItem(this.javaClass, reftype, this.constant_pool_count++);
        int[] fieldarray = new int[]{classItem.getIndex(), typeItem.getIndex()};
        cpi.setData(fieldarray);
        this.constant_pool.add(cpi);
        return cpi;
    }

    public String getConstantUTF(int index) {
        return (String)this.getItemByIndex(index).getData();
    }

    public int getConstantInt(int index) {
        return (Integer)this.getItemByIndex(index).getData();
    }

    public String getConstantUTFIndirect(int index) {
        return (String)this.getItemByIndex(this.getConstantInt(index)).getData();
    }

    public ConstantPoolItem findOrCreateLong(long val) {
        ConstantPoolItem cpi2;
        for (ConstantPoolItem cpi2 : this.constant_pool) {
            if (cpi2.getType() != 5 || (Long)cpi2.getData() != val) continue;
            return cpi2;
        }
        cpi2 = new ConstantPoolItem(this.javaClass, 5, this.constant_pool_count);
        this.constant_pool_count += 2;
        cpi2.setData(new Long(val));
        this.constant_pool.add(cpi2);
        return cpi2;
    }

    public ConstantPoolItem findOrCreateDouble(double val) {
        ConstantPoolItem cpi2;
        for (ConstantPoolItem cpi2 : this.constant_pool) {
            if (cpi2.getType() != 6 || (Double)cpi2.getData() != val) continue;
            return cpi2;
        }
        cpi2 = new ConstantPoolItem(this.javaClass, 6, this.constant_pool_count);
        this.constant_pool_count += 2;
        cpi2.setData(new Double(val));
        this.constant_pool.add(cpi2);
        return cpi2;
    }

    public ConstantPoolItem findOrCreateInteger(int val) {
        ConstantPoolItem cpi2;
        for (ConstantPoolItem cpi2 : this.constant_pool) {
            if (cpi2.getType() != 3 || (Integer)cpi2.getData() != val) continue;
            return cpi2;
        }
        cpi2 = new ConstantPoolItem(this.javaClass, 3, this.constant_pool_count++);
        cpi2.setData(new Integer(val));
        this.constant_pool.add(cpi2);
        return cpi2;
    }

    public ConstantPoolItem findOrCreateFloat(float val) {
        ConstantPoolItem cpi2;
        for (ConstantPoolItem cpi2 : this.constant_pool) {
            if (cpi2.getType() != 4 || ((Float)cpi2.getData()).floatValue() != val) continue;
            return cpi2;
        }
        cpi2 = new ConstantPoolItem(this.javaClass, 4, this.constant_pool_count++);
        cpi2.setData(new Float(val));
        this.constant_pool.add(cpi2);
        return cpi2;
    }

    public ConstantPoolItem findOrCreateUTF(String val) {
        ConstantPoolItem cpi2;
        for (ConstantPoolItem cpi2 : this.constant_pool) {
            if (cpi2.getType() != 1 || !((String)cpi2.getData()).equals(val)) continue;
            return cpi2;
        }
        cpi2 = new ConstantPoolItem(this.javaClass, 1, this.constant_pool_count++);
        cpi2.setData(new String(val));
        this.constant_pool.add(cpi2);
        return cpi2;
    }

    public ConstantPoolItem findNameAndType(String name, String descriptor) {
        for (ConstantPoolItem cpi : this.constant_pool) {
            if (cpi.getType() != 12) continue;
            int[] typearray = (int[])cpi.data;
            String thisname = this.getConstantUTF(typearray[0]);
            String thisdescriptor = this.getConstantUTF(typearray[1]);
            if (!thisname.equals(name) || !thisdescriptor.equals(descriptor)) continue;
            return cpi;
        }
        return null;
    }

    public ConstantPoolItem createNameAndType(String name, String descriptor) {
        ConstantPoolItem nameItem = this.findOrCreateUTF(name);
        ConstantPoolItem descriptorItem = this.findOrCreateUTF(descriptor);
        ConstantPoolItem cpi = new ConstantPoolItem(this.javaClass, 12, this.constant_pool_count++);
        int[] namearray = new int[]{nameItem.getIndex(), descriptorItem.getIndex()};
        cpi.setData(namearray);
        this.constant_pool.add(cpi);
        return cpi;
    }

    public ConstantPoolItem findOrCreateNameAndType(String name, String type) {
        ConstantPoolItem cpi = this.findNameAndType(name, type);
        if (cpi == null) {
            cpi = this.createNameAndType(name, type);
        }
        return cpi;
    }

    public ConstantPoolItem findOrCreateString(String str) {
        for (ConstantPoolItem cpi : this.constant_pool) {
            int utfindex;
            if (cpi.getType() != 8 || !this.getConstantUTF(utfindex = ((Integer)cpi.data).intValue()).equals(str)) continue;
            return cpi;
        }
        int string_utf_index = this.findOrCreateUTF(str).getIndex();
        ConstantPoolItem cpi = new ConstantPoolItem(this.javaClass, 8, this.constant_pool_count++);
        this.constant_pool.add(cpi);
        cpi.setData(string_utf_index);
        return cpi;
    }
}

