/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.ClassParser;

import java.util.List;
import net.fybertech.ClassParser.ClassPool;
import net.fybertech.ClassParser.JavaClass;
import net.fybertech.ClassParser.JavaField;
import net.fybertech.ClassParser.JavaMethod;

public class ClassTraverser {
    private static JavaClass traverseClass = null;
    public static int traverseDepth = 0;

    public static JavaClass traverseClassForObject(String className, String nameAndDesc, int objtype, ClassPool cp) {
        traverseClass = null;
        traverseDepth = 0;
        return ClassTraverser.traverseClassForObject(className, nameAndDesc, objtype, 0, cp);
    }

    public static JavaClass traverseParentsForObject(String className, String nameAndDesc, int objtype, ClassPool cp) {
        traverseClass = null;
        traverseDepth = 0;
        JavaClass jclass = cp.getPool().get(className);
        if (jclass.interfaces_count > 0) {
            int n = 0;
            while (n < jclass.interfaces_count) {
                String iface = jclass.getConstantUTFIndirect(jclass.interfaces[n]);
                ClassTraverser.traverseClassForObject(iface, nameAndDesc, objtype, 0, cp);
                ++n;
            }
        }
        if (jclass.super_class != 0) {
            String nextClass = jclass.getConstantUTFIndirect(jclass.super_class);
            ClassTraverser.traverseClassForObject(nextClass, nameAndDesc, objtype, 0, cp);
        }
        return traverseClass;
    }

    public static JavaClass traverseClassForObject(String className, String nameAndDesc, int objtype, int depth, ClassPool cp) {
        JavaClass jclass = cp.getPool().get(className);
        ++depth;
        if (jclass == null) {
            return traverseClass;
        }
        if (objtype == 9) {
            for (JavaField jf : jclass.fields) {
                String fieldName = jclass.getConstantUTF(jf.name_index);
                String fieldDesc = jclass.getConstantUTF(jf.descriptor_index);
                if ((jf.access_flags & 2) > 0 || !nameAndDesc.equals(String.valueOf(fieldName) + " " + fieldDesc)) continue;
                if (depth <= traverseDepth) break;
                traverseClass = jclass;
                traverseDepth = depth;
                break;
            }
        } else {
            for (JavaMethod jm : jclass.methods) {
                String methodName = jclass.getConstantUTF(jm.name_index);
                String methodDesc = jclass.getConstantUTF(jm.descriptor_index);
                if ((jm.access_flags & 2) > 0 || !nameAndDesc.equals(String.valueOf(methodName) + " " + methodDesc)) continue;
                if (depth <= traverseDepth) break;
                traverseClass = jclass;
                traverseDepth = depth;
                break;
            }
        }
        if (jclass.interfaces_count > 0) {
            int n = 0;
            while (n < jclass.interfaces_count) {
                String iface = jclass.getConstantUTFIndirect(jclass.interfaces[n]);
                ClassTraverser.traverseClassForObject(iface, nameAndDesc, objtype, depth, cp);
                ++n;
            }
        }
        if (jclass.super_class != 0) {
            String nextClass = jclass.getConstantUTFIndirect(jclass.super_class);
            ClassTraverser.traverseClassForObject(nextClass, nameAndDesc, objtype, depth, cp);
        }
        return traverseClass;
    }

    public static void traverseClassForAll(String className, String nameAndDesc, int objtype, List<String> classlist, ClassPool cp) {
        JavaClass jclass = cp.getPool().get(className);
        if (jclass == null) {
            return;
        }
        if (objtype == 9) {
            for (JavaField jf : jclass.fields) {
                String fieldName = jclass.getConstantUTF(jf.name_index);
                String fieldDesc = jclass.getConstantUTF(jf.descriptor_index);
                if (!nameAndDesc.equals(String.valueOf(fieldName) + " " + fieldDesc)) continue;
                if (classlist.contains(className)) break;
                classlist.add(className);
                break;
            }
        } else {
            for (JavaMethod jm : jclass.methods) {
                String methodName = jclass.getConstantUTF(jm.name_index);
                String methodDesc = jclass.getConstantUTF(jm.descriptor_index);
                if (!nameAndDesc.equals(String.valueOf(methodName) + " " + methodDesc)) continue;
                if (classlist.contains(className)) break;
                classlist.add(className);
                break;
            }
        }
        if (jclass.interfaces_count > 0) {
            int n = 0;
            while (n < jclass.interfaces_count) {
                String iface = jclass.getConstantUTFIndirect(jclass.interfaces[n]);
                ClassTraverser.traverseClassForAll(iface, nameAndDesc, objtype, classlist, cp);
                ++n;
            }
        }
        if (jclass.super_class != 0) {
            String nextClass = jclass.getConstantUTFIndirect(jclass.super_class);
            ClassTraverser.traverseClassForAll(nextClass, nameAndDesc, objtype, classlist, cp);
        }
    }
}

