/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.ClassParser;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.fybertech.ClassParser.JavaClass;

public class ClassPool {
    HashMap<String, JavaClass> classPool = new HashMap();

    public void addClass(JavaClass jc) {
        this.classPool.put(jc.getClassName(), jc);
    }

    public JavaClass getClass(String c) {
        return this.classPool.get(c);
    }

    public HashMap<String, JavaClass> getPool() {
        return this.classPool;
    }

    public List<String> walkDirForPool(String dirname) throws IOException {
        return ClassPool.walkDirForPool(dirname, this.classPool);
    }

    public static List<String> walkDirForPool(String dirname, Map<String, JavaClass> paramPool) throws IOException {
        File[] files;
        ArrayList<String> unusedFiles = new ArrayList<String>();
        File dir = new File(dirname);
        if (!dir.isDirectory()) {
            return unusedFiles;
        }
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File thisfile = fileArray[n2];
            if (thisfile.isDirectory()) {
                unusedFiles.addAll(ClassPool.walkDirForPool(thisfile.getPath().toString(), paramPool));
            } else if (!thisfile.getName().endsWith(".class")) {
                unusedFiles.add(thisfile.getPath());
            } else {
                JavaClass jclass = new JavaClass(thisfile.getPath());
                paramPool.put(jclass.getClassName(), jclass);
            }
            ++n2;
        }
        return unusedFiles;
    }

    public static List<String> walkDirForClassList(String dirname) throws IOException {
        File[] files;
        ArrayList<String> list = new ArrayList<String>();
        File dir = new File(dirname);
        if (!dir.isDirectory()) {
            return list;
        }
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File thisfile = fileArray[n2];
            if (thisfile.isDirectory()) {
                list.addAll(ClassPool.walkDirForClassList(thisfile.getPath().toString()));
            } else if (thisfile.getName().endsWith(".class")) {
                list.add(thisfile.getPath());
            }
            ++n2;
        }
        return list;
    }

    public List<String> addJAR(String filename) throws IOException {
        return ClassPool.addJARtoPool(filename, this.classPool);
    }

    public static List<String> addJARtoPool(String paramFilename, Map<String, JavaClass> paramPool) throws IOException {
        ArrayList<String> unusedFiles = new ArrayList<String>();
        JarFile jf = new JarFile(paramFilename);
        Enumeration<JarEntry> e = jf.entries();
        while (e.hasMoreElements()) {
            JarEntry je2 = e.nextElement();
            String name = je2.getName();
            if (!name.endsWith(".class")) {
                unusedFiles.add(name);
                continue;
            }
            JavaClass jc = new JavaClass(new DataInputStream(jf.getInputStream(je2)));
            paramPool.put(jc.getClassName(), jc);
        }
        jf.close();
        return unusedFiles;
    }

    public void saveClassesTo(String outputDir) throws IOException {
        for (JavaClass jclass : this.classPool.values()) {
            String outFilename = String.valueOf(outputDir) + File.separatorChar + jclass.getClassName() + ".class";
            Path path = Paths.get(outFilename, new String[0]).getParent();
            path.toFile().mkdirs();
            DataOutputStream classoutfile = new DataOutputStream(new FileOutputStream(outFilename));
            jclass.writeClass(classoutfile);
            classoutfile.close();
        }
    }
}

