/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.ClassParser;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fybertech.ClassParser.ConstantPoolItem;
import net.fybertech.ClassParser.JavaClass;

public class BytecodeReader {
    static List<OpcodeType> instructions = new ArrayList<OpcodeType>();
    JavaClass javaClass = null;
    public List<RawOpcode> opcodes = new ArrayList<RawOpcode>();
    ByteBuffer codebuffer = null;

    public BytecodeReader(JavaClass jc, byte[] inbuffer) {
        byte[] raw;
        instructions.add(new OpcodeType("aaload", 50));
        instructions.add(new OpcodeType("aastore", 83));
        instructions.add(new OpcodeType("aconst_null", 1));
        instructions.add(new OpcodeType("aload", 25, 1));
        instructions.add(new OpcodeType("aload_0", 42));
        instructions.add(new OpcodeType("aload_1", 43));
        instructions.add(new OpcodeType("aload_2", 44));
        instructions.add(new OpcodeType("aload_3", 45));
        instructions.add(new OpcodeType("anewarray", 189, 2));
        instructions.add(new OpcodeType("areturn", 176));
        instructions.add(new OpcodeType("arraylength", 190));
        instructions.add(new OpcodeType("astore", 58, 1));
        instructions.add(new OpcodeType("astore_0", 75));
        instructions.add(new OpcodeType("astore_1", 76));
        instructions.add(new OpcodeType("astore_2", 77));
        instructions.add(new OpcodeType("astore_3", 78));
        instructions.add(new OpcodeType("athrow", 191));
        instructions.add(new OpcodeType("baload", 51));
        instructions.add(new OpcodeType("bastore", 84));
        instructions.add(new OpcodeType("bipush", 16, 1));
        instructions.add(new OpcodeType("breakpoint", 202));
        instructions.add(new OpcodeType("caload", 52));
        instructions.add(new OpcodeType("castore", 85));
        instructions.add(new OpcodeType("checkcast", 192, 2));
        instructions.add(new OpcodeType("d2f", 144));
        instructions.add(new OpcodeType("d2i", 142));
        instructions.add(new OpcodeType("d2l", 143));
        instructions.add(new OpcodeType("dadd", 99));
        instructions.add(new OpcodeType("daload", 49));
        instructions.add(new OpcodeType("dastore", 82));
        instructions.add(new OpcodeType("dcmpg", 152));
        instructions.add(new OpcodeType("dcmpl", 151));
        instructions.add(new OpcodeType("dconst_0", 14));
        instructions.add(new OpcodeType("dconst_1", 15));
        instructions.add(new OpcodeType("ddiv", 111));
        instructions.add(new OpcodeType("dload", 24, 1));
        instructions.add(new OpcodeType("dload_0", 38));
        instructions.add(new OpcodeType("dload_1", 39));
        instructions.add(new OpcodeType("dload_2", 40));
        instructions.add(new OpcodeType("dload_3", 41));
        instructions.add(new OpcodeType("dmul", 107));
        instructions.add(new OpcodeType("dneg", 119));
        instructions.add(new OpcodeType("drem", 115));
        instructions.add(new OpcodeType("dreturn", 175));
        instructions.add(new OpcodeType("dstore", 57, 1));
        instructions.add(new OpcodeType("dstore_0", 71));
        instructions.add(new OpcodeType("dstore_1", 72));
        instructions.add(new OpcodeType("dstore_2", 73));
        instructions.add(new OpcodeType("dstore_3", 74));
        instructions.add(new OpcodeType("dsub", 103));
        instructions.add(new OpcodeType("dup", 89));
        instructions.add(new OpcodeType("dup_x1", 90));
        instructions.add(new OpcodeType("dup_x2", 91));
        instructions.add(new OpcodeType("dup2", 92));
        instructions.add(new OpcodeType("dup2_x1", 93));
        instructions.add(new OpcodeType("dup2_x2", 94));
        instructions.add(new OpcodeType("f2d", 141));
        instructions.add(new OpcodeType("f2i", 139));
        instructions.add(new OpcodeType("f2l", 140));
        instructions.add(new OpcodeType("fadd", 98));
        instructions.add(new OpcodeType("faload", 48));
        instructions.add(new OpcodeType("fastore", 81));
        instructions.add(new OpcodeType("fcmpg", 150));
        instructions.add(new OpcodeType("fcmpl", 149));
        instructions.add(new OpcodeType("fconst_0", 11));
        instructions.add(new OpcodeType("fconst_1", 12));
        instructions.add(new OpcodeType("fconst_2", 13));
        instructions.add(new OpcodeType("fdiv", 110));
        instructions.add(new OpcodeType("fload", 23, 1));
        instructions.add(new OpcodeType("fload_0", 34));
        instructions.add(new OpcodeType("fload_1", 35));
        instructions.add(new OpcodeType("fload_2", 36));
        instructions.add(new OpcodeType("fload_3", 37));
        instructions.add(new OpcodeType("fmul", 106));
        instructions.add(new OpcodeType("fneg", 118));
        instructions.add(new OpcodeType("frem", 114));
        instructions.add(new OpcodeType("freturn", 174));
        instructions.add(new OpcodeType("fstore", 56, 1));
        instructions.add(new OpcodeType("fstore_0", 67));
        instructions.add(new OpcodeType("fstore_1", 68));
        instructions.add(new OpcodeType("fstore_2", 69));
        instructions.add(new OpcodeType("fstore_3", 70));
        instructions.add(new OpcodeType("fsub", 102));
        instructions.add(new OpcodeType("getfield", 180, 2));
        instructions.add(new OpcodeType("getstatic", 178, 2));
        instructions.add(new OpcodeType("goto", 167, 2));
        instructions.add(new OpcodeType("goto_w", 200, 4));
        instructions.add(new OpcodeType("i2b", 145));
        instructions.add(new OpcodeType("i2c", 146));
        instructions.add(new OpcodeType("i2d", 135));
        instructions.add(new OpcodeType("i2f", 134));
        instructions.add(new OpcodeType("i2l", 133));
        instructions.add(new OpcodeType("i2s", 147));
        instructions.add(new OpcodeType("iadd", 96));
        instructions.add(new OpcodeType("iaload", 46));
        instructions.add(new OpcodeType("iand", 126));
        instructions.add(new OpcodeType("iastore", 79));
        instructions.add(new OpcodeType("iconst_m1", 2));
        instructions.add(new OpcodeType("iconst_0", 3));
        instructions.add(new OpcodeType("iconst_1", 4));
        instructions.add(new OpcodeType("iconst_2", 5));
        instructions.add(new OpcodeType("iconst_3", 6));
        instructions.add(new OpcodeType("iconst_4", 7));
        instructions.add(new OpcodeType("iconst_5", 8));
        instructions.add(new OpcodeType("idiv", 108));
        instructions.add(new OpcodeType("if_acmpeq", 165, 2));
        instructions.add(new OpcodeType("if_acmpne", 166, 2));
        instructions.add(new OpcodeType("if_icmpeq", 159, 2));
        instructions.add(new OpcodeType("if_icmpge", 162, 2));
        instructions.add(new OpcodeType("if_icmpgt", 163, 2));
        instructions.add(new OpcodeType("if_icmple", 164, 2));
        instructions.add(new OpcodeType("if_icmplt", 161, 2));
        instructions.add(new OpcodeType("if_icmpne", 160, 2));
        instructions.add(new OpcodeType("ifeq", 153, 2));
        instructions.add(new OpcodeType("ifge", 156, 2));
        instructions.add(new OpcodeType("ifgt", 157, 2));
        instructions.add(new OpcodeType("ifle", 158, 2));
        instructions.add(new OpcodeType("iflt", 155, 2));
        instructions.add(new OpcodeType("ifne", 154, 2));
        instructions.add(new OpcodeType("ifnonnull", 199, 2));
        instructions.add(new OpcodeType("ifnull", 198, 2));
        instructions.add(new OpcodeType("iinc", 132, 2));
        instructions.add(new OpcodeType("iload", 21, 1));
        instructions.add(new OpcodeType("iload_0", 26));
        instructions.add(new OpcodeType("iload_1", 27));
        instructions.add(new OpcodeType("iload_2", 28));
        instructions.add(new OpcodeType("iload_3", 29));
        instructions.add(new OpcodeType("impdep1", 254));
        instructions.add(new OpcodeType("impdep2", 255));
        instructions.add(new OpcodeType("imul", 104));
        instructions.add(new OpcodeType("ineg", 116));
        instructions.add(new OpcodeType("instanceof", 193, 2));
        instructions.add(new OpcodeType("invokedynamic", 186, 4));
        instructions.add(new OpcodeType("invokeinterface", 185, 4));
        instructions.add(new OpcodeType("invokespecial", 183, 2));
        instructions.add(new OpcodeType("invokestatic", 184, 2));
        instructions.add(new OpcodeType("invokevirtual", 182, 2));
        instructions.add(new OpcodeType("ior", 128));
        instructions.add(new OpcodeType("irem", 112));
        instructions.add(new OpcodeType("ireturn", 172));
        instructions.add(new OpcodeType("ishl", 120));
        instructions.add(new OpcodeType("ishr", 122));
        instructions.add(new OpcodeType("istore", 54, 1));
        instructions.add(new OpcodeType("istore_0", 59));
        instructions.add(new OpcodeType("istore_1", 60));
        instructions.add(new OpcodeType("istore_2", 61));
        instructions.add(new OpcodeType("istore_3", 62));
        instructions.add(new OpcodeType("isub", 100));
        instructions.add(new OpcodeType("iushr", 124));
        instructions.add(new OpcodeType("ixor", 130));
        instructions.add(new OpcodeType("jsr", 168, 2));
        instructions.add(new OpcodeType("jsr_w", 201, 4));
        instructions.add(new OpcodeType("l2d", 138));
        instructions.add(new OpcodeType("l2f", 137));
        instructions.add(new OpcodeType("l2i", 136));
        instructions.add(new OpcodeType("ladd", 97));
        instructions.add(new OpcodeType("laload", 47));
        instructions.add(new OpcodeType("land", 127));
        instructions.add(new OpcodeType("lastore", 80));
        instructions.add(new OpcodeType("lcmp", 148));
        instructions.add(new OpcodeType("lconst_0", 9));
        instructions.add(new OpcodeType("lconst_1", 10));
        instructions.add(new OpcodeType("ldc", 18, 1));
        instructions.add(new OpcodeType("ldc_w", 19, 2));
        instructions.add(new OpcodeType("ldc2_w", 20, 2));
        instructions.add(new OpcodeType("ldiv", 109));
        instructions.add(new OpcodeType("lload", 22, 1));
        instructions.add(new OpcodeType("lload_0", 30));
        instructions.add(new OpcodeType("lload_1", 31));
        instructions.add(new OpcodeType("lload_2", 32));
        instructions.add(new OpcodeType("lload_3", 33));
        instructions.add(new OpcodeType("lmul", 105));
        instructions.add(new OpcodeType("lneg", 117));
        instructions.add(new OpcodeType("lor", 129));
        instructions.add(new OpcodeType("lrem", 113));
        instructions.add(new OpcodeType("lreturn", 173));
        instructions.add(new OpcodeType("lshl", 121));
        instructions.add(new OpcodeType("lshr", 123));
        instructions.add(new OpcodeType("lstore", 55, 1));
        instructions.add(new OpcodeType("lstore_0", 63));
        instructions.add(new OpcodeType("lstore_1", 64));
        instructions.add(new OpcodeType("lstore_2", 65));
        instructions.add(new OpcodeType("lstore_3", 66));
        instructions.add(new OpcodeType("lsub", 101));
        instructions.add(new OpcodeType("lushr", 125));
        instructions.add(new OpcodeType("lxor", 131));
        instructions.add(new OpcodeType("monitorenter", 194));
        instructions.add(new OpcodeType("monitorexit", 195));
        instructions.add(new OpcodeType("multianewarray", 197, 3));
        instructions.add(new OpcodeType("new", 187, 2));
        instructions.add(new OpcodeType("newarray", 188, 1));
        instructions.add(new OpcodeType("nop", 0));
        instructions.add(new OpcodeType("pop", 87));
        instructions.add(new OpcodeType("pop2", 88));
        instructions.add(new OpcodeType("putfield", 181, 2));
        instructions.add(new OpcodeType("putstatic", 179, 2));
        instructions.add(new OpcodeType("ret", 169, 1));
        instructions.add(new OpcodeType("return", 177));
        instructions.add(new OpcodeType("saload", 53));
        instructions.add(new OpcodeType("sastore", 86));
        instructions.add(new OpcodeType("sipush", 17, 2));
        instructions.add(new OpcodeType("swap", 95));
        instructions.add(new OpcodeType("tableswitch", 170));
        instructions.add(new OpcodeType("lookupswitch", 171));
        instructions.add(new OpcodeType("wide", 196));
        this.javaClass = jc;
        ByteBuffer outerbuffer = ByteBuffer.wrap(inbuffer);
        outerbuffer.rewind();
        short max_stack = outerbuffer.getShort();
        short max_locals = outerbuffer.getShort();
        int code_length = outerbuffer.getInt();
        this.codebuffer = ByteBuffer.wrap(Arrays.copyOfRange(inbuffer, 8, 8 + code_length));
        this.codebuffer.rewind();
        int lastposition = 0;
        int line = 1;
        while ((raw = this.getNextInstructionBytes()) != null) {
            this.opcodes.add(new RawOpcode(raw, lastposition, line++));
            lastposition = this.codebuffer.position();
        }
        this.codebuffer.rewind();
    }

    public byte[] getNextInstructionBytes() {
        byte[] outbuffer;
        block9: {
            byte instruction;
            block11: {
                block10: {
                    block8: {
                        outbuffer = null;
                        if (this.codebuffer.remaining() < 1) {
                            return null;
                        }
                        instruction = this.codebuffer.get();
                        if (instruction != -86) break block8;
                        int padding = this.codebuffer.position() % 4;
                        if (padding != 0) {
                            padding = this.codebuffer.position() - padding + 4 - this.codebuffer.position();
                        }
                        int n = 0;
                        while (n < padding) {
                            this.codebuffer.get();
                            ++n;
                        }
                        int defaultbyte = this.codebuffer.getInt();
                        int lowbyte = this.codebuffer.getInt();
                        int highbyte = this.codebuffer.getInt();
                        int total = highbyte - lowbyte + 1;
                        outbuffer = new byte[13 + total * 4];
                        ByteBuffer outwrapper = ByteBuffer.wrap(outbuffer);
                        outwrapper.put((byte)-86);
                        outwrapper.asIntBuffer().put(defaultbyte);
                        outwrapper.asIntBuffer().put(lowbyte);
                        outwrapper.asIntBuffer().put(highbyte);
                        int n2 = 0;
                        while (n2 < total) {
                            outwrapper.asIntBuffer().put(this.codebuffer.getInt());
                            ++n2;
                        }
                        break block9;
                    }
                    if (instruction != -85) break block10;
                    int padding = this.codebuffer.position() % 4;
                    if (padding != 0) {
                        padding = this.codebuffer.position() - padding + 4 - this.codebuffer.position();
                    }
                    int n = 0;
                    while (n < padding) {
                        this.codebuffer.get();
                        ++n;
                    }
                    int defaultbyte = this.codebuffer.getInt();
                    int pairs = this.codebuffer.getInt();
                    outbuffer = new byte[9 + pairs * 8];
                    ByteBuffer outwrapper = ByteBuffer.wrap(outbuffer);
                    outwrapper.rewind();
                    outwrapper.put((byte)-85);
                    outwrapper.asIntBuffer().put(defaultbyte);
                    outwrapper.asIntBuffer().put(pairs);
                    int n3 = 0;
                    while (n3 < pairs * 2) {
                        outwrapper.asIntBuffer().put(this.codebuffer.getInt());
                        ++n3;
                    }
                    break block9;
                }
                if (instruction != -60) break block11;
                outbuffer = new byte[]{-60};
                byte oc = this.codebuffer.get();
                this.codebuffer.getShort();
                if (oc != -124) break block9;
                this.codebuffer.getShort();
                break block9;
            }
            int parmcount = this.getOpcodeParmCount(instruction);
            outbuffer = new byte[parmcount + 1];
            outbuffer[0] = instruction;
            int n = 0;
            while (n < parmcount) {
                outbuffer[n + 1] = this.codebuffer.get();
                ++n;
            }
        }
        return outbuffer;
    }

    public int getOpcodeParmCount(byte opcode) {
        for (OpcodeType bi : instructions) {
            if (bi.opcode != opcode) continue;
            return bi.parameters;
        }
        return 0;
    }

    public String getOpcodeName(int opcode) {
        for (OpcodeType bi : instructions) {
            if (bi.opcode != opcode) continue;
            return bi.mnemonic;
        }
        return String.format("UNKNOWN: %02X", opcode);
    }

    class OpcodeType {
        byte opcode;
        String mnemonic;
        int parameters;

        public OpcodeType(String m, int o, int p) {
            this.opcode = (byte)o;
            this.mnemonic = m;
            this.parameters = p;
        }

        public OpcodeType(String m, int o) {
            this.opcode = (byte)o;
            this.mnemonic = m;
            this.parameters = 0;
        }
    }

    public class RawOpcode {
        public byte opcode;
        public byte[] parameters;
        public int byteposition;
        public int lineposition;

        public RawOpcode(byte[] raw, int pos, int line) {
            this.opcode = raw[0];
            this.byteposition = pos;
            this.lineposition = line;
            this.parameters = Arrays.copyOfRange(raw, 1, raw.length);
        }

        public String toString() {
            switch (this.opcode) {
                case -69: {
                    int classid = (this.parameters[0] & 0xFF) << 8 | this.parameters[1] & 0xFF;
                    return String.valueOf(BytecodeReader.this.getOpcodeName(this.opcode)) + " " + BytecodeReader.this.javaClass.getConstantUTFIndirect(classid);
                }
                case -78: 
                case -76: 
                case -75: 
                case -74: 
                case -73: 
                case -72: 
                case -71: {
                    int id = (this.parameters[0] & 0xFF) << 8 | this.parameters[1] & 0xFF;
                    return String.valueOf(BytecodeReader.this.getOpcodeName(this.opcode)) + " " + BytecodeReader.this.javaClass.getConstantClassNameType(id);
                }
                case 18: {
                    int id = this.parameters[0] & 0xFF;
                    System.out.println("ID: " + id);
                    String extra = "";
                    ConstantPoolItem cpi = BytecodeReader.this.javaClass.constant_pool.getItemByIndex(id);
                    if (cpi.ctype == 8) {
                        extra = "\"" + BytecodeReader.this.javaClass.getConstantUTF((Integer)cpi.getData()) + "\"";
                    } else if (cpi.ctype == 3) {
                        extra = "" + (Integer)cpi.getData();
                    } else if (cpi.ctype == 4) {
                        extra = "" + (Float)cpi.getData();
                    }
                    return String.valueOf(BytecodeReader.this.getOpcodeName(this.opcode)) + " " + extra;
                }
            }
            return String.valueOf(BytecodeReader.this.getOpcodeName(this.opcode)) + (this.parameters.length > 0 ? " PARAMETERS: " + this.parameters.length : "");
        }
    }
}

