/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.ClassParser;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.fybertech.ClassParser.JavaClass;

public class AttributeInfo {
    public int attribute_name_index;
    public int attribute_length;
    public byte[] info;
    public JavaClass javaClass;

    public static int getIntFromByteArray(byte[] buffer, int offset) {
        return (buffer[0 + offset] & 0xFF) << 24 | (buffer[1 + offset] & 0xFF) << 16 | (buffer[2 + offset] & 0xFF) << 8 | buffer[3 + offset] & 0xFF;
    }

    public static short getShortFromByteArray(byte[] buffer, int offset) {
        return (short)((buffer[0 + offset] & 0xFF) << 8 | buffer[1 + offset] & 0xFF);
    }

    public AttributeInfo(JavaClass jc, DataInputStream dis) throws IOException {
        this.attribute_name_index = dis.readUnsignedShort();
        this.attribute_length = dis.readInt();
        this.info = new byte[this.attribute_length];
        int readcount = 0;
        while ((readcount += dis.read(this.info, readcount, this.attribute_length - readcount)) < this.attribute_length) {
        }
        this.javaClass = jc;
    }

    public AttributeInfo(JavaClass jc) {
        this.javaClass = jc;
    }

    public void writeAttribute(DataOutputStream dos) throws IOException {
        dos.writeShort(this.attribute_name_index);
        dos.writeInt(this.info.length);
        dos.write(this.info);
    }

    public String getName() {
        return this.javaClass.getConstantUTF(this.attribute_name_index);
    }
}

