/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.ClassParser.Annotations;

import java.nio.ByteBuffer;
import net.fybertech.ClassParser.Annotations.ElementValueBoolean;
import net.fybertech.ClassParser.Annotations.ElementValueString;
import net.fybertech.ClassParser.Annotations.RuntimeVisibleAnnotation;
import net.fybertech.ClassParser.JavaClass;

public class ElementValue {
    char tag;

    public static ElementValue processValue(JavaClass jc, ByteBuffer buffer) {
        char tag = (char)buffer.get();
        switch (tag) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': {
                buffer.getShort();
                return new ElementValue();
            }
            case 'Z': {
                return new ElementValueBoolean(jc.getConstantBoolean(buffer.getShort() & 0xFFFF));
            }
            case 's': {
                return new ElementValueString(jc.getConstantUTF(buffer.getShort() & 0xFFFF));
            }
            case 'e': {
                buffer.getShort();
                buffer.getShort();
                break;
            }
            case 'c': {
                buffer.getShort();
                break;
            }
            case '@': {
                new RuntimeVisibleAnnotation(jc, buffer);
                break;
            }
            case '[': {
                int count = buffer.getShort() & 0xFFFF;
                int n = 0;
                while (n < count) {
                    ElementValue.processValue(jc, buffer);
                    ++n;
                }
                break;
            }
        }
        return null;
    }
}

