/*
 * Decompiled with CFR 0.152.
 */
package forge;

import forge.Property;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import net.fybertech.intermediary.IntermediaryMod;

public class Configuration {
    public TreeMap<String, Property> blockProperties = new TreeMap();
    public TreeMap<String, Property> itemProperties = new TreeMap();
    public TreeMap<String, Property> generalProperties = new TreeMap();
    public Map<String, Map<String, Property>> categories = new TreeMap<String, Map<String, Property>>();
    net.minecraftforge.common.config.Configuration bridgedConfig = null;

    public Configuration(File file) {
        System.out.println("Configuration: " + file.getPath());
        this.bridgedConfig = new net.minecraftforge.common.config.Configuration(file);
    }

    public void load() {
        IntermediaryMod.logger.info("Configuration.load() " + this.bridgedConfig);
        this.bridgedConfig.load();
    }

    public void save() {
        this.bridgedConfig.save();
    }

    public Property getOrCreateBooleanProperty(String key, String category, boolean defaultValue) {
        boolean result = this.bridgedConfig.getBoolean(key, category, defaultValue, "");
        return new Property(key, result ? "true" : "false");
    }

    public Property getOrCreateProperty(String key, String category, String defaultValue) {
        String result = this.bridgedConfig.getString(key, category, defaultValue, "");
        return new Property(key, result);
    }

    public Property getOrCreateIntProperty(String key, String category, int defaultValue) {
        int result = this.bridgedConfig.getInt(key, category, defaultValue, 0, Integer.MAX_VALUE, "");
        return new Property(key, "" + result);
    }

    public Property getOrCreateBlockIdProperty(String key, int defaultId) {
        return this.getOrCreateIntProperty(key, "block", defaultId);
    }
}

